# 🖨️ 3D printing


![image](https://github.com/user-attachments/assets/293de41b-8f79-49eb-af0a-822879e9b5a0)

## [Download the 3D Models Here](https://github.com/Vector-Wangel/XLeRobot/tree/main/hardware)

## 🤔 Before Printing 



> We assume you have basic experience with consumer-level 3D printers (BambuLab, Prusa, etc.). This means you know how to properly 3D print STL files with PLA filaments and are familiar with reorienting parts, adding supports, adjusting infill, and modifying print speed to achieve your desired balance of material strength, efficiency, and model detail quality.
> 
- For more detailed information, you can check out the 3D printing instructions for [Lekiwi](https://github.com/SIGRobotics-UIUC/LeKiwi/blob/main/3DPrinting.md) and [SO101 Arm](https://github.com/TheRobotStudio/SO-ARM100#printing-the-parts).
- All the 3D printed parts shown in the demo videos and pictures of XLeRobot were printed with a **BambuLab A1 using BambuLab PLA Matte Black**.
- You can also use filaments with better mechanical properties, such as [**PETG HF, PLA CF**](https://us.store.bambulab.com/products/pla-cf), [**BambuLab Tough PLA**](https://us.store.bambulab.com/products/pla-tough-upgrade), etc., to enhance the arm's strength.
- Drying PLA is recommended for humid environments at 45°C for 8 hours before printing.

### 💰 Cost Considerations

* **Your Own printer** (Recommended): Everything can be printed on consumer 3D printers like [BambuLab A1 (~$350 USD)](https://us.store.bambulab.com/products/a1), and you can easily make more and modify your own parts.
* **Filament cost**: Approximately $15–25 USD for the required PLA filament
* **Service printing**: If using a 3D printing service, the total cost is typically under $50 USD, including service fees

```{note}
You can also refer to the instructions of ([Lekiwi](https://github.com/SIGRobotics-UIUC/LeKiwi/blob/main/3DPrinting.md) and [SO101 Arm](https://github.com/TheRobotStudio/SO-ARM100#printing-the-parts)) along with this tutorial.
```

```{note}
Note that the [3D Printing .3mf files](https://github.com/Vector-Wangel/XLeRobot/tree/main/hardware) are only to store the models. It’s highly suggested to place, orient, and add supports yourself in the slicing software to ensure the best printing quality.
```

## 🖖 SO101 Arms

![image](https://github.com/user-attachments/assets/23e253d0-2049-4b72-ac40-394c70b16849)


- For XLeRobot, you only need to print two follower arms. The [leader arm](https://github.com/TheRobotStudio/SO-ARM100/tree/main?tab=readme-ov-file#printing-the-parts) is only necessary if you plan to operate the dual arms simultaneously with leader-follower joint control. 

- Before printing, rearrange the layout of this stl file in the slicer software for your best printing experience.

- 📷Camera: You can find the installation guide for [the Wrist Camera Mount here](https://github.com/TheRobotStudio/SO-ARM100/tree/main/Optional/SO101_Wrist_Cam_Hex-Nut_Mount_32x32_UVC_Module).

- 🫱Soft Gripper: The .3mf file contains soft finray fingers that need to be printed with TPU95A. If you want original SO101 finger, just download the original [SO101.stl](https://github.com/Vector-Wangel/XLeRobot/blob/main/hardware/Ender_Follower_SO101.stl) file.
- ![d2e57534a9e55a3d4dc0d644242cd044](https://github.com/user-attachments/assets/8d095541-d98f-4af8-a43c-028baae0d375)

## 🦾 Arm Base

### 📦 Arm Base

![image](https://github.com/user-attachments/assets/33e77b51-c070-4fbf-8487-30af3721f239)

- 2 arm bases are connected for standardized arm spacing.
- A middle storage shell for computational devices and cable management.
- You can insert a used Bambulab filament cardboard spool for additional structural support.
- Optional parts: Shells for the Control board and the first joint for better protection and visual.

![image](https://github.com/user-attachments/assets/91491f62-a466-4421-ac9b-db3492849a89)




### 🐼 Neck and head

![image](https://github.com/user-attachments/assets/8c73ae22-e5eb-4488-b20c-54b0ce25c9c1)

- Head designed based on the first two links of SO101. Compatible with the same motor.
- The .3mf file contains 2 version of the single RGB head camera connector and shell, one for webcam & realsense, the other for the cheaper camera same as the hand camera. 

- ![image](https://github.com/user-attachments/assets/73f357b1-dc40-437a-9cc6-d4a4dc2f5435)
- You can use any head camera you like, just make a little modification to the last mounting link. The step files are available [HERE](https://github.com/Vector-Wangel/XLeRobot/tree/main/hardware/step) for your adjustment. 
- Hollow neck for filament saving and cable management.


## 🧑‍🦼‍➡️ Wheel Base

![image](https://github.com/user-attachments/assets/c51bcbb2-8a97-4066-8876-31f11537fff4)

- Adjust the height of the base connector by modifying its z-axis scale in your slicer software (while maintaining the xy-axis scale) to ensure even pressure distribution between the 3 omni-wheels on the base and 4 IKEA cart wheels.
- ![image](https://github.com/user-attachments/assets/eff69573-badc-46b2-b66f-c28174090598)
- Alternative to adjusting the base connector: just print the washers below and insert them into the IKEA cart for the best base support.
- ![image](https://github.com/user-attachments/assets/e603a529-0690-4ce0-8d3b-381af0c86155)







### 💰 Cost Considerations

* **Own printer** (Recommended): Everything can be printed on consumer 3D printers like the Bambu Lab A1 (~$400 USD)
* **Filament cost**: Approximately $15–25 USD for the required PLA filament
* **Service printing**: If using a 3D printing service, the total cost is typically under $50 USD, including service fees


