# 🛒 **Bill of Material**

## 💵 Total Cost 

```{note}
Doesn't include cost of 3D printing, tools, shipping and taxes.
```

| Price | US | EU | CN | IN |
| --- | --- | --- | --- | --- |
| **Basic** (use your laptop, single RGB head cam) | **~$660** | **~€680** | **~¥3999** | **~₹87000** |
| ↑ Stereo dual-eye RGB head cam | +$30 | +€30 | +¥199 | +₹6550 |
| + RaspberryPi | +$79 | +€79 | +¥399 | +₹7999 |
| ↑ RealSense RGBD head cam | +$220 | +€230 | +¥1499 | +₹35726 |



![e65bf20604df6c937d00115f2ed7bc2](https://github.com/user-attachments/assets/cdef7558-935d-4e31-a612-f747dfc61340)



```{tip}
You can purchase printed parts or pre-assembled kits from [Wowrobo](https://shop.wowrobo.com/products/so-arm101-diy-kit-assembled-version-1) for SO101 arms. The SO101 arms require about 1.5 hours assembly for two arms.
```

```{note}
If you already have SO101 arms or Lekiwi, refer to this BOM selectively. We recommend checking the other two repos (SO100, Lekiwi) as well for potentially better-priced options.
```

## 🔨 Assembly Tools 

Skip this section if you already have these tools:

| Part | Amount | Unit Cost (US) | Buy (US) | Unit Cost (EU) | Buy (EU) | Unit Cost (CN) | Buy (CN) | Unit Cost (IN) | Buy (IN) |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| M3 Screws and Nuts Set (come with the L-shape screw driver) | 1 | $14.99 | [Amazon](https://a.co/d/4NfBpNS) | €23.5 | [Amazon](https://www.amazon.fr/Cylindrique-Inoxydable-M2-Socket-Assortiment/dp/B09Y8WYFWD/) | ¥40 | [Taobao](https://item.taobao.com/item.htm?abbucket=14&detail_redpacket_pop=true&id=614760389801&ltk2=1745773029845cww4kdo78gamgx9c4hl35&ns=1&priceTId=2100c82517457730113487286e0bc2&query=m3%E5%86%85%E5%85%AD%E8%A7%92%E8%9E%BA%E4%B8%9D%E5%A5%97%E8%A3%85&skuId=4501144438660&spm=a21n57.1.hoverItem.20&utparam=%7B%22aplus_abtest%22%3A%2256d17236f81617358b208d1cf05155cf%22%7D&xxc=taobaoSearch) | ₹1699 | [Amazon India](https://www.amazon.in/Epi-Torque-Epic-Torque-Doityourself-Tensile/dp/B08F5J4YS6/) |
| Flush cutter | 1 | $6.99 | [Amazon](https://a.co/d/61KlrZp) | €23.5 | [Amazon](https://www.amazon.fr/Cylindrique-Inoxydable-M2-Socket-Assortiment/dp/B09Y8WYFWD/) | ¥5.8 | [Taobao](https://item.taobao.com/item.htm?abbucket=14&detail_redpacket_pop=true&id=706039364576&ltk2=1745773187187erh7ued4gqcyyk5573rir&ns=1&priceTId=2100c82517457731790992641e0bc2&query=%E5%89%AA%E7%BA%BF%E9%92%B3&skuId=4964064736437&spm=a21n57.1.hoverItem.5&utparam=%7B%22aplus_abtest%22%3A%22474017eea48950332239eaf78d326730%22%7D&xxc=taobaoSearch) | ₹297 | [Amazon India](https://www.amazon.in/Homdum-Electronic-Jewellery-Electric-Strippers/dp/B09SZH1JQ2) |
| Screwdriver Set | 1 | $6 | [Amazon](https://www.amazon.com/Precision-Phillips-Screwdriver-Electronics-Computer/dp/B0DB227RTH) | €10 | [Amazon](https://www.amazon.fr/dp/B08ZXVMVYD/) | ￥20 | [Taobao](https://e.tb.cn/h.6ReL0wwgtPuSmNV?tk=3rLDV10AVtr) | ₹448 | [Amazon India](https://www.amazon.in/Zaptec-Magnetic-Screwdriver-Suitable-Electronics/dp/B0CN3GTCT6/) |
- Use a flush cutter to cut the metal mesh for cable routing.
- This tool list is just a reference—you can use any tools that will accomplish the task, primarily for driving hex and cross-head screws.
- 9x M4x10 screws are also needed for wheels assembly. 

## ⏫ Feature Parts


| Part | Amount | Unit Cost (US) | Buy (US) | Unit Cost (EU) | Buy (EU) | Unit Cost (CN) | Buy (CN) | Unit Cost (IN) | Buy (IN) |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| STS3215 Servo (12V) | 17 | $14 | [Wowrobo](https://shop.wowrobo.com/products/feetech-sts3215-servo-12v-30kg-high-torque-servo-for-so-arm100) | €16 | [Aliexpress](https://www.aliexpress.com/item/1005009271910382.html) | ￥97 | [TaoBao](https://item.taobao.com/item.htm?id=712179366565&skuId=5268252241438) | ₹2097 | [Robu.in](https://robu.in/product/waveshare-30kg-serial-bus-servo/) |
| IKEA RÅSKOG Utility cart | 1 | $39.99 | [IKEA](https://www.ikea.com/us/en/p/raskog-utility-cart-black-40582181/#content) | €39.99 | [IKEA](https://www.ikea.com/nl/en/p/raskog-trolley-white-30586783/) | ￥249 | [IKEA](https://www.ikea.cn/cn/zh/p/raskog-la-si-ke-shou-tui-che-bai-se-70376721/) | ₹2600 | [Amazon India](https://www.amazon.in/Ikea-R%C3%85SKOG-Trolley-0-35x0-45-Cotton/dp/B07SGJ2RSM) |
| Anker SOLIX C300 Power Station | 1 | $179.99 | [Anker](https://www.ankersolix.com/products/c300-dc?variant=49702163972426&ref=naviMenu_pps) | €169.99 | [Anker](https://www.anker.com/eu-en/products/a17260z1?variant=44598991323326&ref=naviMenu_pps) | ￥899 | [Taobao](https://e.tb.cn/h.6PQRiymMOteAgrb?tk=m6L3V3frrfp) | ₹27899 | [Ubuy India](https://www.ubuy.co.in/product/M62UNA548-solix-c300-portable-power-station-outdoor-288wh-lifepo4-battery-300w-600w-surge-solar-generator-140w-two-way-fast-charging-for-camping) |
| 4" Omni wheels | 3 | $9.99 | [VEX Robotics](https://www.vexrobotics.com/omni-wheels.html?srsltid=AfmBOorWdWT-FIiWSAbicYWSxqYr-d5X3CJSGxMkO33WO0thwlTn4DQu) | €24.5 | [RobotShop](https://eu.robotshop.com/products/100mm-omnidirectional-wheel-brass-bearing-rollers) | ￥135 | [PDD](https://mobile.yangkeduo.com/goods.html?ps=kKWPC7xuzw) | ₹4380 | [Robu.in](https://robu.in/product/100mm-double-aluminium-omni-wheel-bush-type-roller/) |
| Table Clamp 4pcs | 1 | $8.99 | [Amazon](https://www.amazon.com/TAODAN-Trigger-Ratchet-Woodworking-Processes/dp/B0DJNXF8WH?rps=1&sr=1-18) | ~€8 | [TODO](https://www.notion.so/Bill-of-Material-21abb280f59380f48e49e5c51df2b37f?pvs=21) | ￥9.2 | [TaoBao](https://detail.tmall.com/item.htm?id=801399113134&skuId=5633627126649) | ₹772 | [Amazon India](https://www.amazon.in/HASTHIP%C2%AE-Two-Way-Woodworking-Trigger-Jigsaw/dp/B0BDDHN238/) |


![image](https://github.com/user-attachments/assets/ee012d47-f2a9-495c-a156-01bf92b2e63b)

- XLeRobot is designed to be practical, which is why it only comes in a 12V version. You can also purchase for [STS3250 servo](https://shop.wowrobo.com/products/feetech-sts3250-c002-servo-12v-50kg-1-345-servo) (1.5x torque, 3x price) for extreme performance.
- 17 motors = 12 for arms + 3 for base + 2 for head.
- Any battery/power bank/power station that supports two 60W+ USB-C fast charging should work. Here are some other potential options (not tested), these brands should be available both in US and China.
  - [UGREEN 300W 48000mAh Power Bank](https://www.ugreen.com/products/ugreen-300w-48000mah-portable-charger-power-bank?gad_source=1&gad_campaignid=22334559506&gbraid=0AAAAAokPG3uYEJ4xHLZ1A5FoS_1cCYYRO&gclid=CjwKCAjwq9rFBhAIEiwAGVAZP_WRyKyLoZsEkLylqFw3KlfsLzoJ5NMiHtnRrRCAHs69uGl3R8McnBoCL-gQAvD_BwE)
  - [Anker Laptop Power Bank (25K, 165W)](https://www.anker.com/products/a1695-anker-power-bank-25000mah-165w?variant=44320657997974&utm_source=google&utm_medium=pmax&utm_campaign=us_anker_charger_conversion_pmax_seasonal_purchase_ost&utm_content=seasonal&utm_term=%7B20274825774%7D_%7B%7D_%7B%7D&gad_source=1&gad_campaignid=20284126303&gbraid=0AAAAADbnO27MKKh2JRMESwKW-MVxtoKEL&gclid=CjwKCAjwq9rFBhAIEiwAGVAZPyQRpShyzLVCZCrWArnCPk8fVGbShtkYDsQmfMCKwbmLKyY12u9N_xoCKC0QAvD_BwE)
  - [AOHI 240W Laptop Power Bank 27600mAh](https://a.co/d/aW8lNc2)
- For India, some alternative power bank sources are:
  - [Anker Prime Power Bank](https://www.amazon.in/Anker-Portable-Compatible-Charging-Included/dp/B0BYP2F3SG/)
  - [UGREEN 300W 48,000mAh Portable Charger](https://www.amazon.in/UGREEN-Portable-Charger-Digital-Lighting/dp/B0CJY37RT3/)

## 💻 Electronics

| Part | Amount | Unit Cost (US) | Buy (US) | Unit Cost (EU) | Buy (EU) | Unit Cost (CN) | Buy (CN) | Unit Cost (IN) | Buy (IN) |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| Raspberry Pi 5 (Optional) | 1 | $60.00 | [Adafruit](https://www.adafruit.com/product/5812) | €57.00 | [Mouser](https://eu.mouser.com/ProductDetail/Raspberry-Pi/SC1111?qs=HoCaDK9Nz5fnLhlMNnKTiQ%3D%3D) | ￥410 | [Taobao](https://e.tb.cn/h.64IIvlisvAL15g8?tk=fdOVexkHECW) | ₹7,999 | [Robu.in](https://robu.in/product/raspberry-pi-5-model-4gb/) |
| Motor Control Board | 2 | $10.55 | [Amazon](https://www.amazon.com/Waveshare-Integrates-Control-Circuit-Supports/dp/B0CTMM4LWK/) | €12.00 | [Amazon](https://www.amazon.fr/Waveshare-Integrates-Control-Applicable-Integrate/dp/B0CJ6TP3TP) | ￥24 | [Taobao](https://e.tb.cn/h.64DOUpLpB5crVdH?tk=BSaTex9UHWj) | ₹4041 | [Amazon India](https://www.amazon.in/Wonrabai-Integrates-Control-Circuit-Supports/dp/B0D1R4SGFS/) |
| microSD card | 1 | $11.23 | [Amazon](https://www.amazon.com/SanDisk-Extreme-microSDXC-Memory-Adapter/dp/B09X7C7LL1/) | €10.00 | [Amazon](https://www.amazon.fr/Lexar-Carte-Micro-adaptateur-Smartphone/dp/B08XZ2KS1F) | ￥58 | [Taobao](https://e.tb.cn/h.64DMZzLz5h26s12?tk=eImPex96lCQ) | ₹739 | [Amazon India](https://www.amazon.in/SanDisk-Extreme-microSD-Smartphones-Action/dp/B0B2DDJGF8/) |
| USB-C to USB-A Cable 2 pcs | 1 | $8.99 | [Amazon](https://a.co/d/0mWsmhG) | €7 | [Amazon](https://www.amazon.fr/dp/B07BNF842T/) | ￥17 | [Taobao](https://e.tb.cn/h.64HOv24RLmYC4Yh?tk=AXpgexkDFd4) | ₹799 | [Amazon India](https://www.amazon.in/Powerline-Charging-Compatibility-Delivery-MacBook/dp/B07DD5YHMH) |
| USB-C Cable 2 pcs | 1 | $8.99 | [Amazon](https://a.co/d/f8hm4E2) | ~€7 | [TODO](https://www.notion.so/Bill-of-Material-21abb280f59380f48e49e5c51df2b37f?pvs=21) | ￥17 | [Taobao](https://detail.tmall.com/item.htm?abbucket=14&detail_redpacket_pop=true&id=562374737204&ltk2=1745778907089uemkvoxey50xt270pvkfcq&ns=1&priceTId=2100c80417457788995147926e0bd5&query=usbc%E6%95%B0%E6%8D%AE%E7%BA%BF&skuId=5239339491575&spm=a21n57.1.hoverItem.4&utparam=%7B%22aplus_abtest%22%3A%2250461336def889c0b534e9603672d7f7%22%7D&xxc=taobaoSearch) | ₹899 | [Amazon India](https://www.amazon.in/Anker-Charging-MacBook-Galaxy-Charger/dp/B088NRLMPV/) |
| Anker USB Hub | 1 | $15.99 | [Amazon](https://a.co/d/6tJW8lN) |  |  | ￥52 | [Taobao](https://e.tb.cn/h.hTEgXX1RlPY0lWL?tk=AKLz4a3uOsA) | ₹699 | [Amazon India](https://www.amazon.in/Anker-4-Port-Ultra-Extended-MacBook/dp/B07L32B9C2/) |
| 4ft 5264 wires | 1 | $21.99 | [Amazon](https://www.amazon.com/dp/B0D2W47V8V) | ~€20 | [TODO](https://www.notion.so/Bill-of-Material-21abb280f59380f48e49e5c51df2b37f?pvs=21) | ¥20 | [Taobao](https://e.tb.cn/h.6ZvsvUU7wlxTIqu?tk=mz7PeJUloea) 3P-1000mm and 5264 connector | ₹7209 | [Amazon India](https://www.amazon.in/Keszoox-Connector-Assortment-Compatible-Pre-Crimped/dp/B0DCYYWZT7) |
| Type C to DC wire(12V) | 2 | $8.99 | [Amazon 12V](https://www.amazon.com/dp/B0CDBWHXDZ) | ~€8 | [TODO](https://www.notion.so/Bill-of-Material-21abb280f59380f48e49e5c51df2b37f?pvs=21) | ¥20 | [Taobao 12V](https://e.tb.cn/h.6ZvuOW01EmvvHq1?tk=nzvFeJUnyuB) | ₹659 | [Amazon India](https://www.amazon.in/Tobo-7-4x0-6MM-Flexible-Charging-TD-1125CC/dp/B0CQNWRZQ) |

![image](https://github.com/user-attachments/assets/0a8afb77-30b7-4d5c-a981-9b255269f9ec)

- Raspberry Pi 5 is optional, you can just connect XLeRobot to your laptop for an easier setup.
- Ready-made long 5264 wires are not available for purchase in the US—only **connector kits** are available that require manual assembly to extend the length (still easy).
- In India, one may buy the connectors individually from [Sharvi Electronics](https://sharvielectronics.com/?s=5264&post_type=product&product_cat=0) and assemble them.
- 2 USB-C to USB-A cables to connect the Motor Control Board to Raspberry Pi/PC, USB-C to USB-C cables are also OK as long as your computer supports.
- USB-C cable to connect Raspberry Pi to the battery
- Two Type-C to DC cables (12V) connect the motor control board to the power supply.

## 📷 Sensors 

| Part | Amount | Unit Cost (US) | Buy (US) | Unit Cost (EU) | Buy (EU) | Unit Cost (CN) | Buy (CN) | Unit Cost (IN) | Buy (IN) |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| Hand camera | 2 | $12.98 | [Amazon](https://a.co/d/fXX2odP) | ~€10 | [TODO](https://www.notion.so/Bill-of-Material-21abb280f59380f48e49e5c51df2b37f?pvs=21) | ￥99 | [Taobao](https://item.taobao.com/item.htm?ft=t&id=860171734711) | ₹3278 | [Desert Cart](https://www.desertcart.in/products/612412428-innomaker-1080p-usb-2-0-uvc-camera-130-wide-angle) |
| Logitech C920 | 1 | $66 | [Amazon](https://a.co/d/gM8vei1) |  |  | ￥309 |[Taobao]( https://e.tb.cn/h.hjpjA9cw3DpgwQi?tk=DRu642dmCo8 )  | ₹8459 | [Amazon India](https://www.amazon.in/Logitech-C920-Pro-Webcam-Microphones/dp/B006JH8T3S/) |
| RealSense D415 (Optional for Pro) | 1 | $272 | [Intel](https://store.intelrealsense.com/buy-intel-realsense-depth-camera-d415.html) |  |  | ￥1950 |[Taobao](https://e.tb.cn/h.hTHju7zCMDMR84q?tk=z0WU4aXOKey)  | ₹35726 | [Robu.in](https://robu.in/product/intel-d415-realsense-depth-camera/) |

![image](https://github.com/user-attachments/assets/0f5a10ce-d0e9-4e53-b457-27a9ba057cbf)

## 🧑‍🤝‍🧑 Alternative choices 

- **IKEA Cart**: You can use a similar cart not from IKEA; however, this may require minor adjustments to the base connector in [3D printed parts](https://github.com/Vector-Wangel/XLeRobot/tree/main/hardware).
- **Batteries**: You can use **other batteries**, but ensure the maximum output capacity can adequately power 2 arms and 3 wheels(~120W=60W*2 ports) (and a RaspberryPi (40W) if you have one).
- **Electronics**: You can use any brand of cables (USB-C cable must be fast-charging type), microSD card, and Raspberry Pi 5 as long as they are compatible.

## 🧩 Optional Add-ons 

- 🫱Soft Gripper Design: The .3mf file contains soft finray fingers that need to be printed with TPU95A. If you want original SO101 finger, just download the original [SO101.stl](https://github.com/Vector-Wangel/XLeRobot/blob/main/hardware/Ender_Follower_SO101.stl) file.
- ![d2e57534a9e55a3d4dc0d644242cd044](https://github.com/user-attachments/assets/8d095541-d98f-4af8-a43c-028baae0d375)
- ✊Better grip stability: [3M gripper tape](https://www.amazon.com/gp/product/B0093CQPW8/ref=ppx_yo_dt_b_search_asin_title?ie=UTF8&psc=1) (got it from [UMI gripper specifications](https://docs.google.com/document/d/1TPYwV9sNVPAi0ZlAupDMkXZ4CA1hsZx7YDMSmcEy6EU/edit?tab=t.0#heading=h.5k5vwx2iqjqg)) Or any other cheaper one (such as tennis grip tape).
- 🙌Dual-arm leader-follower joint control: Additional two [SO100 arm sets](https://github.com/TheRobotStudio/SO-ARM100/tree/main) for dual-arm leader-follower joint control
- 👗Sleeves: To hide the cables and give XLeRobot a better outfit, just buy the cheapest sport sleeves you can find. [I bought one randomly on Amazon.](https://a.co/d/bjD08Oi)
- 👀VR control: Meta Quest 3 (or 3S)
- For more add-ons and accessories, check out the [SO101 arm repository](https://github.com/TheRobotStudio/SO-ARM100/tree/main?tab=readme-ov-file#optional-hardware)
