# Related Works

🤗Here are all the works, both from robotics research and from the LeRobot community, that I found interesting, meaningful, and have potential for future applications on XLeRobot.

## Blogs

[Analytical IK for SO101](https://vectorwang.notion.site/Analytical-IK-for-SO101-20abb280f59380d288bcdd398ffbfab1?pvs=25)


### 👀 Perception 

#### DRAWER: Convenient Real2Sim with Articulations

[DRAWER: Digital Reconstruction and Articulation with Environment Realism](https://xiahongchi.github.io/DRAWER/)

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Other_works/DRAWER.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>

#### CoTracker

[CoTracker3: Simpler and Better Point Tracking by Pseudo-Labelling Real Videos](https://cotracker3.github.io/)

### 🧠 High-level Task Planning 

#### VJEPA-2: A Self-supervised Foundation World Model

[Introducing V-JEPA 2](https://ai.meta.com/vjepa/)

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Other_works/VJEPA2.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>

### 🙌 Low-level Motion Control

#### HIL-SERL: Current SOTA (personal opinion) for RL

[HIL-SERL: Precise and Dexterous Robotic Manipulation via Human-in-the-Loop Reinforcement Learning](https://hil-serl.github.io/)

[HIL-SERL LeRobot Training Guide](https://huggingface.co/docs/lerobot/hilserl)

#### Caging in Time: A Planning Framework for Robust Object Manipulation

[Caging in Time: A Framework for Robust Object Manipulation under Uncertainties and Limited Robot Perception](https://journals.sagepub.com/doi/pdf/10.1177/02783649251343926)

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Other_works/CIT.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>

### 👨‍🔧 Hardware

#### 3D Vitac: Low-cost Velostat Tactile Sensor

[3D-ViTac: Learning Fine-Grained Manipulation with Visuo-Tactile Sensing](https://binghao-huang.github.io/3D-ViTac/)

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Other_works/3D-Vitac.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>



#### E-flesh: Low-cost Magnetic Tactile Sensor

[eFlesh: Highly customizable Magnetic Touch Sensing using Cut-Cell Microstructures](https://e-flesh.com)

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Other_works/eflesh.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>

#### BACH hand: Belt-driven Active Surface Finger 

[Belt–Augmented Compliant Hand](https://yuanshenli.com/bach.html)

<img src="https://vector-wangel.github.io/XLeRobot-assets/videos/Other_works/bach.gif" width="100%" style="max-width: 100%;" alt="BACH hand demo"/>

### 💻 Simulation

#### Maniskill: Light-weight GPU-accelerated Manipulation-focused Simulator

[ManiSkill — ManiSkill 3.0.0b21 documentation](https://maniskill.readthedocs.io/en/latest/)

#### RoboTwin: Large bimanual Manipulation Benchmark based on Maniskill

[RoboTwin 2.0: A Scalable Data Generator and Benchmark with Strong Domain Randomization for Robust Bimanual Robotic Manipulation](https://robotwin-platform.github.io/)


### 🧑‍🍳 Developing

#### Bambot: Web-based Control Panel 

[BamBot by Tim Qian](https://bambot.org/)

[BamBot Feetech Servo Control Panel - feetech.js](http://bambot.org/feetech.js)

#### Model Context Protocol (MCP)

- [Using MCP on Lerobot SO101 arm](https://github.com/IliaLarchenko/robot_MCP)
- [The official website of MCP](https://modelcontextprotocol.io/introduction)

#### 3D-reconstruction

[Hunyuan3D-2](https://huggingface.co/spaces/tencent/Hunyuan3D-2)


#### Maniskill Sim2real RL

[lerobot-sim2real by Stone Tao](https://github.com/StoneT2000/lerobot-sim2real)




