## SO100/SO101 Arm Examples

### Keyboard Joint Control

The most basic control method using direct joint angle manipulation. Run `0_so100_keyboard_joint_control.py` for manual control of individual joint positions using keyboard inputs. This provides direct access to each joint's movement without inverse kinematics calculations.

### Keyboard End-Effector Control

Advanced control using inverse kinematics to move the end-effector in Cartesian space. Run `1_so100_keyboard_ee_control.py` for intuitive control where keyboard inputs control the end-effector position (X, Y coordinates) rather than individual joints.

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Real_demos/keyboard_teleop.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>

### Dual-Arm Keyboard Control

Simultaneous control of two SO100 arms connected via different serial ports (/dev/ttyACM0 and /dev/ttyACM1). Run `2_dual_so100_keyboard_ee_control.py` for coordinated dual-arm manipulation with separate keyboard mappings for each arm.

### Vision-based Object Following

YOLO-powered object detection and tracking system. Run `3_so100_yolo_ee_control.py` to enable the robot to automatically follow detected objects (such as bottles) using computer vision. This demo requires no training and combines real-time object detection with end-effector control. 

You can check [Ultralytics official website](https://docs.ultralytics.com/models/) to try all kinds of different Vision-related models and applications in an extremely easy way.

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Real_demos/yolo.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>