# 🖨️ 3D打印

![image](https://github.com/user-attachments/assets/293de41b-8f79-49eb-af0a-822879e9b5a0)

## [在此下载3D模型](https://github.com/Vector-Wangel/XLeRobot/tree/main/hardware)

## 🤔 打印前准备 

> 我们假设你有使用消费级3D打印机(BambuLab、Prusa等)的基本经验。这意味着你知道如何正确地使用PLA耗材3D打印STL文件，并熟悉重新定向零件、添加支撑、调整填充率和修改打印速度，以在材料强度、效率和模型细节质量之间达到理想的平衡。
> 
- 更详细的信息，你可以查看[Lekiwi](https://github.com/SIGRobotics-UIUC/LeKiwi/blob/main/3DPrinting.md)和[SO101手臂](https://github.com/TheRobotStudio/SO-ARM100#printing-the-parts)的3D打印说明。
- XLeRobot演示视频和图片中显示的所有3D打印零件都是用**BambuLab A1使用BambuLab PLA哑光黑色**打印的。
- 你也可以使用具有更好机械性能的耗材，如[**PETG HF、PLA CF**](https://us.store.bambulab.com/products/pla-cf)、[**BambuLab Tough PLA**](https://us.store.bambulab.com/products/pla-tough-upgrade)等，以增强手臂的强度。
- 对于潮湿环境，建议在打印前将PLA在45°C下烘干8小时。

### 💰 成本考虑

* **自有打印机** (推荐): 所有零件都可以在[BambuLab A1 (~$350 USD)](https://us.store.bambulab.com/products/a1)等消费级3D打印机上打印，你可以轻松制作更多并修改自己的零件。
* **耗材成本**: 所需PLA耗材约15-25美元
* **服务打印**: 如果使用3D打印服务，包含服务费在内的总成本通常不超过50美元

```{note}
你也可以参考([Lekiwi](https://github.com/SIGRobotics-UIUC/LeKiwi/blob/main/3DPrinting.md)和[SO101手臂](https://github.com/TheRobotStudio/SO-ARM100#printing-the-parts))的说明以及本教程。
```

```{note}
注意[3D打印.3mf文件](https://github.com/Vector-Wangel/XLeRobot/tree/main/hardware)仅用于存储模型。强烈建议在切片软件中自己放置、定向和添加支撑，以确保最佳打印质量。
```

## 🖖 SO101手臂

![image](https://github.com/user-attachments/assets/23e253d0-2049-4b72-ac40-394c70b16849)

- 对于XLeRobot，你只需要打印两个跟随手臂。[主导手臂](https://github.com/TheRobotStudio/SO-ARM100/tree/main?tab=readme-ov-file#printing-the-parts)只有在你计划用主从关节控制同时操作双臂时才需要。

- 打印前，请在切片软件中重新排列此stl文件的布局，以获得最佳打印体验。

- 📷相机: 你可以在这里找到[手腕相机支架的安装指南](https://github.com/TheRobotStudio/SO-ARM100/tree/main/Optional/SO101_Wrist_Cam_Hex-Nut_Mount_32x32_UVC_Module)。

- 🫱软抓手: .3mf文件包含需要用TPU95A打印的软鳍指。如果你想要原始SO101手指，只需下载原始[SO101.stl](https://github.com/Vector-Wangel/XLeRobot/blob/main/hardware/Ender_Follower_SO101.stl)文件。
- ![d2e57534a9e55a3d4dc0d644242cd044](https://github.com/user-attachments/assets/8d095541-d98f-4af8-a43c-028baae0d375)

## 🦾 手臂底座

### 📦 手臂底座

![image](https://github.com/user-attachments/assets/33e77b51-c070-4fbf-8487-30af3721f239)

- 连接2个手臂底座以实现标准化的手臂间距。
- 中间存储外壳用于计算设备和线缆管理。
- 你可以插入使用过的Bambulab耗材纸质线轴以提供额外的结构支撑。
- 可选零件: 控制板和第一个关节的外壳，用于更好的保护和视觉效果。

![image](https://github.com/user-attachments/assets/91491f62-a466-4421-ac9b-db3492849a89)

### 🐼 颈部和头部

![image](https://github.com/user-attachments/assets/8c73ae22-e5eb-4488-b20c-54b0ce25c9c1)

- 头部基于SO101的前两个关节设计。与相同电机兼容。
- .3mf文件包含2个版本的单RGB头部相机连接器和外壳，一个用于网络摄像头和realsense，另一个用于与手部相机相同的更便宜的相机。

- ![image](https://github.com/user-attachments/assets/73f357b1-dc40-437a-9cc6-d4a4dc2f5435)
- 你可以使用任何你喜欢的头部相机，只需对最后的安装连杆进行小幅修改。步骤文件可在[这里](https://github.com/Vector-Wangel/XLeRobot/tree/main/hardware/step)获得，供你调整。
- 中空颈部用于节省耗材和线缆管理。

## 🧑‍🦼‍➡️ 轮式底座

![image](https://github.com/user-attachments/assets/c51bcbb2-8a97-4066-8876-31f11537fff4)

- 通过在切片软件中修改底座连接器的z轴比例(同时保持xy轴比例)来调整其高度，以确保底座上的3个全向轮和4个宜家推车轮子之间的压力分布均匀。
- ![image](https://github.com/user-attachments/assets/eff69573-badc-46b2-b66f-c28174090598)
- 调整底座连接器的替代方案: 只需打印下面的垫圈并将其插入宜家推车，以获得最佳底座支撑。
- ![image](https://github.com/user-attachments/assets/e603a529-0690-4ce0-8d3b-381af0c86155)

### 💰 成本考虑

* **自有打印机** (推荐): 所有零件都可以在Bambu Lab A1 (~$400 USD)等消费级3D打印机上打印
* **耗材成本**: 所需PLA耗材约15-25美元
* **服务打印**: 如果使用3D打印服务，包含服务费在内的总成本通常不超过50美元











