## SO100/SO101手臂控制示例

### 1. 键盘关节控制

使用直接关节角度操作的最基本控制方法。运行`0_so100_keyboard_joint_control.py`使用键盘输入手动控制各个关节位置。这提供对每个关节运动的直接访问，无需逆运动学计算。

### 2. 键盘末端执行器控制

使用逆运动学在笛卡尔空间中移动末端执行器的高级控制。运行`1_so100_keyboard_ee_control.py`进行直观控制，其中键盘输入控制末端执行器位置(X、Y坐标)而不是单个关节。

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Real_demos/keyboard_teleop.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>

### 3. 双臂键盘控制

通过不同串口(/dev/ttyACM0和/dev/ttyACM1)连接的两个SO100手臂的同时控制。运行`2_dual_so100_keyboard_ee_control.py`进行协调的双臂操作，每个手臂有单独的键盘映射。

### 4. 基于视觉的物体跟踪

YOLO驱动的物体检测和跟踪系统。运行`3_so100_yolo_ee_control.py`使机器人能够使用计算机视觉自动跟踪检测到的物体(如瓶子)。此演示无需训练，结合了实时物体检测和末端执行器控制。

您可以查看[Ultralytics官方网站](https://docs.ultralytics.com/models/)以极其简单的方式尝试各种不同的视觉相关模型和应用。

<video width="100%" controls>
  <source src="https://vector-wangel.github.io/XLeRobot-assets/videos/Real_demos/yolo.mp4" type="video/mp4">
  Your browser does not support the video tag.
</video>
