/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.net.bytebuddy.description;

import com.comphenix.net.bytebuddy.description.ModifierReviewable;
import com.comphenix.net.bytebuddy.description.method.MethodDescription;
import com.comphenix.net.bytebuddy.description.type.TypeDescription;
import com.comphenix.net.bytebuddy.description.type.TypeList;
import com.comphenix.net.bytebuddy.matcher.ElementMatchers;
import com.comphenix.net.bytebuddy.utility.nullability.AlwaysNull;
import com.comphenix.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface TypeVariableSource
extends ModifierReviewable.OfAbstraction {
    @AlwaysNull
    public static final TypeVariableSource UNDEFINED = null;

    public TypeList.Generic getTypeVariables();

    @MaybeNull
    public TypeVariableSource getEnclosingSource();

    public boolean isInferrable();

    @MaybeNull
    public TypeDescription.Generic findVariable(String var1);

    public TypeDescription.Generic findExpectedVariable(String var1);

    public <T> T accept(Visitor<T> var1);

    public boolean isGenerified();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements TypeVariableSource {
        @Override
        @MaybeNull
        public TypeDescription.Generic findVariable(String symbol) {
            TypeList.Generic typeVariables = (TypeList.Generic)this.getTypeVariables().filter(ElementMatchers.named(symbol));
            if (typeVariables.isEmpty()) {
                TypeVariableSource enclosingSource = this.getEnclosingSource();
                return enclosingSource == null ? TypeDescription.Generic.UNDEFINED : enclosingSource.findVariable(symbol);
            }
            return (TypeDescription.Generic)typeVariables.getOnly();
        }

        @Override
        public TypeDescription.Generic findExpectedVariable(String symbol) {
            TypeDescription.Generic variable = this.findVariable(symbol);
            if (variable == null) {
                throw new IllegalArgumentException("Cannot resolve " + symbol + " from " + this.toSafeString());
            }
            return variable;
        }

        protected abstract String toSafeString();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Visitor<T> {
        public T onType(TypeDescription var1);

        public T onMethod(MethodDescription.InDefinedShape var1);

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static enum NoOp implements Visitor<TypeVariableSource>
        {
            INSTANCE;


            @Override
            public TypeVariableSource onType(TypeDescription typeDescription) {
                return typeDescription;
            }

            @Override
            public TypeVariableSource onMethod(MethodDescription.InDefinedShape methodDescription) {
                return methodDescription;
            }
        }
    }
}

