/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrent;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketListener;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PacketTypeListenerSet {
    private final Map<PacketType, Set<PacketListener>> typeMap = new HashMap<PacketType, Set<PacketListener>>();
    private final Set<Class<?>> classSet = new HashSet();

    public synchronized boolean add(PacketType packetType, PacketListener listener) {
        Objects.requireNonNull(packetType, "packetType cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        Set listenerSet = this.typeMap.computeIfAbsent(packetType, key -> new HashSet());
        if (!listenerSet.add(listener)) {
            return false;
        }
        this.classSet.add(packetType.getPacketClass());
        return true;
    }

    public synchronized boolean remove(PacketType packetType, PacketListener listener) {
        Objects.requireNonNull(packetType, "packetType cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        Set<PacketListener> listenerSet = this.typeMap.get(packetType);
        if (listenerSet == null) {
            assert (!this.classSet.contains(packetType.getPacketClass()));
            return false;
        }
        if (!listenerSet.remove(listener)) {
            return false;
        }
        if (listenerSet.isEmpty()) {
            this.typeMap.remove(packetType);
            this.classSet.remove(packetType.getPacketClass());
        }
        return true;
    }

    public boolean contains(PacketType packetType) {
        return this.typeMap.containsKey(packetType);
    }

    public boolean contains(Class<?> packetClass) {
        return this.classSet.contains(packetClass);
    }

    public ImmutableSet<PacketType> values() {
        return ImmutableSet.copyOf(this.typeMap.keySet());
    }

    public void clear() {
        this.typeMap.clear();
        this.classSet.clear();
    }
}

