/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketStream;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.google.common.base.Preconditions;
import org.bukkit.entity.Player;

public class ScheduledPacket {
    protected PacketContainer packet;
    protected Player target;
    protected boolean filtered;

    public ScheduledPacket(PacketContainer packet, Player target, boolean filtered) {
        this.setPacket(packet);
        this.setTarget(target);
        this.setFiltered(filtered);
    }

    public static ScheduledPacket fromSilent(PacketContainer packet, Player target) {
        return new ScheduledPacket(packet, target, false);
    }

    public static ScheduledPacket fromFiltered(PacketContainer packet, Player target) {
        return new ScheduledPacket(packet, target, true);
    }

    public PacketContainer getPacket() {
        return this.packet;
    }

    public void setPacket(PacketContainer packet) {
        this.packet = (PacketContainer)Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be NULL");
    }

    public Player getTarget() {
        return this.target;
    }

    public void setTarget(Player target) {
        this.target = (Player)Preconditions.checkNotNull((Object)target, (Object)"target cannot be NULL");
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public PacketType.Sender getSender() {
        return this.packet.getType().getSender();
    }

    public void schedule() {
        this.schedule(ProtocolLibrary.getProtocolManager());
    }

    public void schedule(PacketStream stream) {
        Preconditions.checkNotNull((Object)stream, (Object)"stream cannot be NULL");
        if (this.getSender() == PacketType.Sender.CLIENT) {
            stream.receiveClientPacket(this.getTarget(), this.getPacket(), this.isFiltered());
        } else {
            stream.sendServerPacket(this.getTarget(), this.getPacket(), this.isFiltered());
        }
    }

    public String toString() {
        return "ScheduledPacket[packet=" + String.valueOf(this.packet) + ", target=" + String.valueOf(this.target) + ", filtered=" + this.filtered + "]";
    }
}

