/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.net.bytebuddy.dynamic.DynamicType;
import com.comphenix.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import com.comphenix.net.bytebuddy.implementation.FixedValue;
import com.comphenix.net.bytebuddy.matcher.ElementMatchers;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.packet.KnownPacketData;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.reflect.instances.InstanceCreator;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftRegistryAccess;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.utility.ZeroBuffer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedStreamCodec;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class StructureCache {
    private static final Map<Class<?>, Optional<Supplier<Object>>> CACHED_INSTANCE_CREATORS = new ConcurrentHashMap();
    private static final Map<PacketType, StructureModifier<Object>> STRUCTURE_MODIFIER_CACHE = new ConcurrentHashMap<PacketType, StructureModifier<Object>>();
    private static final Object TRICK_INIT_LOCK = new Object();
    private static boolean TRICK_TRIED = false;
    private static Function<ByteBuf, Object> TRICKED_DATA_SERIALIZER_BASE;
    private static Supplier<Object> TRICKED_DATA_SERIALIZER_JSON;

    @Deprecated
    public static Object newPacket(Class<?> packetClass) {
        return StructureCache.newInstance(packetClass);
    }

    public static boolean canCreateInstance(Class<?> clazz) {
        Optional creator = CACHED_INSTANCE_CREATORS.computeIfAbsent(clazz, x -> Optional.ofNullable(StructureCache.determineBestCreator(clazz)));
        return creator.isPresent();
    }

    public static Object newInstance(Class<?> clazz) {
        Optional creator = CACHED_INSTANCE_CREATORS.computeIfAbsent(clazz, x -> Optional.ofNullable(StructureCache.determineBestCreator(clazz)));
        if (!creator.isPresent()) {
            throw new IllegalArgumentException("Cannot create instance of " + String.valueOf(clazz));
        }
        return ((Supplier)creator.get()).get();
    }

    static Supplier<Object> determineBestCreator(Class<?> clazz) {
        Object instance;
        ConstructorAccessor serializerAccessor;
        FuzzyReflection fuzzy;
        List<Field> singletons;
        if (MinecraftReflection.isPacketClass(clazz) && (singletons = (fuzzy = FuzzyReflection.fromClass(clazz, false)).getFieldList(FuzzyFieldContract.newBuilder().typeExact(clazz).requireModifier(8).requireModifier(1).build())).size() == 1) {
            FieldAccessor accessor = Accessors.getFieldAccessor(singletons.get(0));
            try {
                accessor.get(null);
                return () -> accessor.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            InstanceCreator creator = InstanceCreator.forClass(clazz);
            if (creator.get() != null) {
                return creator;
            }
        }
        catch (Exception creator) {
            // empty catch block
        }
        WrappedStreamCodec streamCodec = PacketRegistry.getStreamCodec(clazz);
        if (streamCodec != null && StructureCache.tryInitTrickDataSerializer()) {
            try {
                Object serializer = TRICKED_DATA_SERIALIZER_BASE.apply(new ZeroBuffer());
                streamCodec.decode(serializer);
                return () -> streamCodec.decode(serializer);
            }
            catch (Exception ex) {
                try {
                    byte[] data;
                    if (clazz.equals(PacketType.Play.Server.MAP_CHUNK.getPacketClass())) {
                        data = KnownPacketData.MAP_CHUNK;
                    } else if (clazz.equals(PacketType.Play.Server.SCOREBOARD_OBJECTIVE.getPacketClass())) {
                        data = KnownPacketData.SCOREBOARD_OBJECTIVE;
                    } else {
                        throw ex;
                    }
                    Object serializer = TRICKED_DATA_SERIALIZER_BASE.apply(Unpooled.copiedBuffer((byte[])data));
                    streamCodec.decode(serializer);
                    return () -> {
                        ((ByteBuf)serializer).readerIndex(0);
                        return streamCodec.decode(serializer);
                    };
                }
                catch (Exception ignored1) {
                    try {
                        Object serializer = TRICKED_DATA_SERIALIZER_JSON.get();
                        streamCodec.decode(serializer);
                        return () -> streamCodec.decode(serializer);
                    }
                    catch (Exception serializer) {
                        // empty catch block
                    }
                }
            }
        }
        if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove() && (serializerAccessor = Accessors.getConstructorAccessorOrNull(clazz, MinecraftReflection.getPacketDataSerializerClass())) != null && StructureCache.tryInitTrickDataSerializer()) {
            try {
                Object serializer = TRICKED_DATA_SERIALIZER_BASE.apply(new ZeroBuffer());
                serializerAccessor.invoke(serializer);
                return () -> serializerAccessor.invoke(serializer);
            }
            catch (Exception ignored) {
                try {
                    Object serializer = TRICKED_DATA_SERIALIZER_JSON.get();
                    serializerAccessor.invoke(serializer);
                    return () -> serializerAccessor.invoke(serializer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((instance = DefaultInstances.DEFAULT.create(clazz)) == null) {
            return null;
        }
        return () -> DefaultInstances.DEFAULT.create(clazz);
    }

    public static Object newPacket(PacketType type) {
        return StructureCache.newPacket(PacketRegistry.getPacketClassFromType(type));
    }

    @Deprecated
    public static StructureModifier<Object> getStructure(Class<?> packetType) {
        PacketType type = PacketRegistry.getPacketType(packetType);
        Preconditions.checkNotNull((Object)type, (Object)("No packet type associated with " + String.valueOf(packetType)));
        return StructureCache.getStructure(type);
    }

    public static StructureModifier<Object> getStructure(PacketType packetType) {
        Preconditions.checkNotNull((Object)packetType, (Object)"type cannot be null");
        return STRUCTURE_MODIFIER_CACHE.computeIfAbsent(packetType, type -> {
            Class<?> packetClass = PacketRegistry.getPacketClassFromType(type);
            if (MinecraftReflection.isBundleDelimiter(packetClass)) {
                packetClass = MinecraftReflection.getPackedBundlePacketClass().get();
            }
            return new StructureModifier(packetClass, MinecraftReflection.getPacketClass(), true);
        });
    }

    public static Object newNullDataSerializer() {
        StructureCache.tryInitTrickDataSerializer();
        return TRICKED_DATA_SERIALIZER_BASE.apply(new ZeroBuffer());
    }

    static void initTrickDataSerializer() {
        Optional<Class<?>> registryByteBuf = MinecraftReflection.getRegistryFriendlyByteBufClass();
        Object textCompound = WrappedChatComponent.fromText("").getHandle();
        Object compound = Accessors.getConstructorAccessor(MinecraftReflection.getNBTCompoundClass(), new Class[0]).invoke(new Object[0]);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition baseBuilder = ByteBuddyFactory.getInstance().createSubclass(registryByteBuf.orElse(MinecraftReflection.getPacketDataSerializerClass())).name(MinecraftMethods.class.getPackage().getName() + ".ProtocolLibTricksNmsDataSerializerBase").method(ElementMatchers.takesArguments(MinecraftReflection.getNBTReadLimiterClass()).and(ElementMatchers.returns(ElementMatchers.isSubTypeOf(MinecraftReflection.getNBTBaseClass())))).intercept(FixedValue.value(compound)).method(ElementMatchers.returns(MinecraftReflection.getIChatBaseComponentClass())).intercept(FixedValue.value(textCompound)).method(ElementMatchers.returns(PublicKey.class).and(ElementMatchers.takesNoArguments())).intercept(FixedValue.nullValue());
        Class serializerBase = baseBuilder.make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded();
        if (registryByteBuf.isPresent()) {
            accessor = Accessors.getConstructorAccessor(FuzzyReflection.fromClass(serializerBase, true).getConstructor(FuzzyMethodContract.newBuilder().parameterDerivedOf(ByteBuf.class).parameterDerivedOf(MinecraftReflection.getRegistryAccessClass()).build()));
            TRICKED_DATA_SERIALIZER_BASE = buf -> accessor.invoke(buf, MinecraftRegistryAccess.get());
        } else {
            accessor = Accessors.getConstructorAccessor(serializerBase, ByteBuf.class);
            TRICKED_DATA_SERIALIZER_BASE = xva$0 -> accessor.invoke(xva$0);
        }
        Class withStringIntercept = baseBuilder.name(MinecraftMethods.class.getPackage().getName() + ".ProtocolLibTricksNmsDataSerializerJson").method(ElementMatchers.returns(String.class).and(ElementMatchers.takesArguments(Integer.TYPE))).intercept(FixedValue.value("{}")).make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded();
        if (registryByteBuf.isPresent()) {
            ConstructorAccessor accessor = Accessors.getConstructorAccessor(FuzzyReflection.fromClass(withStringIntercept).getConstructor(FuzzyMethodContract.newBuilder().parameterDerivedOf(ByteBuf.class).parameterDerivedOf(MinecraftReflection.getRegistryAccessClass()).build()));
            TRICKED_DATA_SERIALIZER_JSON = () -> accessor.invoke(new Object[]{new ZeroBuffer(), MinecraftRegistryAccess.get()});
        } else {
            ConstructorAccessor accessor = Accessors.getConstructorAccessor(withStringIntercept, ByteBuf.class);
            TRICKED_DATA_SERIALIZER_JSON = () -> accessor.invoke(new Object[]{new ZeroBuffer()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tryInitTrickDataSerializer() {
        if (TRICK_TRIED) {
            if (TRICKED_DATA_SERIALIZER_BASE == null) return false;
            return true;
        }
        Object object = TRICK_INIT_LOCK;
        synchronized (object) {
            if (TRICK_TRIED) {
                if (TRICKED_DATA_SERIALIZER_BASE == null) return false;
                return true;
            }
            try {
                StructureCache.initTrickDataSerializer();
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                TRICK_TRIED = true;
            }
            return false;
        }
    }
}

