/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.collection;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.concurrent.PacketTypeListenerSet;
import com.comphenix.protocol.concurrent.PacketTypeMultiMap;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.timing.TimingListenerType;
import com.comphenix.protocol.timing.TimingTrackerManager;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class PacketListenerSet {
    private static final ReportType REPORT_UNSUPPORTED_PACKET = new ReportType("Plugin %s tried to register listener for unknown packet %s [direction: from %s]");
    private static final ReportType REPORT_NULL_PACKET = new ReportType("Plugin %s tried to set a packet or packet handle to null [type: %s, direction: %s]");
    protected final PacketTypeMultiMap<PacketListener> map = new PacketTypeMultiMap();
    protected final PacketTypeListenerSet mainThreadPacketTypes;
    protected final ErrorReporter errorReporter;

    public PacketListenerSet(PacketTypeListenerSet mainThreadPacketTypes, ErrorReporter errorReporter) {
        this.mainThreadPacketTypes = mainThreadPacketTypes;
        this.errorReporter = errorReporter;
    }

    protected abstract ListeningWhitelist getListeningWhitelist(PacketListener var1);

    public void addListener(PacketListener packetListener) {
        ListeningWhitelist listeningWhitelist = this.getListeningWhitelist(packetListener);
        Iterator<PacketType> packet = listeningWhitelist.getTypes().iterator();
        while (packet.hasNext()) {
            PacketType packetType = packet.next();
            Set<PacketType> supportedPacketTypes = packetType.getSender() == PacketType.Sender.SERVER ? PacketRegistry.getServerPacketTypes() : PacketRegistry.getClientPacketTypes();
            if (supportedPacketTypes.contains(packetType)) continue;
            this.errorReporter.reportWarning((Object)this, Report.newBuilder(REPORT_UNSUPPORTED_PACKET).messageParam(new Object[]{PacketAdapter.getPluginName(packetListener), packetType, packetType.getSender()}).build());
            packet.remove();
        }
        this.map.put(listeningWhitelist, packetListener);
        Set<ListenerOptions> options = listeningWhitelist.getOptions();
        for (PacketType packetType : listeningWhitelist.getTypes()) {
            boolean isInboundSync;
            if (this.mainThreadPacketTypes == null || packetType.isAsyncForced()) continue;
            boolean isOutboundSync = packetType.getSender() == PacketType.Sender.SERVER && !options.contains((Object)ListenerOptions.ASYNC);
            boolean bl = isInboundSync = packetType.getSender() == PacketType.Sender.CLIENT && options.contains((Object)ListenerOptions.SYNC);
            if (!isOutboundSync && !isInboundSync) continue;
            this.mainThreadPacketTypes.add(packetType, packetListener);
        }
    }

    public void removeListener(PacketListener packetListener) {
        ListeningWhitelist listeningWhitelist = this.getListeningWhitelist(packetListener);
        this.map.remove(listeningWhitelist, packetListener);
        if (this.mainThreadPacketTypes != null) {
            for (PacketType packetType : listeningWhitelist.getTypes()) {
                this.mainThreadPacketTypes.remove(packetType, packetListener);
            }
        }
    }

    public final boolean containsPacketType(PacketType packetType) {
        return this.map.contains(packetType);
    }

    public final ImmutableSet<PacketType> getPacketTypes() {
        return this.map.getPacketTypes();
    }

    public void invoke(PacketEvent event) {
        this.invoke(event, null);
    }

    public void invoke(PacketEvent event, @Nullable ListenerPriority priorityFilter) {
        Iterable<PacketListener> listeners = this.map.get(event.getPacketType());
        for (PacketListener listener : listeners) {
            ListeningWhitelist listeningWhitelist = listener.getReceivingWhitelist();
            if (priorityFilter != null && listeningWhitelist.getPriority() != priorityFilter) continue;
            PacketContainer originalPacket = event.getPacket();
            if (originalPacket == null || originalPacket.getHandle() == null) break;
            TimingTrackerManager.get(listener, event.isServerPacket() ? TimingListenerType.SYNC_OUTBOUND : TimingListenerType.SYNC_INBOUND).track(event.getPacketType(), () -> this.invokeListener(event, listener));
            PacketContainer newPacket = event.getPacket();
            if (newPacket != null && newPacket.getHandle() != null) continue;
            this.errorReporter.reportWarning((Object)this, Report.newBuilder(REPORT_NULL_PACKET).messageParam(new Object[]{PacketAdapter.getPluginName(listener), originalPacket.getType(), originalPacket.getType().getSender()}).build());
            event.setPacket(originalPacket);
        }
    }

    protected abstract void invokeListener(PacketEvent var1, PacketListener var2);

    public void clear() {
        this.map.clear();
    }
}

