/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class PacketListenerInvoker {
    private static final Class<?> PACKET_LISTENER_CLASS = MinecraftReflection.getMinecraftClass("network.PacketListener", "PacketListener");
    private static final Class<?> GAME_PACKET_LISTENER_CLASS = MinecraftReflection.getPlayerConnectionClass();
    private static final Class<?> COMMON_PACKET_LISTENER_CLASS = MinecraftReflection.getNullableNMS("server.network.ServerCommonPacketListenerImpl", new String[0]);
    private static final Class<?> PREFERRED_PACKET_LISTENER_CLASS = COMMON_PACKET_LISTENER_CLASS != null ? COMMON_PACKET_LISTENER_CLASS : GAME_PACKET_LISTENER_CLASS;
    private static final MethodAccessor PACKET_LISTENER_SEND = PacketListenerInvoker.getPacketListenerSend();
    private static final MethodAccessor PACKET_LISTENER_DISCONNECT = PacketListenerInvoker.getPacketListenerDisconnect();
    private static final boolean DOES_PACKET_LISTENER_DISCONNECT_USE_COMPONENT = PacketListenerInvoker.doesPacketListenerDisconnectUseComponent();
    private static final MethodAccessor NETWORK_MANAGER_SEND = PacketListenerInvoker.getNetworkManagerSend();
    private static final MethodAccessor NETWORK_MANAGER_READ = PacketListenerInvoker.getNetworkManagerRead();
    private static final MethodAccessor NETWORK_MANAGER_DISCONNECT = PacketListenerInvoker.getNetworkManagerDisconnect();
    private static final MethodAccessor NETWORK_MANAGER_PACKET_LISTENER = PacketListenerInvoker.getNetworkManagerPacketListener();
    private final Object networkManager;
    private final AtomicReference<Object> packetListener = new AtomicReference<Object>(null);

    public static void ensureStaticInitializedWithoutError() {
    }

    private static MethodAccessor getPacketListenerSend() {
        FuzzyReflection packetListener = FuzzyReflection.fromClass(PREFERRED_PACKET_LISTENER_CLASS);
        List<Method> send = packetListener.getMethodList(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().parameterCount(1).parameterExactType(MinecraftReflection.getPacketClass(), 0).build());
        if (send.isEmpty()) {
            ProtocolLogger.debug("Can't get packet listener send method", new Object[0]);
            return null;
        }
        return Accessors.getMethodAccessor(send.get(0));
    }

    private static MethodAccessor getPacketListenerDisconnect() {
        FuzzyReflection packetListener = FuzzyReflection.fromClass(PREFERRED_PACKET_LISTENER_CLASS);
        List<Method> disconnect = packetListener.getMethodList(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().parameterCount(1).parameterExactType(MinecraftReflection.getIChatBaseComponentClass(), 0).build());
        if (disconnect.isEmpty()) {
            disconnect = packetListener.getMethodList(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().nameRegex("disconnect.*").parameterCount(1).parameterExactType(String.class, 0).build());
        }
        if (disconnect.isEmpty()) {
            ProtocolLogger.debug("Can't get packet listener disconnect method", new Object[0]);
            return null;
        }
        return Accessors.getMethodAccessor(disconnect.get(0));
    }

    private static boolean doesPacketListenerDisconnectUseComponent() {
        if (PACKET_LISTENER_DISCONNECT != null) {
            Parameter reason = PACKET_LISTENER_DISCONNECT.getMethod().getParameters()[0];
            return MinecraftReflection.isIChatBaseComponent(reason.getClass());
        }
        return false;
    }

    private static MethodAccessor getNetworkManagerSend() {
        FuzzyReflection networkManager = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass());
        Method send = networkManager.getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().parameterCount(1).parameterExactType(MinecraftReflection.getPacketClass(), 0).build());
        return Accessors.getMethodAccessor(send);
    }

    private static MethodAccessor getNetworkManagerRead() {
        FuzzyReflection networkManager = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass(), true);
        Method read = networkManager.getMethodByParameters("read", ChannelHandlerContext.class, MinecraftReflection.getPacketClass());
        return Accessors.getMethodAccessor(read);
    }

    private static MethodAccessor getNetworkManagerDisconnect() {
        FuzzyReflection networkManager = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass());
        Method disconnect = networkManager.getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().parameterCount(1).parameterExactType(MinecraftReflection.getIChatBaseComponentClass(), 0).build());
        return Accessors.getMethodAccessor(disconnect);
    }

    private static MethodAccessor getNetworkManagerPacketListener() {
        FuzzyReflection networkManager = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass());
        Method packetListener = networkManager.getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeExact(PACKET_LISTENER_CLASS).parameterCount(0).build());
        return Accessors.getMethodAccessor(packetListener);
    }

    PacketListenerInvoker(Object networkManager) {
        if (!MinecraftReflection.is(MinecraftReflection.getNetworkManagerClass(), networkManager)) {
            throw new IllegalArgumentException("Given NetworkManager isn't an isntance of NetworkManager");
        }
        this.networkManager = networkManager;
    }

    private Object getPacketListener() {
        Object packetListener = NETWORK_MANAGER_PACKET_LISTENER.invoke(this.networkManager, new Object[0]);
        if (!this.packetListener.compareAndSet(packetListener, packetListener)) {
            if (PREFERRED_PACKET_LISTENER_CLASS.isInstance(packetListener)) {
                this.packetListener.set(packetListener);
            } else {
                this.packetListener.set(null);
            }
        }
        return this.packetListener.get();
    }

    public void send(Object packet) {
        Object packetListener = this.getPacketListener();
        if (PACKET_LISTENER_SEND != null && packetListener != null) {
            PACKET_LISTENER_SEND.invoke(packetListener, packet);
        } else {
            NETWORK_MANAGER_SEND.invoke(this.networkManager, packet);
        }
    }

    public void read(Object packet) {
        NETWORK_MANAGER_READ.invoke(this.networkManager, null, packet);
    }

    public void disconnect(String reason) {
        Object packetListener = this.getPacketListener();
        boolean hasPacketListener = PACKET_LISTENER_DISCONNECT != null && packetListener != null;
        Object wrapped = reason;
        if (!hasPacketListener || DOES_PACKET_LISTENER_DISCONNECT_USE_COMPONENT) {
            wrapped = WrappedChatComponent.fromText(reason).getHandle();
        }
        if (hasPacketListener) {
            PACKET_LISTENER_DISCONNECT.invoke(packetListener, wrapped);
        } else {
            NETWORK_MANAGER_DISCONNECT.invoke(this.networkManager, wrapped);
        }
    }
}

