/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet.internal;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.injector.packet.internal.IdCodecWrapper;
import com.comphenix.protocol.injector.packet.internal.ProtocolContexts;
import com.comphenix.protocol.injector.packet.internal.ProtocolInfoWrapper;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtocolRegistry_1_20_5 {
    private static final Class<?> PACKET_TYPE_CLASS = MinecraftReflection.getMinecraftClass("network.protocol.PacketType");
    public static final List<String> PACKET_TYPES_CLASS_NAMES = List.of("common.CommonPacketTypes", "configuration.ConfigurationPacketTypes", "cookie.CookiePacketTypes", "game.GamePacketTypes", "handshake.HandshakePacketTypes", "login.LoginPacketTypes", "ping.PingPacketTypes", "status.StatusPacketTypes");
    public static final List<Protocol> PROTOCOLS = List.of(new Protocol("configuration.ConfigurationProtocols", null), new Protocol("game.GameProtocols", ProtocolContexts::createGameProtocolContext), new Protocol("handshake.HandshakeProtocols", null), new Protocol("login.LoginProtocols", null), new Protocol("status.StatusProtocols", null));

    public static void fillRegister(PacketRegistry.Register register) {
        Map<Object, Class<?>> packetTypeMap = ProtocolRegistry_1_20_5.getPacketTypes();
        for (Protocol protocol : PROTOCOLS) {
            Class<?> protocolClass = MinecraftReflection.getNullableNMS("network.protocol." + protocol.className(), new String[0]);
            if (protocolClass == null) {
                ProtocolLogger.debug("Can't find protocol class: {0}, will skip it", protocol);
                continue;
            }
            for (Field field : protocolClass.getDeclaredFields()) {
                try {
                    Object fieldValue;
                    if (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !ProtocolInfoWrapper.isUnboundProtocol(fieldValue = field.get(null))) continue;
                    Object context = protocol.context() != null ? protocol.context().get() : null;
                    ProtocolInfoWrapper protocolInfo = ProtocolInfoWrapper.fromUnbound(fieldValue, context);
                    PacketType.Protocol packetProtocol = protocolInfo.id();
                    PacketType.Sender packetSender = protocolInfo.flow();
                    List<IdCodecWrapper.Entry> entries = protocolInfo.codec().getById();
                    for (int id = 0; id < entries.size(); ++id) {
                        IdCodecWrapper.Entry entry = entries.get(id);
                        Class<?> packetClass = packetTypeMap.get(entry.type());
                        if (packetClass == null) {
                            throw new RuntimeException("packetType missing packet " + String.valueOf(entry.type()));
                        }
                        PacketType packetType = PacketType.fromCurrent(packetProtocol, packetSender, id, packetClass);
                        register.registerPacket(packetType, packetClass, packetSender, entry.serializer());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Map<Object, Class<?>> getPacketTypes() {
        HashMap packetTypeMap = new HashMap();
        for (String packetTypesClassName : PACKET_TYPES_CLASS_NAMES) {
            Class<?> packetTypesClass = MinecraftReflection.getNullableNMS("network.protocol." + packetTypesClassName, new String[0]);
            if (packetTypesClass == null) {
                ProtocolLogger.debug("Can't find PacketType class: {0}, will skip it", packetTypesClassName);
                continue;
            }
            for (Field field : packetTypesClass.getDeclaredFields()) {
                try {
                    Type packet;
                    Object packetType;
                    if (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !PACKET_TYPE_CLASS.isInstance(packetType = field.get(null)) || !((packet = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                    packetTypeMap.put(packetType, (Class)packet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return packetTypeMap;
    }

    private record Protocol(@NotNull String className, @Nullable Supplier<Object> context) {
    }
}

