/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.scheduler;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.scheduler.Task;
import org.bukkit.plugin.Plugin;

public abstract class UniversalRunnable
implements Runnable {
    Task task;

    public synchronized void cancel() throws IllegalStateException {
        this.checkScheduled();
        this.task.cancel();
    }

    public synchronized Task runTask(Plugin plugin) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        return this.setupTask(ProtocolLibrary.getScheduler().runTask(this));
    }

    public synchronized Task runTaskLater(Plugin plugin, long delay) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        return this.setupTask(ProtocolLibrary.getScheduler().scheduleSyncDelayedTask(this, delay));
    }

    private void checkScheduled() {
        if (this.task == null) {
            throw new IllegalStateException("Not scheduled yet");
        }
    }

    private void checkNotYetScheduled() {
        if (this.task != null) {
            throw new IllegalStateException("Already scheduled");
        }
    }

    private Task setupTask(Task task) {
        this.task = task;
        return task;
    }
}

