/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.injector.PacketConstructor;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.Converters;
import com.comphenix.protocol.wrappers.Either;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.Pair;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedLevelChunkData;
import com.comphenix.protocol.wrappers.WrappedMessageSignature;
import com.comphenix.protocol.wrappers.WrappedNumberFormat;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedProfilePublicKey;
import com.comphenix.protocol.wrappers.WrappedRegistrable;
import com.comphenix.protocol.wrappers.WrappedRemoteChatSessionData;
import com.comphenix.protocol.wrappers.WrappedSaltedSignature;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedStatistic;
import com.comphenix.protocol.wrappers.WrappedTeamParameters;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class BukkitConverters {
    private static boolean hasWorldType = false;
    private static boolean hasAttributeSnapshot = false;
    private static Map<Class<?>, EquivalentConverter<Object>> genericConverters;
    private static List<PacketConstructor.Unwrapper> unwrappers;
    private static Method worldTypeName;
    private static Method worldTypeGetType;
    private static volatile Constructor<?> mobEffectConstructor;
    private static volatile StructureModifier<Object> mobEffectModifier;
    private static FieldAccessor craftWorldField;
    private static final Map<Class<?>, Supplier<List<Object>>> LIST_SUPPLIERS;
    private static MethodAccessor getEntityTypeName;
    private static MethodAccessor entityTypeFromName;
    private static MethodAccessor BLOCK_FROM_MATERIAL;
    private static MethodAccessor MATERIAL_FROM_BLOCK;
    private static Constructor<?> vec3dConstructor;
    private static StructureModifier<Object> vec3dModifier;
    static MethodAccessor getSound;
    static MethodAccessor getSoundEffect;
    static FieldAccessor soundKey;
    static MethodAccessor bukkitToMinecraft;
    static MethodAccessor minecraftToBukkit;
    static Map<String, Sound> soundIndex;
    private static MethodAccessor getMobEffectId;
    private static MethodAccessor getMobEffect;
    private static Class<?> dimensionManager;
    private static EnumWrappers.FauxEnumConverter<EnumWrappers.Dimension> dimensionConverter;
    private static EnumWrappers.FauxEnumConverter<DimensionImpl> dimensionImplConverter;
    private static MethodAccessor dimensionFromId;
    private static MethodAccessor idFromDimension;
    private static FieldAccessor worldKeyField;
    private static MethodAccessor getServer;
    private static MethodAccessor getWorldServer;
    private static MethodAccessor getWorld;
    private static FieldAccessor dimensionKey;
    private static MethodAccessor worldHandleAccessor;
    private static MethodAccessor worldHandleDimensionManagerAccessor;
    private static ConstructorAccessor merchantRecipeListConstructor;
    private static MethodAccessor bukkitMerchantRecipeToCraft;
    private static MethodAccessor craftMerchantRecipeToNMS;
    private static MethodAccessor nmsMerchantRecipeToBukkit;
    private static MethodAccessor sectionPositionCreate;
    private static Class<?> sectionPositionClass;
    private static Field gameStateMapField;
    private static Field gameStateIdField;

    public static <K, V> EquivalentConverter<Map<K, V>> getMapConverter(final EquivalentConverter<K> keyConverter, final EquivalentConverter<V> valConverter) {
        return new EquivalentConverter<Map<K, V>>(){

            @Override
            public Map<K, V> getSpecific(Object generic) {
                HashMap newMap;
                Map genericMap = (Map)generic;
                try {
                    newMap = (HashMap)genericMap.getClass().newInstance();
                }
                catch (ReflectiveOperationException ex) {
                    newMap = new HashMap();
                }
                for (Map.Entry entry : genericMap.entrySet()) {
                    newMap.put(keyConverter.getSpecific(entry.getKey()), valConverter.getSpecific(entry.getValue()));
                }
                return newMap;
            }

            @Override
            public Object getGeneric(Map<K, V> specific) {
                HashMap<Object, Object> newMap;
                try {
                    newMap = (HashMap<Object, Object>)specific.getClass().newInstance();
                }
                catch (ReflectiveOperationException ex) {
                    newMap = new HashMap<Object, Object>();
                }
                for (Map.Entry entry : specific.entrySet()) {
                    newMap.put(keyConverter.getGeneric(entry.getKey()), valConverter.getGeneric(entry.getValue()));
                }
                return newMap;
            }

            @Override
            public Class<Map<K, V>> getSpecificType() {
                return null;
            }
        };
    }

    private static <T> Object getGenericList(Class<?> listClass, List<T> specific, EquivalentConverter<T> itemConverter) {
        List newList;
        Supplier<List<Object>> supplier = LIST_SUPPLIERS.get(listClass);
        if (supplier == null) {
            try {
                Constructor<?> ctor = listClass.getConstructor(new Class[0]);
                newList = (List)ctor.newInstance(new Object[0]);
                supplier = () -> {
                    try {
                        return (List)ctor.newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new RuntimeException(ex);
                    }
                };
            }
            catch (ReflectiveOperationException ex) {
                supplier = ArrayList::new;
                newList = new ArrayList<Object>();
            }
            LIST_SUPPLIERS.put(listClass, supplier);
        } else {
            newList = supplier.get();
        }
        for (T position : specific) {
            if (position != null) {
                Object converted = itemConverter.getGeneric(position);
                if (converted == null) continue;
                newList.add(converted);
                continue;
            }
            newList.add(null);
        }
        return newList;
    }

    private static <T> List<T> getSpecificList(Object generic, EquivalentConverter<T> itemConverter) {
        if (generic instanceof Collection) {
            ArrayList<T> items = new ArrayList<T>();
            for (Object item : (Collection)generic) {
                T result = itemConverter.getSpecific(item);
                if (item == null) continue;
                items.add(result);
            }
            return items;
        }
        return null;
    }

    public static <T> EquivalentConverter<List<T>> getListConverter(final Class<?> listClass, final EquivalentConverter<T> itemConverter) {
        return Converters.ignoreNull(new EquivalentConverter<List<T>>(){

            @Override
            public List<T> getSpecific(Object generic) {
                return BukkitConverters.getSpecificList(generic, itemConverter);
            }

            @Override
            public Object getGeneric(List<T> specific) {
                return BukkitConverters.getGenericList(listClass, specific, itemConverter);
            }

            @Override
            public Class<List<T>> getSpecificType() {
                Class<List> dummy = List.class;
                return dummy;
            }
        });
    }

    public static <T> EquivalentConverter<List<T>> getListConverter(final EquivalentConverter<T> itemConverter) {
        return Converters.ignoreNull(new EquivalentConverter<List<T>>(){

            @Override
            public List<T> getSpecific(Object generic) {
                return BukkitConverters.getSpecificList(generic, itemConverter);
            }

            @Override
            public Object getGeneric(List<T> specific) {
                return BukkitConverters.getGenericList(specific.getClass(), specific, itemConverter);
            }

            @Override
            public Class<List<T>> getSpecificType() {
                Class<List> dummy = List.class;
                return dummy;
            }
        });
    }

    public static <A, B> EquivalentConverter<Pair<A, B>> getPairConverter(final EquivalentConverter<A> firstConverter, final EquivalentConverter<B> secondConverter) {
        return Converters.ignoreNull(new EquivalentConverter<Pair<A, B>>(){

            @Override
            public Object getGeneric(Pair<A, B> specific) {
                Object first = firstConverter.getGeneric(specific.getFirst());
                Object second = secondConverter.getGeneric(specific.getSecond());
                return new com.mojang.datafixers.util.Pair(first, second);
            }

            @Override
            public Pair<A, B> getSpecific(Object generic) {
                com.mojang.datafixers.util.Pair mjPair = (com.mojang.datafixers.util.Pair)generic;
                Object first = firstConverter.getSpecific(mjPair.getFirst());
                Object second = secondConverter.getSpecific(mjPair.getSecond());
                return new Pair(first, second);
            }

            @Override
            public Class<Pair<A, B>> getSpecificType() {
                Class<Pair> dummy = Pair.class;
                return dummy;
            }
        });
    }

    public static <A, B> EquivalentConverter<Either<A, B>> getEitherConverter(final EquivalentConverter<A> leftConverter, final EquivalentConverter<B> rightConverter) {
        return Converters.ignoreNull(new EquivalentConverter<Either<A, B>>(){

            @Override
            public Object getGeneric(Either<A, B> specific) {
                return specific.map(left -> com.mojang.datafixers.util.Either.left((Object)leftConverter.getGeneric(left)), right -> com.mojang.datafixers.util.Either.right((Object)rightConverter.getGeneric(right)));
            }

            @Override
            public Either<A, B> getSpecific(Object generic) {
                com.mojang.datafixers.util.Either mjEither = (com.mojang.datafixers.util.Either)generic;
                return (Either)mjEither.map(left -> new Either.Left(leftConverter.getSpecific(left)), right -> new Either.Right(rightConverter.getSpecific(right)));
            }

            @Override
            public Class<Either<A, B>> getSpecificType() {
                Class<Either> dummy = Either.class;
                return dummy;
            }
        });
    }

    public static <T> EquivalentConverter<Set<T>> getSetConverter(final EquivalentConverter<T> itemConverter) {
        return Converters.ignoreNull(new EquivalentConverter<Set<T>>(){

            @Override
            public Set<T> getSpecific(Object generic) {
                if (generic instanceof Collection) {
                    HashSet items = new HashSet();
                    for (Object item : (Collection)generic) {
                        Object result = itemConverter.getSpecific(item);
                        if (item == null) continue;
                        items.add(result);
                    }
                    return items;
                }
                return null;
            }

            @Override
            public Object getGeneric(Set<T> specific) {
                HashSet<Object> newList;
                try {
                    newList = (HashSet<Object>)specific.getClass().newInstance();
                }
                catch (ReflectiveOperationException ex) {
                    newList = new HashSet<Object>();
                }
                for (Object position : specific) {
                    if (position != null) {
                        Object converted = itemConverter.getGeneric(position);
                        if (converted == null) continue;
                        newList.add(converted);
                        continue;
                    }
                    newList.add(null);
                }
                return newList;
            }

            @Override
            public Class<Set<T>> getSpecificType() {
                Class<Set> dummy = Set.class;
                return dummy;
            }
        });
    }

    public static <T> EquivalentConverter<Iterable<? extends T>> getArrayConverter(final Class<?> genericItemType, final EquivalentConverter<T> itemConverter) {
        return Converters.ignoreNull(new EquivalentConverter<Iterable<? extends T>>(){

            @Override
            public List<T> getSpecific(Object generic) {
                if (generic instanceof Object[]) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (Object item : (Object[])generic) {
                        Object result = itemConverter.getSpecific(item);
                        builder.add(result);
                    }
                    return builder.build();
                }
                return null;
            }

            @Override
            public Object getGeneric(Iterable<? extends T> specific) {
                ArrayList list = Lists.newArrayList(specific);
                Object[] output = (Object[])Array.newInstance(genericItemType, list.size());
                for (int i = 0; i < output.length; ++i) {
                    Object converted;
                    output[i] = converted = itemConverter.getGeneric(list.get(i));
                }
                return output;
            }

            @Override
            public Class<Iterable<? extends T>> getSpecificType() {
                Class<Iterable> dummy = Iterable.class;
                return dummy;
            }
        });
    }

    public static EquivalentConverter<WrappedGameProfile> getWrappedGameProfileConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedGameProfile::fromHandle, WrappedGameProfile.class));
    }

    public static EquivalentConverter<WrappedChatComponent> getWrappedChatComponentConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedChatComponent::fromHandle, WrappedChatComponent.class));
    }

    public static EquivalentConverter<WrappedBlockData> getWrappedBlockDataConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedBlockData::fromHandle, WrappedBlockData.class));
    }

    public static EquivalentConverter<WrappedRegistrable> getWrappedRegistrable(@NotNull Class<?> registrableClass) {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, handle -> WrappedRegistrable.fromHandle(registrableClass, handle), WrappedRegistrable.class));
    }

    public static EquivalentConverter<WrappedAttribute> getWrappedAttributeConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedAttribute::fromHandle, WrappedAttribute.class));
    }

    public static EquivalentConverter<WrappedProfilePublicKey> getWrappedProfilePublicKeyConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedProfilePublicKey::new, WrappedProfilePublicKey.class));
    }

    public static EquivalentConverter<WrappedProfilePublicKey.WrappedProfileKeyData> getWrappedPublicKeyDataConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedProfilePublicKey.WrappedProfileKeyData::new, WrappedProfilePublicKey.WrappedProfileKeyData.class));
    }

    public static EquivalentConverter<WrappedRemoteChatSessionData> getWrappedRemoteChatSessionDataConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedRemoteChatSessionData::new, WrappedRemoteChatSessionData.class));
    }

    public static EquivalentConverter<WrappedSaltedSignature> getWrappedSignatureConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedSaltedSignature::new, WrappedSaltedSignature.class));
    }

    public static EquivalentConverter<WrappedMessageSignature> getWrappedMessageSignatureConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedMessageSignature::new, WrappedMessageSignature.class));
    }

    public static EquivalentConverter<WrappedLevelChunkData.ChunkData> getWrappedChunkDataConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedLevelChunkData.ChunkData::new, WrappedLevelChunkData.ChunkData.class));
    }

    public static EquivalentConverter<WrappedLevelChunkData.LightData> getWrappedLightDataConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedLevelChunkData.LightData::new, WrappedLevelChunkData.LightData.class));
    }

    public static EquivalentConverter<WrappedTeamParameters> getWrappedTeamParametersConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedTeamParameters::new, WrappedTeamParameters.class));
    }

    public static EquivalentConverter<WrappedNumberFormat> getWrappedNumberFormatConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedNumberFormat::fromHandle, WrappedNumberFormat.class));
    }

    public static EquivalentConverter<PacketContainer> getPacketContainerConverter() {
        return Converters.ignoreNull(Converters.handle(PacketContainer::getHandle, PacketContainer::fromPacket, PacketContainer.class));
    }

    public static EquivalentConverter<WrappedWatchableObject> getWatchableObjectConverter() {
        return Converters.ignoreNull(new EquivalentConverter<WrappedWatchableObject>(){

            @Override
            public Object getGeneric(WrappedWatchableObject specific) {
                return specific.getHandle();
            }

            @Override
            public WrappedWatchableObject getSpecific(Object generic) {
                if (MinecraftReflection.is(MinecraftReflection.getDataWatcherItemClass(), generic)) {
                    return new WrappedWatchableObject(generic);
                }
                if (generic instanceof WrappedWatchableObject) {
                    return (WrappedWatchableObject)generic;
                }
                throw new IllegalArgumentException("Unrecognized type " + String.valueOf(generic.getClass()));
            }

            @Override
            public Class<WrappedWatchableObject> getSpecificType() {
                return WrappedWatchableObject.class;
            }
        });
    }

    public static EquivalentConverter<WrappedDataValue> getDataValueConverter() {
        return Converters.ignoreNull(new EquivalentConverter<WrappedDataValue>(){

            @Override
            public Object getGeneric(WrappedDataValue specific) {
                return specific.getHandle();
            }

            @Override
            public WrappedDataValue getSpecific(Object generic) {
                return new WrappedDataValue(generic);
            }

            @Override
            public Class<WrappedDataValue> getSpecificType() {
                return WrappedDataValue.class;
            }
        });
    }

    public static EquivalentConverter<WrappedDataWatcher> getDataWatcherConverter() {
        return Converters.ignoreNull(new EquivalentConverter<WrappedDataWatcher>(){

            @Override
            public Object getGeneric(WrappedDataWatcher specific) {
                return specific.getHandle();
            }

            @Override
            public WrappedDataWatcher getSpecific(Object generic) {
                if (MinecraftReflection.isDataWatcher(generic)) {
                    return new WrappedDataWatcher(generic);
                }
                if (generic instanceof WrappedDataWatcher) {
                    return (WrappedDataWatcher)generic;
                }
                throw new IllegalArgumentException("Unrecognized type " + String.valueOf(generic.getClass()));
            }

            @Override
            public Class<WrappedDataWatcher> getSpecificType() {
                return WrappedDataWatcher.class;
            }
        });
    }

    public static EquivalentConverter<WorldType> getWorldTypeConverter() {
        if (!hasWorldType) {
            return null;
        }
        final Class<?> worldType = MinecraftReflection.getWorldTypeClass();
        return Converters.ignoreNull(new EquivalentConverter<WorldType>(){

            @Override
            public Object getGeneric(WorldType specific) {
                try {
                    if (worldTypeGetType == null) {
                        worldTypeGetType = FuzzyReflection.fromClass(worldType).getMethodByReturnTypeAndParameters("getType", worldType, String.class);
                    }
                    return worldTypeGetType.invoke((Object)this, specific.getName());
                }
                catch (Exception e) {
                    throw new FieldAccessException("Cannot find the WorldType.getType() method.", e);
                }
            }

            @Override
            public WorldType getSpecific(Object generic) {
                try {
                    if (worldTypeName == null) {
                        try {
                            worldTypeName = worldType.getMethod("name", new Class[0]);
                        }
                        catch (Exception e) {
                            worldTypeName = FuzzyReflection.fromClass(worldType).getMethodByReturnTypeAndParameters("name", String.class, new Class[0]);
                        }
                    }
                    String name = (String)worldTypeName.invoke(generic, new Object[0]);
                    return WorldType.getByName((String)name);
                }
                catch (Exception e) {
                    throw new FieldAccessException("Cannot call the name method in WorldType.", e);
                }
            }

            @Override
            public Class<WorldType> getSpecificType() {
                return WorldType.class;
            }
        });
    }

    public static EquivalentConverter<NbtBase<?>> getNbtConverter() {
        return Converters.ignoreNull(new EquivalentConverter<NbtBase<?>>(){

            @Override
            public Object getGeneric(NbtBase<?> specific) {
                return NbtFactory.fromBase(specific).getHandle();
            }

            @Override
            public NbtBase<?> getSpecific(Object generic) {
                return NbtFactory.fromNMS(generic, null);
            }

            @Override
            public Class<NbtBase<?>> getSpecificType() {
                Class<NbtBase> dummy = NbtBase.class;
                return dummy;
            }
        });
    }

    public static EquivalentConverter<Entity> getEntityConverter(World world) {
        final WeakReference<ProtocolManager> managerRef = new WeakReference<ProtocolManager>(ProtocolLibrary.getProtocolManager());
        return new WorldSpecificConverter<Entity>(world){

            @Override
            public Object getGeneric(Entity specific) {
                return specific.getEntityId();
            }

            @Override
            public Entity getSpecific(Object generic) {
                try {
                    Integer id = (Integer)generic;
                    ProtocolManager manager = (ProtocolManager)managerRef.get();
                    if (id != null && id >= 0 && manager != null) {
                        return manager.getEntityFromID(this.world, id);
                    }
                    return null;
                }
                catch (FieldAccessException e) {
                    throw new RuntimeException("Cannot retrieve entity from ID.", e);
                }
            }

            @Override
            public Class<Entity> getSpecificType() {
                return Entity.class;
            }
        };
    }

    public static EquivalentConverter<EntityType> getEntityTypeConverter() {
        return Converters.ignoreNull(new EquivalentConverter<EntityType>(){

            @Override
            public Object getGeneric(EntityType specific) {
                if (entityTypeFromName == null) {
                    Class<?> entityTypesClass = MinecraftReflection.getEntityTypes();
                    entityTypeFromName = Accessors.getMethodAccessor(FuzzyReflection.fromClass(entityTypesClass, false).getMethod(FuzzyMethodContract.newBuilder().returnDerivedOf(Optional.class).parameterExactArray(String.class).build()));
                }
                Optional opt = (Optional)entityTypeFromName.invoke(null, specific.getName());
                return opt.orElse(null);
            }

            @Override
            public EntityType getSpecific(Object generic) {
                if (getEntityTypeName == null) {
                    Class<?> entityTypesClass = MinecraftReflection.getEntityTypes();
                    getEntityTypeName = Accessors.getMethodAccessor(FuzzyReflection.fromClass(entityTypesClass, false).getMethod(FuzzyMethodContract.newBuilder().returnTypeExact(MinecraftReflection.getMinecraftKeyClass()).parameterExactArray(entityTypesClass).build()));
                }
                MinecraftKey key = MinecraftKey.fromHandle(getEntityTypeName.invoke(null, generic));
                return EntityType.fromName((String)key.getKey());
            }

            @Override
            public Class<EntityType> getSpecificType() {
                return EntityType.class;
            }
        });
    }

    public static EquivalentConverter<ItemStack> getItemStackConverter() {
        return new EquivalentConverter<ItemStack>(){

            @Override
            public ItemStack getSpecific(Object generic) {
                return MinecraftReflection.getBukkitItemStack(generic);
            }

            @Override
            public Object getGeneric(ItemStack specific) {
                return MinecraftReflection.getMinecraftItemStack(specific);
            }

            @Override
            public Class<ItemStack> getSpecificType() {
                return ItemStack.class;
            }
        };
    }

    public static EquivalentConverter<WrappedServerPing> getWrappedServerPingConverter() {
        return Converters.ignoreNull(Converters.handle(WrappedServerPing::getHandle, WrappedServerPing::fromHandle, WrappedServerPing.class));
    }

    public static EquivalentConverter<WrappedStatistic> getWrappedStatisticConverter() {
        return Converters.ignoreNull(Converters.handle(AbstractWrapper::getHandle, WrappedStatistic::fromHandle, WrappedStatistic.class));
    }

    public static EquivalentConverter<Material> getBlockConverter() {
        if (BLOCK_FROM_MATERIAL == null || MATERIAL_FROM_BLOCK == null) {
            Class<?> magicNumbers = MinecraftReflection.getCraftBukkitClass("util.CraftMagicNumbers");
            Class<?> block = MinecraftReflection.getBlockClass();
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(magicNumbers);
            FuzzyMethodContract.Builder builder = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(Material.class).parameterExactArray(block);
            MATERIAL_FROM_BLOCK = Accessors.getMethodAccessor(fuzzy.getMethod(builder.build()));
            builder = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(block).parameterExactArray(Material.class);
            BLOCK_FROM_MATERIAL = Accessors.getMethodAccessor(fuzzy.getMethod(builder.build()));
        }
        return Converters.ignoreNull(new EquivalentConverter<Material>(){

            @Override
            public Object getGeneric(Material specific) {
                return BLOCK_FROM_MATERIAL.invoke(null, specific);
            }

            @Override
            public Material getSpecific(Object generic) {
                return (Material)MATERIAL_FROM_BLOCK.invoke(null, generic);
            }

            @Override
            public Class<Material> getSpecificType() {
                return Material.class;
            }
        });
    }

    public static EquivalentConverter<World> getWorldConverter() {
        return Converters.ignoreNull(new EquivalentConverter<World>(){

            @Override
            public Object getGeneric(World specific) {
                return BukkitUnwrapper.getInstance().unwrapItem(specific);
            }

            @Override
            public World getSpecific(Object generic) {
                return (World)craftWorldField.get(generic);
            }

            @Override
            public Class<World> getSpecificType() {
                return World.class;
            }
        });
    }

    public static EquivalentConverter<PotionEffect> getPotionEffectConverter() {
        return Converters.ignoreNull(new EquivalentConverter<PotionEffect>(){

            @Override
            public Object getGeneric(PotionEffect specific) {
                if (mobEffectConstructor == null) {
                    try {
                        mobEffectConstructor = MinecraftReflection.getMobEffectClass().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find mob effect constructor (int, int, int, boolean).", e);
                    }
                }
                try {
                    return mobEffectConstructor.newInstance(specific.getType().getId(), specific.getDuration(), specific.getAmplifier(), specific.isAmbient());
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot construct MobEffect.", e);
                }
            }

            @Override
            public PotionEffect getSpecific(Object generic) {
                if (mobEffectModifier == null) {
                    mobEffectModifier = new StructureModifier(MinecraftReflection.getMobEffectClass());
                }
                StructureModifier ints = mobEffectModifier.withTarget(generic).withType(Integer.TYPE);
                StructureModifier bools = mobEffectModifier.withTarget(generic).withType(Boolean.TYPE);
                return new PotionEffect(PotionEffectType.getById((int)((Integer)ints.read(0))), ((Integer)ints.read(1)).intValue(), ((Integer)ints.read(2)).intValue(), ((Boolean)bools.read(1)).booleanValue());
            }

            @Override
            public Class<PotionEffect> getSpecificType() {
                return PotionEffect.class;
            }
        });
    }

    public static EquivalentConverter<Vector> getVectorConverter() {
        return Converters.ignoreNull(new EquivalentConverter<Vector>(){

            @Override
            public Class<Vector> getSpecificType() {
                return Vector.class;
            }

            @Override
            public Object getGeneric(Vector specific) {
                if (vec3dConstructor == null) {
                    try {
                        vec3dConstructor = MinecraftReflection.getVec3DClass().getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException("Could not find Vec3d constructor (double, double, double)");
                    }
                }
                try {
                    return vec3dConstructor.newInstance(specific.getX(), specific.getY(), specific.getZ());
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Could not construct Vec3d.", ex);
                }
            }

            @Override
            public Vector getSpecific(Object generic) {
                if (vec3dModifier == null) {
                    vec3dModifier = new StructureModifier(MinecraftReflection.getVec3DClass());
                }
                StructureModifier doubles = vec3dModifier.withTarget(generic).withType(Double.TYPE);
                return new Vector(((Double)doubles.read(0)).doubleValue(), ((Double)doubles.read(1)).doubleValue(), ((Double)doubles.read(2)).doubleValue());
            }
        });
    }

    public static EquivalentConverter<Sound> getSoundConverter() {
        if (MinecraftVersion.NETHER_UPDATE_4.atOrAbove()) {
            if (bukkitToMinecraft == null && minecraftToBukkit == null) {
                Class<?> craftSound = MinecraftReflection.getCraftSoundClass();
                Class<?> soundEvent = MinecraftReflection.getSoundEffectClass();
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(craftSound, false);
                bukkitToMinecraft = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().returnTypeExact(soundEvent).parameterExactArray(Sound.class).requireModifier(8).build()));
                minecraftToBukkit = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().returnTypeExact(Sound.class).parameterExactArray(soundEvent).requireModifier(8).build()));
            }
            return Converters.ignoreNull(new EquivalentConverter<Sound>(){

                @Override
                public Class<Sound> getSpecificType() {
                    return Sound.class;
                }

                @Override
                public Object getGeneric(Sound specific) {
                    return bukkitToMinecraft.invoke(null, specific);
                }

                @Override
                public Sound getSpecific(Object generic) {
                    try {
                        return (Sound)minecraftToBukkit.invoke(null, generic);
                    }
                    catch (IllegalStateException ex) {
                        if (ex.getCause() instanceof NullPointerException || ex.getCause() instanceof NoSuchElementException) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
        }
        if (getSound == null || getSoundEffect == null) {
            Class<?> craftSound = MinecraftReflection.getCraftSoundClass();
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(craftSound, true);
            getSound = Accessors.getMethodAccessor(fuzzy.getMethodByReturnTypeAndParameters("getSound", String.class, Sound.class));
            getSoundEffect = Accessors.getMethodAccessor(fuzzy.getMethodByReturnTypeAndParameters("getSoundEffect", MinecraftReflection.getSoundEffectClass(), String.class));
        }
        return Converters.ignoreNull(new EquivalentConverter<Sound>(){

            @Override
            public Class<Sound> getSpecificType() {
                return Sound.class;
            }

            @Override
            public Object getGeneric(Sound specific) {
                String key = (String)getSound.invoke(null, specific);
                return getSoundEffect.invoke(null, key);
            }

            @Override
            public Sound getSpecific(Object generic) {
                if (soundKey == null) {
                    Class<?> soundEffect = generic.getClass();
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(soundEffect, true);
                    soundKey = Accessors.getFieldAccessor(fuzzy.getFieldByType("key", MinecraftReflection.getMinecraftKeyClass()));
                }
                MinecraftKey minecraftKey = MinecraftKey.fromHandle(soundKey.get(generic));
                String key = minecraftKey.getKey();
                if (soundIndex != null) {
                    return soundIndex.get(key);
                }
                try {
                    return Sound.valueOf((String)minecraftKey.getEnumFormat());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    soundIndex = new ConcurrentHashMap<String, Sound>();
                    for (Sound sound : Sound.values()) {
                        String index = (String)getSound.invoke(null, sound);
                        soundIndex.put(index, sound);
                    }
                    return soundIndex.get(key);
                }
            }
        });
    }

    public static EquivalentConverter<WrappedParticle> getParticleConverter() {
        return Converters.ignoreNull(Converters.handle(WrappedParticle::getHandle, WrappedParticle::fromHandle, WrappedParticle.class));
    }

    public static EquivalentConverter<Advancement> getAdvancementConverter() {
        return Converters.ignoreNull(new EquivalentConverter<Advancement>(){

            @Override
            public Advancement getSpecific(Object generic) {
                try {
                    return (Advancement)MinecraftReflection.getCraftBukkitClass("advancement.CraftAdvancement").getConstructor(MinecraftReflection.getMinecraftClass("advancements.Advancement", "Advancement")).newInstance(generic);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public Object getGeneric(Advancement specific) {
                return BukkitUnwrapper.getInstance().unwrapItem(specific);
            }

            @Override
            public Class<Advancement> getSpecificType() {
                return Advancement.class;
            }
        });
    }

    public static PacketConstructor.Unwrapper asUnwrapper(Class<?> nativeType, EquivalentConverter<Object> converter) {
        return wrappedObject -> {
            Class<?> type = PacketConstructor.getClass(wrappedObject);
            if (converter.getSpecificType().isAssignableFrom(type)) {
                if (wrappedObject instanceof Class) {
                    return nativeType;
                }
                return converter.getGeneric(wrappedObject);
            }
            return null;
        };
    }

    public static Map<Class<?>, EquivalentConverter<Object>> getConvertersForGeneric() {
        if (genericConverters == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            BukkitConverters.addConverter(builder, MinecraftReflection::getDataWatcherClass, BukkitConverters::getDataWatcherConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getItemStackClass, BukkitConverters::getItemStackConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getNBTBaseClass, BukkitConverters::getNbtConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getNBTCompoundClass, BukkitConverters::getNbtConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getDataWatcherItemClass, BukkitConverters::getWatchableObjectConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getMobEffectClass, BukkitConverters::getPotionEffectConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getNmsWorldClass, BukkitConverters::getWorldConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getWorldTypeClass, BukkitConverters::getWorldTypeConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getAttributeSnapshotClass, BukkitConverters::getWrappedAttributeConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getBlockClass, BukkitConverters::getBlockConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getGameProfileClass, BukkitConverters::getWrappedGameProfileConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getServerPingClass, BukkitConverters::getWrappedServerPingConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getStatisticClass, BukkitConverters::getWrappedStatisticConverter);
            BukkitConverters.addConverter(builder, MinecraftReflection::getIBlockDataClass, BukkitConverters::getWrappedBlockDataConverter);
            for (Map.Entry<Class<?>, EquivalentConverter<?>> entry : EnumWrappers.getFromNativeMap().entrySet()) {
                BukkitConverters.addConverter(builder, entry::getKey, entry::getValue);
            }
            genericConverters = builder.build();
        }
        return genericConverters;
    }

    private static void addConverter(ImmutableMap.Builder<Class<?>, EquivalentConverter<Object>> builder, Supplier<Class<?>> getClass, Supplier<EquivalentConverter> getConverter) {
        try {
            EquivalentConverter converter;
            Class<?> clazz = getClass.get();
            if (clazz != null && (converter = getConverter.get()) != null) {
                builder.put(clazz, (Object)converter);
            }
        }
        catch (Exception ex) {
            ProtocolLogger.debug("Exception registering converter", ex);
        }
    }

    public static List<PacketConstructor.Unwrapper> getUnwrappers() {
        if (unwrappers == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry<Class<?>, EquivalentConverter<Object>> entry : BukkitConverters.getConvertersForGeneric().entrySet()) {
                builder.add((Object)BukkitConverters.asUnwrapper(entry.getKey(), entry.getValue()));
            }
            unwrappers = builder.build();
        }
        return unwrappers;
    }

    public static EquivalentConverter<PotionEffectType> getEffectTypeConverter() {
        return Converters.ignoreNull(new EquivalentConverter<PotionEffectType>(){

            @Override
            public Class<PotionEffectType> getSpecificType() {
                return PotionEffectType.class;
            }

            @Override
            public Object getGeneric(PotionEffectType specific) {
                if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
                    if (getMobEffect == null) {
                        Class<?> potionEffectTypeClass = MinecraftReflection.getCraftBukkitClass("potion.CraftPotionEffectType");
                        FuzzyReflection fuzzy = FuzzyReflection.fromClass(potionEffectTypeClass, false);
                        getMobEffect = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactArray(PotionEffectType.class).returnTypeExact(MinecraftReflection.getMobEffectListClass()).requireModifier(8).build()));
                    }
                    return getMobEffect.invoke(null, specific);
                }
                if (getMobEffect == null) {
                    Class<?> clazz = MinecraftReflection.getMobEffectListClass();
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(clazz, false);
                    getMobEffect = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactArray(Integer.TYPE).returnTypeExact(clazz).requireModifier(8).build()));
                }
                int id = specific.getId();
                return getMobEffect.invoke(null, id);
            }

            @Override
            public PotionEffectType getSpecific(Object generic) {
                if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
                    if (getMobEffectId == null) {
                        Class<?> potionEffectTypeClass = MinecraftReflection.getCraftBukkitClass("potion.CraftPotionEffectType");
                        FuzzyReflection fuzzy = FuzzyReflection.fromClass(potionEffectTypeClass, false);
                        getMobEffectId = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactArray(MinecraftReflection.getMobEffectListClass()).returnTypeExact(PotionEffectType.class).requireModifier(8).build()));
                    }
                    return (PotionEffectType)getMobEffectId.invoke(null, generic);
                }
                if (getMobEffectId == null) {
                    Class<?> clazz = MinecraftReflection.getMobEffectListClass();
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(clazz, false);
                    getMobEffectId = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactArray(clazz).returnTypeExact(Integer.TYPE).requireModifier(8).build()));
                }
                int id = (Integer)getMobEffectId.invoke(null, generic);
                return PotionEffectType.getById((int)id);
            }
        });
    }

    public static EquivalentConverter<World> getWorldKeyConverter() {
        return Converters.ignoreNull(new EquivalentConverter<World>(){

            @Override
            public Object getGeneric(World specific) {
                Object nmsWorld = BukkitConverters.getWorldConverter().getGeneric(specific);
                if (worldKeyField == null) {
                    Class<?> worldClass = MinecraftReflection.getNmsWorldClass();
                    Class<?> resourceKeyClass = MinecraftReflection.getResourceKey();
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(nmsWorld.getClass(), true);
                    worldKeyField = Accessors.getFieldAccessor(fuzzy.getParameterizedField(resourceKeyClass, worldClass));
                }
                return worldKeyField.get(nmsWorld);
            }

            @Override
            public World getSpecific(Object generic) {
                if (getServer == null) {
                    getServer = Accessors.getMethodAccessor(Bukkit.getServer().getClass(), "getServer", new Class[0]);
                }
                Object server = getServer.invoke(Bukkit.getServer(), new Object[0]);
                if (getWorldServer == null) {
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(server.getClass(), false);
                    getWorldServer = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactArray(generic.getClass()).returnTypeExact(MinecraftReflection.getWorldServerClass()).build()));
                }
                Object worldServer = getWorldServer.invoke(server, generic);
                if (getWorld == null) {
                    getWorld = Accessors.getMethodAccessor(worldServer.getClass(), "getWorld", new Class[0]);
                }
                return (World)getWorld.invoke(worldServer, new Object[0]);
            }

            @Override
            public Class<World> getSpecificType() {
                return World.class;
            }
        });
    }

    public static EquivalentConverter<World> getDimensionConverter() {
        return Converters.ignoreNull(new EquivalentConverter<World>(){

            @Override
            public Object getGeneric(World specific) {
                return BukkitConverters.getWorldHandleDimensionManagerAccessor().invoke(BukkitConverters.getWorldHandleAccessor().invoke(specific, new Object[0]), new Object[0]);
            }

            @Override
            public World getSpecific(Object generic) {
                for (World world : Bukkit.getWorlds()) {
                    if (this.getGeneric(world) != generic) continue;
                    return world;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public Class<World> getSpecificType() {
                return World.class;
            }
        });
    }

    private static MethodAccessor getWorldHandleAccessor() {
        if (worldHandleAccessor == null) {
            Method handleMethod = FuzzyReflection.fromClass(MinecraftReflection.getCraftWorldClass()).getMethod(FuzzyMethodContract.newBuilder().nameExact("getHandle").returnTypeExact(MinecraftReflection.getWorldServerClass()).build());
            worldHandleAccessor = Accessors.getMethodAccessor(handleMethod);
        }
        return worldHandleAccessor;
    }

    private static MethodAccessor getWorldHandleDimensionManagerAccessor() {
        if (worldHandleDimensionManagerAccessor == null) {
            Method dimensionGetter = FuzzyReflection.fromClass(MinecraftReflection.getWorldServerClass()).getMethod(FuzzyMethodContract.newBuilder().returnTypeExact(MinecraftReflection.getDimensionManager()).build());
            worldHandleDimensionManagerAccessor = Accessors.getMethodAccessor(dimensionGetter);
        }
        return worldHandleDimensionManagerAccessor;
    }

    public static EquivalentConverter<Integer> getDimensionIDConverter() {
        return Converters.ignoreNull(new EquivalentConverter<Integer>(){

            @Override
            public Object getGeneric(Integer specific) {
                if (dimensionManager == null) {
                    dimensionManager = MinecraftReflection.getDimensionManager();
                }
                if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                    World world = null;
                    if (specific == 0) {
                        world = (World)Bukkit.getWorlds().get(0);
                    } else if (specific == -1) {
                        for (World world1 : Bukkit.getWorlds()) {
                            if (world1.getEnvironment() != World.Environment.NETHER) continue;
                            world = world1;
                            break;
                        }
                    } else if (specific == 1) {
                        for (World world1 : Bukkit.getWorlds()) {
                            if (world1.getEnvironment() != World.Environment.THE_END) continue;
                            world = world1;
                            break;
                        }
                    }
                    if (world != null) {
                        try {
                            return BukkitConverters.getWorldHandleDimensionManagerAccessor().invoke(BukkitConverters.getWorldHandleAccessor().invoke(world, new Object[0]), new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw new IllegalArgumentException();
                }
                if (MinecraftVersion.NETHER_UPDATE_2.atOrAbove()) {
                    if (dimensionImplConverter == null) {
                        dimensionImplConverter = new EnumWrappers.FauxEnumConverter<DimensionImpl>(DimensionImpl.class, dimensionManager);
                    }
                    DimensionImpl dimension = DimensionImpl.fromId(specific);
                    return dimensionImplConverter.getGeneric(dimension);
                }
                if (MinecraftVersion.NETHER_UPDATE.atOrAbove()) {
                    if (dimensionConverter == null) {
                        dimensionConverter = new EnumWrappers.FauxEnumConverter<EnumWrappers.Dimension>(EnumWrappers.Dimension.class, dimensionManager);
                    }
                    EnumWrappers.Dimension dimension = EnumWrappers.Dimension.fromId(specific);
                    return dimensionConverter.getGeneric(dimension);
                }
                if (dimensionFromId == null) {
                    FuzzyReflection reflection = FuzzyReflection.fromClass(dimensionManager, false);
                    FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().requireModifier(8).parameterExactType(Integer.TYPE).returnTypeExact(dimensionManager).build();
                    dimensionFromId = Accessors.getMethodAccessor(reflection.getMethod(contract));
                }
                return dimensionFromId.invoke(null, specific);
            }

            @Override
            public Integer getSpecific(Object generic) {
                if (dimensionManager == null) {
                    dimensionManager = MinecraftReflection.getDimensionManager();
                }
                if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                    if (dimensionKey == null) {
                        FuzzyReflection fuzzy = FuzzyReflection.fromClass(dimensionManager, false);
                        dimensionKey = Accessors.getFieldAccessor(fuzzy.getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getMinecraftKeyClass()).banModifier(8).build()));
                    }
                    MinecraftKey key = MinecraftKey.fromHandle(dimensionKey.get(generic));
                    switch (key.getKey()) {
                        case "overworld": {
                            return EnumWrappers.Dimension.OVERWORLD.getId();
                        }
                        case "the_nether": {
                            return EnumWrappers.Dimension.THE_NETHER.getId();
                        }
                        case "the_end": {
                            return EnumWrappers.Dimension.THE_END.getId();
                        }
                    }
                    throw new IllegalArgumentException("id not supported for extra dimensions");
                }
                if (MinecraftVersion.NETHER_UPDATE_2.atOrAbove()) {
                    if (dimensionImplConverter == null) {
                        dimensionImplConverter = new EnumWrappers.FauxEnumConverter<DimensionImpl>(DimensionImpl.class, dimensionManager);
                    }
                    DimensionImpl dimension = (DimensionImpl)((Object)dimensionImplConverter.getSpecific(generic));
                    return dimension.id;
                }
                if (MinecraftVersion.NETHER_UPDATE.atOrAbove()) {
                    if (dimensionConverter == null) {
                        dimensionConverter = new EnumWrappers.FauxEnumConverter<EnumWrappers.Dimension>(EnumWrappers.Dimension.class, dimensionManager);
                    }
                    EnumWrappers.Dimension dimension = (EnumWrappers.Dimension)((Object)dimensionConverter.getSpecific(generic));
                    return dimension.getId();
                }
                if (idFromDimension == null) {
                    FuzzyReflection reflection = FuzzyReflection.fromClass(dimensionManager, false);
                    FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().banModifier(8).returnTypeExact(Integer.TYPE).parameterCount(0).build();
                    idFromDimension = Accessors.getMethodAccessor(reflection.getMethod(contract));
                }
                return (Integer)idFromDimension.invoke(generic, new Object[0]);
            }

            @Override
            public Class<Integer> getSpecificType() {
                return Integer.class;
            }
        });
    }

    public static EquivalentConverter<List<MerchantRecipe>> getMerchantRecipeListConverter() {
        return Converters.ignoreNull(new EquivalentConverter<List<MerchantRecipe>>(){

            @Override
            public Object getGeneric(List<MerchantRecipe> specific) {
                if (merchantRecipeListConstructor == null) {
                    Class<?> merchantRecipeListClass = MinecraftReflection.getMerchantRecipeList();
                    merchantRecipeListConstructor = Accessors.getConstructorAccessor(merchantRecipeListClass, new Class[0]);
                    Class<?> craftMerchantRecipeClass = MinecraftReflection.getCraftBukkitClass("inventory.CraftMerchantRecipe");
                    FuzzyReflection reflection = FuzzyReflection.fromClass(craftMerchantRecipeClass, false);
                    bukkitMerchantRecipeToCraft = Accessors.getMethodAccessor(reflection.getMethodByName("fromBukkit"));
                    craftMerchantRecipeToNMS = Accessors.getMethodAccessor(reflection.getMethodByName("toMinecraft"));
                }
                return specific.stream().map(recipe -> craftMerchantRecipeToNMS.invoke(bukkitMerchantRecipeToCraft.invoke(null, recipe), new Object[0])).collect(() -> (List)merchantRecipeListConstructor.invoke(new Object[0]), List::add, List::addAll);
            }

            @Override
            public List<MerchantRecipe> getSpecific(Object generic) {
                if (nmsMerchantRecipeToBukkit == null) {
                    Class<?> merchantRecipeClass = MinecraftReflection.getMinecraftClass("world.item.trading.MerchantRecipe", "world.item.trading.MerchantOffer", "MerchantRecipe");
                    FuzzyReflection reflection = FuzzyReflection.fromClass(merchantRecipeClass, false);
                    nmsMerchantRecipeToBukkit = Accessors.getMethodAccessor(reflection.getMethodByName("asBukkit"));
                }
                return ((List)generic).stream().map(o -> (MerchantRecipe)nmsMerchantRecipeToBukkit.invoke(o, new Object[0])).collect(Collectors.toList());
            }

            @Override
            public Class<List<MerchantRecipe>> getSpecificType() {
                Class<List> dummy = List.class;
                return dummy;
            }
        });
    }

    public static EquivalentConverter<BlockPosition> getSectionPositionConverter() {
        return Converters.ignoreNull(new EquivalentConverter<BlockPosition>(){

            @Override
            public Object getGeneric(BlockPosition specific) {
                if (sectionPositionClass == null) {
                    sectionPositionClass = MinecraftReflection.getSectionPosition();
                }
                if (sectionPositionCreate == null) {
                    sectionPositionCreate = Accessors.getMethodAccessor(FuzzyReflection.fromClass(sectionPositionClass).getMethod(FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(sectionPositionClass).parameterExactArray(Integer.TYPE, Integer.TYPE, Integer.TYPE).build()));
                }
                return sectionPositionCreate.invoke(null, specific.x, specific.y, specific.z);
            }

            @Override
            public BlockPosition getSpecific(Object generic) {
                StructureModifier modifier = new StructureModifier(generic.getClass()).withTarget(generic).withType(Integer.TYPE);
                return new BlockPosition((Integer)modifier.readSafely(0), (Integer)modifier.readSafely(1), (Integer)modifier.readSafely(2));
            }

            @Override
            public Class<BlockPosition> getSpecificType() {
                return BlockPosition.class;
            }
        });
    }

    public static EquivalentConverter<Integer> getGameStateConverter() {
        return new EquivalentConverter<Integer>(){

            @Override
            public Object getGeneric(Integer specific) {
                if (specific == null) {
                    specific = 0;
                }
                if (MinecraftVersion.NETHER_UPDATE.atOrAbove()) {
                    if (gameStateMapField == null) {
                        Class<?> stateClass = MinecraftReflection.getGameStateClass();
                        gameStateMapField = FuzzyReflection.fromClass(stateClass, true).getField(FuzzyFieldContract.newBuilder().typeDerivedOf(Map.class).build());
                        gameStateMapField.setAccessible(true);
                    }
                    try {
                        Map map = (Map)gameStateMapField.get(null);
                        return map.get(specific);
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return specific;
            }

            @Override
            public Integer getSpecific(Object generic) {
                if (generic == null) {
                    return 0;
                }
                if (MinecraftVersion.NETHER_UPDATE.atOrAbove()) {
                    if (gameStateIdField == null) {
                        Class<?> stateClass = MinecraftReflection.getGameStateClass();
                        gameStateIdField = FuzzyReflection.fromClass(stateClass, true).getField(FuzzyFieldContract.newBuilder().typeExact(Integer.TYPE).build());
                        gameStateIdField.setAccessible(true);
                    }
                    try {
                        return (Integer)gameStateIdField.get(generic);
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return (Integer)generic;
            }

            @Override
            public Class<Integer> getSpecificType() {
                return Integer.class;
            }
        };
    }

    static {
        try {
            MinecraftReflection.getWorldTypeClass();
            hasWorldType = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            MinecraftReflection.getAttributeSnapshotClass();
            hasAttributeSnapshot = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            craftWorldField = Accessors.getFieldAccessor(MinecraftReflection.getNmsWorldClass(), MinecraftReflection.getCraftWorldClass(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LIST_SUPPLIERS = new ConcurrentHashMap();
        getSound = null;
        getSoundEffect = null;
        soundKey = null;
        bukkitToMinecraft = null;
        minecraftToBukkit = null;
        soundIndex = null;
        getMobEffectId = null;
        getMobEffect = null;
        dimensionFromId = null;
        idFromDimension = null;
        worldKeyField = null;
        getServer = null;
        getWorldServer = null;
        getWorld = null;
        merchantRecipeListConstructor = null;
        bukkitMerchantRecipeToCraft = null;
        craftMerchantRecipeToNMS = null;
        nmsMerchantRecipeToBukkit = null;
    }

    static enum DimensionImpl {
        OVERWORLD_IMPL(0),
        THE_NETHER_IMPL(-1),
        THE_END_IMPL(1);

        int id;

        private DimensionImpl(int id) {
            this.id = id;
        }

        static DimensionImpl fromId(int id) {
            switch (id) {
                case 0: {
                    return OVERWORLD_IMPL;
                }
                case -1: {
                    return THE_NETHER_IMPL;
                }
                case 1: {
                    return THE_END_IMPL;
                }
            }
            throw new IllegalArgumentException("Invalid dimension " + id);
        }
    }

    private static abstract class WorldSpecificConverter<TType>
    implements EquivalentConverter<TType> {
        protected World world;

        WorldSpecificConverter(World world) {
            this.world = world;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WorldSpecificConverter && super.equals(obj)) {
                WorldSpecificConverter that = (WorldSpecificConverter)obj;
                return Objects.equal((Object)this.world, (Object)that.world);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getSpecificType(), this.world});
        }
    }

    @Deprecated
    public static abstract class IgnoreNullConverter<TType>
    implements EquivalentConverter<TType> {
        @Override
        public final Object getGeneric(TType specific) {
            if (specific != null) {
                return this.getGenericValue(specific);
            }
            return null;
        }

        public abstract Object getGenericValue(TType var1);

        @Override
        public final TType getSpecific(Object generic) {
            if (generic != null) {
                return this.getSpecificValue(generic);
            }
            return null;
        }

        public abstract TType getSpecificValue(Object var1);

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EquivalentConverter) {
                EquivalentConverter that = (EquivalentConverter)obj;
                return Objects.equal(this.getSpecificType(), that.getSpecificType());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getSpecificType()});
        }
    }
}

