/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import java.util.Optional;
import java.util.function.Function;

public abstract class Either<L, R> {
    public abstract <T> T map(Function<L, T> var1, Function<R, T> var2);

    public abstract Optional<L> left();

    public abstract Optional<R> right();

    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public static class Left<L, R>
    extends Either<L, R> {
        private final L value;

        protected Left(L value) {
            this.value = value;
        }

        @Override
        public <T> T map(Function<L, T> leftConsumer, Function<R, T> rightConsumer) {
            return leftConsumer.apply(this.value);
        }

        @Override
        public Optional<L> left() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public Optional<R> right() {
            return Optional.empty();
        }
    }

    public static class Right<L, R>
    extends Either<L, R> {
        private final R value;

        protected Right(R value) {
            this.value = value;
        }

        @Override
        public <T> T map(Function<L, T> leftConsumer, Function<R, T> rightConsumer) {
            return rightConsumer.apply(this.value);
        }

        @Override
        public Optional<L> left() {
            return Optional.empty();
        }

        @Override
        public Optional<R> right() {
            return Optional.ofNullable(this.value);
        }
    }
}

