/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.Converters;
import java.lang.reflect.Constructor;

public class Vector3F {
    protected float x;
    protected float y;
    protected float z;
    private static Constructor<?> constructor = null;
    private static final Class<?> NMS_CLASS = MinecraftReflection.getNullableNMS("core.Vector3f", "core.Rotations", "Vector3f");

    public Vector3F() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3F(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public Vector3F setX(float x) {
        this.x = x;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Vector3F setY(float y) {
        this.y = y;
        return this;
    }

    public float getZ() {
        return this.z;
    }

    public Vector3F setZ(float z) {
        this.z = z;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vector3F) {
            Vector3F that = (Vector3F)obj;
            if (Float.floatToIntBits(this.x) != Float.floatToIntBits(that.x)) {
                return false;
            }
            if (Float.floatToIntBits(this.y) != Float.floatToIntBits(that.y)) {
                return false;
            }
            return Float.floatToIntBits(this.z) == Float.floatToIntBits(that.z);
        }
        return false;
    }

    public static Class<?> getMinecraftClass() {
        return NMS_CLASS;
    }

    public static EquivalentConverter<Vector3F> getConverter() {
        return Converters.ignoreNull(new EquivalentConverter<Vector3F>(){

            @Override
            public Class<Vector3F> getSpecificType() {
                return Vector3F.class;
            }

            @Override
            public Object getGeneric(Vector3F specific) {
                if (constructor == null) {
                    try {
                        constructor = NMS_CLASS.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE);
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new RuntimeException("Failed to find constructor for Vector3f", ex);
                    }
                }
                try {
                    return constructor.newInstance(Float.valueOf(specific.x), Float.valueOf(specific.y), Float.valueOf(specific.z));
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException("Failed to create new instance of Vector3f", ex);
                }
            }

            @Override
            public Vector3F getSpecific(Object generic) {
                StructureModifier modifier = new StructureModifier(generic.getClass()).withTarget(generic).withType(Float.TYPE);
                float x = ((Float)modifier.read(0)).floatValue();
                float y = ((Float)modifier.read(1)).floatValue();
                float z = ((Float)modifier.read(2)).floatValue();
                return new Vector3F(x, y, z);
            }
        });
    }
}

