/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;

public final class WrappedWatchableObject
extends AbstractWrapper {
    private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherItemClass();
    private static Integer VALUE_INDEX = null;
    private static ConstructorAccessor constructor;
    private final StructureModifier<Object> modifier;

    public WrappedWatchableObject(Object handle) {
        super(HANDLE_TYPE);
        this.setHandle(handle);
        this.modifier = new StructureModifier(this.handleType).withTarget(handle);
    }

    public WrappedWatchableObject(int index, Object value) {
        this(WrappedWatchableObject.newHandle(WrappedDataWatcher.WrappedDataWatcherObject.fromIndex(index), value));
    }

    public WrappedWatchableObject(WrappedDataWatcher.WrappedDataWatcherObject watcherObject, Object value) {
        this(WrappedWatchableObject.newHandle(watcherObject, value));
    }

    private static Object newHandle(WrappedDataWatcher.WrappedDataWatcherObject watcherObject, Object value) {
        if (constructor == null) {
            constructor = Accessors.getConstructorAccessor(HANDLE_TYPE.getConstructors()[0]);
        }
        Object nmsValue = WrappedWatchableObject.getUnwrapped(value);
        if (MinecraftReflection.watcherObjectExists()) {
            return constructor.invoke(watcherObject.getHandle(), nmsValue);
        }
        return constructor.invoke(WrappedDataWatcher.getTypeID(value.getClass()), watcherObject.getIndex(), nmsValue);
    }

    static Object getWrapped(Object value) {
        if (value == null) {
            return null;
        }
        if (MinecraftReflection.is(MinecraftReflection.getDataWatcherItemClass(), value)) {
            return WrappedWatchableObject.getWrapped(new WrappedWatchableObject(value).getRawValue());
        }
        if (value instanceof Optional) {
            return ((Optional)value).map(WrappedWatchableObject::getWrapped);
        }
        if (MinecraftReflection.is(MinecraftReflection.getIChatBaseComponentClass(), value)) {
            return WrappedChatComponent.fromHandle(value);
        }
        if (MinecraftReflection.is(MinecraftReflection.getItemStackClass(), value)) {
            return BukkitConverters.getItemStackConverter().getSpecific(value);
        }
        if (MinecraftReflection.is(MinecraftReflection.getIBlockDataClass(), value)) {
            return BukkitConverters.getWrappedBlockDataConverter().getSpecific(value);
        }
        if (MinecraftReflection.is(Vector3F.getMinecraftClass(), value)) {
            return Vector3F.getConverter().getSpecific(value);
        }
        if (MinecraftReflection.is(MinecraftReflection.getBlockPositionClass(), value)) {
            return BlockPosition.getConverter().getSpecific(value);
        }
        if (MinecraftReflection.is(EnumWrappers.getDirectionClass(), value)) {
            return EnumWrappers.getDirectionConverter().getSpecific(value);
        }
        if (MinecraftReflection.is(MinecraftReflection.getNBTCompoundClass(), value)) {
            return NbtFactory.fromNMSCompound(value);
        }
        return value;
    }

    static Object getUnwrapped(Object wrapped) {
        if (wrapped == null) {
            return null;
        }
        if (wrapped instanceof Optional) {
            return ((Optional)wrapped).map(WrappedWatchableObject::getUnwrapped);
        }
        if (wrapped instanceof WrappedChatComponent) {
            return ((WrappedChatComponent)wrapped).getHandle();
        }
        if (wrapped instanceof ItemStack) {
            return BukkitConverters.getItemStackConverter().getGeneric((ItemStack)wrapped);
        }
        if (wrapped instanceof WrappedBlockData) {
            return BukkitConverters.getWrappedBlockDataConverter().getGeneric((WrappedBlockData)wrapped);
        }
        if (wrapped instanceof Vector3F) {
            return Vector3F.getConverter().getGeneric((Vector3F)wrapped);
        }
        if (wrapped instanceof BlockPosition) {
            return BlockPosition.getConverter().getGeneric((BlockPosition)wrapped);
        }
        if (wrapped instanceof EnumWrappers.Direction) {
            return EnumWrappers.getDirectionConverter().getGeneric((EnumWrappers.Direction)((Object)wrapped));
        }
        if (wrapped instanceof NbtCompound) {
            return NbtFactory.fromBase((NbtCompound)wrapped).getHandle();
        }
        return wrapped;
    }

    public WrappedDataWatcher.WrappedDataWatcherObject getWatcherObject() {
        return new WrappedDataWatcher.WrappedDataWatcherObject(this.modifier.read(0));
    }

    public int getIndex() {
        if (MinecraftReflection.watcherObjectExists()) {
            return this.getWatcherObject().getIndex();
        }
        return (Integer)this.modifier.withType(Integer.TYPE).read(1);
    }

    public Object getValue() {
        return WrappedWatchableObject.getWrapped(this.getRawValue());
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public Object getRawValue() {
        if (VALUE_INDEX == null) {
            VALUE_INDEX = MinecraftReflection.watcherObjectExists() ? 1 : 2;
        }
        return this.modifier.readSafely(VALUE_INDEX);
    }

    public void setValue(Object value, boolean updateClient) {
        if (VALUE_INDEX == null) {
            VALUE_INDEX = MinecraftReflection.watcherObjectExists() ? 1 : 2;
        }
        this.modifier.write(VALUE_INDEX, WrappedWatchableObject.getUnwrapped(value));
        if (updateClient) {
            this.setDirtyState(true);
        }
    }

    public boolean getDirtyState() {
        return (Boolean)this.modifier.withType(Boolean.TYPE).read(0);
    }

    public void setDirtyState(boolean dirty) {
        this.modifier.withType(Boolean.TYPE).write(0, dirty);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WrappedWatchableObject) {
            WrappedWatchableObject that = (WrappedWatchableObject)obj;
            return this.getIndex() == that.getIndex() && this.getRawValue().equals(that.getRawValue()) && this.getDirtyState() == that.getDirtyState();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getIndex();
        result = 31 * result + this.getRawValue().hashCode();
        result = 31 * result + (this.getDirtyState() ? 1231 : 1237);
        return result;
    }

    @Override
    public String toString() {
        return "DataWatcherItem[index=" + this.getIndex() + ", value=" + String.valueOf(this.getValue()) + ", dirty=" + this.getDirtyState() + "]";
    }
}

