import type { Song } from '@/types';

// 默认示例歌曲数据和歌词
export const DEFAULT_SONG: Song = {
  id: 'demo-song-1',
  title: '鲜花',
  artist: {
    id: 'artist-huichundan',
    name: '回春丹',
    avatar: 'https://p1.music.126.net/fKJMTONzRMaeVthOmEvd9A==/109951168948248373.jpg',
    followers: 50000,
    songCount: 15,
    genres: ['流行', '民谣'],
    verified: true,
    createdAt: '2023-01-01T00:00:00.000Z',
    updatedAt: '2023-01-01T00:00:00.000Z'
  },
  album: {
    id: 'album-xianhua',
    title: '鲜花',
    artist: {
      id: 'artist-huichundan',
      name: '回春丹',
      avatar: 'https://p1.music.126.net/fKJMTONzRMaeVthOmEvd9A==/109951168948248373.jpg',
      followers: 50000,
      songCount: 15,
      genres: ['流行', '民谣'],
      verified: true,
      createdAt: '2023-01-01T00:00:00.000Z',
      updatedAt: '2023-01-01T00:00:00.000Z'
    },
    artistId: 'artist-huichundan',
    coverUrl: 'https://p1.music.126.net/fKJMTONzRMaeVthOmEvd9A==/109951168948248373.jpg',
    releaseDate: '2023-01-01',
    songCount: 10,
    duration: 180,
    createdAt: '2023-01-01T00:00:00.000Z',
    updatedAt: '2023-01-01T00:00:00.000Z'
  },
  artistId: 'artist-huichundan',
  albumId: 'album-xianhua',
  duration: 180, // 3分钟
  audioUrl: 'https://media.onmicrosoft.cn/%E5%9B%9E%E6%98%A5%E4%B8%B9%20-%20%E9%B2%9C%E8%8A%B1.flac',
  coverUrl: 'https://p1.music.126.net/fKJMTONzRMaeVthOmEvd9A==/109951168948248373.jpg',
  moods: [
    {
      id: 'mood-1',
      name: '放松',
      description: '轻松舒缓的音乐',
      icon: 'Smile',
      color: 'from-blue-400 to-cyan-500',
      songCount: 50,
      createdAt: '2023-01-01T00:00:00.000Z',
      updatedAt: '2023-01-01T00:00:00.000Z'
    },
    {
      id: 'mood-2',
      name: '愉快',
      description: '快乐积极的音乐',
      icon: 'Heart',
      color: 'from-yellow-400 to-orange-500',
      songCount: 30,
      createdAt: '2023-01-01T00:00:00.000Z',
      updatedAt: '2023-01-01T00:00:00.000Z'
    },
    {
      id: 'mood-3',
      name: '专注',
      description: '适合工作学习的音乐',
      icon: 'Focus',
      color: 'from-purple-400 to-pink-500',
      songCount: 40,
      createdAt: '2023-01-01T00:00:00.000Z',
      updatedAt: '2023-01-01T00:00:00.000Z'
    }
  ],
  moodIds: ['mood-1', 'mood-2', 'mood-3'],
  playCount: 100000,
  liked: false,
  createdAt: new Date().toISOString(),
  updatedAt: new Date().toISOString(),
};

// ⚠️ 警告：以下歌词受版权保护
// 歌词明确标注"未经许可,不得翻唱或使用"
// 仅用于技术演示，商用请获得版权方授权
export const DEFAULT_LYRICS = `[00:00.48]作曲：刘西蒙
[00:00.98]作词：刘西蒙
[00:01.48]编曲：回春丹
[00:01.85]
[00:02.23]（童声）
[00:02.98]我的心我的心
[00:05.99]整栋出租
[00:08.50]处处都给你
[00:15.78]永远开满
[00:17.78]永远开满
[00:20.29]永远开满
[01:02.68]
[01:03.68]彩虹里面的人
[01:07.69]你们好吗
[01:11.71]你那快乐吗
[01:14.21]我期待的吗
[01:16.47]还记得歌唱
[01:18.98]记得啦啦啦吗
[01:21.74]
[01:22.74]躲在屋檐的人
[01:26.00]你们害怕吗
[01:31.26]还记得笑吗
[01:33.52]还记得我吗
[01:36.03]还记得保持好奇的傻瓜
[01:41.04]
[01:42.04]我去到那里会不会一无所知
[01:46.80]去到那里会不会一无所知
[01:51.56]车子经过了桥
[01:54.32]我记得在那便利店买的酒
[01:58.58]可是我不敢一个人喝
[02:03.85]车子又经过了山
[02:08.61]我妄想开着我的烂摩托
[02:12.88]去转一转
[02:14.63]可是我可是我
[02:17.39]可惜我把车卖了
[02:19.40]
[02:20.40]我的心我的心
[02:25.17]整栋出租
[02:27.93]处处都给你
[02:34.70]种好的鲜花
[02:40.22]
[02:41.22]治愈你的白发
[02:44.48]别害怕别害怕
[02:47.24]有我在的地方
[02:54.01]永远开满了鲜花
[03:01.04]
[03:02.04]治愈你的白发
[03:07.06]别害怕
[03:13.08]永远开满了鲜花
[03:20.35]
[03:21.35]治愈你的白发
[03:27.62]永远开满
[03:29.63]永远开满
[03:32.38]永远开满
[04:14.53]
[04:15.03]
[04:15.53]我的心我的心
[04:20.55]整栋出租
[04:23.06]处处都给你
[04:30.08]种好的鲜花
[04:35.35]
[04:36.35]治愈你的白发
[04:39.36]别害怕别害怕
[04:42.37]有我在的地方
[04:49.14]永远开满了鲜花
[04:56.67]
[04:57.67]治愈你的白发
[05:02.19]别害怕
[05:08.45]永远开满了鲜花
[05:15.98]
[05:16.98]治愈你的白发
[05:22.75]永远开满
[05:24.76]永远开满
[05:27.52]永远开满
[05:32.54]
[05:33.54]鲜花
[05:34.04]
[05:34.54]
[05:34.67]
[05:34.80]主唱：刘西蒙
[05:35.30]吉他：刘西蒙 / 韦高飞
[05:36.05]贝斯：郭泽群
[05:36.55]鼓：简丹
[05:37.05]键盘：韦伟
[05:37.80]和声：刘禹彤 / 简丹 / 韦高飞 / 张炜 / 莫皓
[05:38.56]制作人：回春丹 / 韦伟
[05:39.06]监制：杜文清
[05:39.81]录音：张炜@33AW Recording studio
[05:40.31]混音：王大治@时音唱片
[05:40.81]母带：时俊峰
[05:41.00]未经许可,不得翻唱或使用
[05:41.06]经纪人：杜文清
[06:41.06]厂牌：池沼Chizhao
[06:41.15]统筹：杜文清
[06:41.24]统筹协力：吴海荣
[06:41.33]宣传发行：盛柔嘉 / 牛佳钰 / 侯莹
[06:41.42]助理：黎原子
[06:41.51]OP/SP：瓦兹妙赞
[06:41.60]封面设计：刘西蒙
[06:41.69]童声录音棚：龙猫音乐录音棚
[06:41.78]录音：王大治
[06:41.87]童声监制：时萌
[06:41.96]童声合唱：刘源溪 王瀚霆 张皓玮 王宇昊 许俊赫 李佳妍 李雨宸 刘思铄 赵星妍`;