import React from 'react';
import { 
  Smile,
  Coffee,
  Zap,
  Sun,
  CloudRain,
  Moon,
  Star,
  Flame,
  Wind,
  Waves,
  Mountain,
  Leaf,
  Sparkles,
  Target,
  Battery,
  Volume2,
  Headphones,
  Radio,
  Mic,
  Guitar,
  Piano,
  Drum,
  Activity,
  TrendingUp,
  Users,
  Globe,
  Clock,
  Calendar,
  Camera,
  Book,
  Gamepad2,
  Smartphone,
  Laptop,
  Car,
  Plane,
  Home,
  Building,
  MapPin,
  Compass,
  Flag,
  Award,
  Gift,
  Lightbulb,
  Key,
  Lock,
  Shield,
  Eye,
  MessageCircle,
  Mail,
  Phone,
  Settings,
  Wrench,
  Scissors,
  Brush,
  Palette,
  Image,
  FileText,
  Download,
  Upload,
  Save,
  Trash,
  Archive,
  Folder,
  File,
  Search,
  Filter,
  ArrowUpDown,
  BarChart,
  PieChart,
  LineChart,
  Heart,
  Music2
} from 'lucide-react';

// 图标映射表
export const iconMap: Record<string, React.ComponentType<{ className?: string }>> = {
  'Smile': Smile,
  'Coffee': Coffee,
  'Zap': Zap,
  'Sun': Sun,
  'CloudRain': CloudRain,
  'Heart': Heart,
  'Moon': Moon,
  'Star': Star,
  'Flame': Flame,
  'Wind': Wind,
  'Waves': Waves,
  'Mountain': Mountain,
  'Leaf': Leaf,
  'Sparkles': Sparkles,
  'Target': Target,
  'Battery': Battery,
  'Volume2': Volume2,
  'Headphones': Headphones,
  'Radio': Radio,
  'Mic': Mic,
  'Guitar': Guitar,
  'Piano': Piano,
  'Drum': Drum,
  'Activity': Activity,
  'TrendingUp': TrendingUp,
  'Users': Users,
  'Globe': Globe,
  'Clock': Clock,
  'Calendar': Calendar,
  'Camera': Camera,
  'Book': Book,
  'Gamepad2': Gamepad2,
  'Smartphone': Smartphone,
  'Laptop': Laptop,
  'Car': Car,
  'Plane': Plane,
  'Home': Home,
  'Building': Building,
  'MapPin': MapPin,
  'Compass': Compass,
  'Flag': Flag,
  'Award': Award,
  'Gift': Gift,
  'Lightbulb': Lightbulb,
  'Key': Key,
  'Lock': Lock,
  'Shield': Shield,
  'Eye': Eye,
  'MessageCircle': MessageCircle,
  'Mail': Mail,
  'Phone': Phone,
  'Settings': Settings,
  'Tool': Wrench,
  'Wrench': Wrench,
  'Scissors': Scissors,
  'Brush': Brush,
  'Palette': Palette,
  'Image': Image,
  'FileText': FileText,
  'Download': Download,
  'Upload': Upload,
  'Save': Save,
  'Trash': Trash,
  'Archive': Archive,
  'Folder': Folder,
  'File': File,
  'Search': Search,
  'Filter': Filter,
  'Sort': ArrowUpDown,
  'BarChart': BarChart,
  'PieChart': PieChart,
  'LineChart': LineChart,
  'Music': Music2,
  'PaletteIcon': Palette,
};

/**
 * 获取图标组件
 * @param iconName 图标名称
 * @param fallback 默认图标，默认为 Music2
 * @returns React 图标组件
 */
export function getIconComponent(
  iconName: string, 
  fallback: React.ComponentType<{ className?: string }> = Music2
): React.ComponentType<{ className?: string }> {
  return iconMap[iconName] || fallback;
}

/**
 * 渲染图标组件
 * @param iconName 图标名称
 * @param className CSS 类名
 * @param fallback 默认图标组件
 * @returns JSX 元素
 */
export function renderIcon(
  iconName: string, 
  className?: string,
  fallback: React.ComponentType<{ className?: string }> = Music2
): React.ReactElement {
  const IconComponent = getIconComponent(iconName, fallback);
  return <IconComponent className={className} />;
}