<p align=center><img width="200" src="https://p9-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/1c77fe2bae044429836b37aa9326f523~tplv-k3u1fbpfcp-watermark.image?" alt="logo.png"  /></p>
<p align="center">
    <a href="https://v3.vuejs.org/" target="_blank">
        <img src="https://p3-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/dd8e303d325340d6b23253e945508489~tplv-k3u1fbpfcp-zoom-1.image" alt="vue">
    </a>
    <a href="https://element-plus.gitee.io/#/zh-CN/component/changelog" target="_blank">
        <img src="https://p3-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/9bf22ec28f13427ea1a4609ebbf12a4e~tplv-k3u1fbpfcp-zoom-1.image" alt="element plus">
    </a>
    <a href="https://www.tslang.cn/" target="_blank">
        <img src="https://p3-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/f95af82839104c3289be30584bfdce6b~tplv-k3u1fbpfcp-zoom-1.image" alt="typescript">
    </a>
    <a href="https://vitejs.dev/" target="_blank">
        <img src="https://p3-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/229345a011dd47c3a183217ddf008c97~tplv-k3u1fbpfcp-zoom-1.image" alt="vite">
    </a>
    <a href="https://pinia.vuejs.org/" target="_blank">
        <img src="https://p3-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/ca7fe134db464470aacb3248d571573e~tplv-k3u1fbpfcp-zoom-1.image" alt="vite">
    </a>
    <a href="https://pinia.vuejs.org/" target="_blank">
        <img src="https://p3-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/bb8ab71737fb4b8daaf26a910462f689~tplv-k3u1fbpfcp-zoom-1.image" alt="vite">
    </a>
    <a href="https://opensource.org/licenses/MIT">
        <img src="https://p3-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/78fa8d73d585476fab0094f9d93a553b~tplv-k3u1fbpfcp-zoom-1.image" alt="License">
    </a>
</p>

<h1 align="center">猫步简历</h1>
<h2 align="center">一款开源免费简历制作神器</h2>

<p align="center"><b>基于Vue3 + TypeScript + Vite + Element-plus + pinia实现</b></p>

**在线地址：[https://maobucv.com](https://maobucv.com/)**


# 目录
- [目录](#目录)
- [🚀 项目简介](#-项目简介)
- [🤼 功能介绍](#-功能介绍)
- [🎇 项目演示截图](#-项目演示截图)
- [🐶 技术栈介绍](#-技术栈介绍)
- [🏊 如何使用](#-如何使用)
  - [拉取项目](#拉取项目)
  - [安装项目依赖](#安装项目依赖)
  - [项目配置](#项目配置)
  - [运行项目](#运行项目)
  - [构建项目](#构建项目)
- [🧱 项目结构说明](#-项目结构说明)
- [🐨 在线制作设计器](#-在线制作设计器)
  - [设计器简介](#设计器简介)
  - [特点描述](#特点描述)
  - [模板开发](#模板开发)
  - [组件开发相关目录](#组件开发相关目录)
- [🐔 积木制作设计器](#-积木制作设计器)
  - [设计器简介](#设计器简介-1)
  - [特点描述](#特点描述-1)
  - [模板开发](#模板开发-1)
  - [物料组件开发](#物料组件开发)
  - [设计器应用于其他项目](#设计器应用于其他项目)
- [🙉 项目代码提交说明](#-项目代码提交说明)
- [🚟 项目交流](#-项目交流)
- [🍓 成为贡献者](#-成为贡献者)
- [🚉 问题反馈](#-问题反馈)
- [🍜 License](#-license)
- [贡献者](#贡献者)


# 🚀 项目简介
<p align=left>猫步简历是一个开源免费的简历设计制作以及提供模板下载的网站，当前项目为前端项目，完全开源免费。</p>

<p align=left>网站内置有两款设计器，可以方便快捷的制作出精美的简历，除此之外，网站还提供有完整的后台管理系统，可以方便管理整个网站。</p>

<p align=left>该项目已发布两个纯前端版本，这两个纯前端版本之后，项目将接入后台系统，所以如果单纯想要学习前端的小伙伴可以直接下载发布的两个版本之一即可。如果小伙伴想要学习设计器，则可以直接拉取最新前端代码即可。</p>

纯前端版本：<https://github.com/huajian-pro/resume-design/releases>

# 🤼 功能介绍
- [x] 用户邮箱验证码登录注册、忘记密码、找回密码等功能
- [x] 用户个人中心相关信息管理等功能
- [x] 在线制作设计器（专注简历布局）
- [x] 积木创作设计器（任意布局）
- [x] 导出超高清PDF（支持复制、图标等）
- [x] 支持在线以及导出JSON数据
- [x] 支持评论
- [x] 支持Word简历模板下载
- [x] 支持PPT模板下载
- [x] 支持保存草稿功能
- [x] 积分简币体系
- [x] 支持简历主题任意更改（字体、颜色、背景、间距等）
- [x] 完整的后台管理系统，各种数据均可后台配置
- [x] 网站数据统计（访问量、注册人数、简历制作数等）
- [x] 完善的管理端系统，让网站变得可配置化


......更多功能请到官网体验：[猫步简历](https://maobucv.com/)

# 🎇 项目演示截图

**网站首页：**
<p align=center><img src="https://p9-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/e6475e91ab344eb28f338ea50716face~tplv-k3u1fbpfcp-zoom-in-crop-mark:1512:0:0:0.awebp?" alt="网页捕获_26-4-2023_17656_maobucv.com.jpeg"  /></p>

**管理端：**

<p align=center><img src="https://p1-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/2f4565ce066d4d9491eb9280b9a5b6a8~tplv-k3u1fbpfcp-watermark.image?" alt="image.png"  /></p>

**设计器一：**

<p align=center><img src="https://p9-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/732352538cf94b53b9f083e32dad389e~tplv-k3u1fbpfcp-watermark.image?" alt="design-1.png"  /></p>

**设计器二：**

<p align=center><img src="https://p6-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/0ad17cb4117c48d1a73ac4f533f027e9~tplv-k3u1fbpfcp-watermark.image?" alt="design-2.png"  /></p>

......更多页面请到官网体验：[猫步简历](https://maobucv.com/)

# 🐶 技术栈介绍

**前端技术栈：** 
- Vue3.x
- Vite3.x
- TypeScript4.x
- Element-plus
- Pinia

**后端技术栈：**
- nest.js

**数据库：**
- MongoDB

**文件存储：**
- minio


# 🏊 如何使用

## 拉取项目


```
git clone https://github.com/huajian-pro/resume-design.git
```
-   推荐使用包管理工具[pnpm](https://pnpm.io/installation)
-   或使用[yarn](https://yarnpkg.com/getting-started/install)、npm（node自带无需额外安装）包管理工具
-   Node版本请确保在v16.0及以上
> pnpm全局安装方法`npm i -g pnpm`

## 安装项目依赖

```
cd resume-design

// 使用pnpm安装依赖（推荐）
pnpm install
```
注意：如果安装失败请切换网络或者清空npm缓存重试。

## 项目配置

<p align=left>注意：如果你拉取的为纯前端项目，则可以跳过此步骤。</p>

若要运行项目，需要有相对应的后台，如果没有自己搭建的后台，则可以连接猫步简历官方后台。 **修改对应文件**：

**修改前：**

```
// src/config/index.ts

const serverAddress =
  import.meta.env.MODE === 'development' ? 'http://localhost:3399' : 'https://maobucv.com';
const CONFIG = {
  // serverAddress: 'http://localhost:3399',
  // serverAddress: 'https://maobucv.com',
  serverAddress: serverAddress,
  smallpigAddress: 'https://maobucv.com' // 此地址为资源分享菜单的后台地址，可不管
};
export default CONFIG;
```
**修改后：**
```
// src/config/index.ts

const serverAddress = 'https://maobucv.com';
const CONFIG = {
  // serverAddress: 'http://localhost:3399',
  // serverAddress: 'https://maobucv.com',
  serverAddress: serverAddress,
  smallpigAddress: 'https://maobucv.com' // 此地址为资源分享菜单的后台地址，可不管
};
export default CONFIG;
```
**备注**：如想搭建自己的后台，可到[猫步简历官网](https://maobucv.com)获取后端源码。

## 运行项目

进入项目目录，执行命令：

```
pnpm dev
```

注意：如果运行失败，建议检查依赖是否安装完整、以及检查Node版本是否大于16。

## 构建项目

进入项目目录，执行命令：

```
pnpm build
```
将生成的dist上传至服务器，采用nginx部署即可。

# 🧱 项目结构说明


```
resume-design
├── LICENSE                 // 协议文件
├── README.md               // 项目介绍文档
├── build                   // 项目打包相关配置文件
│   ├── utils.ts
│   └── vite
├── commitlint.config.js    // 项目提交代码相关配置，npm run commit会读取 
├── dist                    // 项目构建生成文件
│   ├── favicon.ico
│   ├── index.html
│   ├── json
│   └── static
├── doc                     // 相关文档存放目录
├── index.html
├── package.json
├── pnpm-lock.yaml
├── prettier.config.js
├── public                 // 项目公共文件夹
│   ├── favicon.ico
│   ├── json
│   └── static
├── src
│   ├── App.vue
│   ├── assets             // 相关资源存放目录，如图片等
│   ├── auto-import.d.ts   // 自定引入相关依赖配置文件
│   ├── components         // 全局公共组件存放目录
│   ├── components.d.ts    // 组件自动注册配置，如element-plus
│   ├── config             // 项目全局配置目录，如配置后台接口地址等
│   ├── dictionary         // 项目中使用到的相关字典映射
│   ├── env.d.ts           // Typescript等配置
│   ├── hooks              // 项目公用钩子等
│   ├── http               // 项目请求API存放目录
│   ├── i18n               // 国际化相关
│   ├── interface          // Typescript接口定义
│   ├── main.ts            // 主入口文件
│   ├── material           // 在线制作模块的公共物料组件
│   ├── options            // 在线制作模块的物料属性设置面板组件
│   ├── router             // 项目路由
│   ├── schema             // 在线制作模块相关模型JSON定义
│   ├── store              // 全局状态管理
│   ├── style              // 公共样式存放
│   ├── template           // 在线制作模块模板渲染存放目录
│   ├── utils              // 全局公用工具函数
│   └── views              // 页面
├── tsconfig.json
├── tsconfig.node.json
├── types
│   ├── custom-types.d.ts
│   └── global.d.ts
└── vite.config.ts
```

注意：由于项目在不断更新迭代，项目目录结构可能会改变。

# 🐨 在线制作设计器

## 设计器简介

在线制作设计器主要是项目初期建设时的第一代设计器，功能没有那么复杂，项目目录可能没有那么规范，但是代码还是很清晰明了的。

使用这款设计器只能制作简历，并且让使用者专注于简历数据，不用花费更多精力在配色、字体等方面，以下为在线制作设计器相关截图：

<p align=center><img src="https://p6-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/07286987deda46b7940e4c2553c68de5~tplv-k3u1fbpfcp-watermark.image?" alt="image.png"  /></p>


<p align=center><img src="https://p3-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/cce6750628e74d088db778c7c5e61d12~tplv-k3u1fbpfcp-watermark.image?" alt="design-online-1.png"  /></p>

## 特点描述

该款设计器目前是提供模板最多的，主要用于简历设计制作，用户可以自行添加和删除相对应简历模块，通过简单的拖动实现模块之间顺序交换，主要特点如下：

- 专注于简历制作
- 提供有丰富简历模板
- 已提前配置了简历模块
- 让用户专注于数据
- 可以在模板中添加物料中心组件

## 模板开发

如果想要给在线制作功能添加更多的模板，那么可以到【贡献模板】页面拖拉拽组成一个完整模板，然后提交审核，管理员在后台审核通过后将会展示在模板列表中。

**页面如下：**

<p align=center><img src="https://p6-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/6ef7d0ff9a2d488299f22113a04a88ad~tplv-k3u1fbpfcp-watermark.image?" alt="design-online-2.png"  /></p>

上图中左侧是物料区，该款设计器其实和在线制作设计器是同一款，只不过这儿是用来生成模板使用的。

## 组件开发相关目录

物料组件和属性设置面板分别存放在src下的两个目录，如下所示：

<p align=center><img src="https://p9-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/0e68e1d7b5424ae38b9e7404f756cafb~tplv-k3u1fbpfcp-watermark.image?" alt="design-online-3.png"  /></p>

具体实现步骤可以参考文章：[# 简历开源项目——教你如何新增模板和物料组件](https://juejin.cn/post/7137934645580005390)
# 🐔 积木制作设计器

## 设计器简介

该款设计器为后来新开发的设计器，相较于第一款设计器而言，该款设计器将组件粒度划分为更小，更为灵活，理论而言，不仅可以制作简历，还可以制作海报、logo等等。

但是相对于在线制作设计器而言，积木制作设计器使用户没有那么专注于数据，因为太为灵活，所以需要看用户需求，如果只需要简单制作一份简历，在线制作设计器可能是更好的选择。

**积木设计器截图如下：**

<p align=center><img src="https://p1-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/12e6bcd5214e4619a4308f508654c08c~tplv-k3u1fbpfcp-watermark.image?" alt="lego-design-1.png"  /></p>

## 特点描述

积木制作设计器主要为满足灵活多变的设计场景，理论上它可以渲染任何组件，比如数据可视化组件等，它主要集中于如下特点：

- 物料组件粒度更小
- 画布区域可设计性更强
- 不仅可制作简历，还可制作海报等
- 理论可以渲染任何组件
- 良好的代码结构

## 模板开发

积木制作的模板开发也很简单，任何用户都可以申请提交模板，在设计器内制作出想要的模板，然后提交申请，管理员审核通过即可发布为模板。

**如下所示：**

<p align=center><img src="https://p6-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/c2b153c3a28a4b1c862a1474e2fcba5f~tplv-k3u1fbpfcp-watermark.image?" alt="lego-design-2.png"  /></p>

## 物料组件开发

为了积木制作设计器与项目更好的解耦，比如让其他项目快速接入积木制作设计器，所以积木制作设计器基本是单独一个目录，如下所示：

<p align=center><img src="https://p6-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/f021e4b0c51645bca4bb36ebf92acc12~tplv-k3u1fbpfcp-watermark.image?" alt="image.png"  /></p>

新增物料组件主要关注一下几个目录：

- schema
- setters
- widgets

大体步骤如下：

**第一步：定义物料组件JSON**

在schema/widgetConfig.ts文件中新增一段JSON，JSON例如：

```
{
  id: '', // 组件唯一性id
  componentName: 'hj-text-2', // 组件名
  commentType: '', // 组件类型
  icon: '', // 组件icon
  title: '', // 组件中文名称
  description: '渐变文本-1', // 组件描述信息
  screenShot: {
    src: 'text-2.png',
    width: '116px',
    height: '37px',
    borderRadius: '4px'
  }, // 组件快照
  keywords: '文本-2', // 组件关键词，用于搜索
  category: 'text', // 组件分类
  props: {}, // 组件属性
  css: {
    left: 0,
    top: 0,
    zIndex: 1,
    width: 60,
    height: 20,
    rotate: 0, // 旋转角度
    fontSize: 14,
    letterSpace: 1,
    lineHeight: 1.5,
    fontFamily: '方正黑体简体',
    fontWeight: 500,
    textAlign: 'justify',
    padding: {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    },
    borderWidth: 0,
    borderRadius: 10,
    borderColor: '#eee',
    borderStyle: 'solid'
  }, // 组件样式
  dataSource: {} // 组件单独数据
}
```
将上段JSON添加到List字段中去，左侧物料区对应的分类下就会有对应的组件选择了，主要注意JSON中相关字段含义。其中props和css、dataSource对象中的每一个字段都有对应属性设置组件，比如你在css中添加了fontSize字段，那么右侧属性面板将会出现如下选项：


<p align=center><img src="https://p6-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/04652436dc9944d7a69b7d26a2145732~tplv-k3u1fbpfcp-watermark.image?" alt="image.png"  /></p>

如果没有对应属性设置组件，则需要自己定义。

**第二步：编写组件代码**

在widgets文件夹下新增组件代码，比如下图新增了头像组件：

<p align=center><img src="https://p6-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/386d33e9373b4af28a63b17d65f7e501~tplv-k3u1fbpfcp-watermark.image?" alt="image.png"  /></p>

并且需要在widgets目录下的index.ts中注册该组件。

**第三步：新增组件设置面板**

如果你新增的props和css、dataSource对象中的字段有对应的组件，那么你无需执行这一步，否则需要在setters目录下新增属性设置组件：

<p align=center><img src="https://p1-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/6d57ee20d9e1407dbbedf575106cd354~tplv-k3u1fbpfcp-watermark.image?" alt="image.png"  /></p>
需要注意每新增一个组件都需要在当对应目录下的ts文件中注册组件。

## 设计器应用于其他项目

由于积木制作设计器较为独立，所以抽离到其他项目中比较容易，但是还是有一些点需要注意：

- 设计器使用了pinia，需要单独去剥离，存放在store目录下
- 设计器有导航栏，可能使用全局公共组件，如果不需要直接删除即可
- 涉及到发送请求的地方不需要也直接删除掉
- 其他地方调用了公共组件，可以将公共组件抽离到legoDesigner目录下

# 🙉 项目代码提交说明

为了规范项目的代码提交，项目内安装了husky等插件，提交代码则不能使用传统的git命令提交。

**大致流程如下：**

add更改

```
git add .
```

执行命令：

```
npm run commit
```
会出现如下界面，根据本次改动内容具体选择：

<p align=center><img src="https://p9-juejin.byteimg.com/tos-cn-i-k3u1fbpfcp/51bba01a17c74b619c6d6a7b2fae080d~tplv-k3u1fbpfcp-watermark.image?" alt="image.png"  /></p>

如果代码校验没有通过，则会还原当前改变，并且将变化存入了stash，你需要执行如下命令弹出更改：

```
git stash pop
```
推送代码

```
git push
```
# 🚟 项目交流

- **开放微信交流群**

添加开源作者微信：LHQfighting，备注【猫步简历】，进入猫步简历技术交流群。

- **知识星球学习社区**

此社区只开放给已获取猫步简历项目后端源代码的伙伴，社区内部会持续推送最新后端源码，后端源码具体获取方式可到猫步简历官网查看：[猫步简历](https://maobucv.com)

<p align="center">
    <img width="200" src="https://gitee.com/sharemore52/resume-design/raw/main/src/assets/images/vx.jpg">
    <img width="200" src="https://gitee.com/sharemore52/resume-design/raw/main/src/assets/images/xingqiu.jpg">
</p>

# 🍓 成为贡献者

由于项目目前主要还是小编一个人作为主要代码贡献者，所以工作量很大，分支主要维护在main分支，所以大家提交PR是直接请求合并到main分支即可。

如果你发现了问题并且解决了他，欢迎提交PR吧！成为开源贡献中的一员！

**PR地址：**[pull request](https://github.com/Hacker233/resume-design/pulls)

# 🚉 问题反馈

如果在使用猫步简历的过程中遇到问题，获取你有好的想法、需求等，都可以反馈给开源作者，作者将及时响应。
**反馈途径：**

1. 开放微信交流群直接询问
2. 直接提[issue](https://github.com/Hacker233/resume-design/issues)（强烈建议）

# 🍜 License

- [MIT](https://opensource.org/licenses/MIT)

# 贡献者

<table>
<tr>
    <td align="center" style="word-wrap: break-word; width: 75.0; height: 75.0">
        <a href=https://github.com/Hacker233>
            <img src=https://avatars.githubusercontent.com/u/28037169?v=4 width="50;"  style="border-radius:50%;align-items:center;justify-content:center;overflow:hidden;padding-top:10px" alt=会飞的猪/>
            <br />
            <sub style="font-size:14px"><b>会飞的猪</b></sub>
        </a>
    </td>
    <td align="center" style="word-wrap: break-word; width: 75.0; height: 75.0">
        <a href=https://github.com/QC2168>
            <img src=https://avatars.githubusercontent.com/u/82024018?v=4 width="50;"  style="border-radius:50%;align-items:center;justify-content:center;overflow:hidden;padding-top:10px" alt=_island/>
            <br />
            <sub style="font-size:14px"><b>_island</b></sub>
        </a>
    </td>
    <td align="center" style="word-wrap: break-word; width: 75.0; height: 75.0">
        <a href=https://github.com/ynzy>
            <img src=https://avatars.githubusercontent.com/u/39397772?v=4 width="50;"  style="border-radius:50%;align-items:center;justify-content:center;overflow:hidden;padding-top:10px" alt=张雨凡/>
            <br />
            <sub style="font-size:14px"><b>张雨凡</b></sub>
        </a>
    </td>
    <td align="center" style="word-wrap: break-word; width: 75.0; height: 75.0">
        <a href=https://github.com/Ocean-H1>
            <img src=https://avatars.githubusercontent.com/u/74898523?v=4 width="50;"  style="border-radius:50%;align-items:center;justify-content:center;overflow:hidden;padding-top:10px" alt=Ocean Han/>
            <br />
            <sub style="font-size:14px"><b>Ocean Han</b></sub>
        </a>
    </td>
    <td align="center" style="word-wrap: break-word; width: 75.0; height: 75.0">
        <a href=https://github.com/yucheng514>
            <img src=https://avatars.githubusercontent.com/u/35727398?v=4 width="50;"  style="border-radius:50%;align-items:center;justify-content:center;overflow:hidden;padding-top:10px" alt=- luozha -/>
            <br />
            <sub style="font-size:14px"><b>- luozha -</b></sub>
        </a>
    </td>
    <td align="center" style="word-wrap: break-word; width: 75.0; height: 75.0">
        <a href=https://github.com/Hbisedm>
            <img src=https://avatars.githubusercontent.com/u/51397088?v=4 width="50;"  style="border-radius:50%;align-items:center;justify-content:center;overflow:hidden;padding-top:10px" alt=Sam/>
            <br />
            <sub style="font-size:14px"><b>Sam</b></sub>
        </a>
    </td>
</tr>
</table>