// this file should re-export only things that don't rely on Node.js or other runner features

export {
  EvaluatedModules,
  normalizeModuleId,
  type EvaluatedModuleNode,
} from './evaluatedModules'
export { ModuleRunner } from './runner'
export { ESModulesEvaluator } from './esmEvaluator'
export {
  createDefaultImportMeta,
  createNodeImportMeta,
} from './createImportMeta'

export { createWebSocketModuleRunnerTransport } from '../shared/moduleRunnerTransport'

export type { FetchFunctionOptions, FetchResult } from '../shared/invokeMethods'
export type {
  ModuleRunnerTransportHandlers,
  ModuleRunnerTransport,
} from '../shared/moduleRunnerTransport'
export type { HMRLogger } from '../shared/hmr'
export type {
  ModuleEvaluator,
  ModuleRunnerContext,
  FetchFunction,
  ResolvedResult,
  SSRImportMetadata,
  ModuleRunnerImportMeta,
  ModuleRunnerOptions,
  ModuleRunnerHmr,
} from './types'
export {
  ssrDynamicImportKey,
  ssrExportAllKey,
  ssrExportNameKey,
  ssrImportKey,
  ssrImportMetaKey,
  ssrModuleExportsKey,
} from './constants'
export type { InterceptorOptions } from './sourcemap/interceptor'
