/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.graphics.Blending;
import arc.graphics.Texture;
import arc.graphics.g2d.MySpriteBatchBase;
import arc.math.Mathf;
import java.util.Arrays;
import mindustryX.features.DebugUtil;
import mindustryX.features.RenderExt;

public class MySpriteBatch
extends MySpriteBatchBase {
    private static final int PRIME2 = -1262997959;
    int[] extraZ = new int[10000];
    int orderZ = 0;
    int hashZ = 0;
    private static final IntIntMap vMap = new IntIntMap(10000, 0.25f);
    private static int[] orderArr = new int[1000];
    private static int[] orderArr2 = new int[1000];

    @Override
    protected void z(float z) {
        this.orderZ = 0;
        if (this.z == z) {
            return;
        }
        super.z(z);
    }

    @Override
    protected void flush() {
        ++DebugUtil.lastFlushCount;
        super.flush();
    }

    @Override
    protected void flushRequests() {
        DebugUtil.lastVertices += this.requestVertOffset / 6;
        DebugUtil.lastDrawRequests += this.numRequests;
        super.flushRequests();
    }

    protected void switchTexture(Texture texture) {
        ++DebugUtil.lastSwitchTexture;
        super.switchTexture(texture);
    }

    @Override
    protected void expandRequests() {
        super.expandRequests();
        this.extraZ = Arrays.copyOf(this.extraZ, this.requestZ.length);
    }

    @Override
    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        super.draw(texture, spriteVertices, offset, count);
        if (this.sort && !this.flushing && RenderExt.renderSort) {
            int h = texture.hashCode() + this.hashZ;
            this.extraZ[this.numRequests - 1] = this.orderZ++ << 16 | h & 0xFFFC | (this.blending == Blending.disabled ? 2 : 0) | (this.blending == Blending.additive ? 1 : 0);
        }
    }

    @Override
    protected void draw(Runnable request) {
        super.draw(request);
        if (this.sort && !this.flushing && RenderExt.renderSort) {
            int h = this.hashZ;
            this.extraZ[this.numRequests - 1] = this.orderZ++ << 16 | h & 0xFFFF;
        }
    }

    @Override
    protected void sortRequests() {
        int numRequests = this.numRequests;
        int[] arr = this.requestZ;
        if (RenderExt.renderSort) {
            this.hashZ = DebugUtil.renderDebug ? Float.floatToIntBits((float)Math.random()) : 0;
            int[] extraZ = this.extraZ;
            MySpriteBatch.mapToRank(arr, numRequests);
            MySpriteBatch.mapToRank(extraZ, numRequests);
            for (int i = 0; i < numRequests; ++i) {
                arr[i] = arr[i] << 16 | extraZ[i];
            }
        }
        MySpriteBatch.countingSortMap(arr, numRequests);
        if (this.copy.length < this.requests.length) {
            this.copy = new MySpriteBatchBase.DrawRequest[this.requests.length];
        }
        MySpriteBatchBase.DrawRequest[] items = this.requests;
        MySpriteBatchBase.DrawRequest[] dest = this.copy;
        for (int i = 0; i < numRequests; ++i) {
            dest[arr[i]] = items[i];
        }
    }

    private static int mapToRank(int[] arr, int len) {
        int i;
        IntIntMap map = vMap;
        int[] order = orderArr;
        map.clear();
        int unique = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int id;
            int v = arr[i2];
            arr[i2] = id = map.getOrPut(v, unique);
            if (id != unique) continue;
            if (order.length <= unique) {
                order = orderArr = Arrays.copyOf(order, unique << 1);
            }
            order[unique] = v;
            ++unique;
        }
        Arrays.sort(order, 0, unique);
        int[] order2 = orderArr2;
        if (order2.length < order.length) {
            order2 = orderArr2 = new int[order.length];
        }
        for (i = 0; i < unique; ++i) {
            order2[map.getOrPut((int)order[i], (int)-1)] = i;
        }
        for (i = 0; i < len; ++i) {
            arr[i] = order2[arr[i]];
        }
        return unique;
    }

    private static void countingSortMap(int[] arr, int len) {
        int id;
        int i;
        int[] order = orderArr;
        int[] counts = orderArr2;
        IntIntMap map = vMap;
        map.clear();
        int unique = 0;
        for (i = 0; i < len; ++i) {
            int v = arr[i];
            arr[i] = id = map.getOrPut(v, unique);
            if (id == unique) {
                if (order.length <= unique) {
                    order = orderArr = Arrays.copyOf(order, unique << 1);
                    counts = orderArr2 = Arrays.copyOf(counts, unique << 1);
                }
                order[unique] = v;
                counts[unique] = 1;
                ++unique;
                continue;
            }
            int n = id;
            counts[n] = counts[n] + 1;
        }
        Arrays.sort(order, 0, unique);
        int loc = 0;
        for (i = 0; i < unique; ++i) {
            id = map.getOrPut(order[i], -1);
            int c = counts[id];
            counts[id] = loc;
            loc += c;
        }
        for (i = 0; i < len; ++i) {
            int n = arr[i];
            counts[n] = counts[n] + 1;
        }
    }

    public static class IntIntMap {
        private int[] keys;
        private boolean hasZero;
        private int[] values;
        private int zeroValue;
        private int size;
        private int capacity;
        private int maxSize;
        private float loadFactor;
        private int mask;
        private int hashShift;

        public IntIntMap(int capacity, float loadFactor) {
            this.setCapacity(capacity, loadFactor);
        }

        private int hash(int key) {
            return (key *= -1262997959) ^ key >>> this.hashShift;
        }

        public int getOrPut(int key, int defaultValue) {
            if (key == 0) {
                if (this.hasZero) {
                    return this.zeroValue;
                }
                this.zeroValue = defaultValue;
                this.hasZero = true;
                return defaultValue;
            }
            int mask = this.mask;
            int index = this.hash(key) & mask;
            int[] keys2 = this.keys;
            while (keys2[index] != 0) {
                if (keys2[index] == key) {
                    return this.values[index];
                }
                index = index + 1 & mask;
            }
            keys2[index] = key;
            this.values[index] = defaultValue;
            ++this.size;
            if (this.size > this.maxSize) {
                this.setCapacity(this.capacity << 1, this.loadFactor);
            }
            return defaultValue;
        }

        private void setCapacity(int capacity, float loadFactor) {
            this.capacity = capacity = Mathf.nextPowerOfTwo((int)capacity);
            this.loadFactor = loadFactor;
            this.maxSize = (int)((float)capacity * loadFactor);
            int mask = this.mask = capacity - 1;
            this.hashShift = 31 - Integer.numberOfTrailingZeros(capacity);
            int[] oldKeys = this.keys;
            int[] oldValues = this.values;
            this.keys = new int[capacity];
            int[] keys2 = this.keys;
            this.values = new int[capacity];
            int[] values2 = this.values;
            if (oldKeys == null || oldValues == null) {
                return;
            }
            for (int i = 0; i < oldKeys.length; ++i) {
                if (oldKeys[i] == 0) continue;
                int index = this.hash(oldKeys[i]) & mask;
                while (keys2[index] != 0) {
                    index = index + 1 & mask;
                }
                keys2[index] = oldKeys[i];
                values2[index] = oldValues[i];
            }
        }

        private void clear() {
            Arrays.fill(this.keys, 0);
            Arrays.fill(this.values, 0);
            this.size = 0;
            this.hasZero = false;
        }
    }
}

