/*
 * Decompiled with CFR 0.152.
 */
package mindustry;

import arc.ApplicationCore;
import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.assets.AssetManager;
import arc.assets.Loadable;
import arc.assets.loaders.AssetLoader;
import arc.assets.loaders.FileHandleResolver;
import arc.assets.loaders.MusicLoader;
import arc.assets.loaders.SoundLoader;
import arc.audio.Music;
import arc.audio.Sound;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.MySpriteBatch;
import arc.graphics.g2d.TextureAtlas;
import arc.math.Mathf;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Threads;
import arc.util.Time;
import mindustry.Vars;
import mindustry.ai.BaseRegistry;
import mindustry.audio.SoundPriority;
import mindustry.core.ContentLoader;
import mindustry.core.Control;
import mindustry.core.FileTree;
import mindustry.core.Logic;
import mindustry.core.NetClient;
import mindustry.core.NetServer;
import mindustry.core.PerfCounter;
import mindustry.core.Platform;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.ctype.Content;
import mindustry.game.EventType;
import mindustry.game.Schematics;
import mindustry.gen.Musics;
import mindustry.gen.Sounds;
import mindustry.graphics.IntelGpuCheck;
import mindustry.graphics.LoadRenderer;
import mindustry.graphics.NvGpuInfo;
import mindustry.maps.Map;
import mindustry.maps.MapPreviewLoader;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import mindustry.net.Net;
import mindustry.ui.Fonts;
import mindustryX.Hooks;

public abstract class ClientLauncher
extends ApplicationCore
implements Platform {
    private static final int loadingFPS = 20;
    private long nextFrame;
    private long beginTime;
    private long lastTargetFps = -1L;
    private boolean finished = false;
    private LoadRenderer loader;

    public void setup() {
        long ram;
        boolean gb;
        String dataDir = System.getProperty("mindustry.data.dir", OS.env((String)"MINDUSTRY_DATA_DIR"));
        if (Core.app.isDesktop() && dataDir == null && Fi.get((String)"data").isDirectory()) {
            dataDir = "data";
        }
        if (dataDir != null) {
            Core.settings.setDataDirectory(Core.files.absolute(dataDir));
        }
        Vars.checkLaunch();
        Vars.loadLogger();
        this.loader = new LoadRenderer();
        Events.fire((Object)new EventType.ClientCreateEvent());
        Vars.loadFileLogger();
        Vars.platform = this;
        Vars.maxTextureSize = Gl.getInt((int)3379);
        this.beginTime = Time.millis();
        Log.info((String)"[GL] Version: @", (Object[])new Object[]{Core.graphics.getGLVersion()});
        Log.info((String)"[GL] Max texture size: @", (Object[])new Object[]{Vars.maxTextureSize});
        Log.info((String)"[GL] Using @ API.", (Object[])new Object[]{Core.gl30 != null ? "OpenGL 3" : "OpenGL 2"});
        IntelGpuCheck.init((String)Core.graphics.getGLVersion().vendorString);
        boolean isIntel = IntelGpuCheck.wasIntel();
        if (isIntel && !Core.graphics.isGL30Available()) {
            Log.warn((String)"[GL] Intel GPU detected on previous launch. Due to memory corruption issues, OpenGL 3 support has been disabled for Intel GPUs. See issue #11041.", (Object[])new Object[0]);
        }
        if (Core.gl30 == null && !isIntel) {
            Log.warn((String)"[GL] Your device or video drivers do not support OpenGL 3. This will cause performance issues.", (Object[])new Object[0]);
        }
        if (NvGpuInfo.hasMemoryInfo()) {
            Log.info((String)"[GL] Total available VRAM: @mb", (Object[])new Object[]{NvGpuInfo.getMaxMemoryKB() / 1024});
        }
        if (Vars.maxTextureSize < 4096) {
            Log.warn((String)"[GL] Your maximum texture size is below the recommended minimum of 4096. This will cause severe performance issues.", (Object[])new Object[0]);
        }
        Log.info((String)"[JAVA] Version: @", (Object[])new Object[]{OS.javaVersion});
        if (Core.app.isAndroid()) {
            Log.info((String)"[ANDROID] API level: @", (Object[])new Object[]{Core.app.getVersion()});
        }
        boolean bl = gb = (ram = Runtime.getRuntime().maxMemory()) >= 0x40000000L;
        if (!OS.isIos) {
            Log.info((String)"[RAM] Available: @ @", (Object[])new Object[]{Strings.fixed((float)(gb ? (float)ram / 1024.0f / 1024.0f / 1024.0f : (float)ram / 1024.0f / 1024.0f), (int)1), gb ? "GB" : "MB"});
        }
        Time.setDeltaProvider(() -> {
            float result = Core.graphics.getDeltaTime() * 60.0f;
            return Float.isNaN(result) || Float.isInfinite(result) ? 1.0f : Mathf.clamp((float)result, (float)1.0E-4f, (float)Vars.maxDeltaClient);
        });
        UI.loadColors();
        Core.batch = new MySpriteBatch();
        Core.assets = new AssetManager();
        Core.assets.setLoader(Texture.class, ".msav", (AssetLoader)new MapPreviewLoader());
        Vars.tree = new FileTree();
        Core.assets.setLoader(Sound.class, (AssetLoader)new SoundLoader((FileHandleResolver)Vars.tree){

            public void loadAsync(AssetManager manager, String fileName, Fi file, SoundLoader.SoundParameter parameter) {
            }

            public Sound loadSync(AssetManager manager, String fileName, Fi file, SoundLoader.SoundParameter parameter) {
                if (parameter != null && parameter.sound != null) {
                    Vars.mainExecutor.submit(() -> parameter.sound.load(file));
                    return parameter.sound;
                }
                Sound sound = new Sound();
                Vars.mainExecutor.submit(() -> {
                    try {
                        sound.load(file);
                    }
                    catch (Throwable t) {
                        Log.err((String)("Error loading sound: " + file), (Throwable)t);
                    }
                });
                return sound;
            }
        });
        Core.assets.setLoader(Music.class, (AssetLoader)new MusicLoader((FileHandleResolver)Vars.tree){

            public void loadAsync(AssetManager manager, String fileName, Fi file, MusicLoader.MusicParameter parameter) {
            }

            public Music loadSync(AssetManager manager, String fileName, Fi file, MusicLoader.MusicParameter parameter) {
                if (parameter != null && parameter.music != null) {
                    Vars.mainExecutor.submit(() -> {
                        try {
                            parameter.music.load(file);
                        }
                        catch (Throwable t) {
                            Log.err((String)("Error loading music: " + file), (Throwable)t);
                        }
                    });
                    return parameter.music;
                }
                Music music = new Music();
                Vars.mainExecutor.submit(() -> {
                    try {
                        music.load(file);
                    }
                    catch (Throwable t) {
                        Log.err((String)("Error loading music: " + file), (Throwable)t);
                    }
                });
                return music;
            }
        });
        Core.assets.load("sprites/error.png", Texture.class);
        Core.atlas = TextureAtlas.blankAtlas();
        Vars.net = new Net(Vars.platform.getNet());
        Vars.mods = new Mods();
        Vars.schematics = new Schematics();
        Fonts.loadSystemCursors();
        Core.assets.load((Loadable)new Vars());
        Core.assets.load((String)(Vars.maxTextureSize >= 4096 ? "sprites/sprites.aatls" : "sprites/fallback/sprites.aatls"), TextureAtlas.class).loaded = t -> {
            Core.atlas = t;
        };
        Core.assets.loadRun("maps", Map.class, () -> Vars.maps.loadPreviews());
        Musics.load();
        Sounds.load();
        Core.assets.loadRun("contentcreate", Content.class, () -> {
            Vars.content.createBaseContent();
            Vars.content.loadColors();
        }, () -> {
            Vars.mods.loadScripts();
            Vars.content.createModContent();
        });
        Core.assets.load((Loadable)Vars.mods);
        Vars.logic = new Logic();
        this.add(Vars.logic);
        Vars.control = new Control();
        this.add(Vars.control);
        Vars.renderer = new Renderer();
        this.add(Vars.renderer);
        Fonts.loadFonts();
        Vars.ui = new UI();
        this.add(Vars.ui);
        Vars.netServer = new NetServer();
        this.add((ApplicationListener)Vars.netServer);
        Vars.netClient = new NetClient();
        this.add(Vars.netClient);
        this.add(new Hooks());
        Core.assets.load((Loadable)Vars.schematics);
        Core.assets.loadRun("contentinit", ContentLoader.class, () -> Vars.content.init(), () -> Vars.content.load());
        Core.assets.loadRun("baseparts", BaseRegistry.class, () -> {}, () -> Vars.bases.load());
    }

    public void add(ApplicationListener module) {
        super.add(module);
        if (module instanceof Loadable) {
            Loadable l = (Loadable)module;
            Core.assets.load(l);
        }
    }

    public void resize(int width, int height) {
        if (Core.assets == null) {
            return;
        }
        if (!this.finished) {
            Draw.proj().setOrtho(0.0f, 0.0f, (float)width, (float)height);
        } else {
            super.resize(width, height);
        }
    }

    public void update() {
        PerfCounter.update.begin();
        int targetfps = Vars.ios ? 0 : Core.settings.getInt("fpscap", 120);
        boolean changed = this.lastTargetFps != (long)targetfps && this.lastTargetFps != -1L;
        boolean limitFps = targetfps > 0 && targetfps <= 240;
        this.lastTargetFps = targetfps;
        this.nextFrame = limitFps && !changed ? (this.nextFrame += (long)(1000000000 / targetfps)) : Time.nanos();
        if (!this.finished) {
            if (this.loader != null) {
                this.loader.draw();
            }
            if (Core.assets.update(50)) {
                this.loader.dispose();
                this.loader = null;
                SoundPriority.init();
                for (ApplicationListener listener : this.modules) {
                    listener.init();
                }
                Vars.mods.eachClass((Cons<Mod>)((Cons)Mod::init));
                this.finished = true;
                Events.fire((Object)new EventType.ClientLoadEvent());
                Log.info((String)"Total time to load: @ms", (Object[])new Object[]{Time.timeSinceMillis((long)this.beginTime)});
                Vars.clientLoaded = true;
                super.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> {
                    super.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                    Vars.finishLaunch();
                }))));
            }
        } else {
            Vars.asyncCore.begin();
            super.update();
            Vars.asyncCore.end();
        }
        if (limitFps) {
            Gl.flush();
            long current = Time.nanos();
            if (this.nextFrame > current) {
                long toSleep = this.nextFrame - current;
                Threads.sleep((long)(toSleep / 1000000L), (int)((int)(toSleep % 1000000L)));
            } else {
                this.nextFrame = current;
            }
        }
        PerfCounter.update.end();
    }

    public void exit() {
        Vars.finishLaunch();
    }

    public void init() {
        this.nextFrame = Time.nanos();
        this.setup();
    }

    public void resume() {
        if (this.finished) {
            super.resume();
        }
    }

    public void pause() {
        if (Vars.mobile) {
            Vars.finishLaunch();
        }
        if (this.finished) {
            super.pause();
        }
    }
}

