/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.struct.EnumSet;
import arc.struct.IntSeq;
import arc.struct.ObjectIntMap;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.ai.BlockIndexer;
import mindustry.ai.types.PrebuildAI;
import mindustry.content.Blocks;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.logic.Ranged;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.meta.BlockFlag;

public class BlockIndexer {
    private static final int quadrantSize = 20;
    private static final Rect rect = new Rect();
    private static boolean returnBool = false;
    private int quadWidth;
    private int quadHeight;
    private IntSeq[][][] ores;
    private IntSeq[][][] wallOres;
    private Seq<Building>[] damagedTiles = new Seq[Team.all.length];
    private Seq<Item> allPresentOres = new Seq();
    public ObjectIntMap<Item> allOres = new ObjectIntMap();
    public ObjectIntMap<Item> allWallOres = new ObjectIntMap();
    private Seq<Team> activeTeams = new Seq(Team.class);
    private Seq<Building>[][] flagMap = new Seq[Team.all.length][BlockFlag.all.length];
    private boolean[] blocksPresent;
    private Seq<Building> breturnArray = new Seq(Building.class);
    private Seq<Tile>[] floorMap;

    public BlockIndexer() {
        this.clearFlags();
        Events.on(EventType.TilePreChangeEvent.class, event -> this.removeIndex(event.tile));
        Events.on(EventType.TileChangeEvent.class, event -> this.addIndex(event.tile));
        Events.on(EventType.TileFloorChangeEvent.class, event -> {
            this.removeFloorIndex(event.tile, event.previous);
            this.addFloorIndex(event.tile, event.floor);
        });
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.damagedTiles = new Seq[Team.all.length];
            this.flagMap = new Seq[Team.all.length][BlockFlag.all.length];
            this.floorMap = new Seq[BlockFlag.all.length];
            this.activeTeams = new Seq(Team.class);
            this.clearFlags();
            this.allOres.clear();
            this.allWallOres.clear();
            this.ores = new IntSeq[Vars.content.items().size][][];
            this.wallOres = new IntSeq[Vars.content.items().size][][];
            this.quadWidth = Mathf.ceil((float)((float)Vars.world.width() / 20.0f));
            this.quadHeight = Mathf.ceil((float)((float)Vars.world.height() / 20.0f));
            this.blocksPresent = new boolean[Vars.content.blocks().size];
            for (Team team : Team.all) {
                Teams.TeamData data = Vars.state.teams.get(team);
                if (data == null) continue;
                if (data.buildingTree != null) {
                    data.buildingTree.clear();
                }
                if (data.turretTree == null) continue;
                data.turretTree.clear();
            }
            for (Tile tile : Vars.world.tiles) {
                Item drop;
                this.process(tile);
                this.addFloorIndex(tile, tile.floor());
                int qx = tile.x / 20;
                int qy = tile.y / 20;
                if (tile.block() == Blocks.air) {
                    drop = tile.drop();
                    if (drop == null) continue;
                    if (this.ores[drop.id] == null) {
                        this.ores[drop.id] = new IntSeq[this.quadWidth][this.quadHeight];
                    }
                    if (this.ores[drop.id][qx][qy] == null) {
                        this.ores[drop.id][qx][qy] = new IntSeq(false, 16);
                    }
                    this.ores[drop.id][qx][qy].add(tile.pos());
                    this.allOres.increment((Object)drop);
                    continue;
                }
                drop = tile.wallDrop();
                if (drop == null) continue;
                if (this.wallOres[drop.id] == null) {
                    this.wallOres[drop.id] = new IntSeq[this.quadWidth][this.quadHeight];
                }
                if (this.wallOres[drop.id][qx][qy] == null) {
                    this.wallOres[drop.id][qx][qy] = new IntSeq(false, 16);
                }
                this.wallOres[drop.id][qx][qy].add(tile.pos());
                this.allWallOres.increment((Object)drop);
            }
            this.updatePresentOres();
            for (Team team : Team.all) {
                Teams.TeamData data = Vars.state.teams.get(team);
                if (!team.rules().prebuildAi || !data.hasCore()) continue;
                PrebuildAI.sortPlans((Queue)data.plans);
            }
        });
    }

    public Seq<Item> getAllPresentOres() {
        return this.allPresentOres;
    }

    private void updatePresentOres() {
        this.allPresentOres.clear();
        for (Item item : Vars.content.items()) {
            if (!this.hasOre(item) && !this.hasWallOre(item)) continue;
            this.allPresentOres.add((Object)item);
        }
    }

    private void removeFloorIndex(Tile tile, Floor floor) {
        if (floor.flags.size == 0 || this.floorMap == null) {
            return;
        }
        for (BlockFlag flag : (BlockFlag[])floor.flags.array) {
            this.getFlaggedFloors(flag).remove((Object)tile);
        }
    }

    private void addFloorIndex(Tile tile, Floor floor) {
        if (floor.flags.size == 0 || !floor.shouldIndex(tile) || this.floorMap == null) {
            return;
        }
        for (BlockFlag flag : (BlockFlag[])floor.flags.array) {
            this.getFlaggedFloors(flag).add((Object)tile);
        }
    }

    public Seq<Tile> getFlaggedFloors(BlockFlag flag) {
        if (this.floorMap[flag.ordinal()] == null) {
            this.floorMap[flag.ordinal()] = new Seq(false);
        }
        return this.floorMap[flag.ordinal()];
    }

    public void removeIndex(Tile tile) {
        Team team = tile.team();
        if (tile.build != null && tile.isCenter()) {
            Building build = tile.build;
            EnumSet<BlockFlag> flags = tile.block().flags;
            Teams.TeamData data = team.data();
            if (flags.size > 0) {
                for (BlockFlag flag : (BlockFlag[])flags.array) {
                    this.getFlagged(team)[flag.ordinal()].remove((Object)build);
                }
            }
            data.buildings.remove((Object)build);
            ((Seq)data.buildingTypes.get((Object)build.block, () -> new Seq(false))).remove((Object)build);
            data.unitCap -= tile.block().unitCapModifier;
            if (data.buildingTree != null) {
                data.buildingTree.remove((QuadTree.QuadTreeObject)build);
            }
            if (data.turretTree != null && build.block.attacks) {
                data.turretTree.remove((QuadTree.QuadTreeObject)build);
            }
            if (build.wasDamaged && this.damagedTiles[team.id] != null) {
                this.damagedTiles[team.id].remove((Object)build);
            }
            build.wasDamaged = false;
        }
    }

    public void addIndex(Tile base) {
        this.process(base);
        base.getLinkedTiles(tile -> {
            Item drop = tile.drop();
            Item wallDrop = tile.wallDrop();
            if (drop == null && wallDrop == null) {
                return;
            }
            int qx = tile.x / 20;
            int qy = tile.y / 20;
            int pos = tile.pos();
            if (tile.block() == Blocks.air) {
                int old;
                if (drop != null) {
                    if (this.ores[drop.id] == null) {
                        this.ores[drop.id] = new IntSeq[this.quadWidth][this.quadHeight];
                    }
                    if (this.ores[drop.id][qx][qy] == null) {
                        this.ores[drop.id][qx][qy] = new IntSeq(false, 16);
                    }
                    if (this.ores[drop.id][qx][qy].addUnique(pos) && (old = this.allOres.increment((Object)drop)) == 0) {
                        this.updatePresentOres();
                    }
                }
                if (wallDrop != null && this.wallOres != null && this.wallOres[wallDrop.id] != null && this.wallOres[wallDrop.id][qx][qy] != null && this.wallOres[wallDrop.id][qx][qy].removeValue(pos) && (old = this.allWallOres.increment((Object)wallDrop, -1)) == 1) {
                    this.updatePresentOres();
                }
            } else {
                int old;
                if (wallDrop != null) {
                    if (this.wallOres[wallDrop.id] == null) {
                        this.wallOres[wallDrop.id] = new IntSeq[this.quadWidth][this.quadHeight];
                    }
                    if (this.wallOres[wallDrop.id][qx][qy] == null) {
                        this.wallOres[wallDrop.id][qx][qy] = new IntSeq(false, 16);
                    }
                    if (this.wallOres[wallDrop.id][qx][qy].addUnique(pos) && (old = this.allWallOres.increment((Object)wallDrop)) == 0) {
                        this.updatePresentOres();
                    }
                }
                if (drop != null && this.ores != null && this.ores[drop.id] != null && this.ores[drop.id][qx][qy] != null && this.ores[drop.id][qx][qy].removeValue(pos) && (old = this.allOres.increment((Object)drop, -1)) == 1) {
                    this.updatePresentOres();
                }
            }
        });
    }

    public boolean isBlockPresent(Block block) {
        return this.blocksPresent != null && this.blocksPresent[block.id];
    }

    private void clearFlags() {
        for (int i = 0; i < this.flagMap.length; ++i) {
            for (int j = 0; j < BlockFlag.all.length; ++j) {
                this.flagMap[i][j] = new Seq();
            }
        }
    }

    private Seq<Building>[] getFlagged(Team team) {
        return this.flagMap[team.id];
    }

    public boolean hasOre(Item item) {
        return this.allOres.get((Object)item) > 0;
    }

    public boolean hasWallOre(Item item) {
        return this.allWallOres.get((Object)item) > 0;
    }

    public Seq<Building> getDamaged(Team team) {
        if (this.damagedTiles[team.id] == null) {
            this.damagedTiles[team.id] = new Seq(false);
            return this.damagedTiles[team.id];
        }
        Seq<Building> tiles = this.damagedTiles[team.id];
        tiles.removeAll(b -> !b.damaged());
        return tiles;
    }

    public Seq<Building> getFlagged(Team team, BlockFlag type) {
        return this.flagMap[team.id][type.ordinal()];
    }

    @Nullable
    public Building findClosestFlag(float x, float y, Team team, BlockFlag flag) {
        return (Building)Geometry.findClosest((float)x, (float)y, this.getFlagged(team, flag));
    }

    public boolean eachBlock(Teamc team, float range, Boolf<Building> pred, Cons<Building> cons) {
        return this.eachBlock(team.team(), team.getX(), team.getY(), range, pred, cons);
    }

    public boolean eachBlock(@Nullable Team team, float wx, float wy, float range, Boolf<Building> pred, Cons<Building> cons) {
        if (team == null) {
            returnBool = false;
            this.allBuildings(wx, wy, range, (Cons<Building>)((Cons)b -> {
                if (pred.get(b)) {
                    returnBool = true;
                    cons.get(b);
                }
            }));
            return returnBool;
        }
        this.breturnArray.clear();
        QuadTree buildings = team.data().buildingTree;
        if (buildings == null) {
            return false;
        }
        buildings.intersect(wx - range, wy - range, range * 2.0f, range * 2.0f, b -> {
            if (b.within(wx, wy, range + b.hitSize() / 2.0f) && pred.get(b)) {
                this.breturnArray.add(b);
            }
        });
        int size = this.breturnArray.size;
        Building[] items = (Building[])this.breturnArray.items;
        for (int i = 0; i < size; ++i) {
            cons.get((Object)items[i]);
            items[i] = null;
        }
        this.breturnArray.size = 0;
        return size > 0;
    }

    public boolean eachBlock(Team team, Rect rect, Boolf<Building> pred, Cons<Building> cons) {
        if (team == null) {
            return false;
        }
        this.breturnArray.clear();
        QuadTree buildings = team.data().buildingTree;
        if (buildings == null) {
            return false;
        }
        buildings.intersect(rect, b -> {
            if (pred.get(b)) {
                this.breturnArray.add(b);
            }
        });
        int size = this.breturnArray.size;
        Building[] items = (Building[])this.breturnArray.items;
        for (int i = 0; i < size; ++i) {
            cons.get((Object)items[i]);
            items[i] = null;
        }
        this.breturnArray.size = 0;
        return size > 0;
    }

    public Seq<Building> getEnemy(Team team, BlockFlag type) {
        this.breturnArray.clear();
        Seq data = Vars.state.teams.present;
        if (data.isEmpty()) {
            for (Team enemy : Team.all) {
                Seq<Building> set;
                if (enemy == team || enemy == Team.derelict && !Vars.state.rules.coreCapture || (set = this.getFlagged(enemy)[type.ordinal()]) == null) continue;
                this.breturnArray.addAll(set);
            }
        } else {
            for (int i = 0; i < data.size; ++i) {
                Seq<Building> set;
                Team enemy = ((Teams.TeamData[])data.items)[i].team;
                if (enemy == team || enemy == Team.derelict && !Vars.state.rules.coreCapture || (set = this.getFlagged(enemy)[type.ordinal()]) == null) continue;
                this.breturnArray.addAll(set);
            }
        }
        return this.breturnArray;
    }

    public void notifyHealthChanged(Building build) {
        boolean damaged = build.damaged();
        if (build.wasDamaged != damaged) {
            if (this.damagedTiles[build.team.id] == null) {
                this.damagedTiles[build.team.id] = new Seq(false);
            }
            if (damaged) {
                this.damagedTiles[build.team.id].add((Object)build);
            } else {
                this.damagedTiles[build.team.id].remove((Object)build);
            }
            build.wasDamaged = damaged;
        }
    }

    public void allBuildings(float x, float y, float range, Cons<Building> cons) {
        this.breturnArray.clear();
        for (int i = 0; i < this.activeTeams.size; ++i) {
            Team team = ((Team[])this.activeTeams.items)[i];
            QuadTree buildings = team.data().buildingTree;
            if (buildings == null) continue;
            buildings.intersect(x - range, y - range, range * 2.0f, range * 2.0f, this.breturnArray);
        }
        Building[] items = (Building[])this.breturnArray.items;
        int size = this.breturnArray.size;
        for (int i = 0; i < size; ++i) {
            Building b = items[i];
            if (b != null && b.within(x, y, range + b.hitSize() / 2.0f)) {
                cons.get((Object)b);
            }
            items[i] = null;
        }
        this.breturnArray.size = 0;
    }

    public Building findEnemyTile(Team team, float x, float y, float range, Units.BuildingPriorityf priority, Boolf<Building> pred) {
        Building target = null;
        float targetDist = 0.0f;
        for (int i = 0; i < this.activeTeams.size; ++i) {
            Building candidate;
            Team enemy = ((Team[])this.activeTeams.items)[i];
            if (enemy == team || enemy == Team.derelict && !Vars.state.rules.coreCapture || (candidate = Vars.indexer.findTile(enemy, x, y, range, (Boolf<Building>)((Boolf)b -> pred.get(b) && b.isDiscovered(team)), true)) == null) continue;
            float dist = candidate.dst(x, y) - candidate.hitSize() / 2.0f;
            if (!(target == null || dist < targetDist && priority.priority(candidate) >= priority.priority(target)) && !(priority.priority(candidate) > priority.priority(target))) continue;
            target = candidate;
            targetDist = dist;
        }
        return target;
    }

    public Building findEnemyTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        return this.findEnemyTile(team, x, y, range, UnitSorts.buildingDefault, pred);
    }

    public Building findTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        return this.findTile(team, x, y, range, pred, false);
    }

    public Building findTile(Team team, float x, float y, float range, Boolf<Building> pred, boolean usePriority) {
        Building closest = null;
        float dst = 0.0f;
        QuadTree buildings = team.data().buildingTree;
        if (buildings == null) {
            return null;
        }
        this.breturnArray.clear();
        buildings.intersect(rect.setCentered(x, y, range * 2.0f), this.breturnArray);
        for (int i = 0; i < this.breturnArray.size; ++i) {
            float bdst;
            Building next = ((Building[])this.breturnArray.items)[i];
            if (!pred.get((Object)next) || !next.block.targetable || !((bdst = next.dst(x, y) - next.hitSize() / 2.0f) < range) || closest != null && (!(bdst < dst) || usePriority && !(closest.block.priority <= next.block.priority)) && (!usePriority || !(closest.block.priority < next.block.priority))) continue;
            dst = bdst;
            closest = next;
        }
        return closest;
    }

    public Tile findClosestOre(float xp, float yp, Item item) {
        if (this.ores[item.id] != null) {
            float minDst = 0.0f;
            Tile closest = null;
            for (int qx = 0; qx < this.quadWidth; ++qx) {
                for (int qy = 0; qy < this.quadHeight; ++qy) {
                    Tile tile;
                    IntSeq arr = this.ores[item.id][qx][qy];
                    if (arr == null || arr.size <= 0 || (tile = Vars.world.tile(arr.first())).block() != Blocks.air) continue;
                    float dst = Mathf.dst2((float)xp, (float)yp, (float)tile.worldx(), (float)tile.worldy());
                    if (closest != null && !(dst < minDst)) continue;
                    closest = tile;
                    minDst = dst;
                }
            }
            return closest;
        }
        return null;
    }

    public Tile findClosestWallOre(float xp, float yp, Item item) {
        if (this.wallOres[item.id] != null) {
            float minDst = 0.0f;
            Tile closest = null;
            for (int qx = 0; qx < this.quadWidth; ++qx) {
                for (int qy = 0; qy < this.quadHeight; ++qy) {
                    Tile tile;
                    IntSeq arr = this.wallOres[item.id][qx][qy];
                    if (arr == null || arr.size <= 0 || (tile = Vars.world.tile(arr.first())).block() == Blocks.air) continue;
                    float dst = Mathf.dst2((float)xp, (float)yp, (float)tile.worldx(), (float)tile.worldy());
                    if (closest != null && !(dst < minDst)) continue;
                    closest = tile;
                    minDst = dst;
                }
            }
            return closest;
        }
        return null;
    }

    public Tile findClosestOre(Unit unit, Item item) {
        return this.findClosestOre(unit.x, unit.y, item);
    }

    public Tile findClosestWallOre(Unit unit, Item item) {
        return this.findClosestWallOre(unit.x, unit.y, item);
    }

    private void process(Tile tile) {
        Team team = tile.team();
        if (tile.isCenter() && tile.build != null) {
            Teams.TeamData data = team.data();
            if (tile.block().flags.size > 0 && tile.isCenter()) {
                Seq<Building>[] map = this.getFlagged(team);
                for (BlockFlag flag : (BlockFlag[])tile.block().flags.array) {
                    map[flag.ordinal()].add((Object)tile.build);
                }
            }
            data.buildings.add((Object)tile.build);
            ((Seq)data.buildingTypes.get((Object)tile.block(), () -> new Seq(false))).add((Object)tile.build);
            data.unitCap += tile.block().unitCapModifier;
            if (!this.activeTeams.contains((Object)team)) {
                this.activeTeams.add((Object)team);
            }
            if (data.buildingTree == null) {
                data.buildingTree = new QuadTree(new Rect(0.0f, 0.0f, (float)Vars.world.unitWidth(), (float)Vars.world.unitHeight()));
            }
            data.buildingTree.insert((QuadTree.QuadTreeObject)tile.build);
            if (tile.block().attacks && tile.build instanceof Ranged) {
                if (data.turretTree == null) {
                    data.turretTree = new TurretQuadtree(new Rect(0.0f, 0.0f, (float)Vars.world.unitWidth(), (float)Vars.world.unitHeight()));
                }
                data.turretTree.insert((QuadTree.QuadTreeObject)tile.build);
            }
            this.notifyHealthChanged(tile.build);
        }
        if (this.blocksPresent != null) {
            if (!tile.block().isStatic()) {
                this.blocksPresent[tile.floorID()] = true;
                this.blocksPresent[tile.overlayID()] = true;
            }
            if (tile.blockID() < this.blocksPresent.length) {
                this.blocksPresent[tile.blockID()] = true;
            }
        }
    }
}

