/*
 * Decompiled with CFR 0.152.
 */
package mindustry.async;

import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.async.AsyncProcess;
import mindustry.entities.EntityGroup;
import mindustry.gen.Groups;
import mindustry.gen.Physicsc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustryX.VarsX;

public class PhysicsProcess
implements AsyncProcess {
    public static final int layers = 4;
    public static final int layerGround = 0;
    public static final int layerLegs = 1;
    public static final int layerFlying = 2;
    public static final int layerUnderwater = 3;
    private PhysicsWorld physics;
    private Seq<PhysicRef> refs = new Seq(false);
    private EntityGroup<Unit> group = Groups.unit;

    public void begin() {
        if (this.physics == null) {
            return;
        }
        boolean local = !Vars.net.client();
        this.refs.removeAll(ref -> {
            if (!ref.entity.isAdded()) {
                this.physics.remove(ref.body);
                ref.entity.physref(null);
                return true;
            }
            return false;
        });
        for (Unit entity : this.group) {
            if (entity == null || entity.type == null || !entity.type.physics) continue;
            if (entity.physref == null) {
                PhysicsWorld.PhysicsBody body = new PhysicsWorld.PhysicsBody();
                body.x = entity.x;
                body.y = entity.y;
                body.mass = entity.mass();
                body.radius = entity.hitSize * 0.6f;
                PhysicRef ref2 = new PhysicRef(entity, body);
                this.refs.add((Object)ref2);
                entity.physref = ref2;
                this.physics.add(body);
            }
            PhysicRef ref3 = entity.physref;
            ref3.body.layer = entity.collisionLayer();
            ref3.x = entity.x;
            ref3.y = entity.y;
            ref3.body.local = local || entity.isLocal();
        }
    }

    public void process() {
        if (this.physics == null) {
            return;
        }
        for (PhysicRef ref : this.refs) {
            ref.body.x = ref.x;
            ref.body.y = ref.y;
        }
        this.physics.update();
    }

    public void end() {
        if (this.physics == null) {
            return;
        }
        for (PhysicRef ref : this.refs) {
            Unitc unit;
            Physicsc entity = ref.entity;
            if (entity instanceof Unitc && (unit = (Unitc)entity).isLocal() && ((Boolean)VarsX.noPlayerHitBox.get()).booleanValue()) continue;
            entity.move(ref.body.x - ref.x, ref.body.y - ref.y);
        }
    }

    public void reset() {
        if (this.physics != null) {
            this.refs.clear();
            this.physics = null;
        }
    }

    public void init() {
        this.reset();
        this.physics = new PhysicsWorld(Vars.world.getQuadBounds(new Rect()));
    }

    public static class PhysicsWorld {
        private static final float scl = 1.25f;
        private final QuadTree<PhysicsBody>[] trees = new QuadTree[4];
        private final Seq<PhysicsBody> bodies = new Seq(false, 16, PhysicsBody.class);
        private final Seq<PhysicsBody> seq = new Seq(PhysicsBody.class);
        private final Rect rect = new Rect();
        private final Vec2 vec = new Vec2();
        private final Rand rand = new Rand();

        public PhysicsWorld(Rect bounds) {
            for (int i = 0; i < 4; ++i) {
                this.trees[i] = new QuadTree(new Rect(bounds));
            }
        }

        public void add(PhysicsBody body) {
            this.bodies.add((Object)body);
        }

        public void remove(PhysicsBody body) {
            this.bodies.remove((Object)body);
        }

        public void update() {
            PhysicsBody body;
            int i;
            for (int i2 = 0; i2 < 4; ++i2) {
                this.trees[i2].clear();
            }
            PhysicsBody[] bodyItems = (PhysicsBody[])this.bodies.items;
            int bodySize = this.bodies.size;
            for (i = 0; i < bodySize; ++i) {
                body = bodyItems[i];
                if (body.layer < 0) continue;
                body.collided = false;
                this.trees[body.layer].insert((QuadTree.QuadTreeObject)body);
            }
            for (i = 0; i < bodySize; ++i) {
                body = bodyItems[i];
                if (!body.local || body.layer < 0) continue;
                body.hitbox(this.rect);
                this.seq.size = 0;
                this.trees[body.layer].intersect(this.rect, this.seq);
                int size = this.seq.size;
                PhysicsBody[] items = (PhysicsBody[])this.seq.items;
                for (int j = 0; j < size; ++j) {
                    PhysicsBody other = items[j];
                    if (other == body || other.collided) continue;
                    float rs = body.radius + other.radius;
                    float dst = Mathf.dst((float)body.x, (float)body.y, (float)other.x, (float)other.y);
                    if (!(dst < rs)) continue;
                    this.vec.set(body.x - other.x, body.y - other.y);
                    if (this.vec.isZero()) {
                        this.vec.trns(this.rand.random(360.0f), rs - dst);
                    } else {
                        this.vec.setLength(rs - dst);
                    }
                    float ms = body.mass + other.mass;
                    float m1 = other.mass / ms;
                    float m2 = body.mass / ms;
                    body.x += this.vec.x * m1 / 1.25f;
                    body.y += this.vec.y * m1 / 1.25f;
                    if (!other.local) continue;
                    other.x -= this.vec.x * m2 / 1.25f;
                    other.y -= this.vec.y * m2 / 1.25f;
                }
                body.collided = true;
            }
        }

        public static class PhysicsBody
        implements QuadTree.QuadTreeObject {
            public float x;
            public float y;
            public float radius;
            public float mass;
            public int layer = 0;
            public boolean collided = false;
            public boolean local = true;

            public void hitbox(Rect out) {
                out.setCentered(this.x, this.y, this.radius * 2.0f, this.radius * 2.0f);
            }
        }
    }

    public static class PhysicRef {
        public Physicsc entity;
        public PhysicsWorld.PhysicsBody body;
        public float x;
        public float y;

        public PhysicRef(Physicsc entity, PhysicsWorld.PhysicsBody body) {
            this.entity = entity;
            this.body = body;
        }
    }
}

