/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Dialog;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Slider;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.core.GameState;
import mindustry.core.Platform;
import mindustry.editor.EditorTool;
import mindustry.editor.MapEditor;
import mindustry.editor.MapGenerateDialog;
import mindustry.editor.MapInfoDialog;
import mindustry.editor.MapLoadDialog;
import mindustry.editor.MapResizeDialog;
import mindustry.editor.MapView;
import mindustry.editor.SectorGenerateDialog;
import mindustry.game.GameStats;
import mindustry.game.Gamemode;
import mindustry.game.MapObjectives;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.io.MapIO;
import mindustry.maps.Map;
import mindustry.type.Publishable;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.MapPlayDialog;
import mindustry.world.Block;
import mindustry.world.Tiles;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BuildVisibility;
import mindustryX.VarsX;
import mindustryX.features.UIExt;

public class MapEditorDialog
extends Dialog
implements Disposable {
    private MapView view;
    private MapInfoDialog infoDialog;
    private MapLoadDialog loadDialog;
    private MapResizeDialog resizeDialog;
    private MapGenerateDialog generateDialog;
    private SectorGenerateDialog sectorGenDialog;
    private MapPlayDialog playtestDialog;
    private ScrollPane pane;
    private BaseDialog menu;
    private Table blockSelection;
    private Rules lastSavedRules;
    private boolean saved = false;
    private boolean shownWithMap = false;
    private Seq<Block> blocksOut = new Seq();

    public MapEditorDialog() {
        super("");
        this.background(Styles.black);
        this.view = new MapView();
        this.infoDialog = new MapInfoDialog();
        this.generateDialog = new MapGenerateDialog(true);
        this.sectorGenDialog = new SectorGenerateDialog();
        this.playtestDialog = new MapPlayDialog();
        this.menu = new BaseDialog("@menu");
        this.menu.addCloseButton();
        float swidth = 180.0f;
        this.menu.cont.table(t -> {
            t.defaults().size(swidth, 60.0f).padBottom(5.0f).padRight(5.0f).padLeft(5.0f);
            t.button("@editor.savemap", (Drawable)Icon.save, this::save);
            t.button("@editor.mapinfo", (Drawable)Icon.pencil, () -> {
                this.infoDialog.show();
                this.menu.hide();
            });
            t.row();
            t.button("@editor.generate", (Drawable)Icon.terrain, () -> {
                this.generateDialog.show(arg_0 -> ((MapGenerateDialog)this.generateDialog).applyToEditor(arg_0));
                this.menu.hide();
            });
            t.button("@editor.resize", (Drawable)Icon.resize, () -> {
                this.resizeDialog.show();
                this.menu.hide();
            });
            t.row();
            t.button("@editor.import", (Drawable)Icon.download, () -> {
                Object[] objectArray = new Object[12];
                objectArray[0] = "@editor.importmap";
                objectArray[1] = "@editor.importmap.description";
                objectArray[2] = Icon.download;
                objectArray[3] = () -> ((MapLoadDialog)this.loadDialog).show();
                objectArray[4] = "@editor.importfile";
                objectArray[5] = "@editor.importfile.description";
                objectArray[6] = Icon.file;
                objectArray[7] = () -> Vars.platform.showFileChooser(true, "msav", file -> Vars.ui.loadAnd(() -> Vars.maps.tryCatchMapError(() -> {
                    if (MapIO.isImage((Fi)file)) {
                        Vars.ui.showInfo("@editor.errorimage");
                    } else {
                        Vars.editor.beginEdit(MapIO.createMap((Fi)file, (boolean)true));
                    }
                })));
                objectArray[8] = "@editor.importimage";
                objectArray[9] = "@editor.importimage.description";
                objectArray[10] = Icon.fileImage;
                objectArray[11] = () -> Vars.platform.showFileChooser(true, "png", file -> Vars.ui.loadAnd(() -> {
                    try {
                        Pixmap pixmap = new Pixmap(file);
                        if (pixmap.width > MapResizeDialog.maxSize || pixmap.height > MapResizeDialog.maxSize) {
                            throw new Exception("Image is too large (maximum size is " + MapResizeDialog.maxSize + "x" + MapResizeDialog.maxSize + ")");
                        }
                        Vars.editor.beginEdit(pixmap);
                        pixmap.dispose();
                    }
                    catch (Exception e) {
                        Vars.ui.showException("@editor.errorload", e);
                        Log.err((Throwable)e);
                    }
                }));
                this.createDialog("@editor.import", objectArray);
            });
            t.button("@editor.export", (Drawable)Icon.upload, () -> this.createDialog("@editor.export", "@editor.exportfile", "@editor.exportfile.description", Icon.file, () -> Vars.platform.export((String)Vars.editor.tags.get((Object)"name", (Object)"unknown"), "msav", file -> MapIO.writeMap((Fi)file, (Map)Vars.editor.createMap(file))), "@editor.exportimage", "@editor.exportimage.description", Icon.fileImage, () -> Vars.platform.export((String)Vars.editor.tags.get((Object)"name", (Object)"unknown"), "png", file -> {
                Pixmap out = MapIO.writeImage((Tiles)Vars.editor.tiles());
                file.writePng(out);
                out.dispose();
            })));
            t.row();
            t.button("@editor.ingame", (Drawable)Icon.right, this::editInGame);
            t.button("@editor.playtest", (Drawable)Icon.play, this::playtest);
        });
        this.menu.cont.row();
        if (Vars.steam) {
            this.menu.cont.button("@editor.publish.workshop", (Drawable)Icon.link, () -> {
                Map builtin = (Map)Vars.maps.all().find(m -> m.name().equals(((String)Vars.editor.tags.get((Object)"name", (Object)"")).trim()));
                if (Vars.editor.tags.containsKey((Object)"steamid") && builtin != null && !builtin.custom) {
                    Vars.platform.viewListingID((String)Vars.editor.tags.get((Object)"steamid"));
                    return;
                }
                Map map = this.save();
                if (Vars.editor.tags.containsKey((Object)"steamid") && map != null) {
                    Vars.platform.viewListing((Publishable)map);
                    return;
                }
                if (map == null) {
                    return;
                }
                if (((String)map.tags.get((Object)"description", (Object)"")).length() < 4) {
                    Vars.ui.showErrorMessage("@editor.nodescription");
                    return;
                }
                if (!Structs.contains((Object[])Gamemode.all, g -> g.valid(map))) {
                    Vars.ui.showErrorMessage("@map.nospawn");
                    return;
                }
                Vars.platform.publish((Publishable)map);
            }).padTop(-3.0f).size(swidth * 2.0f + 10.0f, 60.0f).update(b -> b.setText(Vars.editor.tags.containsKey((Object)"steamid") ? (((String)Vars.editor.tags.get((Object)"author", (Object)"")).equals(Vars.steamPlayerName) ? "@workshop.listing" : "@view.workshop") : "@editor.publish.workshop"));
            this.menu.cont.row();
        }
        this.menu.cont.button("@editor.sectorgenerate", (Drawable)Icon.terrain, () -> {
            this.menu.hide();
            this.sectorGenDialog.show();
        }).padTop(!Vars.steam ? -3.0f : 1.0f).size(swidth * 2.0f + 10.0f, 60.0f);
        this.menu.cont.row();
        if (OS.hasProp((String)"mindustry.editor.simulate.button")) {
            this.menu.cont.button("Simulate", (Drawable)Icon.logic, () -> {
                this.menu.hide();
                BaseDialog dialog = new BaseDialog("Simulate");
                int[] seconds = new int[]{60};
                dialog.cont.add((CharSequence)"Seconds: ");
                dialog.cont.field(seconds[0] + "", text -> {
                    seconds[0] = Strings.parseInt((String)text, (int)1);
                }).valid(s -> (float)Strings.parseInt((String)s, (int)9999999) < 600.0f);
                dialog.addCloseButton();
                dialog.buttons.button("@ok", (Drawable)Icon.ok, () -> {
                    Vars.ui.loadAnd(() -> {
                        float deltaScl = 2.0f;
                        int steps = Mathf.ceil((float)((float)seconds[0] * 60.0f / deltaScl));
                        float oldDelta = Time.delta;
                        Time.delta = deltaScl;
                        Seq builds = new Seq();
                        Time.clear();
                        Vars.world.tiles.eachTile(t -> {
                            if (t.build != null && t.isCenter() && t.block().update && t.build.allowUpdate()) {
                                builds.add((Object)t.build);
                                t.build.updateProximity();
                            }
                        });
                        for (int i = 0; i < steps; ++i) {
                            Time.update();
                            for (Building build : builds) {
                                build.update();
                            }
                            Groups.powerGraph.update();
                        }
                        Groups.unit.clear();
                        Time.clear();
                        Time.delta = oldDelta;
                    });
                    dialog.hide();
                }).size(210.0f, 64.0f);
                dialog.show();
            }).size(swidth * 2.0f + 10.0f, 60.0f);
            this.menu.cont.row();
        }
        this.menu.cont.button("@quit", (Drawable)Icon.exit, () -> {
            this.tryExit();
            this.menu.hide();
        }).padTop(1.0f).size(swidth * 2.0f + 10.0f, 60.0f);
        this.resizeDialog = new MapResizeDialog((width, height, shiftX, shiftY) -> {
            if (Vars.editor.width() != width || Vars.editor.height() != height || shiftX != 0 || shiftY != 0) {
                Vars.ui.loadAnd(() -> Vars.editor.resize(width, height, shiftX, shiftY));
            }
        });
        this.loadDialog = new MapLoadDialog(map -> Vars.ui.loadAnd(() -> {
            try {
                Vars.editor.beginEdit((Map)map);
            }
            catch (Exception e) {
                Vars.ui.showException("@editor.errorload", e);
                Log.err((Throwable)e);
            }
        }));
        this.setFillParent(true);
        this.clearChildren();
        this.margin(0.0f);
        this.update(() -> {
            if (this.hasKeyboard()) {
                this.doInput();
            }
        });
        this.shown(() -> {
            this.saved = true;
            if (!Core.settings.getBool("landscape")) {
                Vars.platform.beginForceLandscape();
            }
            Vars.editor.clearOp();
            Core.scene.setScrollFocus((Element)this.view);
            if (!this.shownWithMap) {
                Vars.logic.reset();
                Vars.state.rules = new Rules();
                Vars.editor.beginEdit(200, 200);
            }
            this.shownWithMap = false;
            Time.runTask((float)10.0f, () -> ((Platform)Vars.platform).updateRPC());
        });
        this.hidden(() -> {
            Vars.editor.clearOp();
            Vars.platform.updateRPC();
            if (!Core.settings.getBool("landscape")) {
                Vars.platform.endForceLandscape();
            }
        });
        this.shown(this::build);
    }

    public void resumeEditing() {
        Vars.state.set(GameState.State.menu);
        this.shownWithMap = true;
        this.show();
        Vars.state.rules = this.lastSavedRules == null ? new Rules() : this.lastSavedRules;
        this.lastSavedRules = null;
        this.saved = false;
        Vars.editor.renderer.recache();
    }

    private void editInGame() {
        this.menu.hide();
        Vars.ui.loadAnd(() -> {
            this.lastSavedRules = Vars.state.rules;
            this.hide();
            Vars.state.teams = new Teams();
            Vars.player.reset();
            Vars.state.rules = Gamemode.editor.apply(this.lastSavedRules.copy());
            Vars.state.rules.limitMapArea = false;
            Vars.state.rules.sector = null;
            Vars.state.rules.fog = false;
            Vars.state.map = new Map(StringMap.of((Object[])new Object[]{"name", "Editor Playtesting", "width", Vars.editor.width(), "height", Vars.editor.height()}));
            Vars.state.set(GameState.State.playing);
            Vars.world.endMapLoad();
            Vars.player.clearUnit();
            for (Unit unit : Groups.unit) {
                if (!unit.spawnedByCore) continue;
                unit.remove();
            }
            Groups.build.clear();
            Groups.weather.clear();
            Vars.logic.play();
            Point2 center = this.view.project((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f);
            CoreBlock.CoreBuild best = Vars.player.bestCore();
            Vars.player.set(center.x * 8, center.y * 8);
            Unit unit = (best != null ? ((CoreBlock)((Object)((Object)((Object)best.block)))).unitType : (Vars.state.rules.hasEnv(16) ? UnitTypes.evoke : UnitTypes.alpha)).spawn(Vars.editor.drawTeam, Vars.player.x, Vars.player.y);
            unit.spawnedByCore = true;
            Vars.player.unit(unit);
            Vars.player.set((Position)unit);
            Core.camera.position.set(unit.x, unit.y);
        });
    }

    public void resumeAfterPlaytest(Map map) {
        this.beginEditMap(map.file);
    }

    private void playtest() {
        this.menu.hide();
        Map map = this.save();
        if (map != null) {
            if (Core.input.shift()) {
                this.hide();
                Vars.control.playMap(map, map.applyRules(Gamemode.survival.valid(map) ? Gamemode.survival : (Gamemode.attack.valid(map) ? Gamemode.attack : Gamemode.sandbox)), true);
            } else {
                this.playtestDialog.playListener = this::hide;
                this.playtestDialog.show(map, true);
            }
        }
    }

    @Nullable
    public Map save() {
        boolean isEditor = Vars.state.rules.editor;
        Vars.state.rules.editor = false;
        Vars.state.rules.allowEditRules = false;
        Vars.state.rules.objectiveFlags.clear();
        Vars.state.rules.objectives.each(MapObjectives.MapObjective::reset);
        Vars.state.stats = new GameStats();
        String name = ((String)Vars.editor.tags.get((Object)"name", (Object)"")).trim();
        Vars.editor.tags.put((Object)"rules", (Object)JsonIO.write((Object)Vars.state.rules));
        Vars.editor.tags.remove((Object)"width");
        Vars.editor.tags.remove((Object)"height");
        Vars.player.clearUnit();
        Unit unit = (Unit)Groups.unit.find(u -> u.spawnedByCore);
        if (unit != null) {
            unit.remove();
        }
        Map returned = null;
        if (name.isEmpty()) {
            this.infoDialog.show();
            Core.app.post(() -> Vars.ui.showErrorMessage("@editor.save.noname"));
        } else {
            Map map = (Map)Vars.maps.all().find(m -> m.name().equalsIgnoreCase(name));
            if (map != null && !map.custom && !map.workshop) {
                this.handleSaveBuiltin(map);
            } else {
                boolean workshop = false;
                if (map != null && map.tags.containsKey((Object)"steamid")) {
                    Vars.editor.tags.put((Object)"steamid", (Object)((String)map.tags.get((Object)"steamid")));
                    workshop = true;
                }
                returned = Vars.maps.saveMap((ObjectMap)Vars.editor.tags);
                if (workshop) {
                    returned.workshop = workshop;
                }
                Vars.ui.showInfoFade("@editor.saved");
            }
        }
        this.menu.hide();
        this.saved = true;
        Vars.state.rules.editor = isEditor;
        return returned;
    }

    protected void handleSaveBuiltin(Map map) {
        Vars.ui.showErrorMessage("@editor.save.overwrite");
    }

    private void createDialog(String title, Object ... arguments) {
        BaseDialog dialog = new BaseDialog(title);
        float h = 90.0f;
        dialog.cont.defaults().size(360.0f, h).padBottom(5.0f).padRight(5.0f).padLeft(5.0f);
        for (int i = 0; i < arguments.length; i += 4) {
            String name = (String)arguments[i];
            String description = (String)arguments[i + 1];
            Drawable iconname = (Drawable)arguments[i + 2];
            Runnable listenable = (Runnable)arguments[i + 3];
            TextButton button2 = (TextButton)dialog.cont.button(name, () -> {
                listenable.run();
                dialog.hide();
                this.menu.hide();
            }).left().margin(0.0f).get();
            button2.clearChildren();
            button2.image(iconname).padLeft(10.0f);
            button2.table(t -> {
                t.add((CharSequence)name).growX().wrap();
                t.row();
                t.add((CharSequence)description).color(Color.gray).growX().wrap();
            }).growX().pad(10.0f).padLeft(5.0f);
            button2.row();
            dialog.cont.row();
        }
        dialog.addCloseButton();
        dialog.show();
    }

    public Dialog show() {
        return super.show(Core.scene, (Action)Actions.sequence((Action)Actions.alpha((float)1.0f)));
    }

    public void hide() {
        super.hide((Action)Actions.sequence((Action)Actions.alpha((float)0.0f)));
    }

    public void dispose() {
        Vars.editor.renderer.dispose();
    }

    public void beginEditMap(Fi file) {
        Vars.ui.loadAnd(() -> {
            try {
                this.shownWithMap = true;
                Vars.editor.beginEdit(MapIO.createMap((Fi)file, (boolean)true));
                this.show();
            }
            catch (Exception e) {
                Log.err((Throwable)e);
                Vars.ui.showException("@editor.errorload", e);
            }
        });
    }

    public MapView getView() {
        return this.view;
    }

    public MapGenerateDialog getGenerateDialog() {
        return this.generateDialog;
    }

    public void resetSaved() {
        this.saved = false;
    }

    public boolean hasPane() {
        return Core.scene.getScrollFocus() == this.pane || Core.scene.getKeyboardFocus() != this;
    }

    public void build() {
        float size = Vars.mobile ? 50.0f : 58.0f;
        this.clearChildren();
        this.table(cont -> {
            cont.left();
            cont.table(mid -> {
                mid.top();
                Table tools = new Table().top();
                ButtonGroup group = new ButtonGroup();
                Table[] lastTable = new Table[]{null};
                Cons addTool = tool -> {
                    ImageButton button2 = new ImageButton((Drawable)Vars.ui.getIcon(tool.name()), Styles.squareTogglei);
                    button2.clicked(() -> {
                        this.view.setTool((EditorTool)((Object)((Object)((Object)tool))));
                        if (lastTable[0] != null) {
                            lastTable[0].remove();
                        }
                    });
                    button2.update(() -> button2.setChecked(this.view.getTool() == tool));
                    group.add((Button)button2);
                    if (tool.altModes.length > 0) {
                        button2.clicked(l -> {
                            if (!Vars.mobile) {
                                l.setButton(KeyCode.mouseRight);
                            }
                        }, e -> {
                            if (Vars.mobile && e.getTapCount() < 2) {
                                return;
                            }
                            if (lastTable[0] != null) {
                                lastTable[0].remove();
                            }
                            Table table2 = new Table(Styles.black9);
                            table2.defaults().size(300.0f, 70.0f);
                            for (int i = 0; i < tool.altModes.length; ++i) {
                                int mode = i;
                                String name = tool.altModes[i];
                                table2.button(b -> {
                                    b.left();
                                    b.marginLeft(6.0f);
                                    b.setStyle((Button.ButtonStyle)Styles.flatTogglet);
                                    b.add((CharSequence)Core.bundle.get("toolmode." + name)).left();
                                    b.row();
                                    b.add((CharSequence)Core.bundle.get("toolmode." + name + ".description")).color(Color.lightGray).left();
                                }, () -> {
                                    tool.mode = tool.mode == mode ? -1 : mode;
                                    table2.remove();
                                }).update(b -> b.setChecked(tool.mode == mode));
                                table2.row();
                            }
                            table2.update(() -> {
                                Vec2 v = button2.localToStageCoordinates(Tmp.v1.setZero());
                                table2.setPosition(v.x, v.y, 10);
                                if (!this.isShown()) {
                                    table2.remove();
                                    lastTable[0] = null;
                                }
                            });
                            table2.pack();
                            table2.act(Core.graphics.getDeltaTime());
                            this.addChild((Element)table2);
                            lastTable[0] = table2;
                        });
                    }
                    Label mode = new Label((CharSequence)"");
                    mode.setColor(Pal.remove);
                    mode.update(() -> mode.setText((CharSequence)(tool.mode == -1 ? "" : "M" + (tool.mode + 1) + " ")));
                    mode.setAlignment(20, 20);
                    mode.touchable = Touchable.disabled;
                    tools.stack(new Element[]{button2, mode});
                };
                tools.defaults().size(size, size);
                tools.button((Drawable)Icon.menu, Styles.flati, () -> ((BaseDialog)this.menu).show());
                ImageButton grid = (ImageButton)tools.button((Drawable)Icon.grid, Styles.squareTogglei, () -> this.view.setGrid(!this.view.isGrid())).get();
                addTool.get((Object)EditorTool.zoom);
                tools.row();
                ImageButton undo = (ImageButton)tools.button((Drawable)Icon.undo, Styles.flati, Vars.editor::undo).get();
                ImageButton redo = (ImageButton)tools.button((Drawable)Icon.redo, Styles.flati, Vars.editor::redo).get();
                addTool.get((Object)EditorTool.pick);
                tools.row();
                undo.setDisabled(() -> !Vars.editor.canUndo());
                redo.setDisabled(() -> !Vars.editor.canRedo());
                undo.update(() -> undo.getImage().setColor(undo.isDisabled() ? Color.gray : Color.white));
                redo.update(() -> redo.getImage().setColor(redo.isDisabled() ? Color.gray : Color.white));
                grid.update(() -> grid.setChecked(this.view.isGrid()));
                addTool.get((Object)EditorTool.line);
                addTool.get((Object)EditorTool.pencil);
                addTool.get((Object)EditorTool.eraser);
                tools.row();
                addTool.get((Object)EditorTool.fill);
                addTool.get((Object)EditorTool.spray);
                ImageButton rotate = (ImageButton)tools.button((Drawable)Icon.right, Styles.flati, () -> {
                    Vars.editor.rotation = (Vars.editor.rotation + 1) % 4;
                }).get();
                rotate.getImage().update(() -> {
                    rotate.getImage().setRotation((float)(Vars.editor.rotation * 90));
                    rotate.getImage().setOrigin(1);
                });
                tools.row();
                tools.image(Tex.whiteui, Pal.gray).colspan(3).height(4.0f).width(size * 3.0f + 3.0f).row();
                int i = 0;
                for (Team team : Team.baseTeams) {
                    ImageButton button2 = new ImageButton(Tex.whiteui, Styles.clearNoneTogglei);
                    button2.margin(4.0f);
                    button2.getImageCell().grow();
                    button2.getStyle().imageUpColor = team.color;
                    button2.clicked(() -> {
                        Vars.editor.drawTeam = team;
                    });
                    button2.update(() -> button2.setChecked(Vars.editor.drawTeam == team));
                    tools.add((Element)button2);
                    if (i++ % 3 != 2) continue;
                    tools.row();
                }
                tools.button("[violet]\u5176\u4ed6\u961f\u4f0d", Styles.flatToggleMenut, () -> UIExt.teamSelect.pickOne((Cons<Team>)((Cons)team -> {
                    Vars.editor.drawTeam = team;
                }))).update(b -> {
                    boolean checked = !Seq.with((Object[])Team.baseTeams).contains((Object)Vars.editor.drawTeam);
                    b.setColor(checked ? Vars.editor.drawTeam.color : Color.violet);
                    b.setChecked(checked);
                }).colspan(3).size(size * 3.0f, size / 2.0f);
                mid.add((Element)tools).top().padBottom(-6.0f);
                mid.row();
                mid.table(t -> {
                    t.add((CharSequence)"\u8f85\u52a9\u7ebf\uff1a");
                    t.field(Integer.toString(Vars.editor.interval), TextField.TextFieldFilter.digitsOnly, value -> {
                        Vars.editor.interval = Integer.parseInt(value);
                    }).valid(Strings::canParsePositiveInt).maxTextLength(4).width(100.0f);
                }).row();
                TextField brushField = (TextField)((Table)mid.table().get()).add((CharSequence)"\u7b14\u5237\uff1a").getTable().field(Float.toString(Vars.editor.brushSize), value -> {
                    Vars.editor.brushSize = Float.parseFloat(value);
                }).valid(Strings::canParsePositiveFloat).maxTextLength(4).width(100.0f).get();
                mid.row();
                mid.table(Tex.underline, t -> {
                    Slider slider = new Slider(0.0f, (float)(MapEditor.brushSizes.length - 1), 1.0f, false);
                    slider.moved(f -> {
                        Vars.editor.brushSize = MapEditor.brushSizes[(int)f];
                        brushField.setText(Float.toString(Vars.editor.brushSize));
                    });
                    for (int j = 0; j < MapEditor.brushSizes.length; ++j) {
                        if (MapEditor.brushSizes[j] != Vars.editor.brushSize) continue;
                        slider.setValue((float)j);
                    }
                    Label label = new Label((CharSequence)"@editor.brush");
                    label.setAlignment(1);
                    label.touchable = Touchable.disabled;
                    t.top().stack(new Element[]{slider, label}).width(size * 3.0f - 20.0f).padTop(4.0f);
                    t.row();
                }).padTop(5.0f).growX().top();
                mid.row();
                mid.check("@editor.showblocks", Vars.editor.showBuildings, b -> {
                    Vars.editor.showBuildings = b;
                    Vars.editor.renderer.recacheShadows();
                }).pad(2.0f).growX().with(Table::left).row();
                mid.check("@editor.showterrain", Vars.editor.showTerrain, b -> {
                    Vars.editor.showTerrain = b;
                    Vars.editor.renderer.recacheTerrain();
                }).pad(2.0f).growX().with(Table::left).row();
                mid.check("@editor.showfloor", Vars.editor.showFloor, b -> {
                    Vars.editor.showFloor = b;
                }).pad(2.0f).growX().with(Table::left).row();
                if (!Vars.mobile) {
                    mid.button("@editor.center", (Drawable)Icon.move, Styles.flatt, this.view::center).growX().margin(9.0f);
                }
            }).margin(0.0f).left().growY();
            cont.table(t -> t.add((Element)this.view).grow()).grow();
            cont.table(this::addBlockSelection).right().growY();
        }).grow();
    }

    private void doInput() {
        if (Core.input.ctrl()) {
            for (int i = 0; i < this.view.getTool().altModes.length; ++i) {
                if (i + 1 >= KeyCode.numbers.length || !Core.input.keyTap(KeyCode.numbers[i + 1])) continue;
                this.view.getTool().mode = i;
            }
        } else {
            for (EditorTool tool : EditorTool.all) {
                if (!Core.input.keyTap(tool.key)) continue;
                this.view.setTool(tool);
                break;
            }
        }
        if (Core.input.keyTap(KeyCode.escape) && !this.menu.isShown()) {
            this.menu.show();
        }
        if (Core.input.keyTap(KeyCode.r)) {
            Vars.editor.rotation = Mathf.mod((int)(Vars.editor.rotation + 1), (int)4);
        }
        if (Core.input.keyTap(KeyCode.e)) {
            Vars.editor.rotation = Mathf.mod((int)(Vars.editor.rotation - 1), (int)4);
        }
        if (Core.input.ctrl()) {
            if (Core.input.keyTap(KeyCode.z)) {
                if (Core.input.shift()) {
                    Vars.editor.redo();
                } else {
                    Vars.editor.undo();
                }
            }
            if (Core.input.keyTap(KeyCode.y)) {
                Vars.editor.redo();
            }
            if (Core.input.keyTap(KeyCode.s)) {
                this.save();
            }
            if (Core.input.keyTap(KeyCode.g)) {
                this.view.setGrid(!this.view.isGrid());
            }
        }
    }

    private void tryExit() {
        Vars.ui.showConfirm("@confirm", "@editor.unsaved", this::hide);
    }

    private void addBlockSelection(Table cont) {
        this.blockSelection = new Table();
        this.pane = new ScrollPane((Element)this.blockSelection, Styles.smallPane);
        this.pane.setFadeScrollBars(false);
        this.pane.setOverscroll(true, false);
        this.pane.exited(() -> {
            if (this.pane.hasScroll()) {
                Core.scene.setScrollFocus((Element)this.view);
            }
        });
        Table[] configTable = new Table[]{null};
        Block[] lastBlock = new Block[]{null};
        cont.table(search -> {
            search.image((Drawable)Icon.zoom).padRight(8.0f);
            ((TextField)search.field("", this::rebuildBlockSelection).growX().name("editor/search").maxTextLength(40).get()).setMessageText("@players.search");
        }).growX().pad(-2.0f).padLeft(6.0f);
        cont.row();
        cont.table(Tex.underline, extra -> extra.labelWrap(() -> Vars.editor.drawBlock.localizedName).width(200.0f).center()).growX();
        cont.row();
        cont.collapser(t -> {
            configTable[0] = t;
        }, () -> Vars.editor.drawBlock != null && Vars.editor.drawBlock.editorConfigurable).with(c -> c.setEnforceMinSize(true)).update(col -> {
            if (lastBlock[0] != Vars.editor.drawBlock) {
                configTable[0].clear();
                if (Vars.editor.drawBlock != null) {
                    Vars.editor.drawBlock.buildEditorConfig(configTable[0]);
                    col.invalidateHierarchy();
                }
                lastBlock[0] = Vars.editor.drawBlock;
            }
        }).growX().row();
        cont.add((Element)this.pane).expandY().growX().top().left();
        this.rebuildBlockSelection("");
    }

    private void rebuildBlockSelection(String searchText) {
        this.blockSelection.clear();
        this.blocksOut.clear();
        this.blocksOut.addAll(Vars.content.blocks());
        this.blocksOut.sort((b1, b2) -> {
            int core = -Boolean.compare(b1 instanceof CoreBlock, b2 instanceof CoreBlock);
            if (core != 0) {
                return core;
            }
            int synth = Boolean.compare(b1.synthetic(), b2.synthetic());
            if (synth != 0) {
                return synth;
            }
            int ore = Boolean.compare(b1 instanceof OverlayFloor, b2 instanceof OverlayFloor);
            if (ore != 0) {
                return ore;
            }
            return Integer.compare(b1.id, b2.id);
        });
        int i = 0;
        int perRow = (Integer)VarsX.editorBrush.get();
        for (Block block : this.blocksOut) {
            TextureRegion region = block.uiIcon;
            if (!Core.atlas.isFound(region) || !block.inEditor || block.buildVisibility == BuildVisibility.debugOnly || !searchText.isEmpty() && !block.localizedName.toLowerCase().contains(searchText.trim().replaceAll(" +", " ").toLowerCase())) continue;
            ImageButton button2 = new ImageButton(Tex.whiteui, Styles.clearNoneTogglei);
            button2.getStyle().imageUp = new TextureRegionDrawable(region);
            button2.clicked(() -> {
                Vars.editor.drawBlock = block;
            });
            button2.resizeImage(32.0f);
            button2.update(() -> button2.setChecked(Vars.editor.drawBlock == block));
            this.blockSelection.add((Element)button2).size(50.0f).tooltip(block.localizedName);
            if (i == 0) {
                Vars.editor.drawBlock = block;
            }
            if (++i % perRow != 0) continue;
            this.blockSelection.row();
        }
        if (i == 0) {
            this.blockSelection.add((CharSequence)"@none.found").padLeft(54.0f).padTop(10.0f);
        }
    }
}

