/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Floatf;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import java.util.Comparator;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.editor.MapObjectivesDialog;
import mindustry.editor.WaveGraph;
import mindustry.game.SpawnGroup;
import mindustry.game.Waves;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Tile;
import mindustryX.VarsX;
import mindustryX.features.ArcWaveSpawner;
import mindustryX.features.UIExt;
import mindustryX.features.ui.ContentSelectDialog;
import mindustryX.features.ui.FormatDefault;

public class WaveInfoDialog
extends BaseDialog {
    Seq<SpawnGroup> groups = new Seq();
    @Nullable
    private SpawnGroup expandedGroup;
    private Table table;
    private int search = -1;
    @Nullable
    private UnitType filterType;
    private Sort sort = Sort.begin;
    private boolean reverseSort = false;
    private boolean checkedSpawns;
    private WaveGraph graph = new WaveGraph();
    private int winWave;
    private boolean wavesListMode;
    private Cell<?> wavesListCell;
    private Table wavesList;
    private Element wavesListPane;

    public WaveInfoDialog() {
        super("@waves.title");
        this.shown(() -> {
            this.checkedSpawns = false;
            this.setup();
        });
        this.hidden(() -> {
            Vars.state.rules.spawns = this.groups;
        });
        this.addCloseButton();
        this.buttons.button("@waves.edit", (Drawable)Icon.edit, () -> {
            BaseDialog dialog = new BaseDialog("@waves.edit");
            dialog.addCloseButton();
            dialog.setFillParent(false);
            dialog.cont.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.cleart;
                t.defaults().size(280.0f, 64.0f).pad(2.0f);
                t.button("@waves.copy", (Drawable)Icon.copy, style, () -> {
                    Vars.ui.showInfoFade("@waves.copied");
                    Core.app.setClipboardText(Vars.maps.writeWaves(this.groups));
                    dialog.hide();
                }).disabled(b -> this.groups == null || this.groups.isEmpty()).marginLeft(12.0f).row();
                t.button("@waves.load", (Drawable)Icon.download, style, () -> {
                    try {
                        this.groups = Vars.maps.readWaves(Core.app.getClipboardText());
                        this.buildGroups();
                    }
                    catch (Exception e) {
                        Log.err((Throwable)e);
                        Vars.ui.showErrorMessage("@waves.invalid");
                    }
                    dialog.hide();
                }).disabled(Core.app.getClipboardText() == null || !Core.app.getClipboardText().startsWith("[")).marginLeft(12.0f).row();
                t.button("@clear", (Drawable)Icon.none, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                    this.groups.clear();
                    this.buildGroups();
                    dialog.hide();
                })).marginLeft(12.0f).row();
                t.button("@settings.reset", (Drawable)Icon.refresh, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                    this.groups = (Seq)JsonIO.copy((Object)Vars.waves.get());
                    this.buildGroups();
                    dialog.hide();
                })).marginLeft(12.0f);
            });
            dialog.show();
        }).size(250.0f, 64.0f);
        this.buttons.button("\u5207\u6362\u663e\u793a\u6a21\u5f0f", () -> {
            this.wavesListMode = !this.wavesListMode;
            this.wavesListCell.setElement((Element)(this.wavesListMode ? this.wavesListPane : this.graph));
        }).width(200.0f);
        this.buttons.button(Core.bundle.get("waves.random"), (Drawable)Icon.refresh, () -> {
            this.groups.clear();
            this.groups = Waves.generate((float)0.1f);
            this.buildGroups();
        }).width(200.0f);
    }

    void setup() {
        this.groups = (Seq)JsonIO.copy(Vars.state.rules.spawns.isEmpty() ? Vars.waves.get() : Vars.state.rules.spawns);
        if (this.groups == null) {
            this.groups = new Seq();
        }
        this.cont.clear();
        this.cont.stack(new Element[]{new Table(Tex.clear, main -> {
            main.table(s -> {
                s.image((Drawable)Icon.zoom).padRight(8.0f);
                ((TextField)s.field(this.search < 0 ? "" : this.search + 1 + "", TextField.TextFieldFilter.digitsOnly, text -> {
                    this.search = this.groups.any() ? Strings.parseInt((String)text, (int)0) - 1 : -1;
                    this.buildGroups();
                }).growX().maxTextLength(8).get()).setMessageText("@waves.search");
                s.button((Drawable)Icon.units, Styles.emptyi, () -> this.showUnits((Cons<UnitType>)((Cons)type -> {
                    this.filterType = type;
                }), true)).size(46.0f).tooltip("@waves.filter").update(b -> {
                    b.getStyle().imageUp = this.filterType != null ? new TextureRegionDrawable(this.filterType.uiIcon) : Icon.filter;
                });
            }).growX().pad(6.0f).row();
            main.pane(t -> {
                this.table = t;
            }).grow().padRight(8.0f).scrollX(false).row();
            main.table(t -> {
                t.button("@add", () -> {
                    this.showUnits((Cons<UnitType>)((Cons)type -> {
                        this.expandedGroup = new SpawnGroup(type);
                        this.groups.add((Object)this.expandedGroup);
                    }), false);
                    this.buildGroups();
                }).growX().height(70.0f);
                t.button((Drawable)Icon.filter, () -> {
                    BaseDialog dialog = new BaseDialog("@waves.sort");
                    dialog.setFillParent(false);
                    dialog.cont.table(Tex.button, f -> {
                        for (Sort s : Sort.all) {
                            f.button("@waves.sort." + (Object)((Object)s), Styles.flatTogglet, () -> {
                                this.sort = s;
                                dialog.hide();
                                this.buildGroups();
                            }).size(150.0f, 60.0f).checked(s == this.sort);
                        }
                    }).row();
                    dialog.cont.check("@waves.sort.reverse", b -> {
                        this.reverseSort = b;
                        this.buildGroups();
                    }).padTop(4.0f).checked(this.reverseSort).padBottom(8.0f);
                    dialog.addCloseButton();
                    dialog.show();
                }).size(64.0f, 70.0f).padLeft(6.0f);
            }).growX();
        }), new Label("@waves.none"){
            {
                this.visible(() -> WaveInfoDialog.this.groups.isEmpty());
                this.touchable = Touchable.disabled;
                this.setWrap(true);
                this.setAlignment(1, 1);
            }
        }}).width(390.0f).growY();
        this.graph = new WaveGraph();
        this.wavesList = new Table();
        this.winWave = -1;
        Cell cell = this.wavesListCell = this.cont.pane((Element)this.wavesList).scrollX(false).grow();
        this.wavesListPane = cell.get();
        if (!this.wavesListMode) {
            this.wavesListCell.setElement((Element)this.graph);
        }
        this.buildGroups();
    }

    void buildWavesList() {
        if (this.winWave < 0) {
            this.winWave = Math.min(ArcWaveSpawner.calWinWave(), 200);
        }
        int maxWaves = ArcWaveSpawner.calWinWaveClamped();
        this.winWave = Math.min(this.winWave, maxWaves);
        this.wavesList.clearChildren();
        this.wavesList.margin(0.0f).defaults().pad(5.0f).growX();
        this.wavesList.table(Tex.button, t -> t.add((CharSequence)"\ue86d \u4e3a\u5355\u4f4d\u6570\u91cf\uff1b\ue813 \u4e3a\u5355\u4f4d\u8840+\u76fe\uff1b\ue810 \u4e3a\u8ba1\u7b97buff\u7684\u8840+\u76fe\uff1b\ue86e \u4e3a\u9884\u4f30DPS\u3002\u5728\u6e38\u620f\u4e2d\u65f6\u4f1a\u8003\u8651\u5730\u56fe\u51fa\u602a\u70b9\u6570\u76ee").color(Pal.accent)).scrollX(false).growX().row();
        float firstWaveTime = Vars.state.rules.initialWaveSpacing <= 0.0f ? 2.0f * Vars.state.rules.waveSpacing : Vars.state.rules.initialWaveSpacing;
        int winWave = this.winWave;
        for (int waveI = 0; waveI < winWave; ++waveI) {
            ArcWaveSpawner.WaveInfo wave = ArcWaveSpawner.getOrInit(waveI);
            this.wavesList.table(Tex.button, t -> {
                t.table(tt -> {
                    tt.add((CharSequence)("\u7b2c[accent]" + (wave.wave + 1) + "[]\u6ce2")).row();
                    int thisTime = (int)((float)wave.wave * Vars.state.rules.waveSpacing + firstWaveTime);
                    tt.add((CharSequence)FormatDefault.duration((float)thisTime / 60.0f, false)).row();
                    tt.label(() -> {
                        if (!Vars.state.isGame()) {
                            return "";
                        }
                        int deltaTime = thisTime - (int)(Vars.state.wave <= 1 ? firstWaveTime - Vars.state.wavetime : firstWaveTime + Vars.state.rules.waveSpacing * (float)(Vars.state.wave - 1) - Vars.state.wavetime);
                        return FormatDefault.duration((float)deltaTime / 60.0f, false);
                    }).row();
                }).width(120.0f).left();
                if (wave.amount == 0) {
                    t.add();
                    t.add((CharSequence)"\u8be5\u6ce2\u6b21\u6ca1\u6709\u654c\u4eba");
                } else {
                    t.add((Element)wave.proTable(true, -1, (Boolf<SpawnGroup>)((Boolf)group -> true)));
                    t.pane((Element)wave.unitTable(-1, (Boolf<SpawnGroup>)((Boolf)group -> true), Vars.mobile ? 8 : 15)).scrollX(true).scrollY(false).growX();
                }
            }).growX().row();
        }
        this.wavesList.button("\u52a0\u8f7d\u66f4\u591a\u6ce2\u6b21", () -> {
            this.winWave *= 2;
            this.buildWavesList();
        }).disabled(winWave == maxWaves).fillX().height(32.0f);
    }

    void buildGroups() {
        this.table.clear();
        this.table.top();
        this.table.margin(10.0f);
        if (this.groups != null) {
            this.groups.sort(Structs.comps((Comparator)Structs.comparingFloat(this.sort.sort), (Comparator)Structs.comparingFloat(this.sort.secondary)));
            if (this.reverseSort) {
                this.groups.reverse();
            }
            for (SpawnGroup group : this.groups) {
                if (group.effect == StatusEffects.none) {
                    group.effect = null;
                }
                if (this.search >= 0 && group.getSpawned(this.search) <= 0 || this.filterType != null && group.type != this.filterType) continue;
                this.table.table(Tex.button, t -> {
                    t.margin(0.0f).defaults().pad(3.0f).padLeft(5.0f).growX().left();
                    t.button(b -> {
                        b.left();
                        b.image(group.type.uiIcon).size(32.0f).padRight(3.0f).scaling(Scaling.fit);
                        b.add((CharSequence)group.type.localizedName).ellipsis(true).maxWidth(110.0f).left().color(ArcWaveSpawner.unitTypeColor(group.type));
                        if (group.items != null && group.items.amount > 0) {
                            b.image(group.items.item.uiIcon).size(20.0f).padRight(3.0f).scaling(Scaling.fit);
                        }
                        if (group.payloads != null && group.payloads.size > 0) {
                            b.image((Drawable)Icon.uploadSmall).size(20.0f).padRight(3.0f).scaling(Scaling.fit);
                        }
                        b.add().growX();
                        b.label(() -> {
                            StringBuilder builder = new StringBuilder();
                            builder.append("[lightgray]").append(group.begin + 1);
                            if (group.begin == group.end) {
                                return builder.toString();
                            }
                            if (group.end > 999999) {
                                builder.append("+");
                            } else {
                                builder.append("~").append(group.end + 1);
                            }
                            if (group.spacing > 1) {
                                builder.append("[white]|[lightgray]").append(group.spacing);
                            }
                            return builder.append("  ").toString();
                        }).minWidth(45.0f).labelAlign(8).left();
                        b.button((Drawable)Icon.copySmall, Styles.emptyi, () -> {
                            this.expandedGroup = group.copy();
                            this.groups.insert(this.groups.indexOf((Object)group) + 1, (Object)this.expandedGroup);
                            this.buildGroups();
                        }).pad(-6.0f).size(46.0f).tooltip("@editor.copy");
                        b.button((Drawable)(group.effect != null ? new TextureRegionDrawable(group.effect.uiIcon) : Icon.effectSmall), Styles.emptyi, 24.0f, () -> this.showEffects(group)).pad(-6.0f).size(46.0f).scaling(Scaling.fit).tooltip(group.effect != null ? group.effect.localizedName : "@none");
                        b.button((Drawable)Icon.unitsSmall, Styles.emptyi, () -> this.showUnits((Cons<UnitType>)((Cons)type -> {
                            group.type = type;
                        }), false)).pad(-6.0f).size(46.0f).tooltip("@stat.unittype");
                        b.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                            this.groups.remove((Object)group);
                            if (this.expandedGroup == group) {
                                this.expandedGroup = null;
                            }
                            this.table.getCell((Element)t).pad(0.0f);
                            t.remove();
                            this.buildGroups();
                        }).pad(-6.0f).size(46.0f).padRight(-12.0f).tooltip("@waves.remove");
                        b.clicked(KeyCode.mouseMiddle, () -> {
                            this.expandedGroup = group.copy();
                            this.groups.insert(this.groups.indexOf((Object)group) + 1, (Object)this.expandedGroup);
                            this.buildGroups();
                        });
                    }, () -> {
                        this.expandedGroup = this.expandedGroup == group ? null : group;
                        this.buildGroups();
                    }).height(46.0f).pad(-6.0f).padBottom(0.0f).row();
                    if (this.expandedGroup == group) {
                        t.table(spawns -> {
                            spawns.field("" + (group.begin + 1), TextField.TextFieldFilter.digitsOnly, text -> {
                                if (Strings.canParsePositiveInt((String)text)) {
                                    group.begin = Strings.parseInt((String)text) - 1;
                                    this.updateWaves();
                                }
                            }).width(100.0f);
                            spawns.add((CharSequence)"@waves.to").padLeft(4.0f).padRight(4.0f);
                            ((TextField)spawns.field(group.end == Integer.MAX_VALUE ? "" : group.end + 1 + "", TextField.TextFieldFilter.digitsOnly, text -> {
                                if (Strings.canParsePositiveInt((String)text)) {
                                    group.end = Strings.parseInt((String)text) - 1;
                                    this.updateWaves();
                                } else if (text.isEmpty()) {
                                    group.end = Integer.MAX_VALUE;
                                    this.updateWaves();
                                }
                            }).width(100.0f).get()).setMessageText("\u221e");
                        }).row();
                        t.table(p -> {
                            p.add((CharSequence)"@waves.every").padRight(4.0f);
                            p.field(group.spacing + "", TextField.TextFieldFilter.digitsOnly, text -> {
                                if (Strings.canParsePositiveInt((String)text) && Strings.parseInt((String)text) > 0) {
                                    group.spacing = Strings.parseInt((String)text);
                                    this.updateWaves();
                                }
                            }).width(100.0f);
                            p.add((CharSequence)"@waves.waves").padLeft(4.0f);
                        }).row();
                        t.table(a -> {
                            a.field(group.unitAmount + "", TextField.TextFieldFilter.digitsOnly, text -> {
                                if (Strings.canParsePositiveInt((String)text)) {
                                    group.unitAmount = Strings.parseInt((String)text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add((CharSequence)" + ");
                            a.field(Strings.fixed((float)Math.max(Mathf.zero((float)group.unitScaling) ? 0.0f : 1.0f / group.unitScaling, 0.0f), (int)2), TextField.TextFieldFilter.floatsOnly, text -> {
                                if (Strings.canParsePositiveFloat((String)text)) {
                                    group.unitScaling = 1.0f / Strings.parseFloat((String)text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add((CharSequence)"@waves.perspawn").padLeft(4.0f);
                        }).row();
                        t.table(a -> {
                            a.field(group.max + "", TextField.TextFieldFilter.digitsOnly, text -> {
                                if (Strings.canParsePositiveInt((String)text)) {
                                    group.max = Strings.parseInt((String)text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add((CharSequence)"@waves.max").padLeft(5.0f);
                        }).row();
                        t.table(a -> {
                            a.field((int)group.shields + "", TextField.TextFieldFilter.digitsOnly, text -> {
                                if (Strings.canParsePositiveInt((String)text)) {
                                    group.shields = Strings.parseInt((String)text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add((CharSequence)" + ");
                            a.field((int)group.shieldScaling + "", TextField.TextFieldFilter.digitsOnly, text -> {
                                if (Strings.canParsePositiveInt((String)text)) {
                                    group.shieldScaling = Strings.parseInt((String)text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add((CharSequence)"@waves.shields").padLeft(4.0f);
                        }).row();
                        t.check("@waves.guardian", b -> {
                            group.effect = b ? StatusEffects.boss : null;
                            this.buildGroups();
                        }).padTop(4.0f).update(b -> b.setChecked(group.effect == StatusEffects.boss)).padBottom(8.0f).row();
                        t.table(a -> {
                            a.add((CharSequence)"@waves.team").padRight(8.0f);
                            a.button(b -> b.image(Tex.whiteui).size(24.0f).update(i -> i.setColor(group.team == null ? Color.clear : group.team.color)), (Button.ButtonStyle)Styles.squarei, () -> MapObjectivesDialog.showTeamSelect((boolean)true, team -> {
                                group.team = team;
                            })).size(38.0f);
                        }).padTop(0.0f).row();
                        t.table(a -> {
                            a.add((CharSequence)"@waves.spawn").padRight(8.0f);
                            ((TextButton)a.button("", () -> {
                                if (!this.checkedSpawns) {
                                    Vars.spawner.reset();
                                    this.checkedSpawns = true;
                                }
                                BaseDialog dialog = new BaseDialog("@waves.spawn.select");
                                dialog.cont.pane(p -> {
                                    p.background(Tex.button).margin(10.0f);
                                    int i = 0;
                                    int cols = 4;
                                    int max = 20;
                                    if (Vars.spawner.getSpawns().size >= max) {
                                        p.add((CharSequence)("[lightgray](first " + max + ")")).colspan(cols).padBottom(4.0f).row();
                                    }
                                    for (Tile spawn : Vars.spawner.getSpawns()) {
                                        p.button(spawn.x + ", " + spawn.y, Styles.flatTogglet, () -> {
                                            group.spawn = Point2.pack((int)spawn.x, (int)spawn.y);
                                            dialog.hide();
                                        }).size(110.0f, 45.0f).checked(spawn.pos() == group.spawn);
                                        if (++i % cols == 0) {
                                            p.row();
                                        }
                                        if (i < 20) continue;
                                        break;
                                    }
                                    if (Vars.spawner.getSpawns().isEmpty()) {
                                        p.add((CharSequence)"@waves.spawn.none");
                                    } else {
                                        p.button("@waves.spawn.all", Styles.flatTogglet, () -> {
                                            group.spawn = -1;
                                            dialog.hide();
                                        }).size(110.0f, 45.0f).checked(-1 == group.spawn);
                                    }
                                }).grow();
                                dialog.setFillParent(false);
                                dialog.addCloseButton();
                                dialog.show();
                            }).width(160.0f).height(36.0f).get()).getLabel().setText(() -> group.spawn == -1 ? "@waves.spawn.all" : Point2.x((int)group.spawn) + ", " + Point2.y((int)group.spawn));
                        }).row();
                        t.table(a -> {
                            a.defaults().pad(2.0f);
                            a.add((CharSequence)"\u643a\u5e26\u7269\u54c1[gold]X[]: ");
                            a.button((Drawable)(group.items != null ? new TextureRegionDrawable(group.items.item.uiIcon) : Icon.noneSmall), Styles.emptyi, 24.0f, () -> {
                                if (group.type.itemCapacity <= 0) {
                                    UIExt.announce("[red]\u8be5\u5355\u4f4d\u4e0d\u53ef\u643a\u5e26\u7269\u54c1");
                                    return;
                                }
                                ContentSelectDialog dialog = new ContentSelectDialog();
                                dialog.addNull(() -> {
                                    group.items = null;
                                    this.buildGroups();
                                    dialog.hide();
                                }).setChecked(group.items == null);
                                dialog.addContents(Vars.content.items(), group.items != null ? group.items.item : null, it -> {
                                    if (group.items == null) {
                                        group.items = new ItemStack(it, 1);
                                    }
                                    group.items.item = it;
                                    dialog.hide();
                                    this.buildGroups();
                                });
                                dialog.show();
                            });
                            if (group.items != null) {
                                a.label(() -> "x" + group.items.amount);
                                a.slider(1.0f, (float)group.type.itemCapacity, 1.0f, it -> {
                                    group.items.amount = (int)it;
                                }).padLeft(8.0f).growX();
                            } else {
                                a.add().growX();
                            }
                        }).margin(8.0f).row();
                        t.table(a -> {
                            a.defaults().pad(2.0f);
                            a.add((CharSequence)"\u643a\u5e26\u8f7d\u8377[gold]X[]: ");
                            if (group.payloads != null) {
                                for (UnitType it : group.payloads) {
                                    a.button((Drawable)new TextureRegionDrawable(it.uiIcon), Styles.emptyi, 24.0f, () -> group.payloads.remove((Object)it));
                                }
                            }
                            a.add().growX();
                            a.button((Drawable)Icon.addSmall, Styles.emptyi, 24.0f, () -> this.showUnits((Cons<UnitType>)((Cons)type -> {
                                if (group.type.payloadCapacity <= 0.0f) {
                                    UIExt.announce("[red]\u8be5\u5355\u4f4d\u4e0d\u53ef\u643a\u5e26\u8f7d\u8377");
                                    return;
                                }
                                if (group.payloads == null) {
                                    group.payloads = Seq.with((Object[])new UnitType[0]);
                                }
                                group.payloads.add((Object)type);
                            }), false));
                        }).margin(8.0f).row();
                    }
                }).width(340.0f).pad(8.0f);
                this.table.row();
            }
            if (this.table.getChildren().isEmpty() && this.groups.any()) {
                this.table.add((CharSequence)"@none.found");
            }
        } else {
            this.table.add((CharSequence)"@editor.default");
        }
        this.updateWaves();
    }

    void showUnits(Cons<UnitType> cons, boolean reset) {
        ContentSelectDialog dialog = new ContentSelectDialog();
        dialog.title.setText((CharSequence)(reset ? "@waves.filter" : ""));
        if (reset) {
            dialog.addNull(() -> {
                cons.get(null);
                dialog.hide();
                this.buildGroups();
            });
        }
        dialog.addContents(Vars.content.units().select(type -> !type.isHidden() || (Boolean)VarsX.allUnlocked.get() != false), null, type -> {
            cons.get((Object)type);
            dialog.hide();
            this.buildGroups();
        });
        dialog.show();
    }

    void showEffects(SpawnGroup group) {
        ContentSelectDialog dialog = new ContentSelectDialog();
        dialog.addNull(() -> {
            group.effect = null;
            dialog.hide();
            this.buildGroups();
        });
        dialog.addContents(Vars.content.statusEffects().select(effect -> !effect.isHidden() && !effect.reactive || (Boolean)VarsX.allUnlocked.get() != false), null, type -> {
            group.effect = type;
            dialog.hide();
            this.buildGroups();
        });
        dialog.show();
    }

    void updateWaves() {
        this.graph.groups = this.groups;
        this.graph.rebuild();
        ArcWaveSpawner.reload(this.groups);
        this.buildWavesList();
    }

    static enum Sort {
        begin((Floatf<SpawnGroup>)((Floatf)g -> g.begin), (Floatf<SpawnGroup>)((Floatf)g -> g.type.id)),
        health((Floatf<SpawnGroup>)((Floatf)g -> g.type.health)),
        type((Floatf<SpawnGroup>)((Floatf)g -> g.type.id));

        static final Sort[] all;
        final Floatf<SpawnGroup> sort;
        final Floatf<SpawnGroup> secondary;

        private Sort(Floatf<SpawnGroup> sort) {
            this(sort, (Floatf<SpawnGroup>)((Floatf)g -> g.begin));
        }

        private Sort(Floatf<SpawnGroup> sort, Floatf<SpawnGroup> secondary) {
            this.sort = sort;
            this.secondary = secondary;
        }

        static {
            all = Sort.values();
        }
    }
}

