/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustryX.features.ui.FormatDefault;

public class ShieldArcAbility
extends Ability {
    private static Unit paramUnit;
    private static ShieldArcAbility paramField;
    private static Vec2 paramPos;
    private static final Cons<Bullet> shieldConsumer;
    protected static final Cons<Unit> unitConsumer;
    public float radius = 60.0f;
    public float regen = 0.1f;
    public float max = 200.0f;
    public float cooldown = 300.0f;
    public float angle = 80.0f;
    public float angleOffset = 0.0f;
    public float x = 0.0f;
    public float y = 0.0f;
    public boolean whenShooting = true;
    public float width = 6.0f;
    public float chanceDeflect = -1.0f;
    public Sound deflectSound = Sounds.none;
    public Sound breakSound = Sounds.shieldBreakSmall;
    public Sound hitSound = Sounds.shieldHit;
    public float hitSoundVolume = 0.12f;
    public float missileUnitMultiplier = 2.0f;
    public boolean drawArc = true;
    @Nullable
    public String region;
    @Nullable
    public Color color;
    public boolean offsetRegion = false;
    public boolean pushUnits = true;
    protected float widthScale;
    protected float alpha;

    public void addStats(Table t) {
        super.addStats(t);
        t.add((CharSequence)this.abilityStat("shield", new Object[]{Strings.autoFixed((float)this.max, (int)2)}));
        t.row();
        t.add((CharSequence)this.abilityStat("repairspeed", new Object[]{Strings.autoFixed((float)(this.regen * 60.0f), (int)2)}));
        t.row();
        t.add((CharSequence)this.abilityStat("cooldown", new Object[]{Strings.autoFixed((float)(this.cooldown / 60.0f), (int)2)}));
        t.row();
        t.add((CharSequence)this.abilityStat("deflectchance", new Object[]{Strings.autoFixed((float)(this.chanceDeflect * 100.0f), (int)2)}));
    }

    public void update(Unit unit) {
        if (this.data < this.max) {
            this.data += Time.delta * this.regen;
        }
        boolean active = this.data > 0.0f && (unit.isShooting || !this.whenShooting);
        this.alpha = Math.max(this.alpha - Time.delta / 10.0f, 0.0f);
        if (active) {
            this.widthScale = Mathf.lerpDelta((float)this.widthScale, (float)1.0f, (float)0.06f);
            paramUnit = unit;
            paramField = this;
            paramPos.set(this.x, this.y).rotate(unit.rotation - 90.0f).add((Position)unit);
            float reach = this.radius + this.width;
            Groups.bullet.intersect(ShieldArcAbility.paramPos.x - reach, ShieldArcAbility.paramPos.y - reach, reach * 2.0f, reach * 2.0f, shieldConsumer);
            Units.nearbyEnemies(ShieldArcAbility.paramUnit.team, ShieldArcAbility.paramPos.x - reach, ShieldArcAbility.paramPos.y - reach, reach * 2.0f, reach * 2.0f, unitConsumer);
        } else {
            this.widthScale = Mathf.lerpDelta((float)this.widthScale, (float)0.0f, (float)0.11f);
        }
    }

    public void created(Unit unit) {
        this.data = this.max;
    }

    public void draw(Unit unit) {
        if (this.widthScale > 0.001f) {
            Draw.z((float)125.0f);
            Draw.color((Color)(this.color == null ? unit.type.shieldColor(unit) : this.color), (Color)Color.white, (float)Mathf.clamp((float)this.alpha));
            Vec2 pos = paramPos.set(this.x, this.y).rotate(unit.rotation - 90.0f).add((Position)unit);
            if (!Vars.renderer.animateShields) {
                Draw.alpha((float)0.4f);
            }
            if (this.region != null) {
                Vec2 rp = this.offsetRegion ? pos : Tmp.v1.set((Position)unit);
                Draw.yscl = this.widthScale;
                Draw.rect((String)this.region, (float)rp.x, (float)rp.y, (float)(unit.rotation - 90.0f));
                Draw.yscl = 1.0f;
            }
            if (this.drawArc) {
                Lines.stroke(this.width * this.widthScale);
                Lines.arc(pos.x, pos.y, this.radius, this.angle / 360.0f, unit.rotation + this.angleOffset - this.angle / 2.0f);
            }
            Draw.reset();
        }
    }

    public void displayBars(Unit unit, Table bars) {
        bars.add((Element)new Bar(() -> (this.data < 0.0f ? "[red]" : "") + "\ue84d " + FormatDefault.percent(this.data, this.max), () -> Pal.accent, () -> this.data / this.max)).row();
    }

    static {
        paramPos = new Vec2();
        shieldConsumer = b -> {
            if (b.team != ShieldArcAbility.paramUnit.team && b.type.absorbable && ShieldArcAbility.paramField.data > 0.0f && (!b.within((Position)paramPos, ShieldArcAbility.paramField.radius - ShieldArcAbility.paramField.width) || !paramPos.within(b.x - b.deltaX, b.y - b.deltaY, ShieldArcAbility.paramField.radius - ShieldArcAbility.paramField.width)) && (Tmp.v1.set((Position)b).add(b.deltaX, b.deltaY).within((Position)paramPos, ShieldArcAbility.paramField.radius + ShieldArcAbility.paramField.width) || b.within((Position)paramPos, ShieldArcAbility.paramField.radius + ShieldArcAbility.paramField.width)) && (Angles.within((float)paramPos.angleTo((Position)b), (float)(ShieldArcAbility.paramUnit.rotation + ShieldArcAbility.paramField.angleOffset), (float)(ShieldArcAbility.paramField.angle / 2.0f)) || Angles.within((float)paramPos.angleTo(b.x + b.deltaX, b.y + b.deltaY), (float)(ShieldArcAbility.paramUnit.rotation + ShieldArcAbility.paramField.angleOffset), (float)(ShieldArcAbility.paramField.angle / 2.0f)))) {
                if (ShieldArcAbility.paramField.chanceDeflect > 0.0f && b.vel.len() >= 0.1f && b.type.reflectable && Mathf.chance((double)ShieldArcAbility.paramField.chanceDeflect)) {
                    ShieldArcAbility.paramField.deflectSound.at((Position)paramPos, Mathf.random((float)0.9f, (float)1.1f));
                    b.trns(-b.vel.x, -b.vel.y);
                    float penX = Math.abs(ShieldArcAbility.paramPos.x - b.x);
                    float penY = Math.abs(ShieldArcAbility.paramPos.y - b.y);
                    if (penX > penY) {
                        b.vel.x *= -1.0f;
                    } else {
                        b.vel.y *= -1.0f;
                    }
                    b.owner = paramUnit;
                    b.team = ShieldArcAbility.paramUnit.team;
                    b.time += 1.0f;
                } else {
                    b.absorb();
                    Fx.absorb.at((Position)b);
                    ShieldArcAbility.paramField.hitSound.at(b.x, b.y, 1.0f + Mathf.range((float)0.1f), ShieldArcAbility.paramField.hitSoundVolume);
                }
                if (ShieldArcAbility.paramField.data <= b.damage()) {
                    ShieldArcAbility.paramField.data -= ShieldArcAbility.paramField.cooldown * ShieldArcAbility.paramField.regen;
                    Fx.arcShieldBreak.at(ShieldArcAbility.paramPos.x, ShieldArcAbility.paramPos.y, 0.0f, ShieldArcAbility.paramField.color == null ? ShieldArcAbility.paramUnit.type.shieldColor(paramUnit) : ShieldArcAbility.paramField.color, (Object)paramUnit);
                    ShieldArcAbility.paramField.breakSound.at(ShieldArcAbility.paramPos.x, ShieldArcAbility.paramPos.y);
                }
                ShieldArcAbility.paramField.data -= b.type.shieldDamage((Bullet)b);
                ShieldArcAbility.paramField.alpha = 1.0f;
            }
        };
        unitConsumer = unit -> {
            if (ShieldArcAbility.paramField.data > 0.0f && unit.targetable(ShieldArcAbility.paramUnit.team) && (!unit.within((Position)paramPos, ShieldArcAbility.paramField.radius - ShieldArcAbility.paramField.width) || !paramPos.within(unit.x - unit.deltaX, unit.y - unit.deltaY, ShieldArcAbility.paramField.radius - ShieldArcAbility.paramField.width)) && (Tmp.v1.set((Position)unit).add(unit.deltaX, unit.deltaY).within((Position)paramPos, ShieldArcAbility.paramField.radius + ShieldArcAbility.paramField.width) || unit.within((Position)paramPos, ShieldArcAbility.paramField.radius + ShieldArcAbility.paramField.width)) && (Angles.within((float)paramPos.angleTo((Position)unit), (float)(ShieldArcAbility.paramUnit.rotation + ShieldArcAbility.paramField.angleOffset), (float)(ShieldArcAbility.paramField.angle / 2.0f)) || Angles.within((float)paramPos.angleTo(unit.x + unit.deltaX, unit.y + unit.deltaY), (float)(ShieldArcAbility.paramUnit.rotation + ShieldArcAbility.paramField.angleOffset), (float)(ShieldArcAbility.paramField.angle / 2.0f)))) {
                float reach;
                float overlapDst;
                if (unit.isMissile() && unit.killable() && ShieldArcAbility.paramField.missileUnitMultiplier >= 0.0f) {
                    unit.remove();
                    unit.type.deathSound.at((Position)unit);
                    unit.type.deathExplosionEffect.at((Position)unit);
                    Fx.absorb.at((Position)unit);
                    Fx.circleColorSpark.at(unit.x, unit.y, ShieldArcAbility.paramUnit.team.color);
                    ShieldArcAbility.paramField.data -= unit.health() * ShieldArcAbility.paramField.missileUnitMultiplier * Vars.state.rules.unitDamage(unit.team);
                    ShieldArcAbility.paramField.alpha = 1.0f;
                } else if (ShieldArcAbility.paramField.pushUnits && (unit.isFlying() || !paramUnit.isFlying()) && (overlapDst = (reach = ShieldArcAbility.paramField.radius + ShieldArcAbility.paramField.width) - unit.dst(ShieldArcAbility.paramPos.x, ShieldArcAbility.paramPos.y)) > 0.0f) {
                    unit.vel.setZero();
                    unit.move(Tmp.v1.set((Position)unit).sub((Position)paramUnit).setLength(overlapDst + 0.01f));
                    if (Mathf.chanceDelta((double)(0.5f * Time.delta))) {
                        Fx.circleColorSpark.at(unit.x, unit.y, ShieldArcAbility.paramUnit.team.color);
                    }
                }
            }
        };
    }
}

