/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.gen.Building;
import mindustry.gen.Decalc;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Timedc;
import mindustry.gen.Unitc;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class Decal
implements Pool.Poolable,
Decalc,
Drawc,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
Posc,
Rotc,
Timedc {
    protected transient boolean added;
    public Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    public float lifetime;
    public TextureRegion region;
    public float rotation;
    public float time;
    public float x;
    public float y;

    protected Decal() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    public Color color() {
        return this.color;
    }

    public TextureRegion region() {
        return this.region;
    }

    public float lifetime() {
        return this.lifetime;
    }

    public float rotation() {
        return this.rotation;
    }

    public float time() {
        return this.time;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 8;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "Decal#" + this.id;
    }

    public void color(Color color) {
        this.color = color;
    }

    public void id(int id) {
        this.id = id;
    }

    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    public void region(TextureRegion region) {
        this.region = region;
    }

    public void rotation(float rotation) {
        this.rotation = rotation;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    public void time(float time) {
        this.time = time;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        Unitc u;
        Decal decal;
        return this == Vars.player || (decal = this) instanceof Unitc && (u = (Unitc)decal).controller() == Vars.player;
    }

    public boolean isRemote() {
        Unitc u;
        Decal decal = this;
        return decal instanceof Unitc && (u = (Unitc)decal).isPlayer() && !this.isLocal();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return false;
    }

    public float clipSize() {
        return this.region.width * 2;
    }

    public float fin() {
        return this.time / this.lifetime;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static Decal create() {
        return (Decal)Pools.obtain(Decal.class, Decal::new);
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.added = true;
    }

    public void afterRead() {
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    public void draw() {
        Draw.z((float)10.0f);
        Draw.mixcol((Color)this.color, (float)this.color.a);
        Draw.alpha((float)(1.0f - Mathf.curve((float)this.fin(), (float)0.98f)));
        Draw.rect((TextureRegion)this.region, (float)this.x, (float)this.y, (float)this.rotation);
        Draw.reset();
    }

    public void read(Reads read) {
        this.afterRead();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        this.added = false;
        Groups.queueFree((Pool.Poolable)this);
    }

    public void reset() {
        this.added = false;
        this.id = EntityGroup.nextId();
        this.lifetime = 0.0f;
        this.region = null;
        this.rotation = 0.0f;
        this.time = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void update() {
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    public void write(Writes write) {
    }
}

