/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.ui.layout.Scl;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Ratekeeper;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import java.nio.FloatBuffer;
import java.util.Comparator;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.types.CommandAI;
import mindustry.content.Blocks;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.IndexableEntity__player;
import mindustry.gen.IndexableEntity__sync;
import mindustry.gen.Playerc;
import mindustry.gen.Posc;
import mindustry.gen.Syncc;
import mindustry.gen.Timerc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.io.TypeIO;
import mindustry.net.Administration;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;
import mindustryX.events.PlayerTeamChangedEvent;

public class Player
implements Drawc,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
IndexableEntity__player,
IndexableEntity__sync,
Playerc,
Posc,
Syncc,
Timerc {
    public static final float deathDelay = 60.0f;
    protected transient boolean added;
    public boolean admin;
    public boolean boosting;
    public Color color = new Color();
    @Nullable
    public transient NetConnection con;
    public transient float deathTimer;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    protected transient int index__player = -1;
    protected transient int index__sync = -1;
    public transient Ratekeeper itemDepositRate = new Ratekeeper();
    @Nullable
    public transient Unit justSwitchFrom;
    @Nullable
    public transient Unit justSwitchTo;
    @Nullable
    public UnitCommand lastCommand;
    @Nullable
    protected transient Unit lastReadUnit;
    public transient String lastText = "";
    public transient long lastUpdated;
    public transient String locale = "en";
    public float mouseX;
    public float mouseY;
    public String name = "frog";
    public boolean shooting;
    protected Team team = Team.sharded;
    public transient float textFadeTime;
    public transient Interval timer = new Interval(6);
    public boolean typing;
    @Nullable
    protected Unit unit;
    public transient long updateSpacing;
    protected transient int wrongReadUnits;
    public float x;
    private transient float x_LAST_;
    private transient float x_TARGET_;
    public float y;
    private transient float y_LAST_;
    private transient float y_TARGET_;

    protected Player() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Unit unit() {
        return this.unit;
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Nullable
    public CoreBlock.CoreBuild bestCore() {
        Seq cores = this.team.cores();
        return (CoreBlock.CoreBuild)cores.min(b -> cores.size == 1 || ((CoreBlock)((Object)((Object)((Object)b.block)))).unitType.supportsEnv(Vars.state.rules.env), Structs.comps((Comparator)Structs.comparingInt(c -> -c.block.size), (Comparator)Structs.comparingFloat(c -> c.dst2(this.x, this.y))));
    }

    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    public Unit justSwitchFrom() {
        return this.justSwitchFrom;
    }

    public Unit justSwitchTo() {
        return this.justSwitchTo;
    }

    public Color color() {
        return this.color;
    }

    public Interval timer() {
        return this.timer;
    }

    public Ratekeeper itemDepositRate() {
        return this.itemDepositRate;
    }

    public boolean admin() {
        return this.admin;
    }

    public boolean boosting() {
        return this.boosting;
    }

    public boolean shooting() {
        return this.shooting;
    }

    public boolean typing() {
        return this.typing;
    }

    public float deathTimer() {
        return this.deathTimer;
    }

    public float mouseX() {
        return this.mouseX;
    }

    public float mouseY() {
        return this.mouseY;
    }

    public float textFadeTime() {
        return this.textFadeTime;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 12;
    }

    public int id() {
        return this.id;
    }

    public String lastText() {
        return this.lastText;
    }

    public String locale() {
        return this.locale;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "Player#" + this.id;
    }

    public long lastUpdated() {
        return this.lastUpdated;
    }

    public long updateSpacing() {
        return this.updateSpacing;
    }

    public UnitCommand lastCommand() {
        return this.lastCommand;
    }

    public Team team() {
        return this.team;
    }

    public NetConnection con() {
        return this.con;
    }

    public void admin(boolean admin) {
        this.admin = admin;
    }

    public void boosting(boolean boosting) {
        this.boosting = boosting;
    }

    public void color(Color color) {
        this.color = color;
    }

    public void con(NetConnection con) {
        this.con = con;
    }

    public void deathTimer(float deathTimer) {
        this.deathTimer = deathTimer;
    }

    public void id(int id) {
        this.id = id;
    }

    public void itemDepositRate(Ratekeeper itemDepositRate) {
        this.itemDepositRate = itemDepositRate;
    }

    public void justSwitchFrom(Unit justSwitchFrom) {
        this.justSwitchFrom = justSwitchFrom;
    }

    public void justSwitchTo(Unit justSwitchTo) {
        this.justSwitchTo = justSwitchTo;
    }

    public void lastCommand(UnitCommand lastCommand) {
        this.lastCommand = lastCommand;
    }

    public void lastText(String lastText) {
        this.lastText = lastText;
    }

    public void lastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void locale(String locale) {
        this.locale = locale;
    }

    public void mouseX(float mouseX) {
        this.mouseX = mouseX;
    }

    public void mouseY(float mouseY) {
        this.mouseY = mouseY;
    }

    public void name(String name) {
        this.name = name;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    public void setIndex__player(int index) {
        this.index__player = index;
    }

    public void setIndex__sync(int index) {
        this.index__sync = index;
    }

    public void shooting(boolean shooting) {
        this.shooting = shooting;
    }

    public void textFadeTime(float textFadeTime) {
        this.textFadeTime = textFadeTime;
    }

    public void timer(Interval timer) {
        this.timer = timer;
    }

    public void typing(boolean typing) {
        this.typing = typing;
    }

    public void updateSpacing(long updateSpacing) {
        this.updateSpacing = updateSpacing;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public void read(Reads read) {
        short REV = read.s();
        if (REV == 0) {
            this.admin = read.bool();
            this.boosting = read.bool();
            this.color = TypeIO.readColor(read, this.color);
            this.mouseX = read.f();
            this.mouseY = read.f();
            this.name = TypeIO.readString(read);
            this.shooting = read.bool();
            this.team = TypeIO.readTeam(read);
            this.typing = read.bool();
            this.unit = TypeIO.readUnit(read);
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 1) {
            this.admin = read.bool();
            this.boosting = read.bool();
            this.color = TypeIO.readColor(read, this.color);
            this.lastCommand = TypeIO.readCommand(read);
            this.mouseX = read.f();
            this.mouseY = read.f();
            this.name = TypeIO.readString(read);
            this.shooting = read.bool();
            this.team = TypeIO.readTeam(read);
            this.typing = read.bool();
            this.unit = TypeIO.readUnit(read);
            this.x = read.f();
            this.y = read.f();
        } else {
            throw new IllegalArgumentException("Unknown revision '" + REV + "' for entity type 'PlayerComp'");
        }
        this.afterRead();
    }

    public void write(Writes write) {
        write.s(1);
        write.bool(this.admin);
        write.bool(this.boosting);
        TypeIO.writeColor(write, this.color);
        TypeIO.writeCommand(write, this.lastCommand);
        write.f(this.mouseX);
        write.f(this.mouseY);
        TypeIO.writeString(write, this.name);
        write.bool(this.shooting);
        TypeIO.writeTeam(write, this.team);
        write.bool(this.typing);
        TypeIO.writeUnit(write, this.unit);
        write.f(this.x);
        write.f(this.y);
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public TextureRegion icon() {
        if (this.dead()) {
            if (this.core() == null) {
                return UnitTypes.alpha.uiIcon;
            }
            CoreBlock.CoreBuild bestCore = this.bestCore();
            if (bestCore == null) {
                return UnitTypes.alpha.uiIcon;
            }
            return ((CoreBlock)((Object)bestCore.block)).unitType.uiIcon;
        }
        return this.unit.icon();
    }

    public boolean dead() {
        return this.unit == null || !this.unit.isValid();
    }

    public boolean displayAmmo() {
        return this.unit instanceof BlockUnitc || Vars.state.rules.unitAmmo;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isBuilder() {
        return this.unit != null && this.unit.canBuild();
    }

    public boolean isLocal() {
        Unitc u;
        Player player;
        return this == Vars.player || (player = this) instanceof Unitc && (u = (Unitc)player).controller() == Vars.player;
    }

    public boolean isLogicControllable() {
        return false;
    }

    public boolean isRemote() {
        Unitc u;
        Player player = this;
        return player instanceof Unitc && (u = (Unitc)player).isPlayer() && !this.isLocal();
    }

    public boolean isSyncHidden(Player player) {
        return false;
    }

    public boolean isValidController() {
        return this.isAdded();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return false;
    }

    public boolean timer(int index, float time) {
        if (Float.isInfinite(time)) {
            return false;
        }
        return this.timer.get(index, time);
    }

    public float clipSize() {
        return this.unit == null ? 20.0f : this.unit.type.hitSize * 2.0f;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public String coloredName() {
        return "[#" + this.color.toString().toUpperCase() + "]" + this.name;
    }

    public String ip() {
        return this.con == null ? "localhost" : this.con.address;
    }

    public String plainName() {
        return Strings.stripColors((CharSequence)this.name);
    }

    public String usid() {
        return this.con == null ? "[LOCAL]" : this.con.usid;
    }

    public String uuid() {
        return this.con == null ? "[LOCAL]" : this.con.uuid;
    }

    public Administration.PlayerInfo getInfo() {
        if (this.isLocal()) {
            throw new IllegalArgumentException("Local players cannot be traced and do not have info.");
        }
        return Vars.netServer.admins.getInfo(this.uuid());
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static Player create() {
        return new Player();
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__player = Groups.player.addIndex(this);
        this.index__sync = Groups.sync.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.added = true;
    }

    public void afterRead() {
    }

    public void afterReadAll() {
    }

    public void afterSync() {
        if (this.isLocal() && this.unit == this.justSwitchFrom && this.justSwitchFrom != null && this.justSwitchTo != null) {
            this.unit = this.justSwitchTo;
            if (++this.wrongReadUnits >= 2) {
                this.justSwitchFrom = null;
                this.wrongReadUnits = 0;
            }
        } else {
            this.justSwitchFrom = null;
            this.justSwitchTo = null;
            this.wrongReadUnits = 0;
        }
        Unit set = this.unit;
        this.unit = this.lastReadUnit;
        this.unit(set);
        this.lastReadUnit = this.unit;
        if (this.unit != null) {
            this.unit.aim(this.mouseX, this.mouseY);
            this.unit.controlWeapons(this.shooting, this.shooting);
            this.unit.controller((UnitController)this);
        }
    }

    public void beforeWrite() {
    }

    public void checkSpawn() {
        CoreBlock.CoreBuild core = this.bestCore();
        if (core != null) {
            core.requestSpawn(this);
        }
    }

    public void clearUnit() {
        this.unit(null);
    }

    public void draw() {
        if (this.unit != null && this.name != null && !this.unit.inFogTo(Vars.player.team())) {
            Draw.z((float)150.0f);
            float z = Drawf.text();
            Font font = Fonts.outline;
            GlyphLayout layout = (GlyphLayout)Pools.obtain(GlyphLayout.class, GlyphLayout::new);
            float nameHeight = 11.0f;
            float textHeight = 15.0f;
            boolean ints = font.usesIntegerPositions();
            font.setUseIntegerPositions(false);
            font.getData().setScale(0.25f / Scl.scl((float)1.0f));
            layout.setText(font, (CharSequence)this.name);
            if (!this.isLocal()) {
                Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
                Fill.rect((float)this.unit.x, (float)(this.unit.y + 11.0f - layout.height / 2.0f), (float)(layout.width + 2.0f), (float)(layout.height + 3.0f));
                Draw.color();
                font.setColor(this.color);
                font.draw((CharSequence)this.name, this.unit.x, this.unit.y + 11.0f, 0.0f, 1, false);
                if (this.admin) {
                    float s = 3.0f;
                    Draw.color((float)(this.color.r * 0.5f), (float)(this.color.g * 0.5f), (float)(this.color.b * 0.5f), (float)1.0f);
                    Draw.rect((TextureRegion)Icon.adminSmall.getRegion(), (float)(this.unit.x + layout.width / 2.0f + 2.0f + 1.0f), (float)(this.unit.y + 11.0f - 1.5f), (float)s, (float)s);
                    Draw.color((Color)this.color);
                    Draw.rect((TextureRegion)Icon.adminSmall.getRegion(), (float)(this.unit.x + layout.width / 2.0f + 2.0f + 1.0f), (float)(this.unit.y + 11.0f - 1.0f), (float)s, (float)s);
                }
            }
            if (Core.settings.getBool("playerchat") && (this.textFadeTime > 0.0f && this.lastText != null || this.typing)) {
                String text = this.textFadeTime <= 0.0f || this.lastText == null ? "[lightgray]" + Strings.animated((float)Time.time, (int)4, (float)15.0f, (String)".") : this.lastText;
                float width = 100.0f;
                float visualFadeTime = 1.0f - Mathf.curve((float)(1.0f - this.textFadeTime), (float)0.9f);
                font.setColor(1.0f, 1.0f, 1.0f, this.textFadeTime <= 0.0f || this.lastText == null ? 1.0f : visualFadeTime);
                layout.setText(font, (CharSequence)text, Color.white, width, 4, true);
                Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.3f * (this.textFadeTime <= 0.0f || this.lastText == null ? 1.0f : visualFadeTime)));
                Fill.rect((float)this.unit.x, (float)(this.unit.y + 15.0f + layout.height - layout.height / 2.0f), (float)(layout.width + 2.0f), (float)(layout.height + 3.0f));
                font.draw((CharSequence)text, this.unit.x - width / 2.0f, this.unit.y + 15.0f + layout.height, width, 1, true);
            }
            Draw.reset();
            Pools.free((Object)layout);
            font.getData().setScale(1.0f);
            font.setColor(Color.white);
            font.setUseIntegerPositions(ints);
            Draw.z((float)z);
        }
    }

    public void handleSyncHidden() {
    }

    public void interpolate() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis((long)this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.x = Mathf.lerp((float)this.x_LAST_, (float)this.x_TARGET_, (float)alpha);
            this.y = Mathf.lerp((float)this.y_LAST_, (float)this.y_TARGET_, (float)alpha);
        } else if (this.lastUpdated != 0L) {
            this.x = this.x_TARGET_;
            this.y = this.y_TARGET_;
        }
    }

    public void kick(String reason) {
        this.con.kick(reason);
    }

    public void kick(String reason, long duration) {
        this.con.kick(reason, duration);
    }

    public void kick(Packets.KickReason reason) {
        this.con.kick(reason);
    }

    public void kick(Packets.KickReason reason, long duration) {
        this.con.kick(reason, duration);
    }

    public void readSync(Reads read) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis((long)this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        boolean islocal = this.isLocal();
        this.admin = read.bool();
        if (!islocal) {
            this.boosting = read.bool();
        } else {
            read.bool();
        }
        this.color = TypeIO.readColor(read, this.color);
        if (!islocal) {
            this.mouseX = read.f();
        } else {
            read.f();
        }
        if (!islocal) {
            this.mouseY = read.f();
        } else {
            read.f();
        }
        this.name = TypeIO.readString(read);
        if (!islocal) {
            this.shooting = read.bool();
        } else {
            read.bool();
        }
        this.team = TypeIO.readTeam(read);
        if (!islocal) {
            this.typing = read.bool();
        } else {
            read.bool();
        }
        this.unit = TypeIO.readUnit(read);
        if (!islocal) {
            this.x_LAST_ = this.x;
            this.x_TARGET_ = read.f();
        } else {
            read.f();
            this.x_LAST_ = this.x;
            this.x_TARGET_ = this.x;
        }
        if (!islocal) {
            this.y_LAST_ = this.y;
            this.y_TARGET_ = read.f();
        } else {
            read.f();
            this.y_LAST_ = this.y;
            this.y_TARGET_ = this.y;
        }
        this.afterSync();
    }

    public void readSyncManual(FloatBuffer buffer) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis((long)this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = buffer.get();
        this.y_LAST_ = this.y;
        this.y_TARGET_ = buffer.get();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.player.removeIndex(this, this.index__player);
        this.index__player = -1;
        Groups.sync.removeIndex(this, this.index__sync);
        this.index__sync = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        this.added = false;
        if (this.unit != null) {
            this.clearUnit();
        }
        this.lastReadUnit = null;
        this.justSwitchFrom = null;
        this.justSwitchTo = null;
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
    }

    public void reset() {
        this.team = Vars.state.rules.defaultTeam;
        this.typing = false;
        this.admin = false;
        this.textFadeTime = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        if (!this.dead()) {
            this.unit.resetController();
            this.unit = null;
        }
    }

    public void sendMessage(String text) {
        this.sendMessage(text, null, null);
    }

    public void sendMessage(String text, Player from) {
        this.sendMessage(text, from, null);
    }

    public void sendMessage(String text, Player from, String unformatted) {
        if (this.isLocal()) {
            if (Vars.ui != null) {
                Vars.ui.chatfrag.addMessage(text);
            }
        } else {
            Call.sendMessage((NetConnection)this.con, (String)text, (String)unformatted, (Player)from);
        }
    }

    public void sendUnformatted(Player from, String unformatted) {
        this.sendMessage(Vars.netServer.chatFormatter.format(from, unformatted), from, unformatted);
    }

    public void sendUnformatted(String unformatted) {
        this.sendUnformatted(null, unformatted);
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void snapInterpolation() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = this.x;
        this.y_LAST_ = this.y;
        this.y_TARGET_ = this.y;
    }

    public void snapSync() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x_TARGET_;
        this.x = this.x_TARGET_;
        this.y_LAST_ = this.y_TARGET_;
        this.y = this.y_TARGET_;
    }

    public void team(Team team) {
        Team last = this.team;
        this.team = team;
        if (this.unit != null) {
            this.unit.team(team);
        }
        Events.fire((Object)new PlayerTeamChangedEvent(last, this));
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void unit(Unit unit) {
        CommandAI ai;
        UnitController unitController;
        if (this.isLocal() && unit == this.justSwitchFrom && this.justSwitchFrom != null && this.justSwitchTo != null) {
            return;
        }
        if (this.unit == unit) {
            return;
        }
        if (unit != null && (unitController = unit.controller()) instanceof CommandAI) {
            ai = (CommandAI)unitController;
            this.lastCommand = ai.command;
        }
        if (this.unit != null) {
            this.unit.resetController();
            if (this.lastCommand != null && (unitController = this.unit.controller()) instanceof CommandAI) {
                ai = (CommandAI)unitController;
                ai.command(this.lastCommand);
            }
        }
        this.unit = unit;
        if (unit != null) {
            unit.team(this.team);
            unit.controller((UnitController)this);
            if (unit.isRemote()) {
                unit.snapInterpolation();
            }
            if (!Vars.headless && this.isLocal()) {
                Vars.control.input.block = null;
            }
        }
        Events.fire((Object)new EventType.UnitChangeEvent(this, unit));
    }

    public void update() {
        if (this.unit != null && !this.unit.isValid()) {
            this.clearUnit();
        }
        if (!this.dead()) {
            this.set((Position)this.unit);
            this.unit.team(this.team);
            this.deathTimer = 0.0f;
            if (this.unit.type.canBoost) {
                this.unit.elevation = Mathf.approachDelta((float)this.unit.elevation, (float)(this.unit.onSolid() || this.boosting || this.unit.isFlying() && !this.unit.canLand() ? 1.0f : 0.0f), (float)this.unit.type.riseSpeed);
            }
        } else {
            CoreBlock.CoreBuild core = this.bestCore();
            if (core != null) {
                this.deathTimer += Time.delta;
                if (this.deathTimer >= 60.0f) {
                    core.requestSpawn(this);
                    this.deathTimer = 0.0f;
                }
            }
        }
        this.textFadeTime -= Time.delta / 300.0f;
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
    }

    public void writeSync(Writes write) {
        write.bool(this.admin);
        write.bool(this.boosting);
        TypeIO.writeColor(write, this.color);
        write.f(this.mouseX);
        write.f(this.mouseY);
        TypeIO.writeString(write, this.name);
        write.bool(this.shooting);
        TypeIO.writeTeam(write, this.team);
        write.bool(this.typing);
        TypeIO.writeUnit(write, this.unit);
        write.f(this.x);
        write.f(this.y);
    }

    public void writeSyncManual(FloatBuffer buffer) {
        buffer.put(this.x);
        buffer.put(this.y);
    }
}

