/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.math.geom.Position;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.Posc;
import mindustry.gen.Teamc;
import mindustry.gen.Unitc;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;

public class PosTeam
implements Entityc,
IndexableEntity__all,
Posc,
Teamc {
    protected transient boolean added;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    public Team team = Team.derelict;
    public float x;
    public float y;

    protected PosTeam() {
    }

    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Nullable
    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return 28;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "PosTeam#" + this.id;
    }

    public Team team() {
        return this.team;
    }

    public void id(int id) {
        this.id = id;
    }

    public void setIndex__all(int index) {
        this.index__all = index;
    }

    public void team(Team team) {
        this.team = team;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public boolean cheating() {
        return this.team.rules().cheat;
    }

    public boolean inFogTo(Team viewer) {
        return this.team != viewer && !Vars.fogControl.isVisible(viewer, this.x, this.y);
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        Unitc u;
        PosTeam posTeam;
        return this == Vars.player || (posTeam = this) instanceof Unitc && (u = (Unitc)posTeam).controller() == Vars.player;
    }

    public boolean isRemote() {
        Unitc u;
        PosTeam posTeam = this;
        return posTeam instanceof Unitc && (u = (Unitc)posTeam).isPlayer() && !this.isLocal();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    public boolean serialize() {
        return true;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int tileX() {
        return World.toTile(this.x);
    }

    public int tileY() {
        return World.toTile(this.y);
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static PosTeam create() {
        return new PosTeam();
    }

    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.added = true;
    }

    public void afterRead() {
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    public void read(Reads read) {
        this.afterRead();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        this.added = false;
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void update() {
    }

    public void write(Writes write) {
    }
}

