/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.LogicAI;
import mindustry.entities.Sized;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Voronoi;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;
import mindustryX.features.RenderExt;

public class OverlayRenderer {
    private static final float indicatorLength = 14.0f;
    private static final float spawnerMargin = 88.0f;
    private static final Rect rect = new Rect();
    private float buildFade;
    private float unitFade;
    private Sized lastSelect;
    private Seq<CoreEdge> cedges = new Seq();
    private boolean updatedCores;

    public OverlayRenderer() {
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.updatedCores = true;
        });
        Events.on(EventType.CoreChangeEvent.class, e -> {
            this.updatedCores = true;
        });
    }

    private void updateCoreEdges() {
        if (!this.updatedCores) {
            return;
        }
        this.updatedCores = false;
        this.cedges.clear();
        Seq pos = new Seq();
        Seq teams = new Seq();
        for (Teams.TeamData team : Vars.state.teams.active) {
            for (CoreBlock.CoreBuild b : team.cores) {
                teams.add((Object)b);
                pos.add((Object)new Vec2(b.x, b.y));
            }
        }
        if (pos.isEmpty()) {
            return;
        }
        Seq result = Voronoi.generate((Vec2[])((Vec2[])pos.toArray(Vec2.class)), (float)0.0f, (float)Vars.world.unitWidth(), (float)0.0f, (float)Vars.world.unitHeight());
        for (Voronoi.GraphEdge edge : result) {
            this.cedges.add((Object)new CoreEdge(edge.x1, edge.y1, edge.x2, edge.y2, ((CoreBlock.CoreBuild)teams.get((int)edge.site1)).team, ((CoreBlock.CoreBuild)teams.get((int)edge.site2)).team));
        }
    }

    public void drawBottom() {
        InputHandler input = Vars.control.input;
        if (Vars.player.dead() && !((Boolean)RenderExt.deadOverlay.get()).booleanValue()) {
            return;
        }
        if (Vars.player.isBuilder()) {
            Vars.player.unit().drawBuildPlans();
        }
        input.drawBottom();
    }

    public void drawTop() {
        Unit unit2;
        Building build;
        Unit unit3;
        Object region;
        Building build2;
        Unitc u;
        InputHandler input;
        Healthc select;
        if (!Vars.player.dead() && Vars.ui.hudfrag.shown) {
            if (Core.settings.getBool("playerindicators")) {
                for (Player player : Groups.player) {
                    if (Vars.player == player || Vars.player.team() != player.team() || rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(player.x, player.y)) continue;
                    Tmp.v1.set((Position)player).sub((Position)Vars.player).setLength(14.0f);
                    Lines.stroke(2.0f, Vars.player.team().color);
                    Lines.lineAngle(Vars.player.x + Tmp.v1.x, Vars.player.y + Tmp.v1.y, Tmp.v1.angle(), 4.0f);
                    Draw.reset();
                }
            }
            if (Core.settings.getBool("indicators") && !Vars.state.rules.fog) {
                Groups.unit.each(unit -> {
                    if (!unit.isLocal() && unit.team != Vars.player.team() && !rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(unit.x, unit.y)) {
                        Tmp.v1.set(unit.x, unit.y).sub((Position)Vars.player).setLength(14.0f);
                        Lines.stroke(1.0f, unit.team().color);
                        Lines.lineAngle(Vars.player.x + Tmp.v1.x, Vars.player.y + Tmp.v1.y, Tmp.v1.angle(), 3.0f);
                        Draw.reset();
                    }
                });
            }
        }
        if ((select = (input = Vars.control.input).selectedUnit()) == null) {
            select = input.selectedControlBuild();
        }
        if (!Core.input.keyDown(Binding.control) || !Vars.state.rules.possessionAllowed) {
            select = null;
        }
        this.unitFade = Mathf.lerpDelta((float)this.unitFade, (float)Mathf.num((select != null ? 1 : 0) != 0), (float)0.1f);
        if (select != null) {
            this.lastSelect = select;
        }
        if (select == null) {
            select = this.lastSelect;
        }
        if (select != null && (!(select instanceof Unitc) || (u = (Unitc)select).isAI())) {
            Building building;
            Draw.mixcol((Color)Pal.accent, (float)1.0f);
            Draw.alpha((float)this.unitFade);
            if (select instanceof BlockUnitc) {
                BlockUnitc b = (BlockUnitc)select;
                building = b.tile();
            } else {
                Building b;
                building = select instanceof Building ? (b = (Building)select) : null;
            }
            build2 = building;
            Object object = region = build2 != null ? build2.block.fullIcon : Core.atlas.white();
            if (select instanceof BlockUnitc) {
                Draw.rect((TextureRegion)region, (float)select.getX(), (float)select.getY());
            }
            for (int i = 0; i < 4; ++i) {
                float rot = (float)i * 90.0f + 45.0f + -Time.time % 360.0f;
                float length = select.hitSize() * 1.5f + this.unitFade * 2.5f;
                Draw.rect((String)"select-arrow", (float)(select.getX() + Angles.trnsx((float)rot, (float)length)), (float)(select.getY() + Angles.trnsy((float)rot, (float)length)), (float)(length / 1.9f), (float)(length / 1.9f), (float)(rot - 135.0f));
            }
            Draw.reset();
        }
        if (input.config.isShown()) {
            Building tile = input.config.getSelected();
            tile.drawConfigure();
        }
        if (!Vars.player.dead() || ((Boolean)RenderExt.deadOverlay.get()).booleanValue()) {
            input.drawTop();
        }
        input.drawUnitSelection();
        if (Vars.player.dead() && !((Boolean)RenderExt.deadOverlay.get()).booleanValue()) {
            return;
        }
        this.buildFade = Mathf.lerpDelta((float)this.buildFade, (float)(input.isPlacing() || input.isUsingSchematic() ? 1.0f : 0.0f), (float)0.06f);
        Draw.reset();
        Lines.stroke(this.buildFade * 2.0f);
        if (this.buildFade > 0.005f) {
            if (Vars.state.rules.polygonCoreProtection) {
                this.updateCoreEdges();
                Draw.color((Color)Pal.accent);
                for (int i = 0; i < 2; ++i) {
                    float offset = i == 0 ? -2.0f : 0.0f;
                    region = this.cedges.iterator();
                    while (region.hasNext()) {
                        CoreEdge edge = (CoreEdge)region.next();
                        Team displayed = edge.displayed();
                        if (displayed == null) continue;
                        Draw.color((Color)(i == 0 ? Color.darkGray : Tmp.c1.set(displayed.color).lerp(Pal.accent, Mathf.absin((float)Time.time, (float)10.0f, (float)0.2f))));
                        Lines.line(edge.x1, edge.y1 + offset, edge.x2, edge.y2 + offset);
                    }
                }
                Draw.color();
            } else {
                Vars.state.teams.eachEnemyCore(Vars.player.team(), core -> {
                    float br = Vars.state.rules.buildRadius(core.team);
                    if (Core.camera.bounds(Tmp.r1).overlaps(Tmp.r2.setCentered(core.x, core.y, br * 2.0f))) {
                        Draw.color((Color)Color.darkGray, (float)0.7f);
                        Lines.circle(core.x, core.y - 2.0f, br);
                        Draw.color((Color)Pal.accent, (Color)core.team.color, (float)(0.2f + Mathf.absin((float)Time.time, (float)10.0f, (float)0.5f)));
                        Lines.circle(core.x, core.y, br);
                    }
                });
                Vars.player.team().cores().each(core -> {
                    float br = Vars.state.rules.buildRadius(core.team);
                    if (Vars.state.rules.pvp && Core.camera.bounds(Tmp.r1).overlaps(Tmp.r2.setCentered(core.x, core.y, Vars.state.rules.enemyCoreBuildRadius * 2.0f))) {
                        Draw.color((Color)Color.darkGray, (float)0.4f);
                        Lines.circle(core.x, core.y - 2.0f, br);
                        Draw.color((Color)Pal.accent, (Color)core.team.color, (float)(0.0f + Mathf.absin((float)Time.time, (float)10.0f, (float)0.5f)));
                        Lines.circle(core.x, core.y, br);
                    }
                });
            }
        }
        Lines.stroke(2.0f);
        Draw.color((Color)Color.gray, (Color)Color.lightGray, (float)Mathf.absin((float)Time.time, (float)8.0f, (float)1.0f));
        if (Vars.state.hasSpawns()) {
            for (Tile tile : Vars.spawner.getSpawns()) {
                if (!tile.within(Vars.player.x, Vars.player.y, Vars.state.rules.dropZoneRadius + 88.0f)) continue;
                Draw.alpha((float)Mathf.clamp((float)(1.0f - (Vars.player.dst((Position)tile) - Vars.state.rules.dropZoneRadius) / 88.0f)));
                Lines.dashCircle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius);
            }
        }
        Draw.reset();
        if (input.block == null && !Core.scene.hasMouse()) {
            Vec2 vec = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            build2 = Vars.world.buildWorld(vec.x, vec.y);
            if (build2 != null) {
                build2.drawSelect();
                if (!build2.enabled && build2.block.drawDisabled) {
                    build2.drawDisabled();
                }
            }
            if (build2 != null && build2.team == Vars.player.team() && Core.input.keyDown(Binding.rotatePlaced) && build2.block.rotate && build2.block.quickRotate && build2.interactable(Vars.player.team())) {
                Vars.control.input.drawArrow(build2.block, build2.tileX(), build2.tileY(), build2.rotation, true);
                Draw.color((Color)Pal.accent, (float)(0.3f + Mathf.absin((float)4.0f, (float)0.2f)));
                Fill.square((float)build2.x, (float)build2.y, (float)((float)(build2.block.size * 8) / 2.0f));
                Draw.color();
            }
        }
        input.drawOverSelect();
        build2 = Vars.ui.hudfrag.blockfrag.hover();
        if (build2 instanceof Unit) {
            Unit unit4 = (Unit)((Object)build2);
            Draw.color((Color)unit4.team.color);
            Lines.dashCircle(unit4.x, unit4.y, unit4.type.range);
            Draw.color();
        }
        if ((region = Vars.ui.hudfrag.blockfrag.hover()) instanceof Unit && (region = (unit3 = (Unit)region).controller()) instanceof LogicAI) {
            LogicAI ai = (LogicAI)region;
            if (ai.controller != null && ai.controller.isValid() && (Vars.state.isEditor() || !ai.controller.block.privileged)) {
                build = ai.controller;
                Drawf.square((float)build.x, (float)build.y, (float)((float)(build.block.size * 8) / 2.0f + 2.0f));
                if (!unit3.within((Position)build, unit3.hitSize * 2.0f)) {
                    Drawf.arrow((float)unit3.x, (float)unit3.y, (float)build.x, (float)build.y, (float)(unit3.hitSize * 2.0f), (float)4.0f);
                }
                Draw.color((Color)Pal.accent);
                Lines.line(unit3.x, unit3.y, build.x, build.y);
                Draw.color();
            }
        }
        if (input.isDroppingItem()) {
            Vec2 v = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            float size = 8.0f;
            Draw.rect((TextureRegion)Vars.player.unit().item().fullIcon, (float)v.x, (float)v.y, (float)size, (float)size);
            Draw.color((Color)Pal.accent);
            Lines.circle(v.x, v.y, 6.0f + Mathf.absin((float)Time.time, (float)5.0f, (float)1.0f));
            Draw.reset();
            build = Vars.world.buildWorld(v.x, v.y);
            if (input.canDropItem() && build != null && build.interactable(Vars.player.team()) && build.acceptStack(Vars.player.unit().item(), Vars.player.unit().stack.amount, Vars.player.unit()) > 0 && Vars.player.within((Position)build, 220.0f) && input.itemDepositCooldown <= 0.0f) {
                boolean invalid = !build.allowDeposit();
                Lines.stroke(3.0f, Pal.gray);
                Lines.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 3.0f + Mathf.absin((float)Time.time, (float)5.0f, (float)1.0f));
                Lines.stroke(1.0f, invalid ? Pal.remove : Pal.place);
                Lines.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 2.0f + Mathf.absin((float)Time.time, (float)5.0f, (float)1.0f));
                Draw.reset();
                if (invalid) {
                    build.block.drawPlaceText(Core.bundle.get("bar.onlycoredeposit"), build.tileX(), build.tileY(), false);
                }
            }
        }
        if ((unit2 = Vars.player.unit()) instanceof BlockUnitc) {
            BlockUnitc unitc = (BlockUnitc)unit2;
            unitc.tile().drawSelect();
        }
    }

    public void checkApplySelection(Unit u) {
        if (this.unitFade > 0.001f && this.lastSelect == u) {
            Color prev = Draw.getMixColor();
            Draw.mixcol((Color)(prev.a > 0.001f ? prev.lerp(Pal.accent, this.unitFade) : Pal.accent), (float)Math.max(this.unitFade, prev.a));
        }
    }

    private static class CoreEdge {
        float x1;
        float y1;
        float x2;
        float y2;
        Team t1;
        Team t2;

        public CoreEdge(float x1, float y1, float x2, float y2, Team t1, Team t2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.t1 = t1;
            this.t2 = t2;
        }

        @Nullable
        Team displayed() {
            return this.t1 == this.t2 ? null : (this.t1 == Vars.player.team() ? this.t2 : (this.t2 == Vars.player.team() ? this.t1 : (this.t2.id == 0 ? this.t1 : (this.t1.id < this.t2.id && this.t1.id != 0 ? this.t1 : this.t2))));
        }
    }
}

