/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.assets.AssetLoaderParameters;
import arc.assets.loaders.TextureLoader;
import arc.files.Fi;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.scene.ui.layout.Scl;
import arc.struct.FloatSeq;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.graphics.Shaders;
import mindustryX.VarsX;

public class Shaders {
    public static BlockBuildShader blockbuild;
    @Nullable
    public static ShieldShader shield;
    public static BuildBeamShader buildBeam;
    public static UnitBuildShader build;
    public static UnitArmorShader armor;
    public static DarknessShader darkness;
    public static FogShader fog;
    public static LightShader light;
    public static SurfaceShader water;
    public static SurfaceShader mud;
    public static SurfaceShader tar;
    public static SurfaceShader slag;
    public static SurfaceShader cryofluid;
    public static SurfaceShader space;
    public static SurfaceShader caustics;
    public static SurfaceShader arkycite;
    public static PlanetShader planet;
    public static CloudShader clouds;
    public static PlanetGridShader planetGrid;
    public static AtmosphereShader atmosphere;
    public static ShockwaveShader shockwave;
    public static MeshShader mesh;
    public static Shader unlit;
    public static Shader unlitWhite;
    public static Shader screenspace;

    public static void init() {
        mesh = new MeshShader();
        blockbuild = new BlockBuildShader();
        try {
            shield = new ShieldShader();
        }
        catch (Throwable t) {
            shield = null;
            t.printStackTrace();
        }
        fog = new FogShader();
        buildBeam = new BuildBeamShader();
        build = new UnitBuildShader();
        armor = new UnitArmorShader();
        darkness = new DarknessShader();
        light = new LightShader();
        water = new SurfaceShader("water");
        arkycite = new SurfaceShader("arkycite");
        mud = new SurfaceShader("mud");
        tar = new SurfaceShader("tar");
        slag = new SurfaceShader("slag");
        cryofluid = new SurfaceShader("cryofluid");
        space = new SpaceShader("space");
        caustics = new /* Unavailable Anonymous Inner Class!! */;
        planet = new PlanetShader();
        clouds = new CloudShader();
        planetGrid = new PlanetGridShader();
        atmosphere = new AtmosphereShader();
        unlit = new LoadShader("planet", "unlit");
        unlitWhite = new LoadShader("planet", "unlitwhite");
        screenspace = new LoadShader("screenspace", "screenspace");
    }

    public static Fi getShaderFi(String file) {
        return Vars.tree.get("shaders/" + file);
    }

    public static class ShieldShader
    extends LoadShader {
        public ShieldShader() {
            super("shield", "screenspace");
        }

        public void apply() {
            this.setUniformf("u_dp", Scl.scl((float)1.0f));
            this.setUniformf("u_time", Time.time / Scl.scl((float)1.0f));
            this.setUniformf("u_static", (Boolean)VarsX.staticShieldsBorder.get() != false ? 1.0f : 0.0f);
            this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
            this.setUniformf("u_invsize", 1.0f / Core.camera.width, 1.0f / Core.camera.height);
        }
    }

    public static class BuildBeamShader
    extends LoadShader {
        public BuildBeamShader() {
            super("buildbeam", "screenspace");
        }

        public void apply() {
            this.setUniformf("u_dp", Scl.scl((float)1.0f));
            this.setUniformf("u_time", Time.time / Scl.scl((float)1.0f));
            this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
            this.setUniformf("u_invsize", 1.0f / Core.camera.width, 1.0f / Core.camera.height);
        }
    }

    public static class SurfaceShader
    extends Shader {
        Texture noiseTex;

        public SurfaceShader(String frag) {
            super(Shaders.getShaderFi("screenspace.vert"), Shaders.getShaderFi(frag + ".frag"));
            this.loadNoise();
        }

        public SurfaceShader(String vertRaw, String fragRaw) {
            super(vertRaw, fragRaw);
            this.loadNoise();
        }

        public String textureName() {
            return "noise";
        }

        public void loadNoise() {
            Core.assets.load((String)new StringBuilder().append((String)"sprites/").append((String)this.textureName()).append((String)".png").toString(), Texture.class).loaded = t -> {
                t.setFilter(Texture.TextureFilter.linear);
                t.setWrap(Texture.TextureWrap.repeat);
            };
        }

        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
            this.setUniformf("u_time", Time.time);
            if (this.hasUniform("u_noise")) {
                if (this.noiseTex == null) {
                    this.noiseTex = (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class);
                }
                this.noiseTex.bind(1);
                ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                this.setUniformi("u_noise", 1);
            }
        }
    }

    public static class SpaceShader
    extends SurfaceShader {
        Texture texture;

        public SpaceShader(String frag) {
            super(frag);
            Core.assets.load((String)"sprites/space.png", Texture.class, (AssetLoaderParameters)new TextureLoader.TextureParameter(){
                {
                    this.magFilter = Texture.TextureFilter.linear;
                    this.minFilter = Texture.TextureFilter.mipMapLinearLinear;
                    this.wrapU = this.wrapV = Texture.TextureWrap.mirroredRepeat;
                    this.genMipMaps = true;
                }
            }).loaded = t -> {
                this.texture = t;
            };
        }

        @Override
        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x, Core.camera.position.y);
            this.setUniformf("u_ccampos", Core.camera.position);
            this.setUniformf("u_resolution", Core.graphics.getWidth(), Core.graphics.getHeight());
            this.setUniformf("u_time", Time.time);
            this.texture.bind(1);
            ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
            this.setUniformi("u_stars", 1);
        }
    }

    public static class LoadShader
    extends Shader {
        public LoadShader(String frag, String vert) {
            super(Shaders.getShaderFi(vert + ".vert"), Shaders.getShaderFi(frag + ".frag"));
        }
    }

    public static class ShockwaveShader
    extends LoadShader {
        static final int max = 64;
        static final int size = 5;
        protected FloatSeq data = new FloatSeq();
        protected FloatSeq uniforms = new FloatSeq();
        protected boolean hadAny = false;
        protected FrameBuffer buffer = new FrameBuffer();
        public float lifetime = 20.0f;

        public ShockwaveShader() {
            super("shockwave", "screenspace");
            Events.run((Object)EventType.Trigger.update, () -> {
                if (Vars.state.isPaused()) {
                    return;
                }
                if (Vars.state.isMenu()) {
                    this.data.size = 0;
                    return;
                }
                float[] items = this.data.items;
                for (int i = 0; i < this.data.size; i += 5) {
                    int n = i + 3;
                    items[n] = items[n] - Time.delta / items[i + 4];
                    if (!(items[i + 3] <= 0.0f)) continue;
                    if (this.data.size > 5) {
                        System.arraycopy(items, this.data.size - 5, items, i, 5);
                    }
                    this.data.size -= 5;
                    i -= 5;
                }
            });
            Events.run((Object)EventType.Trigger.preDraw, () -> {
                boolean bl = this.hadAny = this.data.size > 0;
                if (this.hadAny) {
                    this.buffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                    this.buffer.begin(Color.clear);
                }
            });
            Events.run((Object)EventType.Trigger.postDraw, () -> {
                if (this.hadAny) {
                    this.buffer.end();
                    Draw.blend((Blending)Blending.disabled);
                    this.buffer.blit((Shader)this);
                    Draw.blend();
                }
            });
        }

        public void apply() {
            int count = this.data.size / 5;
            this.setUniformi("u_shockwave_count", count);
            if (count > 0) {
                this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
                this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
                this.uniforms.clear();
                float[] items = this.data.items;
                for (int i = 0; i < count; ++i) {
                    int offset = i * 5;
                    this.uniforms.add(items[offset], items[offset + 1], items[offset + 2] * (1.0f - items[offset + 3]), items[offset + 3]);
                }
                this.setUniform4fv("u_shockwaves", this.uniforms.items, 0, this.uniforms.size);
            }
        }

        public void add(float x, float y, float radius) {
            this.add(x, y, radius, 20.0f);
        }

        public void add(float x, float y, float radius, float lifetime) {
            if (this.data.size / 5 >= 64) {
                float[] items = this.data.items;
                items[0] = x;
                items[1] = y;
                items[2] = radius;
                items[3] = 1.0f;
                items[4] = lifetime;
            } else {
                this.data.addAll(new float[]{x, y, radius, 1.0f, lifetime});
            }
        }
    }
}

