/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.layout.Table;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.input.PlaceMode;
import mindustry.ui.Styles;
import mindustry.world.Tile;
import mindustryX.features.LogicExt;
import mindustryX.features.RenderExt;

public class DesktopInput
extends InputHandler {
    public Vec2 movement = new Vec2();
    public Graphics.Cursor cursorType = Graphics.Cursor.SystemCursor.arrow;
    public int selectX = -1;
    public int selectY = -1;
    public int schemX = -1;
    public int schemY = -1;
    public int lastLineX;
    public int lastLineY;
    public int schematicX;
    public int schematicY;
    public PlaceMode mode;
    public float selectScale;
    @Nullable
    public BuildPlan splan;
    public boolean deleting = false;
    public boolean shouldShoot = false;
    public boolean panning = false;
    public boolean movedPlan = false;
    public float panScale = 0.005f;
    public float panSpeed = 4.5f;
    public float panBoostSpeed = 15.0f;
    public long selectMillis = 0L;
    public Tile prevSelected;
    public int lastCtrlGroup;
    public long lastCtrlGroupSelectMillis;
    public long lastPayloadKeyTapMillis;
    public long lastPayloadKeyHoldMillis;
    private float buildPlanMouseOffsetX;
    private float buildPlanMouseOffsetY;
    private boolean changedCursor;
    private boolean pressedCommandRect;
    @Nullable
    public Teamc target;

    boolean showHint() {
        return Vars.ui.hudfrag.shown && Core.settings.getBool("hints") && this.selectPlans.isEmpty() && !Vars.player.dead() && (!this.isBuilding && !Core.settings.getBool("buildautopause") || Vars.player.unit().isBuilding() || !Vars.player.dead() && !Vars.player.unit().spawnedByCore());
    }

    @Override
    public void reset() {
        super.reset();
        this.shouldShoot = false;
        this.deleting = false;
    }

    @Override
    public void buildUI(Group group) {
        group.fill(t -> {
            t.color.a = 0.0f;
            t.visible(() -> {
                float f;
                t.color.a = Mathf.lerpDelta((float)t.color.a, (float)Mathf.num((boolean)this.showHint()), (float)0.15f);
                return f > 0.001f;
            });
            t.bottom();
            t.table(Styles.black6, b -> {
                StringBuilder str = new StringBuilder();
                b.defaults().left();
                b.label(() -> {
                    if (!this.showHint()) {
                        return str;
                    }
                    str.setLength(0);
                    if (!(this.isBuilding || Core.settings.getBool("buildautopause") || Vars.player.unit().isBuilding())) {
                        str.append(Core.bundle.format("enablebuilding", new Object[]{Binding.pauseBuilding.value.key.toString()}));
                    } else if (Vars.player.unit().isBuilding()) {
                        str.append(Core.bundle.format(this.isBuilding ? "pausebuilding" : "resumebuilding", new Object[]{Binding.pauseBuilding.value.key.toString()})).append("\n").append(Core.bundle.format("cancelbuilding", new Object[]{Binding.clearBuilding.value.key.toString()})).append("\n").append(Core.bundle.format("selectschematic", new Object[]{Binding.schematicSelect.value.key.toString()}));
                    }
                    if (!Vars.player.dead() && !Vars.player.unit().spawnedByCore()) {
                        str.append(str.length() != 0 ? "\n" : "").append(Core.bundle.format("respawn", new Object[]{Binding.respawn.value.key.toString()}));
                    }
                    return str;
                }).style((Style)Styles.outlineLabel);
            }).margin(10.0f);
        });
        group.fill(t -> {
            t.visible(() -> Vars.ui.hudfrag.shown && this.lastSchematic != null && !this.selectPlans.isEmpty());
            t.bottom();
            t.table(Styles.black6, b -> {
                b.defaults().left();
                b.label(() -> Core.bundle.format("schematic.flip", new Object[]{Binding.schematicFlipX.value.key.toString(), Binding.schematicFlipY.value.key.toString()})).style((Style)Styles.outlineLabel).visible(() -> Core.settings.getBool("hints"));
                b.row();
                b.table(a -> a.button("@schematic.add", (Drawable)Icon.save, this::showSchematicSave).colspan(2).size(250.0f, 50.0f).disabled(f -> this.lastSchematic == null || this.lastSchematic.file != null));
                b.row();
                b.table(a -> a.button("@schematic.preview", (Drawable)Icon.info, this::showSchematicPreview).colspan(2).size(250.0f, 50.0f).disabled(f -> this.lastSchematic == null || this.lastSchematic.file != null));
            }).margin(6.0f);
        });
    }

    @Override
    public void drawTop() {
        if (this.cursorType != Graphics.Cursor.SystemCursor.arrow && Core.scene.hasMouse()) {
            this.cursorType = Graphics.Cursor.SystemCursor.arrow;
            Core.graphics.cursor(this.cursorType);
        }
        Lines.stroke(1.0f);
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (this.mode == PlaceMode.breaking) {
            this.drawBreakSelection(this.selectX, this.selectY, cursorX, cursorY, !Core.input.keyDown(Binding.schematicSelect) || this.schemX == -1 || this.schemY == -1 ? 100 : Vars.maxSchematicSize, false);
        }
        if (!Core.scene.hasKeyboard() && this.mode != PlaceMode.breaking) {
            if (Core.input.keyDown(Binding.schematicSelect) && this.schemX != -1 && this.schemY != -1) {
                this.drawSelection(this.schemX, this.schemY, cursorX, cursorY, Vars.maxSchematicSize);
            } else if (Core.input.keyDown(Binding.rebuildSelect)) {
                this.drawRebuildSelection(this.schemX, this.schemY, cursorX, cursorY);
            }
        }
        Draw.reset();
    }

    @Override
    public void drawBottom() {
        BuildPlan plan;
        int i;
        BuildPlan plan2;
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (this.splan != null) {
            boolean valid = this.validPlace(this.splan.x, this.splan.y, this.splan.block, this.splan.rotation, this.splan);
            if (this.splan.block.rotate && this.splan.block.drawArrow) {
                this.drawArrow(this.splan.block, this.splan.x, this.splan.y, this.splan.rotation, valid);
            }
            this.splan.block.drawPlan(this.splan, this.allPlans(), valid);
            this.drawSelected(this.splan.x, this.splan.y, this.splan.block, this.getPlan(this.splan.x, this.splan.y, this.splan.block.size, this.splan) != null ? Pal.remove : Pal.accent);
        }
        if (this.mode == PlaceMode.none && !this.isPlacing() && (plan2 = this.getPlan(cursorX, cursorY)) != null) {
            this.drawSelected(plan2.x, plan2.y, plan2.breaking ? plan2.tile().block() : plan2.block, Pal.accent);
        }
        BuildPlan[] items = (BuildPlan[])this.selectPlans.items;
        int size = this.selectPlans.size;
        for (i = 0; i < size; ++i) {
            plan = items[i];
            plan.animScale = 1.0f;
            this.drawPlan(plan);
        }
        for (i = 0; i < size; ++i) {
            plan = items[i];
            this.drawOverPlan(plan, plan.cachedValid);
        }
        if (Vars.player.isBuilder()) {
            if (this.mode == PlaceMode.placing && this.block != null) {
                for (i = 0; i < this.linePlans.size; ++i) {
                    plan = (BuildPlan)this.linePlans.get(i);
                    if (i == this.linePlans.size - 1 && plan.block.rotate && plan.block.drawArrow) {
                        this.drawArrow(this.block, plan.x, plan.y, plan.rotation);
                    }
                    this.drawPlan((BuildPlan)this.linePlans.get(i));
                }
                this.linePlans.each(this::drawOverPlan);
            } else if (this.isPlacing()) {
                int rot;
                int n = rot = this.block == null ? this.rotation : this.block.planRotation(this.rotation);
                if (this.block.rotate && this.block.drawArrow) {
                    this.drawArrow(this.block, cursorX, cursorY, rot);
                }
                Draw.color();
                boolean valid = this.validPlace(cursorX, cursorY, this.block, rot);
                this.drawPlan(cursorX, cursorY, this.block, rot);
                this.block.drawPlace(cursorX, cursorY, rot, valid);
                if (this.block.saveConfig) {
                    Draw.mixcol((Color)(!valid ? Pal.breakInvalid : Color.white), (float)((!valid ? 0.4f : 0.24f) + Mathf.absin((float)Time.globalTime, (float)6.0f, (float)0.28f)));
                    this.bplan.set(cursorX, cursorY, rot, this.block);
                    this.bplan.config = this.block.lastConfig;
                    this.block.drawPlanConfig(this.bplan, this.allPlans());
                    this.bplan.config = null;
                    Draw.reset();
                }
                this.drawOverlapCheck(this.block, cursorX, cursorY, valid);
            }
        }
        Draw.reset();
    }

    @Override
    public void update() {
        Tile selected;
        super.update();
        if (Vars.net.active() && Core.input.keyTap(Binding.playerList) && (Core.scene.getKeyboardFocus() == null || Core.scene.getKeyboardFocus().isDescendantOf((Element)Vars.ui.listfrag.content) || Core.scene.getKeyboardFocus().isDescendantOf(Vars.ui.minimapfrag.elem))) {
            Vars.ui.listfrag.toggle();
        }
        boolean locked = this.locked();
        boolean panCam = false;
        float camSpeed = (!Core.input.keyDown(Binding.boost) ? this.panSpeed : this.panBoostSpeed) * Time.delta;
        boolean detached = Core.settings.getBool("detach-camera", false);
        if (!Core.scene.hasField() && !Core.scene.hasDialog()) {
            if (Core.input.keyTap(Binding.debugHitboxes)) {
                boolean bl = Vars.drawDebugHitboxes = !Vars.drawDebugHitboxes;
            }
            if (Core.input.keyTap(Binding.detachCamera)) {
                detached = !detached;
                Core.settings.put("detach-camera", (Object)detached);
                if (!detached) {
                    this.panning = false;
                }
                this.spectating = null;
            }
            if (Core.input.keyDown(Binding.pan)) {
                panCam = true;
                this.panning = true;
                this.spectating = null;
            }
            if (Math.abs(Core.input.axis(Binding.moveX)) > 0.0f || Math.abs(Core.input.axis(Binding.moveY)) > 0.0f || Core.input.keyDown(Binding.mouseMove)) {
                this.panning = false;
                this.spectating = null;
            }
        }
        this.panning |= detached;
        if (!locked) {
            if ((Vars.player.dead() || Vars.state.isPaused() || detached) && !Vars.ui.chatfrag.shown() && !Core.scene.hasField() && !Core.scene.hasDialog()) {
                if (Core.input.keyDown(Binding.mouseMove)) {
                    panCam = true;
                }
                Core.camera.position.add(Tmp.v1.setZero().add(Core.input.axis(Binding.moveX), Core.input.axis(Binding.moveY)).nor().scl(camSpeed));
            } else if (!(Vars.player.dead() && this.spectating == null || this.panning)) {
                Player coreTarget;
                Team corePanTeam = Vars.state.won ? Vars.state.rules.waveTeam : Vars.player.team();
                Object object = coreTarget = Vars.state.gameOver && !Vars.state.rules.pvp && corePanTeam.data().lastCore != null ? corePanTeam.data().lastCore : null;
                Player panTarget = coreTarget != null ? coreTarget : (this.spectating != null ? this.spectating : Vars.player);
                Core.camera.position.lerpDelta((Position)panTarget, Core.settings.getBool("smoothcamera") ? 0.08f : 1.0f);
            }
            if (panCam) {
                Core.camera.position.x += Mathf.clamp((float)(((float)Core.input.mouseX() - (float)Core.graphics.getWidth() / 2.0f) * this.panScale), (float)-1.0f, (float)1.0f) * camSpeed;
                Core.camera.position.y += Mathf.clamp((float)(((float)Core.input.mouseY() - (float)Core.graphics.getHeight() / 2.0f) * this.panScale), (float)-1.0f, (float)1.0f) * camSpeed;
            }
        }
        boolean bl = this.shouldShoot = !Core.scene.hasMouse() && !locked && !Vars.state.isEditor();
        if (!(locked || this.block != null || Core.scene.hasField() || Core.scene.hasDialog() || !Vars.player.dead() && Vars.player.unit().type.canBoost && Binding.commandMode.value.key == Binding.boost.value.key)) {
            if (Core.settings.getBool("commandmodehold")) {
                this.commandMode = Core.input.keyDown(Binding.commandMode);
            } else if (Core.input.keyTap(Binding.commandMode)) {
                this.commandMode = !this.commandMode;
            }
        } else {
            this.commandMode = false;
        }
        this.selectedUnits.removeAll(u -> !u.allowCommand() || !u.isValid() || u.team != Vars.player.team());
        if (this.commandMode && !Core.scene.hasField() && !Core.scene.hasDialog()) {
            if (Core.input.keyTap(Binding.selectAllUnits)) {
                this.selectedUnits.clear();
                this.commandBuildings.clear();
                if (Core.input.keyDown(Binding.selectAcrossScreen)) {
                    Core.camera.bounds(Tmp.r1);
                    this.selectedUnits.set(this.selectedCommandUnits(Tmp.r1.x, Tmp.r1.y, Tmp.r1.width, Tmp.r1.height).removeAll(u -> !u.type.controlSelectGlobal));
                } else {
                    for (Unit unit : Vars.player.team().data().units) {
                        if (!unit.isCommandable() || !unit.type.controlSelectGlobal) continue;
                        this.selectedUnits.add((Object)unit);
                    }
                }
            }
            if (Core.input.keyTap(Binding.selectAllUnitTransport)) {
                this.selectedUnits.clear();
                this.commandBuildings.clear();
                if (Core.input.keyDown(Binding.selectAcrossScreen)) {
                    Core.camera.bounds(Tmp.r1);
                    this.selectedUnits.set(this.selectedCommandUnits(Tmp.r1.x, Tmp.r1.y, Tmp.r1.width, Tmp.r1.height, (Boolf<Unit>)((Boolf)u -> u instanceof Payloadc)));
                } else {
                    for (Unit unit : Vars.player.team().data().units) {
                        if (!unit.isCommandable() || !(unit instanceof Payloadc)) continue;
                        this.selectedUnits.add((Object)unit);
                    }
                }
            }
            if (Core.input.keyTap(Binding.selectAllUnitFactories)) {
                this.selectedUnits.clear();
                this.commandBuildings.clear();
                for (Building build : Vars.player.team().data().buildings) {
                    if (!build.isCommandable()) continue;
                    this.commandBuildings.add((Object)build);
                }
                if (Core.input.keyDown(Binding.selectAcrossScreen)) {
                    Core.camera.bounds(Tmp.r1);
                    this.commandBuildings.retainAll(b -> Tmp.r1.overlaps(b.x - b.hitSize() / 2.0f, b.y - b.hitSize() / 2.0f, b.hitSize(), b.hitSize()));
                }
            }
            for (int i = 0; i < controlGroupBindings.length; ++i) {
                if (!Core.input.keyTap(controlGroupBindings[i])) continue;
                if (this.controlGroups[i] == null) {
                    this.controlGroups[i] = new IntSeq();
                }
                IntSeq group = this.controlGroups[i];
                boolean creating = Core.input.keyDown(Binding.createControlGroup);
                if (creating) {
                    group.clear();
                    IntSeq selectedUnitIds = this.selectedUnits.mapInt(u -> u.id);
                    if (Core.settings.getBool("distinctcontrolgroups", true)) {
                        for (IntSeq cg : this.controlGroups) {
                            if (cg == null) continue;
                            cg.removeAll(selectedUnitIds);
                        }
                    }
                    group.addAll(selectedUnitIds);
                }
                for (int j = 0; j < group.size; ++j) {
                    Unit u2 = (Unit)Groups.unit.getByID(group.get(j));
                    if (u2 != null && u2.isCommandable() && u2.isValid()) continue;
                    group.removeIndex(j);
                    --j;
                }
                if (group.isEmpty() || creating) continue;
                this.selectedUnits.clear();
                this.commandBuildings.clear();
                group.each(id -> {
                    Unit unit = (Unit)Groups.unit.getByID(id);
                    if (unit != null) {
                        this.selectedUnits.addAll((Object[])new Unit[]{unit});
                    }
                });
                if (this.lastCtrlGroup == i && Time.timeSinceMillis((long)this.lastCtrlGroupSelectMillis) < 400L) {
                    float totalX = 0.0f;
                    float totalY = 0.0f;
                    for (Unit unit : this.selectedUnits) {
                        totalX += unit.x;
                        totalY += unit.y;
                    }
                    this.panning = true;
                    Core.camera.position.set(totalX / (float)this.selectedUnits.size, totalY / (float)this.selectedUnits.size);
                }
                this.lastCtrlGroup = i;
                this.lastCtrlGroupSelectMillis = Time.millis();
            }
        }
        if (!Core.scene.hasMouse() && !locked && Vars.state.rules.possessionAllowed && Core.input.keyDown(Binding.control) && Core.input.keyTap(Binding.select)) {
            Building build;
            Unit on = this.selectedUnit();
            build = this.selectedControlBuild();
            if (on != null) {
                Call.unitControl((Player)Vars.player, (Unit)on);
                this.shouldShoot = false;
                this.recentRespawnTimer = 1.0f;
            } else if (build != null) {
                Call.buildingControlSelect((Player)Vars.player, (Building)build);
                this.recentRespawnTimer = 1.0f;
            }
        }
        if (!(Vars.player.dead() || Vars.state.isPaused() || Core.scene.hasField() || locked)) {
            if (!LogicExt.noUpdatePlayerMovement) {
                this.updateMovement(Vars.player.unit());
            }
            if (Core.input.keyTap(Binding.respawn)) {
                this.controlledType = null;
                this.recentRespawnTimer = 1.0f;
                Call.unitClear((Player)Vars.player);
            }
        }
        if (Vars.state.isGame() && !Core.scene.hasDialog() && !Core.scene.hasField()) {
            if (Core.input.keyTap(Binding.minimap)) {
                Vars.ui.minimapfrag.toggle();
            }
            if (Core.input.keyTap(Binding.planetMap) && Vars.state.isCampaign()) {
                Vars.ui.planet.toggle();
            }
            if (Core.input.keyTap(Binding.research) && Vars.state.isCampaign()) {
                Vars.ui.research.toggle();
            }
            if (Core.input.keyTap(Binding.schematicMenu)) {
                Vars.ui.schematics.toggle();
            }
            if (Core.input.keyTap(Binding.toggleBlockStatus)) {
                Core.settings.put("blockstatus", (Object)(!Core.settings.getBool("blockstatus") ? 1 : 0));
            }
            if (Core.input.keyTap(Binding.togglePowerLines)) {
                if (Core.settings.getInt("lasersopacity") == 0) {
                    Core.settings.put("lasersopacity", (Object)Core.settings.getInt("preferredlaseropacity", 100));
                } else {
                    Core.settings.put("preferredlaseropacity", (Object)Core.settings.getInt("lasersopacity"));
                    Core.settings.put("lasersopacity", (Object)0);
                }
            }
        }
        if (Vars.state.isMenu() || Core.scene.hasDialog()) {
            return;
        }
        if (!(Core.scene.hasScroll() && !Core.input.keyDown(Binding.diagonalPlacement) || Vars.ui.chatfrag.shown() || Vars.ui.consolefrag.shown() || !(Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f) || Core.input.keyDown(Binding.rotatePlaced) || !Core.input.keyDown(Binding.diagonalPlacement) && Binding.zoom.value.equals((Object)Binding.rotate.value) && (Vars.player.isBuilder() && this.isPlacing() && this.block.rotate || !this.selectPlans.isEmpty()))) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse() && (selected = Vars.world.tileWorld(Core.input.mouseWorldX(), Core.input.mouseWorldY())) != null) {
            Call.tileTap((Player)Vars.player, (Tile)selected);
        }
        if (Core.input.keyRelease(Binding.select) && this.commandRect) {
            this.selectUnitsRect();
        }
        if (Vars.player.dead() || locked) {
            this.cursorType = Graphics.Cursor.SystemCursor.arrow;
            if (!locked) {
                this.pollInputNoPlayer();
                if (((Boolean)RenderExt.deadOverlay.get()).booleanValue()) {
                    this.pollInputPlayer();
                }
            }
        } else {
            this.pollInputPlayer();
        }
        if (Core.input.keyRelease(Binding.select) && !LogicExt.noUpdatePlayerMovement) {
            Vars.player.shooting = false;
        }
        if (!Core.scene.hasMouse() && !Vars.ui.minimapfrag.shown()) {
            Core.graphics.cursor(this.cursorType);
            this.changedCursor = this.cursorType != Graphics.Cursor.SystemCursor.arrow;
        } else {
            this.cursorType = Graphics.Cursor.SystemCursor.arrow;
            if (this.changedCursor) {
                Core.graphics.cursor((Graphics.Cursor)Graphics.Cursor.SystemCursor.arrow);
                this.changedCursor = false;
            }
        }
    }

    @Override
    public void useSchematic(Schematic schem, boolean checkHidden) {
        this.block = null;
        this.schematicX = this.tileX(this.getMouseX());
        this.schematicY = this.tileY(this.getMouseY());
        this.selectPlans.clear();
        this.selectPlans.addAll(Vars.schematics.toPlans(schem, this.schematicX, this.schematicY, checkHidden));
        this.mode = PlaceMode.none;
    }

    @Override
    public boolean isBreaking() {
        return this.mode == PlaceMode.breaking;
    }

    @Override
    public void buildPlacementUI(Table table2) {
        table2.left().margin(0.0f).defaults().size(48.0f).left();
        table2.button((Drawable)Icon.paste, Styles.clearNonei, () -> Vars.ui.schematics.show()).tooltip("@schematics");
        table2.button((Drawable)Icon.book, Styles.clearNonei, () -> Vars.ui.database.show()).tooltip("@database");
        table2.button((Drawable)Icon.tree, Styles.clearNonei, () -> Vars.ui.research.show()).visible(() -> Vars.state.isCampaign()).tooltip("@research");
        table2.button((Drawable)Icon.map, Styles.clearNonei, () -> Vars.ui.planet.show()).visible(() -> Vars.state.isCampaign()).tooltip("@planetmap");
    }

    void pollInputNoPlayer() {
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse()) {
            this.tappedOne = false;
            Tile selected = this.tileAt(Core.input.mouseX(), Core.input.mouseY());
            if (this.commandMode) {
                this.commandRect = true;
                this.commandRectX = Core.input.mouseWorldX();
                this.commandRectY = Core.input.mouseWorldY();
            } else if (selected != null) {
                this.tileTapped(selected.build);
            }
        }
    }

    void pollInputPlayer() {
        int index;
        BuildPlan plan;
        if (Core.scene.hasField()) {
            return;
        }
        Tile selected = this.tileAt(Core.input.mouseX(), Core.input.mouseY());
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        int rawCursorX = World.toTile(Core.input.mouseWorld().x);
        int rawCursorY = World.toTile(Core.input.mouseWorld().y);
        if (!Vars.player.dead() && Core.settings.getBool("buildautopause") && this.isBuilding && !Vars.player.unit().isBuilding()) {
            this.isBuilding = false;
            this.buildWasAutoPaused = true;
        }
        if (!this.selectPlans.isEmpty()) {
            int shiftX = rawCursorX - this.schematicX;
            int shiftY = rawCursorY - this.schematicY;
            this.selectPlans.each(s -> {
                s.x += shiftX;
                s.y += shiftY;
            });
            this.schematicX += shiftX;
            this.schematicY += shiftY;
        }
        if (!Vars.player.dead() && Core.input.keyTap(Binding.deselect) && !Vars.ui.minimapfrag.shown() && !this.isPlacing() && Vars.player.unit().plans.isEmpty() && !this.commandMode) {
            Vars.player.unit().mineTile = null;
        }
        if (Core.input.keyTap(Binding.clearBuilding) && !Vars.player.dead()) {
            Vars.player.unit().clearBuilding();
        }
        if ((Core.input.keyTap(Binding.schematicSelect) || Core.input.keyTap(Binding.rebuildSelect)) && !Core.scene.hasKeyboard() && this.mode != PlaceMode.breaking) {
            this.schemX = rawCursorX;
            this.schemY = rawCursorY;
        }
        if (Core.input.keyTap(Binding.clearBuilding) || this.isPlacing()) {
            this.lastSchematic = null;
            this.selectPlans.clear();
        }
        if (!Core.scene.hasKeyboard() && this.selectX == -1 && this.selectY == -1 && this.schemX != -1 && this.schemY != -1) {
            if (Core.input.keyRelease(Binding.schematicSelect)) {
                this.lastSchematic = Vars.schematics.create(this.schemX, this.schemY, rawCursorX, rawCursorY);
                this.useSchematic(this.lastSchematic);
                if (this.selectPlans.isEmpty()) {
                    this.lastSchematic = null;
                }
                this.schemX = -1;
                this.schemY = -1;
            } else if (Core.input.keyRelease(Binding.rebuildSelect)) {
                this.rebuildArea(this.schemX, this.schemY, rawCursorX, rawCursorY);
                this.schemX = -1;
                this.schemY = -1;
            }
        }
        if (!this.selectPlans.isEmpty()) {
            if (Core.input.keyTap(Binding.schematicFlipX)) {
                this.flipPlans((Seq<BuildPlan>)this.selectPlans, true);
            }
            if (Core.input.keyTap(Binding.schematicFlipY)) {
                this.flipPlans((Seq<BuildPlan>)this.selectPlans, false);
            }
        }
        if (this.splan != null) {
            int x = Math.round((Core.input.mouseWorld().x + this.buildPlanMouseOffsetX) / 8.0f);
            int y = Math.round((Core.input.mouseWorld().y + this.buildPlanMouseOffsetY) / 8.0f);
            if (this.splan.x != x || this.splan.y != y) {
                this.splan.x = x;
                this.splan.y = y;
                this.movedPlan = true;
            }
        }
        if (this.block == null || this.mode != PlaceMode.placing) {
            this.linePlans.clear();
        }
        if (Core.input.keyTap(Binding.pauseBuilding)) {
            this.isBuilding = !this.isBuilding;
            this.buildWasAutoPaused = false;
            if (this.isBuilding) {
                Vars.player.shooting = false;
            }
        }
        if (this.isPlacing() && this.mode == PlaceMode.placing && (cursorX != this.lastLineX || cursorY != this.lastLineY || Core.input.keyTap(Binding.diagonalPlacement) || Core.input.keyRelease(Binding.diagonalPlacement))) {
            this.updateLine(this.selectX, this.selectY);
            this.lastLineX = cursorX;
            this.lastLineY = cursorY;
        }
        if (!Vars.player.dead() && Core.input.keyRelease(Binding.select) && !Core.scene.hasMouse() && (plan = this.getPlan(cursorX, cursorY)) != null && !this.movedPlan && (index = Vars.player.unit().plans.indexOf((Object)plan, true)) != -1) {
            Vars.player.unit().plans.removeIndex(index);
            Vars.player.unit().plans.addFirst((Object)plan);
        }
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse()) {
            this.tappedOne = false;
            plan = this.getPlan(cursorX, cursorY);
            if (Core.input.keyDown(Binding.breakBlock)) {
                this.mode = PlaceMode.none;
            } else if (!this.selectPlans.isEmpty()) {
                if (Vars.player.isBuilder()) {
                    this.flushPlans((Seq<BuildPlan>)this.selectPlans);
                }
                this.movedPlan = true;
            } else if (this.isPlacing()) {
                this.selectX = cursorX;
                this.selectY = cursorY;
                this.lastLineX = cursorX;
                this.lastLineY = cursorY;
                this.mode = PlaceMode.placing;
                this.updateLine(this.selectX, this.selectY);
            } else if (plan != null && !plan.breaking && this.mode == PlaceMode.none && !plan.initialized && plan.progress <= 0.0f) {
                this.splan = plan;
                this.movedPlan = false;
                this.buildPlanMouseOffsetX = (float)(this.splan.x * 8) - Core.input.mouseWorld().x;
                this.buildPlanMouseOffsetY = (float)(this.splan.y * 8) - Core.input.mouseWorld().y;
            } else if (plan != null && plan.breaking) {
                this.deleting = true;
            } else if (this.commandMode) {
                this.commandRect = true;
                this.commandRectX = Core.input.mouseWorldX();
                this.commandRectY = Core.input.mouseWorldY();
            } else if (!this.checkConfigTap() && selected != null && !this.tryRepairDerelict(selected)) {
                if (!(Vars.player.dead() || this.tryTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y) || this.tileTapped(selected.build) || Vars.player.unit().activelyBuilding() || this.droppingItem || this.tryStopMine(selected) || (!Core.settings.getBool("doubletapmine") || selected == this.prevSelected && Time.timeSinceMillis((long)this.selectMillis) < 500L) && this.tryBeginMine(selected) || Core.scene.hasKeyboard())) {
                    Vars.player.shooting = this.shouldShoot;
                }
            } else if (!Core.scene.hasKeyboard()) {
                Vars.player.shooting = this.shouldShoot;
            }
            this.selectMillis = Time.millis();
            this.prevSelected = selected;
        } else if (Core.input.keyTap(Binding.deselect) && this.isPlacing()) {
            this.block = null;
            this.mode = PlaceMode.none;
        } else if (Core.input.keyTap(Binding.deselect) && !this.selectPlans.isEmpty()) {
            this.selectPlans.clear();
            this.lastSchematic = null;
        } else if (Core.input.keyTap(Binding.breakBlock) && !Core.scene.hasMouse() && Vars.player.isBuilder() && !this.commandMode) {
            this.deleting = false;
            this.mode = PlaceMode.breaking;
            this.selectX = this.tileX(Core.input.mouseX());
            this.selectY = this.tileY(Core.input.mouseY());
            this.schemX = rawCursorX;
            this.schemY = rawCursorY;
        }
        if (!Vars.player.dead() && Core.input.keyDown(Binding.select) && this.mode == PlaceMode.none && !this.isPlacing() && this.deleting) {
            plan = this.getPlan(cursorX, cursorY);
            if (plan != null && plan.breaking) {
                Vars.player.unit().plans().remove((Object)plan);
            }
        } else {
            this.deleting = false;
        }
        if (this.mode == PlaceMode.placing && this.block != null) {
            if (!(this.overrideLineRotation || Core.input.keyDown(Binding.diagonalPlacement) || this.selectX == cursorX && this.selectY == cursorY || (int)Core.input.axisTap(Binding.rotate) == 0)) {
                this.rotation = (int)((Angles.angle((float)this.selectX, (float)this.selectY, (float)cursorX, (float)cursorY) + 45.0f) / 90.0f) % 4;
                this.overrideLineRotation = true;
            }
        } else {
            this.overrideLineRotation = false;
        }
        if (Core.input.keyRelease(Binding.breakBlock) && Core.input.keyDown(Binding.schematicSelect) && this.mode == PlaceMode.breaking) {
            this.lastSchematic = Vars.schematics.create(this.schemX, this.schemY, rawCursorX, rawCursorY);
            this.schemX = -1;
            this.schemY = -1;
        }
        if (!Vars.player.dead() && (Core.input.keyRelease(Binding.breakBlock) || Core.input.keyRelease(Binding.select))) {
            if (this.mode == PlaceMode.placing && this.block != null) {
                if (Core.input.keyDown(Binding.boost)) {
                    this.flushPlansReverse((Seq<BuildPlan>)this.linePlans);
                } else {
                    this.flushPlans((Seq<BuildPlan>)this.linePlans);
                }
                this.linePlans.clear();
                Events.fire((Object)new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                this.removeSelection(this.selectX, this.selectY, cursorX, cursorY, !Core.input.keyDown(Binding.schematicSelect) ? 100 : Vars.maxSchematicSize);
                if (this.lastSchematic != null) {
                    this.useSchematic(this.lastSchematic);
                    this.lastSchematic = null;
                }
            }
            this.selectX = -1;
            this.selectY = -1;
            this.tryDropItems(selected == null ? null : selected.build, Core.input.mouseWorld().x, Core.input.mouseWorld().y);
            if (this.splan != null) {
                if (this.getPlan(this.splan.x, this.splan.y, this.splan.block.size, this.splan) != null) {
                    Vars.player.unit().plans().remove((Object)this.splan, true);
                }
                if (Core.input.ctrl()) {
                    this.inv.hide();
                    this.config.hideConfig();
                    this.planConfig.showConfig(this.splan);
                } else {
                    this.planConfig.hide();
                }
                this.splan = null;
            }
            this.mode = PlaceMode.none;
        }
        if (!this.isPlacing() && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (Vars.player.shooting && !this.canShoot()) {
            Vars.player.shooting = false;
        }
        if (this.isPlacing() && Vars.player.isBuilder()) {
            this.cursorType = Graphics.Cursor.SystemCursor.hand;
            this.selectScale = Mathf.lerpDelta((float)this.selectScale, (float)1.0f, (float)0.2f);
        } else {
            this.selectScale = 0.0f;
        }
        if (!Core.input.keyDown(Binding.diagonalPlacement) && Math.abs((int)Core.input.axisTap(Binding.rotate)) > 0) {
            this.rotation = Mathf.mod((int)(this.rotation + (int)Core.input.axisTap(Binding.rotate)), (int)4);
            if (this.splan != null) {
                this.splan.rotation = Mathf.mod((int)(this.splan.rotation + (int)Core.input.axisTap(Binding.rotate)), (int)4);
            }
            if (this.isPlacing() && this.mode == PlaceMode.placing) {
                this.updateLine(this.selectX, this.selectY);
            } else if (!this.selectPlans.isEmpty() && !Vars.ui.chatfrag.shown()) {
                this.rotatePlans((Seq<BuildPlan>)this.selectPlans, Mathf.sign((float)Core.input.axisTap(Binding.rotate)));
            }
        }
        Tile cursor = this.tileAt(Core.input.mouseX(), Core.input.mouseY());
        this.cursorType = Graphics.Cursor.SystemCursor.arrow;
        if (cursor != null) {
            if (cursor.build != null && cursor.build.interactable(Vars.player.team())) {
                this.cursorType = cursor.build.getCursor();
            }
            if (this.canRepairDerelict(cursor) && !Vars.player.dead() && Vars.player.unit().canBuild()) {
                this.cursorType = Vars.ui.repairCursor;
            }
            if (this.isPlacing() && Vars.player.isBuilder() || !this.selectPlans.isEmpty()) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (!this.isPlacing() && this.canMine(cursor)) {
                this.cursorType = Vars.ui.drillCursor;
            }
            if (this.commandMode && this.selectedUnits.any()) {
                Unit unit;
                boolean canAttack;
                boolean bl = canAttack = cursor.build != null && !cursor.build.inFogTo(Vars.player.team()) && cursor.build.team != Vars.player.team();
                if (!canAttack && (unit = this.selectedEnemyUnit(Core.input.mouseWorldX(), Core.input.mouseWorldY())) != null) {
                    canAttack = this.selectedUnits.contains(u -> u.canTarget(unit));
                }
                if (canAttack) {
                    this.cursorType = Vars.ui.targetCursor;
                }
                if (Core.input.keyTap(Binding.commandQueue) && Binding.commandQueue.value.key.type != KeyCode.KeyType.mouse) {
                    this.commandTap(Core.input.mouseX(), Core.input.mouseY(), true);
                }
            }
            if (this.getPlan(cursor.x, cursor.y) != null && this.mode == PlaceMode.none) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (this.canTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) {
                this.cursorType = Vars.ui.unloadCursor;
            }
            if (cursor.build != null && cursor.interactable(Vars.player.team()) && !this.isPlacing() && Math.abs(Core.input.axisTap(Binding.rotate)) > 0.0f && Core.input.keyDown(Binding.rotatePlaced) && cursor.block().rotate && cursor.block().quickRotate) {
                Call.rotateBlock((Player)Vars.player, (Building)cursor.build, (Core.input.axisTap(Binding.rotate) > 0.0f ? 1 : 0) != 0);
            }
        }
    }

    public boolean tap(float x, float y, int count, KeyCode button2) {
        if (Core.scene.hasMouse() || !this.commandMode) {
            return false;
        }
        this.tappedOne = true;
        if (button2 == KeyCode.mouseLeft) {
            if (count >= 2) {
                this.selectTypedUnits();
            } else {
                this.tapCommandUnit();
            }
        }
        return super.tap(x, y, count, button2);
    }

    public boolean touchDown(float x, float y, int pointer, KeyCode button2) {
        if (Core.scene.hasMouse() || !this.commandMode) {
            return false;
        }
        if (button2 == KeyCode.mouseRight) {
            this.commandTap(x, y);
        }
        if (button2 == Binding.commandQueue.value.key) {
            this.commandTap(x, y, true);
        }
        return super.touchDown(x, y, pointer, button2);
    }

    @Override
    public boolean selectedBlock() {
        return this.isPlacing() && this.mode != PlaceMode.breaking;
    }

    @Override
    public float getMouseX() {
        return Core.input.mouseX();
    }

    @Override
    public float getMouseY() {
        return Core.input.mouseY();
    }

    @Override
    public void updateState() {
        super.updateState();
        if (Vars.state.isMenu()) {
            this.lastSchematic = null;
            this.droppingItem = false;
            this.mode = PlaceMode.none;
            this.block = null;
            this.splan = null;
            this.selectPlans.clear();
        }
    }

    @Override
    public void panCamera(Vec2 position) {
        if (!this.locked()) {
            this.panning = true;
            Core.camera.position.set(position);
        }
    }

    protected void updateMovement(Unit unit) {
        boolean aimCursor;
        boolean boosted;
        boolean omni = unit.type.omniMovement;
        float speed = unit.speed();
        float xa = Core.input.axis(Binding.moveX);
        float ya = Core.input.axis(Binding.moveY);
        boolean bl = boosted = unit instanceof Mechc && unit.isFlying();
        if (Core.settings.getBool("detach-camera")) {
            Vec2 targetPos = Core.camera.position;
            this.movement.set(targetPos).sub((Position)Vars.player).limit(speed);
            if (Vars.player.within((Position)targetPos, 15.0f)) {
                this.movement.setZero();
                unit.vel.approachDelta(Vec2.ZERO, unit.speed() * unit.type().accel / 2.0f);
            }
        } else {
            this.movement.set(xa, ya).nor().scl(speed);
            if (Core.input.keyDown(Binding.mouseMove)) {
                this.movement.add(Core.input.mouseWorld().sub((Position)Vars.player).scl(0.04f * speed)).limit(speed);
            }
        }
        boolean bl2 = aimCursor = omni && Vars.player.shooting && unit.type.hasWeapons() && unit.type.faceTarget && !boosted;
        if (aimCursor) {
            unit.lookAt(unit.angleTo(unit.aimX, unit.aimY));
        } else {
            unit.lookAt(unit.prefRotation());
        }
        unit.movePref(this.movement);
        unit.aim((Position)Core.input.mouseWorld());
        unit.controlWeapons(true, Vars.player.shooting && !boosted);
        Vars.player.boosting = Core.input.keyDown(Binding.boost);
        Vars.player.mouseX = unit.aimX();
        Vars.player.mouseY = unit.aimY();
        if (unit instanceof Payloadc) {
            if (Core.input.keyTap(Binding.pickupCargo)) {
                this.tryPickupPayload();
                this.lastPayloadKeyTapMillis = Time.millis();
            }
            if (Core.input.keyDown(Binding.pickupCargo) && Time.timeSinceMillis((long)this.lastPayloadKeyHoldMillis) > 20L && Time.timeSinceMillis((long)this.lastPayloadKeyTapMillis) > 200L) {
                this.tryPickupPayload();
                this.lastPayloadKeyHoldMillis = Time.millis();
            }
            if (Core.input.keyTap(Binding.dropCargo)) {
                this.tryDropPayload();
                this.lastPayloadKeyTapMillis = Time.millis();
            }
            if (Core.input.keyDown(Binding.dropCargo) && Time.timeSinceMillis((long)this.lastPayloadKeyHoldMillis) > 20L && Time.timeSinceMillis((long)this.lastPayloadKeyTapMillis) > 200L) {
                this.tryDropPayload();
                this.lastPayloadKeyHoldMillis = Time.millis();
            }
        }
    }
}

