/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.Core;
import arc.Events;
import arc.func.Prov;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntMap;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.CounterInputStream;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.Planets;
import mindustry.content.TechTree;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.entities.EntityGroup;
import mindustry.game.EventType;
import mindustry.game.GameStats;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.EntityMapping;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.io.JsonIO;
import mindustry.io.SaveFileReader;
import mindustry.io.SaveMeta;
import mindustry.io.TypeIO;
import mindustry.maps.Map;
import mindustry.mod.DataPatcher;
import mindustry.type.MapLocales;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.WorldContext;

public abstract class SaveVersion
extends SaveFileReader {
    protected static OrderedMap<String, SaveFileReader.CustomChunk> customChunks = new OrderedMap();
    public final int version;

    public static void addCustomChunk(String name, SaveFileReader.CustomChunk chunk) {
        customChunks.put((Object)name, (Object)chunk);
    }

    public SaveVersion(int version) {
        this.version = version;
    }

    public SaveMeta getMeta(DataInput stream) throws IOException {
        stream.readInt();
        StringMap map = this.readStringMap(stream);
        return new SaveMeta(map.getInt("version"), map.getLong("saved"), map.getLong("playtime"), map.getInt("build"), (String)map.get((Object)"mapname"), map.getInt("wave"), (Rules)JsonIO.read(Rules.class, (String)((String)map.get((Object)"rules", (Object)"{}"))), map);
    }

    public final void write(DataOutputStream stream) throws IOException {
        this.write(stream, new StringMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DataInputStream stream, CounterInputStream counter, WorldContext context) throws IOException {
        this.readRegion("meta", stream, counter, in -> this.readMeta((DataInput)in, context));
        this.readRegion("content", stream, counter, this::readContentHeader);
        try {
            if (this.version >= 11) {
                this.readRegion("patches", stream, counter, this::readContentPatches);
            }
            this.readRegion("map", stream, counter, in -> this.readMap((DataInput)in, context));
            this.readRegion("entities", stream, counter, this::readEntities);
            if (this.version >= 8) {
                this.readRegion("markers", stream, counter, this::readMarkers);
            }
            this.readRegion("custom", stream, counter, this::readCustomChunks);
        }
        finally {
            Vars.content.setTemporaryMapper(null);
        }
    }

    public void write(DataOutputStream stream, StringMap extraTags) throws IOException {
        this.writeRegion("meta", stream, out -> this.writeMeta((DataOutput)out, extraTags));
        this.writeRegion("content", stream, this::writeContentHeader);
        this.writeRegion("patches", stream, this::writeContentPatches);
        this.writeRegion("map", stream, this::writeMap);
        this.writeRegion("entities", stream, this::writeEntities);
        this.writeRegion("markers", stream, this::writeMarkers);
        this.writeRegion("custom", stream, s -> this.writeCustomChunks((DataOutput)s, false));
    }

    public void writeCustomChunks(DataOutput stream, boolean net) throws IOException {
        Seq chunks = customChunks.orderedKeys().select(s -> ((SaveFileReader.CustomChunk)customChunks.get(s)).shouldWrite() && (!net || ((SaveFileReader.CustomChunk)customChunks.get(s)).writeNet()));
        stream.writeInt(chunks.size);
        for (String chunkName : chunks) {
            SaveFileReader.CustomChunk chunk = (SaveFileReader.CustomChunk)customChunks.get((Object)chunkName);
            stream.writeUTF(chunkName);
            this.writeChunk(stream, writes -> chunk.write(writes.output));
        }
    }

    public void readCustomChunks(DataInput stream) throws IOException {
        int amount = stream.readInt();
        for (int i = 0; i < amount; ++i) {
            String name = stream.readUTF();
            SaveFileReader.CustomChunk chunk = (SaveFileReader.CustomChunk)customChunks.get((Object)name);
            if (chunk != null) {
                this.readChunk(stream, (arg_0, arg_1) -> ((SaveFileReader.CustomChunk)chunk).read(arg_0, arg_1));
                continue;
            }
            this.skipChunk(stream);
        }
    }

    public void writeMeta(DataOutput stream, StringMap tags) throws IOException {
        if (Vars.state.isCampaign()) {
            Vars.state.rules.sector.info.prepare(Vars.state.rules.sector);
            Vars.state.rules.sector.saveInfo();
        }
        for (TechTree.TechNode node : TechTree.all) {
            node.save();
        }
        StringMap result = new StringMap();
        result.putAll((ObjectMap)tags);
        this.writeStringMap(stream, result.merge((ObjectMap)StringMap.of((Object[])new Object[]{"saved", Time.millis(), "playtime", Vars.headless ? 0L : Vars.control.saves.getTotalPlaytime(), "build", Version.build, "mapname", Vars.state.map.name(), "wave", Vars.state.wave, "tick", Vars.state.tick, "wavetime", Float.valueOf(Vars.state.wavetime), "stats", JsonIO.write((Object)Vars.state.stats), "rules", JsonIO.write((Object)Vars.state.rules), "sectorPreset", Vars.state.rules.sector != null && Vars.state.rules.sector.preset != null ? Vars.state.rules.sector.preset.name : "", "locales", JsonIO.write((Object)Vars.state.mapLocales), "mods", JsonIO.write((Object)Vars.mods.getModStrings().toArray(String.class)), "controlGroups", Vars.headless || Vars.control == null ? "null" : JsonIO.write((Object)Vars.control.input.controlGroups), "width", Vars.world.width(), "height", Vars.world.height(), "viewpos", Tmp.v1.set((Position)(Vars.player == null ? Vec2.ZERO : Vars.player)).toString(), "controlledType", Vars.headless || Vars.control.input.controlledType == null ? "null" : Vars.control.input.controlledType.name, "nocores", Vars.state.rules.defaultTeam.cores().isEmpty(), "playerteam", Vars.player == null ? Vars.state.rules.defaultTeam.id : Vars.player.team().id})));
    }

    public void readMeta(DataInput stream, WorldContext context) throws IOException {
        Map worldmap;
        StringMap map = this.readStringMap(stream);
        Vars.state.wave = map.getInt("wave");
        Vars.state.wavetime = map.getFloat("wavetime", Vars.state.rules.waveSpacing);
        Vars.state.tick = map.getFloat("tick");
        Vars.state.stats = (GameStats)JsonIO.read(GameStats.class, (String)((String)map.get((Object)"stats", (Object)"{}")));
        Vars.state.rules = (Rules)JsonIO.read(Rules.class, (String)((String)map.get((Object)"rules", (Object)"{}")));
        Vars.state.mapLocales = (MapLocales)JsonIO.read(MapLocales.class, (String)((String)map.get((Object)"locales", (Object)"{}")));
        if (Vars.state.rules.spawns.isEmpty()) {
            Vars.state.rules.spawns = Vars.waves.get();
        }
        if (context.getSector() != null) {
            Vars.state.rules.sector = context.getSector();
            if (Vars.state.rules.sector != null) {
                Vars.state.rules.sector.planet.applyRules(Vars.state.rules);
            }
        }
        if (Vars.state.rules.planet == Planets.serpulo && !Vars.state.rules.hiddenBuildItems.contains((Object)Items.beryllium)) {
            Vars.state.rules.planet = Planets.sun;
        }
        if (Vars.state.rules.planet == Planets.serpulo && Vars.state.rules.hasEnv(16)) {
            Vars.state.rules.planet = Planets.erekir;
        }
        if (!Vars.headless) {
            IntSeq[] groups2;
            Tmp.v1.tryFromString((String)map.get((Object)"viewpos"));
            Core.camera.position.set(Tmp.v1);
            Vars.player.set((Position)Tmp.v1);
            Vars.control.input.controlledType = (UnitType)((Object)Vars.content.getByName(ContentType.unit, (String)map.get((Object)"controlledType", (Object)"<none>")));
            Team team = Team.get((int)map.getInt("playerteam", Vars.state.rules.defaultTeam.id));
            if (!Vars.net.client() && team != Team.derelict) {
                Vars.player.team(team);
            }
            if ((groups2 = (IntSeq[])JsonIO.read(IntSeq[].class, (String)((String)map.get((Object)"controlGroups", (Object)"null")))) != null && groups2.length == Vars.control.input.controlGroups.length) {
                Vars.control.input.controlGroups = groups2;
            }
        }
        Vars.state.map = (worldmap = Vars.maps.byName((String)map.get((Object)"mapname", (Object)"\\\\\\"))) == null ? new Map(StringMap.of((Object[])new Object[]{"name", map.get((Object)"mapname", (Object)"Unknown"), "width", 1, "height", 1})) : worldmap;
    }

    public void writeMap(DataOutput stream) throws IOException {
        Tile tile;
        int i;
        stream.writeShort(Vars.world.width());
        stream.writeShort(Vars.world.height());
        for (i = 0; i < Vars.world.width() * Vars.world.height(); ++i) {
            Tile nextTile;
            tile = Vars.world.tiles.geti(i);
            stream.writeShort(tile.floorID());
            stream.writeShort(tile.overlayID());
            int consecutives = 0;
            for (int j = i + 1; j < Vars.world.width() * Vars.world.height() && consecutives < 255 && (nextTile = Vars.world.rawTile(j % Vars.world.width(), j / Vars.world.width())).floorID() == tile.floorID() && nextTile.overlayID() == tile.overlayID(); ++consecutives, ++j) {
            }
            stream.writeByte(consecutives);
            i += consecutives;
        }
        for (i = 0; i < Vars.world.width() * Vars.world.height(); ++i) {
            Tile nextTile;
            tile = Vars.world.tiles.geti(i);
            stream.writeShort(tile.blockID());
            boolean savedata = tile.shouldSaveData();
            byte packed = (byte)((tile.build != null ? 1 : 0) | (savedata ? 4 : 0));
            stream.writeByte(packed);
            if (savedata) {
                stream.writeByte(tile.data);
                stream.writeByte(tile.floorData);
                stream.writeByte(tile.overlayData);
                stream.writeInt(tile.extraData);
            }
            if (tile.build != null) {
                if (tile.isCenter()) {
                    stream.writeBoolean(true);
                    this.writeChunk(stream, out -> {
                        out.b((int)tile.build.version());
                        tile.build.writeAll((Writes)out);
                    });
                    continue;
                }
                stream.writeBoolean(false);
                continue;
            }
            if (savedata) continue;
            int consecutives = 0;
            for (int j = i + 1; j < Vars.world.width() * Vars.world.height() && consecutives < 255 && (nextTile = Vars.world.rawTile(j % Vars.world.width(), j / Vars.world.width())).blockID() == tile.blockID() && savedata == nextTile.shouldSaveData(); ++consecutives, ++j) {
            }
            stream.writeByte(consecutives);
            i += consecutives;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMap(DataInput stream, WorldContext context) throws IOException {
        int width = stream.readUnsignedShort();
        int height = stream.readUnsignedShort();
        boolean generating = context.isGenerating();
        if (!generating) {
            context.begin();
        }
        try {
            int i;
            context.resize(width, height);
            for (i = 0; i < width * height; ++i) {
                int x = i % width;
                int y = i / width;
                short floorid = stream.readShort();
                short oreid = stream.readShort();
                int consecutives = stream.readUnsignedByte();
                if (Vars.content.block(floorid) == Blocks.air) {
                    floorid = Blocks.stone.id;
                }
                context.create(x, y, (int)floorid, (int)oreid, 0);
                for (int j = i + 1; j < i + 1 + consecutives; ++j) {
                    int newx = j % width;
                    int newy = j / width;
                    context.create(newx, newy, (int)floorid, (int)oreid, 0);
                }
                i += consecutives;
            }
            for (i = 0; i < width * height; ++i) {
                Block block = Vars.content.block(stream.readShort());
                Tile tile = context.tile(i);
                if (block == null) {
                    block = Blocks.air;
                }
                boolean isCenter = true;
                byte packedCheck = stream.readByte();
                boolean hadEntity = (packedCheck & 1) != 0;
                boolean hadData = (packedCheck & 4) != 0;
                byte data = 0;
                byte floorData = 0;
                byte overlayData = 0;
                int extraData = 0;
                if (hadData) {
                    data = stream.readByte();
                    floorData = stream.readByte();
                    overlayData = stream.readByte();
                    extraData = stream.readInt();
                }
                if (hadEntity) {
                    isCenter = stream.readBoolean();
                }
                if (isCenter) {
                    tile.setBlock(block);
                    if (tile.build != null) {
                        tile.build.enabled = true;
                    }
                }
                if (hadData) {
                    tile.data = data;
                    tile.floorData = floorData;
                    tile.overlayData = overlayData;
                    tile.extraData = extraData;
                    context.onReadTileData();
                }
                if (hadEntity) {
                    if (!isCenter) continue;
                    if (block.hasBuilding()) {
                        try {
                            this.readChunkReads(stream, (in, len) -> {
                                byte revision = in.b();
                                tile.build.readAll((Reads)in, revision);
                            });
                        }
                        catch (Throwable e) {
                            throw new IOException("Failed to read tile entity of block: " + (Object)((Object)block), e);
                        }
                    } else {
                        this.skipChunk(stream);
                    }
                    context.onReadBuilding();
                    continue;
                }
                if (hadData) continue;
                int consecutives = stream.readUnsignedByte();
                for (int j = i + 1; j < i + 1 + consecutives; ++j) {
                    context.tile(j).setBlock(block);
                }
                i += consecutives;
            }
        }
        finally {
            if (!generating) {
                context.end();
            }
        }
    }

    public void writeTeamBlocks(DataOutput stream) throws IOException {
        Seq data = Vars.state.teams.getActive().copy();
        if (!data.contains((Object)Team.sharded.data())) {
            data.add((Object)Team.sharded.data());
        }
        Writes writes = new Writes(stream);
        stream.writeInt(data.size);
        for (Teams.TeamData team : data) {
            stream.writeInt(team.team.id);
            stream.writeInt(team.plans.size);
            for (Teams.BlockPlan block : team.plans) {
                stream.writeShort(block.x);
                stream.writeShort(block.y);
                stream.writeShort(block.rotation);
                stream.writeShort(block.block.id);
                TypeIO.writeObject(writes, block.config);
            }
        }
    }

    public void writeWorldEntities(DataOutput stream) throws IOException {
        stream.writeInt(Groups.all.count(Entityc::serialize));
        for (Entityc entity : Groups.all) {
            if (!entity.serialize()) continue;
            this.writeChunk(stream, out -> {
                out.b(entity.classId());
                out.i(entity.id());
                entity.beforeWrite();
                entity.write(out);
            });
        }
    }

    public void writeEntityMapping(DataOutput stream) throws IOException {
        stream.writeShort(EntityMapping.customIdMap.size);
        for (IntMap.Entry entry : EntityMapping.customIdMap.entries()) {
            stream.writeShort(entry.key);
            stream.writeUTF((String)entry.value);
        }
    }

    public void writeEntities(DataOutput stream) throws IOException {
        this.writeEntityMapping(stream);
        this.writeTeamBlocks(stream);
        this.writeWorldEntities(stream);
    }

    public void writeMarkers(DataOutput stream) throws IOException {
        Vars.state.markers.write(stream);
    }

    public void readMarkers(DataInput stream) throws IOException {
        Vars.state.markers.read(stream);
    }

    public void readTeamBlocks(DataInput stream) throws IOException {
        int teamc = stream.readInt();
        Reads reads = new Reads(stream);
        for (int i = 0; i < teamc; ++i) {
            Team team = Team.get((int)stream.readInt());
            Teams.TeamData data = team.data();
            int blocks = stream.readInt();
            data.plans.clear();
            data.plans.ensureCapacity(Math.min(blocks, 1000));
            IntSet set = new IntSet();
            for (int j = 0; j < blocks; ++j) {
                short x = stream.readShort();
                short y = stream.readShort();
                short rot = stream.readShort();
                short bid = stream.readShort();
                Object obj = TypeIO.readObject(reads);
                if (!set.add(Point2.pack((int)x, (int)y))) continue;
                data.plans.addLast((Object)new Teams.BlockPlan((int)x, (int)y, rot, Vars.content.block(bid), obj));
            }
        }
    }

    public void readWorldEntities(DataInput stream, Prov[] mapping) throws IOException {
        IntSet used = new IntSet();
        Seq reassign = new Seq();
        int amount = stream.readInt();
        for (int j = 0; j < amount; ++j) {
            this.readChunkReads(stream, (in, len) -> {
                int typeid = in.ub();
                if (mapping[typeid] == null) {
                    in.skip(len - 1);
                    return;
                }
                int id = in.i();
                Entityc entity = (Entityc)mapping[typeid].get();
                EntityGroup.checkNextId(id);
                entity.id(id);
                entity.read(in);
                if (used.add(id)) {
                    entity.add();
                } else {
                    Log.warn((String)"Duplicate entity ID in save: @ (@)", (Object[])new Object[]{id, entity});
                    reassign.add((Object)entity);
                }
            });
        }
        for (Entityc ent : reassign) {
            ent.id(EntityGroup.nextId());
            ent.add();
        }
        Groups.all.each(Entityc::afterReadAll);
    }

    public Prov[] readEntityMapping(DataInput stream) throws IOException {
        Prov[] entityMapping = Arrays.copyOf(EntityMapping.idMap, EntityMapping.idMap.length);
        int amount = stream.readShort();
        for (int i = 0; i < amount; ++i) {
            short id = stream.readShort();
            String name = stream.readUTF();
            entityMapping[id] = EntityMapping.map((String)name);
        }
        return entityMapping;
    }

    public void readEntities(DataInput stream) throws IOException {
        Prov[] mapping = this.readEntityMapping(stream);
        this.readTeamBlocks(stream);
        this.readWorldEntities(stream, mapping);
    }

    public void skipContentPatches(DataInput stream) throws IOException {
        int amount = stream.readUnsignedByte();
        for (int i = 0; i < amount; ++i) {
            int len = stream.readInt();
            stream.skipBytes(len);
        }
    }

    public void readContentPatches(DataInput stream) throws IOException {
        Seq patches = new Seq();
        int amount = stream.readUnsignedByte();
        if (amount > 0) {
            for (int i = 0; i < amount; ++i) {
                int len = stream.readInt();
                byte[] bytes = new byte[len];
                stream.readFully(bytes);
                patches.add((Object)new String(bytes, Strings.utf8));
            }
        }
        Events.fire((Object)new EventType.ContentPatchLoadEvent(patches));
        if (patches.size > 0) {
            try {
                Vars.state.patcher.apply(patches);
            }
            catch (Throwable e) {
                Log.err((String)("Failed to apply patches: " + patches), (Throwable)e);
            }
        }
    }

    public void writeContentPatches(DataOutput stream) throws IOException {
        if (Vars.state.patcher.patches.size > 0) {
            Seq patches = Vars.state.patcher.patches;
            stream.writeByte(patches.size);
            for (DataPatcher.PatchSet patchset : patches) {
                byte[] bytes = patchset.patch.getBytes(Strings.utf8);
                stream.writeInt(bytes.length);
                stream.write(bytes);
            }
        } else {
            stream.writeByte(0);
        }
    }

    public void readContentHeader(DataInput stream) throws IOException {
        int mapped = stream.readUnsignedByte();
        MappableContent[][] map = new MappableContent[ContentType.all.length][0];
        for (int i = 0; i < mapped; ++i) {
            ContentType type = ContentType.all[stream.readByte()];
            int total = stream.readShort();
            map[type.ordinal()] = new MappableContent[total];
            for (int j = 0; j < total; ++j) {
                String name = stream.readUTF();
                map[type.ordinal()][j] = Vars.content.getByName(type, type == ContentType.block ? (String)fallback.get((Object)name, (Object)name) : name);
            }
        }
        Vars.content.setTemporaryMapper(map);
        if (this.version < 11) {
            Seq patches = new Seq();
            Events.fire((Object)new EventType.ContentPatchLoadEvent(patches));
            if (patches.size > 0) {
                try {
                    Vars.state.patcher.apply(patches);
                }
                catch (Throwable e) {
                    Log.err((String)("Failed to apply patches: " + patches), (Throwable)e);
                }
            }
        }
    }

    public void writeContentHeader(DataOutput stream) throws IOException {
        Seq<Content>[] map = Vars.content.getContentMap();
        int mappable = 0;
        for (Seq<Content> arr : map) {
            if (arr.size <= 0 || !(arr.first() instanceof MappableContent)) continue;
            ++mappable;
        }
        stream.writeByte(mappable);
        for (Seq<Content> arr : map) {
            if (arr.size <= 0 || !(arr.first() instanceof MappableContent)) continue;
            stream.writeByte(((Content)arr.first()).getContentType().ordinal());
            stream.writeShort(arr.size);
            for (Content c : arr) {
                stream.writeUTF(((MappableContent)c).name);
            }
        }
    }
}

