/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.Queue;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.UnitStance;
import mindustry.ai.types.AssemblerAI;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.GroundAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.TechTree;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.MapObjectives;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.EntityMapping;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.io.JsonIO;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.logic.LMarkerControl;
import mindustry.net.Administration;
import mindustry.net.Packets;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.payloads.Payload;
import mindustryX.features.LogicExt;

public class TypeIO {
    static final WeaponMount[] noMounts = new WeaponMount[0];
    static final Ability[] noAbilities = new Ability[0];

    public static void writeObject(Writes write, Object object) {
        if (object == null) {
            write.b(0);
        } else if (object instanceof Integer) {
            Integer i = (Integer)object;
            write.b(1);
            write.i(i.intValue());
        } else if (object instanceof Long) {
            Long l = (Long)object;
            write.b(2);
            write.l(l.longValue());
        } else if (object instanceof Float) {
            Float f = (Float)object;
            write.b(3);
            write.f(f.floatValue());
        } else if (object instanceof String) {
            String s = (String)object;
            write.b(4);
            TypeIO.writeString(write, s);
        } else if (object instanceof Content) {
            Content map = (Content)object;
            write.b(5);
            write.b((int)((byte)map.getContentType().ordinal()));
            if (LogicExt.contentsCompatibleMode && map instanceof Block) {
                Block b = (Block)map;
                TypeIO.writeBlock(write, b);
            } else {
                write.s((int)map.id);
            }
        } else if (object instanceof IntSeq) {
            IntSeq arr = (IntSeq)object;
            write.b(6);
            write.s((int)((short)arr.size));
            for (int i = 0; i < arr.size; ++i) {
                write.i(arr.items[i]);
            }
        } else if (object instanceof Point2) {
            Point2 p = (Point2)object;
            write.b(7);
            write.i(p.x);
            write.i(p.y);
        } else if (object instanceof Point2[]) {
            Point2[] p = (Point2[])object;
            write.b(8);
            write.b(p.length);
            for (Point2 point2 : p) {
                write.i(point2.pack());
            }
        } else if (object instanceof TechTree.TechNode) {
            TechTree.TechNode map = (TechTree.TechNode)object;
            write.b(9);
            write.b((int)((byte)map.content.getContentType().ordinal()));
            write.s((int)map.content.id);
        } else if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            write.b(10);
            write.bool(b.booleanValue());
        } else if (object instanceof Double) {
            Double d = (Double)object;
            write.b(11);
            write.d(d.doubleValue());
        } else if (object instanceof Building) {
            Building b = (Building)object;
            write.b(12);
            write.i(b.pos());
        } else if (object instanceof BuildingBox) {
            BuildingBox b = (BuildingBox)object;
            write.b(12);
            write.i(b.pos);
        } else if (object instanceof LAccess) {
            LAccess l = (LAccess)object;
            write.b(13);
            write.s(l.ordinal());
        } else if (object instanceof byte[]) {
            byte[] b = (byte[])object;
            write.b(14);
            write.i(b.length);
            write.b(b);
        } else if (object instanceof boolean[]) {
            boolean[] b = (boolean[])object;
            write.b(16);
            write.i(b.length);
            for (boolean bool : b) {
                write.bool(bool);
            }
        } else if (object instanceof Unit) {
            Unit u = (Unit)object;
            write.b(17);
            write.i(u.id);
        } else if (object instanceof UnitBox) {
            UnitBox u = (UnitBox)object;
            write.b(17);
            write.i(u.id);
        } else if (object instanceof Vec2[]) {
            Vec2[] vecs = (Vec2[])object;
            write.b(18);
            write.s(vecs.length);
            for (Vec2 v : vecs) {
                write.f(v.x);
                write.f(v.y);
            }
        } else if (object instanceof Vec2) {
            Vec2 v = (Vec2)object;
            write.b(19);
            write.f(v.x);
            write.f(v.y);
        } else if (object instanceof Team) {
            Team t = (Team)object;
            write.b(20);
            write.b(t.id);
        } else if (object instanceof int[]) {
            int[] i = (int[])object;
            write.b(21);
            TypeIO.writeInts(write, i);
        } else if (object instanceof Object[]) {
            Object[] objs = (Object[])object;
            write.b(22);
            write.i(objs.length);
            for (Object obj : objs) {
                TypeIO.writeObject(write, obj);
            }
        } else if (object instanceof UnitCommand) {
            UnitCommand command = (UnitCommand)object;
            write.b(23);
            write.s((int)command.id);
        } else {
            throw new IllegalArgumentException("Unknown object type: " + object.getClass());
        }
    }

    @Nullable
    public static Object readObject(Reads read) {
        return TypeIO.readObjectBoxed(read, false);
    }

    @Nullable
    public static Object readObjectBoxed(Reads read, boolean box) {
        return TypeIO.readObject(read, box, null);
    }

    @Nullable
    public static Object readObject(Reads read, boolean box, @Nullable ContentMapper mapper) {
        IntSeq intSeq;
        byte type = read.b();
        switch (type) {
            case 0: {
                intSeq = null;
                break;
            }
            case 1: {
                intSeq = Integer.valueOf(read.i());
                break;
            }
            case 2: {
                intSeq = Long.valueOf(read.l());
                break;
            }
            case 3: {
                intSeq = Float.valueOf(read.f());
                break;
            }
            case 4: {
                intSeq = TypeIO.readString(read);
                break;
            }
            case 5: {
                if (mapper == null) {
                    intSeq = Vars.content.getByID(ContentType.all[read.b()], read.s());
                    break;
                }
                intSeq = mapper.get(ContentType.all[read.b()], (int)read.s());
                break;
            }
            case 6: {
                int length = read.s();
                IntSeq arr = new IntSeq(length);
                for (int i = 0; i < length; ++i) {
                    arr.add(read.i());
                }
                intSeq = arr;
                break;
            }
            case 7: {
                intSeq = new Point2(read.i(), read.i());
                break;
            }
            case 8: {
                int len = read.b();
                Point2[] out = new Point2[len];
                for (int i = 0; i < len; ++i) {
                    out[i] = Point2.unpack((int)read.i());
                }
                intSeq = out;
                break;
            }
            case 9: {
                intSeq = ((UnlockableContent)((Object)Vars.content.getByID((ContentType)ContentType.all[read.b()], (int)read.s()))).techNode;
                break;
            }
            case 10: {
                intSeq = Boolean.valueOf(read.bool());
                break;
            }
            case 11: {
                intSeq = Double.valueOf(read.d());
                break;
            }
            case 12: {
                if (!box) {
                    intSeq = Vars.world.build(read.i());
                    break;
                }
                intSeq = new BuildingBox(read.i());
                break;
            }
            case 13: {
                intSeq = LAccess.all[read.s()];
                break;
            }
            case 14: {
                int blen = read.i();
                byte[] bytes = new byte[blen];
                read.b(bytes);
                intSeq = (IntSeq)bytes;
                break;
            }
            case 15: {
                read.b();
                intSeq = null;
                break;
            }
            case 16: {
                int boollen = read.i();
                boolean[] bools = new boolean[boollen];
                for (int i = 0; i < boollen; ++i) {
                    bools[i] = read.bool();
                }
                intSeq = (IntSeq)bools;
                break;
            }
            case 17: {
                if (!box) {
                    intSeq = Groups.unit.getByID(read.i());
                    break;
                }
                intSeq = new UnitBox(read.i());
                break;
            }
            case 18: {
                int len = read.s();
                Vec2[] out = new Vec2[len];
                for (int i = 0; i < len; ++i) {
                    out[i] = new Vec2(read.f(), read.f());
                }
                intSeq = out;
                break;
            }
            case 19: {
                intSeq = new Vec2(read.f(), read.f());
                break;
            }
            case 20: {
                intSeq = Team.all[read.ub()];
                break;
            }
            case 21: {
                intSeq = (IntSeq)TypeIO.readInts(read);
                break;
            }
            case 22: {
                int objlen = read.i();
                Object[] objs = new Object[objlen];
                for (int i = 0; i < objlen; ++i) {
                    objs[i] = TypeIO.readObject(read, box, mapper);
                }
                intSeq = objs;
                break;
            }
            case 23: {
                intSeq = Vars.content.unitCommand(read.us());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown object type: " + type);
            }
        }
        return intSeq;
    }

    public static void writePayload(Writes writes, Payload payload) {
        Payload.write((Payload)payload, (Writes)writes);
    }

    public static Payload readPayload(Reads read) {
        return Payload.read((Reads)read);
    }

    public static void writeMounts(Writes writes, WeaponMount[] mounts) {
        writes.b(mounts.length);
        for (WeaponMount m : mounts) {
            writes.b((m.shoot ? 1 : 0) | (m.rotate ? 2 : 0));
            writes.f(m.aimX);
            writes.f(m.aimY);
        }
    }

    public static WeaponMount[] readMounts(Reads read, WeaponMount[] mounts) {
        int len = read.b();
        for (int i = 0; i < len; ++i) {
            byte state = read.b();
            float ax = read.f();
            float ay = read.f();
            if (i > mounts.length - 1) continue;
            WeaponMount m = mounts[i];
            m.aimX = ax;
            m.aimY = ay;
            m.shoot = (state & 1) != 0;
            m.rotate = (state & 2) != 0;
        }
        return mounts;
    }

    public static WeaponMount[] readMounts(Reads read) {
        read.skip(read.b() * 9);
        return noMounts;
    }

    public static Ability[] readAbilities(Reads read, Ability[] abilities) {
        int len = read.b();
        for (int i = 0; i < len; ++i) {
            float data = read.f();
            if (abilities.length <= i) continue;
            abilities[i].data = data;
        }
        return abilities;
    }

    public static void writeAbilities(Writes write, Ability[] abilities) {
        write.b(abilities.length);
        for (Ability a : abilities) {
            write.f(a.data);
        }
    }

    public static Ability[] readAbilities(Reads read) {
        read.skip((int)read.b());
        return noAbilities;
    }

    public static void writeUnitContainer(Writes write, Units.UnitSyncContainer cont) {
        write.i(cont.unit.id);
        write.b(cont.unit.classId() & 0xFF);
        cont.unit.beforeWrite();
        cont.unit.writeSync(write);
    }

    public static Units.UnitSyncContainer readUnitContainer(Reads read) {
        int id = read.i();
        int typeID = read.ub();
        Unit entity = (Unit)Groups.unit.getByID(id);
        boolean add = false;
        boolean created = false;
        if (entity == null) {
            entity = (Unit)EntityMapping.map((int)(typeID & 0xFF)).get();
            entity.id(id);
            if (!Vars.netClient.isEntityUsed(entity.id())) {
                add = true;
            }
            created = true;
        }
        entity.readSync(read);
        if (created) {
            entity.snapSync();
        }
        if (add) {
            entity.add();
            Vars.netClient.addRemovedEntity(entity.id());
        }
        return new Units.UnitSyncContainer(entity);
    }

    public static void writeUnit(Writes write, Unit unit) {
        write.b(unit == null ? 0 : (unit instanceof BlockUnitc ? 1 : 2));
        if (unit instanceof BlockUnitc) {
            write.i(((BlockUnitc)unit).tile().pos());
        } else if (unit == null) {
            write.i(0);
        } else {
            write.i(unit.id);
        }
    }

    public static Unit readUnit(Reads read) {
        byte type = read.b();
        int id = read.i();
        if (type == 0) {
            return null;
        }
        if (type == 2) {
            return (Unit)Groups.unit.getByID(id);
        }
        if (type == 1) {
            Unit unit;
            Building tile = Vars.world.build(id);
            if (tile instanceof ControlBlock) {
                ControlBlock cont = (ControlBlock)tile;
                unit = cont.unit();
            } else {
                unit = null;
            }
            return unit;
        }
        return null;
    }

    public static void writeCommand(Writes write, @Nullable UnitCommand command) {
        write.b(command == null ? 255 : (int)command.id);
    }

    @Nullable
    public static UnitCommand readCommand(Reads read) {
        int val = read.ub();
        return val == 255 ? null : Vars.content.unitCommand(val);
    }

    public static void writeStance(Writes write, @Nullable UnitStance stance) {
        write.b(stance == null ? 255 : (int)stance.id);
    }

    public static UnitStance readStance(Reads read) {
        int val = read.ub();
        return val == 255 || val >= Vars.content.unitStances().size ? UnitStance.stop : Vars.content.unitStance(val);
    }

    public static void writeEntity(Writes write, Entityc entity) {
        write.i(entity == null ? -1 : entity.id());
    }

    public static <T extends Entityc> T readEntity(Reads read) {
        return Groups.sync.getByID(read.i());
    }

    public static void writeBuilding(Writes write, Building tile) {
        write.i(tile == null ? -1 : tile.pos());
    }

    public static Building readBuilding(Reads read) {
        return Vars.world.build(read.i());
    }

    public static void writeTile(Writes write, Tile tile) {
        write.i(tile == null ? Point2.pack((int)-1, (int)-1) : tile.pos());
    }

    public static Tile readTile(Reads read) {
        return Vars.world.tile(read.i());
    }

    public static void writeBlock(Writes write, Block block) {
        if (LogicExt.contentsCompatibleMode) {
            write.s(Vars.content.getTemporaryMapperId(block));
            return;
        }
        write.s((int)block.id);
    }

    public static Block readBlock(Reads read) {
        return Vars.content.block(read.s());
    }

    public static int getMaxPlans(Queue<BuildPlan> plans) {
        int used = Math.min(plans.size, 20);
        int totalLength = 0;
        for (int i = 0; i < used; ++i) {
            Object b;
            BuildPlan plan = (BuildPlan)plans.get(i);
            Object object = plan.config;
            if (object instanceof byte[]) {
                b = (byte[])object;
                totalLength += ((byte[])b).length;
            }
            if ((object = plan.config) instanceof String) {
                b = (String)object;
                totalLength += ((String)b).length();
            }
            if (totalLength <= 500) continue;
            used = i + 1;
            break;
        }
        return used;
    }

    public static void writePlansQueueNet(Writes write, Queue<BuildPlan> plans) {
        if (plans == null) {
            write.i(-1);
            return;
        }
        int used = TypeIO.getMaxPlans(plans);
        write.i(used);
        for (int i = 0; i < used; ++i) {
            TypeIO.writePlan(write, (BuildPlan)plans.get(i));
        }
    }

    public static Queue<BuildPlan> readPlansQueue(Reads read) {
        int used = read.i();
        if (used == -1) {
            return null;
        }
        Queue out = new Queue();
        for (int i = 0; i < used; ++i) {
            out.add((Object)TypeIO.readPlan(read));
        }
        return out;
    }

    public static void writePlan(Writes write, BuildPlan plan) {
        write.b(plan.breaking ? 1 : 0);
        write.i(Point2.pack((int)plan.x, (int)plan.y));
        if (!plan.breaking) {
            TypeIO.writeBlock(write, plan.block);
            write.b((int)((byte)plan.rotation));
            boolean writePlan = !Vars.headless || !Vars.net.server();
            write.b(writePlan ? 1 : 0);
            TypeIO.writeObject(write, writePlan ? plan.config : null);
        }
    }

    public static BuildPlan readPlan(Reads read) {
        BuildPlan current;
        byte type = read.b();
        int position = read.i();
        if (Vars.world.tile(position) == null) {
            return null;
        }
        if (type == 1) {
            current = new BuildPlan((int)Point2.x((int)position), (int)Point2.y((int)position));
        } else {
            short block = read.s();
            byte rotation = read.b();
            boolean hasConfig = read.b() == 1;
            Object config = TypeIO.readObject(read);
            current = new BuildPlan((int)Point2.x((int)position), (int)Point2.y((int)position), (int)rotation, Vars.content.block(block));
            if (hasConfig) {
                current.config = config;
            }
        }
        return current;
    }

    public static void writePlans(Writes write, BuildPlan[] plans) {
        if (plans == null) {
            write.s(-1);
            return;
        }
        write.s((int)((short)plans.length));
        for (BuildPlan plan : plans) {
            TypeIO.writePlan(write, plan);
        }
    }

    public static BuildPlan[] readPlans(Reads read) {
        int reqamount = read.s();
        if (reqamount == -1) {
            return null;
        }
        BuildPlan[] reqs = new BuildPlan[reqamount];
        for (int i = 0; i < reqamount; ++i) {
            BuildPlan plan = TypeIO.readPlan(read);
            if (plan == null) continue;
            reqs[i] = plan;
        }
        return reqs;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeController(Writes write, UnitController control) {
        Object b;
        Object object;
        CommandAI ai;
        if (control instanceof Player) {
            Player p = (Player)control;
            write.b(0);
            write.i(p.id);
            return;
        }
        if (control instanceof LogicAI) {
            LogicAI logic = (LogicAI)control;
            if (logic.controller != null) {
                write.b(3);
                write.i(logic.controller.pos());
                return;
            }
        }
        if (control instanceof CommandAI) {
            ai = (CommandAI)control;
            write.b(9);
            write.bool(ai.attackTarget != null);
            write.bool(ai.targetPos != null);
            if (ai.targetPos != null) {
                write.f(ai.targetPos.x);
                write.f(ai.targetPos.y);
            }
            if (ai.attackTarget != null) {
                write.b(ai.attackTarget instanceof Building ? 1 : 0);
                object = ai.attackTarget;
                if (object instanceof Building) {
                    b = (Building)object;
                    write.i(((Building)b).pos());
                } else {
                    write.i(((Unit)ai.attackTarget).id);
                }
            }
            write.b(ai.command == null ? -1 : (int)ai.command.id);
            write.b(ai.commandQueue.size);
            b = ai.commandQueue.iterator();
        } else {
            if (control instanceof AssemblerAI) {
                write.b(5);
                return;
            }
            write.b(2);
            return;
        }
        while (b.hasNext()) {
            Position pos = (Position)b.next();
            if (pos instanceof Building) {
                Building b2 = (Building)pos;
                write.b(0);
                write.i(b2.pos());
                continue;
            }
            if (pos instanceof Unit) {
                Unit u = (Unit)pos;
                write.b(1);
                write.i(u.id);
                continue;
            }
            if (pos instanceof Vec2) {
                Vec2 v = (Vec2)pos;
                write.b(2);
                write.f(v.x);
                write.f(v.y);
                continue;
            }
            write.b(3);
        }
        int count = Vars.content.unitStances().count(arg_0 -> ((CommandAI)ai).hasStance(arg_0));
        write.b(count);
        object = Vars.content.unitStances().iterator();
        while (object.hasNext()) {
            UnitStance stance = (UnitStance)object.next();
            if (!ai.hasStance(stance)) continue;
            TypeIO.writeStance(write, stance);
        }
    }

    public static UnitController readController(Reads read, UnitController prev) {
        byte type = read.b();
        if (type == 0) {
            int id = read.i();
            Player player = (Player)Groups.player.getByID(id);
            if (player == null) {
                return prev;
            }
            return player;
        }
        if (type == 1) {
            read.i();
            return prev;
        }
        if (type == 3) {
            int pos = read.i();
            if (prev instanceof LogicAI) {
                LogicAI pai = (LogicAI)prev;
                pai.controller = Vars.world.build(pos);
                return pai;
            }
            LogicAI out = new LogicAI();
            out.controlTimer = 600.0f;
            out.controller = Vars.world.build(pos);
            return out;
        }
        if (type == 4 || type == 6 || type == 7 || type == 8 || type == 9) {
            int i;
            CommandAI pai;
            CommandAI ai = prev instanceof CommandAI ? (pai = (CommandAI)prev) : new CommandAI();
            boolean hasAttack = read.bool();
            boolean hasPos = read.bool();
            if (hasPos) {
                if (ai.targetPos == null) {
                    ai.targetPos = new Vec2();
                }
                ai.targetPos.set(read.f(), read.f());
            } else {
                ai.targetPos = null;
            }
            ai.setupLastPos();
            ai.readAttackTarget = -1;
            if (hasAttack) {
                byte entityType = read.b();
                if (entityType == 1) {
                    ai.attackTarget = Vars.world.build(read.i());
                } else {
                    ai.readAttackTarget = read.i();
                    ai.attackTarget = (Teamc)Groups.unit.getByID(ai.readAttackTarget);
                }
            } else {
                ai.attackTarget = null;
            }
            if (type == 6 || type == 7 || type == 8 || type == 9) {
                byte id = read.b();
                UnitCommand unitCommand = ai.command = id < 0 ? null : Vars.content.unitCommand(id);
                if (ai.command == null) {
                    ai.command = UnitCommand.moveCommand;
                }
            }
            if (type == 7 || type == 8 || type == 9) {
                ai.commandQueue.clear();
                int length = read.ub();
                block5: for (i = 0; i < length; ++i) {
                    byte commandType = read.b();
                    switch (commandType) {
                        case 0: {
                            Building build = Vars.world.build(read.i());
                            if (build == null) continue block5;
                            ai.commandQueue.add((Object)build);
                            continue block5;
                        }
                        case 1: {
                            Unit unit = (Unit)Groups.unit.getByID(read.i());
                            if (unit == null) continue block5;
                            ai.commandQueue.add((Object)unit);
                            continue block5;
                        }
                        case 2: {
                            ai.commandQueue.add((Object)new Vec2(read.f(), read.f()));
                        }
                    }
                }
            }
            if (type == 8) {
                ai.setStance(TypeIO.readStance(read));
            } else if (type == 9) {
                int stances = read.ub();
                for (i = 0; i < stances; ++i) {
                    ai.setStance(TypeIO.readStance(read));
                }
            }
            return ai;
        }
        if (type == 5) {
            return prev instanceof AssemblerAI ? prev : new AssemblerAI();
        }
        return !(prev instanceof AIController) || prev instanceof LogicAI ? new GroundAI() : prev;
    }

    public static void writeKick(Writes write, Packets.KickReason reason) {
        write.b((int)((byte)reason.ordinal()));
    }

    public static Packets.KickReason readKick(Reads read) {
        return Packets.KickReason.all[read.b()];
    }

    public static void writeMarkerControl(Writes write, LMarkerControl reason) {
        write.b((int)((byte)reason.ordinal()));
    }

    public static LMarkerControl readMarkerControl(Reads read) {
        return LMarkerControl.all[read.ub()];
    }

    public static void writeRules(Writes write, Rules rules) {
        String string = JsonIO.write((Object)rules);
        byte[] bytes = string.getBytes(Vars.charset);
        write.i(bytes.length);
        write.b(bytes);
    }

    public static Rules readRules(Reads read) {
        int length = read.i();
        String string = new String(read.b(new byte[length]), Vars.charset);
        return (Rules)JsonIO.read(Rules.class, (String)string);
    }

    public static void writeObjectives(Writes write, MapObjectives executor) {
        String string = JsonIO.write((Object)executor);
        byte[] bytes = string.getBytes(Vars.charset);
        write.i(bytes.length);
        write.b(bytes);
    }

    public static MapObjectives readObjectives(Reads read) {
        int length = read.i();
        String string = new String(read.b(new byte[length]), Vars.charset);
        return (MapObjectives)JsonIO.read(MapObjectives.class, (String)string);
    }

    public static void writeObjectiveMarker(Writes write, MapObjectives.ObjectiveMarker marker) {
        String string = JsonIO.json.toJson((Object)marker, MapObjectives.ObjectiveMarker.class);
        byte[] bytes = string.getBytes(Vars.charset);
        write.i(bytes.length);
        write.b(bytes);
    }

    public static MapObjectives.ObjectiveMarker readObjectiveMarker(Reads read) {
        int length = read.i();
        String string = new String(read.b(new byte[length]), Vars.charset);
        return (MapObjectives.ObjectiveMarker)JsonIO.read(MapObjectives.ObjectiveMarker.class, (String)string);
    }

    public static void writeVecNullable(Writes write, @Nullable Vec2 v) {
        if (v == null) {
            write.f(Float.NaN);
            write.f(Float.NaN);
        } else {
            write.f(v.x);
            write.f(v.y);
        }
    }

    @Nullable
    public static Vec2 readVecNullable(Reads read) {
        float x = read.f();
        float y = read.f();
        return Float.isNaN(x) || Float.isNaN(y) ? null : new Vec2(x, y);
    }

    public static void writeVec2(Writes write, Vec2 v) {
        if (v == null) {
            write.f(0.0f);
            write.f(0.0f);
        } else {
            write.f(v.x);
            write.f(v.y);
        }
    }

    public static Vec2 readVec2(Reads read, Vec2 base) {
        return base.set(read.f(), read.f());
    }

    public static Vec2 readVec2(Reads read) {
        return new Vec2(read.f(), read.f());
    }

    public static void writeStatus(Writes write, StatusEntry entry) {
        write.s((int)entry.effect.id);
        write.f(entry.time);
        if (entry.effect.dynamic) {
            write.b((entry.damageMultiplier != 1.0f ? 1 : 0) | (entry.healthMultiplier != 1.0f ? 2 : 0) | (entry.speedMultiplier != 1.0f ? 4 : 0) | (entry.reloadMultiplier != 1.0f ? 8 : 0) | (entry.buildSpeedMultiplier != 1.0f ? 16 : 0) | (entry.dragMultiplier != 1.0f ? 32 : 0) | (entry.armorOverride >= 0.0f ? 64 : 0));
            if (entry.damageMultiplier != 1.0f) {
                write.f(entry.damageMultiplier);
            }
            if (entry.healthMultiplier != 1.0f) {
                write.f(entry.healthMultiplier);
            }
            if (entry.speedMultiplier != 1.0f) {
                write.f(entry.speedMultiplier);
            }
            if (entry.reloadMultiplier != 1.0f) {
                write.f(entry.reloadMultiplier);
            }
            if (entry.buildSpeedMultiplier != 1.0f) {
                write.f(entry.buildSpeedMultiplier);
            }
            if (entry.dragMultiplier != 1.0f) {
                write.f(entry.dragMultiplier);
            }
            if (entry.armorOverride >= 0.0f) {
                write.f(entry.armorOverride);
            }
        }
    }

    public static StatusEntry readStatus(Reads read) {
        short id = read.s();
        float time = read.f();
        StatusEntry result = new StatusEntry().set((StatusEffect)((Object)Vars.content.getByID(ContentType.status, id)), time);
        if (result.effect.dynamic) {
            int flags = read.ub();
            if ((flags & 1) != 0) {
                result.damageMultiplier = read.f();
            }
            if ((flags & 2) != 0) {
                result.healthMultiplier = read.f();
            }
            if ((flags & 4) != 0) {
                result.speedMultiplier = read.f();
            }
            if ((flags & 8) != 0) {
                result.reloadMultiplier = read.f();
            }
            if ((flags & 0x10) != 0) {
                result.buildSpeedMultiplier = read.f();
            }
            if ((flags & 0x20) != 0) {
                result.dragMultiplier = read.f();
            }
            if ((flags & 0x40) != 0) {
                result.armorOverride = read.f();
            }
        }
        return result;
    }

    public static void writeItems(Writes write, ItemStack stack) {
        TypeIO.writeItem(write, stack.item);
        write.i(stack.amount);
    }

    public static ItemStack readItems(Reads read, ItemStack stack) {
        return stack.set(TypeIO.readItem(read), read.i());
    }

    public static ItemStack readItems(Reads read) {
        return new ItemStack(TypeIO.readItem(read), read.i());
    }

    public static void writeItemStacks(Writes write, ItemStack[] stacks) {
        write.s(stacks.length);
        for (ItemStack stack : stacks) {
            TypeIO.writeItems(write, stack);
        }
    }

    public static ItemStack[] readItemStacks(Reads read) {
        int count = read.s();
        ItemStack[] stacks = new ItemStack[count];
        for (int i = 0; i < count; ++i) {
            stacks[i] = TypeIO.readItems(read);
        }
        return stacks;
    }

    public static void writeLiquidStacks(Writes write, LiquidStack[] stacks) {
        write.s(stacks.length);
        for (LiquidStack stack : stacks) {
            TypeIO.writeLiquid(write, stack.liquid);
            write.f(stack.amount);
        }
    }

    public static LiquidStack[] readLiquidStacks(Reads read) {
        int count = read.s();
        LiquidStack[] stacks = new LiquidStack[count];
        for (int i = 0; i < count; ++i) {
            Liquid liquid = TypeIO.readLiquid(read);
            stacks[i] = new LiquidStack(liquid, read.f());
        }
        return stacks;
    }

    public static void writeTeam(Writes write, Team team) {
        write.b(team == null ? 0 : team.id);
    }

    public static Team readTeam(Reads read) {
        return Team.get((int)read.b());
    }

    public static void writeAction(Writes write, Packets.AdminAction reason) {
        write.b((int)((byte)reason.ordinal()));
    }

    public static Packets.AdminAction readAction(Reads read) {
        return Packets.AdminAction.all[read.b()];
    }

    public static void writeUnitType(Writes write, UnitType effect) {
        write.s((int)effect.id);
    }

    public static UnitType readUnitType(Reads read) {
        return (UnitType)((Object)Vars.content.getByID(ContentType.unit, read.s()));
    }

    public static void writeEffect(Writes write, Effect effect) {
        write.s(effect.id);
    }

    public static Effect readEffect(Reads read) {
        return Effect.get((int)read.us());
    }

    public static void writeColor(Writes write, Color color) {
        write.i(color.rgba());
    }

    public static Color readColor(Reads read) {
        return new Color(read.i());
    }

    public static Color readColor(Reads read, Color color) {
        return color.set(read.i());
    }

    public static void writeIntSeq(Writes write, IntSeq seq) {
        write.i(seq.size);
        for (int i = 0; i < seq.size; ++i) {
            write.i(seq.items[i]);
        }
    }

    public static IntSeq readIntSeq(Reads read) {
        int size = read.i();
        IntSeq result = new IntSeq(size);
        for (int i = 0; i < size; ++i) {
            result.items[i] = read.i();
        }
        result.size = size;
        return result;
    }

    public static void writeContent(Writes write, Content cont) {
        write.b(cont.getContentType().ordinal());
        write.s((int)cont.id);
    }

    public static Content readContent(Reads read) {
        byte id = read.b();
        return Vars.content.getByID(ContentType.all[id], read.s());
    }

    public static void writeLiquid(Writes write, Liquid liquid) {
        write.s(liquid == null ? -1 : (int)liquid.id);
    }

    public static Liquid readLiquid(Reads read) {
        short id = read.s();
        return id == -1 ? null : Vars.content.liquid(id);
    }

    public static void writeBulletType(Writes write, BulletType type) {
        write.s((int)type.id);
    }

    public static BulletType readBulletType(Reads read) {
        return (BulletType)Vars.content.getByID(ContentType.bullet, read.s());
    }

    public static void writeItem(Writes write, Item item) {
        write.s(item == null ? -1 : (int)item.id);
    }

    public static Item readItem(Reads read) {
        short id = read.s();
        return id == -1 ? null : Vars.content.item(id);
    }

    public static void writeSound(Writes write, Sound sound) {
        write.s(Sounds.getSoundId((Sound)sound));
    }

    public static Sound readSound(Reads read) {
        return Sounds.getSound((int)read.s());
    }

    public static void writeWeather(Writes write, Weather item) {
        write.s(item == null ? -1 : (int)item.id);
    }

    public static Weather readWeather(Reads read) {
        short id = read.s();
        return id == -1 ? null : (Weather)((Object)Vars.content.getByID(ContentType.weather, id));
    }

    public static void writeString(Writes write, String string) {
        if (string != null) {
            write.b(1);
            write.str(string);
        } else {
            write.b(0);
        }
    }

    public static String readString(Reads read) {
        byte exists = read.b();
        if (exists != 0) {
            return read.str();
        }
        return null;
    }

    public static void writeString(ByteBuffer write, String string) {
        if (string != null) {
            byte[] bytes = string.getBytes(Vars.charset);
            write.putShort((short)bytes.length);
            write.put(bytes);
        } else {
            write.putShort((short)-1);
        }
    }

    public static String readString(ByteBuffer read) {
        short slength = read.getShort();
        if (slength != -1) {
            byte[] bytes = new byte[slength];
            read.get(bytes);
            return new String(bytes, Vars.charset);
        }
        return null;
    }

    public static void writeBytes(Writes write, byte[] bytes) {
        write.s((int)((short)bytes.length));
        write.b(bytes);
    }

    public static byte[] readBytes(Reads read) {
        short length = read.s();
        return read.b(new byte[length]);
    }

    public static void writeInts(Writes write, int[] ints) {
        write.s((int)((short)ints.length));
        for (int i : ints) {
            write.i(i);
        }
    }

    public static int[] readInts(Reads read) {
        int length = read.s();
        int[] out = new int[length];
        for (int i = 0; i < length; ++i) {
            out[i] = read.i();
        }
        return out;
    }

    public static void writeTraceInfo(Writes write, Administration.TraceInfo trace) {
        TypeIO.writeString(write, trace.ip);
        TypeIO.writeString(write, trace.uuid);
        TypeIO.writeString(write, trace.locale);
        write.b(trace.modded ? 1 : 0);
        write.b(trace.mobile ? 1 : 0);
        write.i(trace.timesJoined);
        write.i(trace.timesKicked);
        TypeIO.writeStrings(write, trace.ips, 12);
        TypeIO.writeStrings(write, trace.names, 12);
    }

    public static Administration.TraceInfo readTraceInfo(Reads read) {
        return new Administration.TraceInfo(TypeIO.readString(read), TypeIO.readString(read), TypeIO.readString(read), read.b() == 1, read.b() == 1, read.i(), read.i(), TypeIO.readStrings(read), TypeIO.readStrings(read));
    }

    public static void writeStrings(Writes write, String[] strings, int maxLen) {
        write.b(Math.min(strings.length, maxLen));
        for (int i = 0; i < Math.min(strings.length, maxLen); ++i) {
            TypeIO.writeString(write, strings[i]);
        }
    }

    public static void writeStrings(Writes write, String[] strings) {
        write.b(strings.length);
        for (String s : strings) {
            TypeIO.writeString(write, s);
        }
    }

    public static String[] readStrings(Reads read) {
        int length = read.ub();
        String[] result = new String[length];
        for (int j = 0; j < length; ++j) {
            result[j] = TypeIO.readString(read);
        }
        return result;
    }

    public static void writeStringArray(Writes write, String[][] strings) {
        write.b(strings.length);
        for (String[] string : strings) {
            write.b(string.length);
            for (String s : string) {
                TypeIO.writeString(write, s);
            }
        }
    }

    public static String[][] readStringArray(Reads read) {
        int rows = read.ub();
        String[][] strings = new String[rows][];
        for (int i = 0; i < rows; ++i) {
            int columns = read.ub();
            strings[i] = new String[columns];
            for (int j = 0; j < columns; ++j) {
                strings[i][j] = TypeIO.readString(read);
            }
        }
        return strings;
    }

    public static void writeStringData(DataOutput buffer, String string) throws IOException {
        if (string != null) {
            byte[] bytes = string.getBytes(Vars.charset);
            buffer.writeShort((short)bytes.length);
            buffer.write(bytes);
        } else {
            buffer.writeShort(-1);
        }
    }

    public static String readStringData(DataInput buffer) throws IOException {
        short slength = buffer.readShort();
        if (slength != -1) {
            byte[] bytes = new byte[slength];
            buffer.readFully(bytes);
            return new String(bytes, Vars.charset);
        }
        return null;
    }

    public static class BuildingBox
    implements Boxed<Building> {
        public int pos;

        public BuildingBox(int pos) {
            this.pos = pos;
        }

        public Building unbox() {
            return Vars.world.build(this.pos);
        }

        public String toString() {
            return "BuildingBox{pos=" + this.pos + '}';
        }
    }

    public static class UnitBox
    implements Boxed<Unit> {
        public int id;

        public UnitBox(int id) {
            this.id = id;
        }

        public Unit unbox() {
            return (Unit)Groups.unit.getByID(this.id);
        }

        public String toString() {
            return "UnitBox{id=" + this.id + '}';
        }
    }
}

