/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.func.Cons;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.util.Log;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.logic.LAssembler;
import mindustry.logic.LExecutor;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tiles;

public class LogicFilter
extends GenerateFilter {
    public static int maxInstructionsExecution = 6250000;
    public String code;
    public boolean loop;

    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption(){
            final String name;
            {
                this.name = "code";
            }

            public void build(Table table2) {
                table2.button(b -> b.image((Drawable)Icon.pencil).size(24.0f), () -> Vars.ui.logic.show(LogicFilter.this.code, null, true, (Cons<String>)((Cons)code -> {
                    LogicFilter.this.code = code;
                }))).pad(4.0f).margin(12.0f);
                table2.add((CharSequence)("@filter.option." + this.name));
            }
        }, new FilterOption.ToggleOption("loop", () -> this.loop, f -> {
            this.loop = f;
        })};
    }

    public void apply(Tiles tiles, GenerateFilter.GenerateInput in) {
        LExecutor executor = new LExecutor();
        executor.privileged = true;
        try {
            executor.load(LAssembler.assemble((String)this.code, (boolean)true));
        }
        catch (Throwable ignored) {
            Log.err((Throwable)ignored);
            return;
        }
        Vars.logicVars.update();
        for (int i = 1; i < maxInstructionsExecution && (this.loop || !(executor.counter.numval >= (double)executor.instructions.length) && !(executor.counter.numval < 0.0)); ++i) {
            executor.runOnce();
        }
    }

    public char icon() {
        return '\uf7e4';
    }

    public boolean isPost() {
        return true;
    }
}

