/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.struct.Seq;
import java.net.URL;

public class ModClassLoader
extends ClassLoader {
    private Seq<ClassLoader> children = new Seq();
    private ThreadLocal<Boolean> inChild = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public ModClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addChild(ClassLoader child) {
        this.children.add((Object)child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.inChild.get().booleanValue()) {
            this.inChild.set(false);
            throw new ClassNotFoundException(name);
        }
        ClassNotFoundException last = null;
        int size = this.children.size;
        int i = 0;
        while (i < size) {
            try {
                this.inChild.set(true);
                Class<?> clazz = ((ClassLoader)this.children.get(i)).loadClass(name);
                this.inChild.set(false);
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    this.inChild.set(false);
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    last = e;
                    ++i;
                }
            }
        }
        throw last == null ? new ClassNotFoundException(name) : last;
    }

    @Override
    public URL getResource(String name) {
        if (name.equals("mod.hjson") || name.equals("icon.png")) {
            return null;
        }
        return super.getResource(name);
    }
}

