/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Strings;
import arc.util.io.PropertiesUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.mod.Mods;
import mindustryX.features.MetricCollector;

public class CrashHandler {
    public static String createReport(Throwable exception) {
        String report;
        MetricCollector.INSTANCE.handleException(exception);
        String error = CrashHandler.writeException(exception);
        Mods.LoadedMod cause = CrashHandler.getModCause(exception);
        String string = report = cause == null ? "Mindustry has crashed. How unfortunate.\n" : "The mod '" + cause.meta.displayName + "' (" + cause.name + ") has caused Mindustry to crash.\n";
        if (Vars.mods != null && Vars.mods.list().size == 0 && Version.build != -1) {
            report = report + "Report this at https://github.com/TinyLake/MindustryX/issues/new?labels=bug&template=bug_report.md\n\n";
        }
        Seq enabledMods = Vars.mods == null ? null : Vars.mods.list().select(m -> m.shouldBeEnabled() && m.isSupported());
        return report + "Version: " + Version.combined() + (Version.buildDate.equals("unknown") ? "" : " (Built " + Version.buildDate + ")") + (Vars.headless ? " (Server)" : "") + "\nDate: " + new SimpleDateFormat("MMMM d, yyyy HH:mm:ss a", Locale.getDefault()).format(new Date()) + "\nOS: " + OS.osName + (OS.osArchBits != null ? " x" + OS.osArchBits : "") + " (" + OS.osArch + ")\n" + (Core.graphics == null || Core.graphics.getGLVersion() == null ? "" : "GL Version: " + Core.graphics.getGLVersion() + "\n") + ((OS.isAndroid || OS.isIos) && Core.app != null ? "Android API level: " + Core.app.getVersion() + "\n" : "") + "Java Version: " + OS.javaVersion + "\nRuntime Available Memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "mb\nCores: " + OS.cores + "\n" + (cause == null ? "" : "Likely Cause: " + cause.meta.displayName + " (" + cause.name + " v" + cause.meta.version + ")\n") + (enabledMods == null ? "<no mod init>" : "Mods: " + (enabledMods.isEmpty() ? "none (vanilla)" : enabledMods.toString(", ", mod -> mod.name + ":" + mod.meta.version))) + "\n" + (Vars.state != null && Vars.state.patcher != null && Vars.state.patcher.patches != null && Vars.state.patcher.patches.size > 0 ? "Patches: \n" + Vars.state.patcher.patches.toString("\n---\n", p -> p.patch) + "\n" : "") + "\n\n" + error;
    }

    public static void log(Throwable exception) {
        try {
            Core.settings.getDataDirectory().child("crashes").child("crash_" + System.currentTimeMillis() + ".txt").writeString(CrashHandler.createReport(exception));
            MetricCollector.INSTANCE.waitPost();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void handle(Throwable exception, Cons<File> writeListener) {
        try {
            try {
                Log.err((Throwable)exception);
            }
            catch (Throwable no) {
                exception.printStackTrace();
            }
            try {
                Core.settings.manualSave();
            }
            catch (Throwable no) {
                // empty catch block
            }
            if (OS.username.equals("anuke") && !"steam".equals(Version.modifier)) {
                System.exit(1);
            }
            if (Version.number == 0) {
                try {
                    ObjectMap map = new ObjectMap();
                    PropertiesUtils.load((ObjectMap)map, (Reader)new InputStreamReader(CrashHandler.class.getResourceAsStream("/version.properties")));
                    Version.type = (String)map.get((Object)"type");
                    Version.number = Integer.parseInt((String)map.get((Object)"number"));
                    Version.modifier = (String)map.get((Object)"modifier");
                    if (((String)map.get((Object)"build")).contains(".")) {
                        String[] split = ((String)map.get((Object)"build")).split("\\.");
                        Version.build = Integer.parseInt(split[0]);
                        Version.revision = Integer.parseInt(split[1]);
                    } else {
                        Version.build = Strings.canParseInt((String)((String)map.get((Object)"build"))) ? Integer.parseInt((String)map.get((Object)"build")) : -1;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Log.err((String)"Failed to parse version.", (Object[])new Object[0]);
                }
            }
            try {
                File file = new File(OS.getAppDataDirectoryString((String)"Mindustry"), "crashes/crash-report-" + new SimpleDateFormat("MM_dd_yyyy_HH_mm_ss").format(new Date()) + ".txt");
                new Fi(OS.getAppDataDirectoryString((String)"Mindustry")).child("crashes").mkdirs();
                new Fi(file).writeString(CrashHandler.createReport(exception));
                writeListener.get((Object)file);
            }
            catch (Throwable e) {
                Log.err((String)"Failed to save local crash report.", (Throwable)e);
            }
            try {
                Vars.net.dispose();
            }
            catch (Throwable e) {}
        }
        catch (Throwable death) {
            death.printStackTrace();
        }
        MetricCollector.INSTANCE.waitPost();
        System.exit(1);
    }

    @Nullable
    public static Mods.LoadedMod getModCause(Throwable e) {
        if (Vars.mods == null) {
            return null;
        }
        try {
            for (StackTraceElement element : e.getStackTrace()) {
                String name = element.getClassName();
                if (name.matches("(mindustry|arc|java|javax|sun|jdk)\\..*")) continue;
                for (Mods.LoadedMod mod : Vars.mods.list()) {
                    if (mod.meta.main != null && CrashHandler.getMatches(mod.meta.main, name) > 0) {
                        return mod;
                    }
                    if (element.getFileName() == null || !element.getFileName().endsWith(".js") || !element.getFileName().startsWith(mod.name + "/")) continue;
                    return mod;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static int getMatches(String name1, String name2) {
        String[] arr1 = name1.split("\\.");
        String[] arr2 = name2.split("\\.");
        int matches = 0;
        for (int i = 0; i < Math.min(arr1.length, arr2.length); ++i) {
            if (!arr1[i].equals(arr2[i])) {
                return i;
            }
            if (arr1[i].matches("net|org|com|io")) continue;
            ++matches;
        }
        return matches;
    }

    private static String writeException(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

