/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Func;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Scaled;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.ControlPathfinder;
import mindustry.ai.ItemUnitStance;
import mindustry.ai.Pathfinder;
import mindustry.ai.UnitCommand;
import mindustry.ai.UnitStance;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.FlyingAI;
import mindustry.ai.types.GroundAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Leg;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.entities.part.DrawPart;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Crawlc;
import mindustry.gen.EntityMapping;
import mindustry.gen.Entityc;
import mindustry.gen.Legsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Segmentc;
import mindustry.gen.Sounds;
import mindustry.gen.Tankc;
import mindustry.gen.TimedKillc;
import mindustry.gen.UnderwaterMovec;
import mindustry.gen.Unit;
import mindustry.gen.WaterCrawlc;
import mindustry.gen.WaterMovec;
import mindustry.graphics.Drawf;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.logic.LAccess;
import mindustry.logic.Senseable;
import mindustry.type.AmmoType;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.PayloadStack;
import mindustry.type.StatusEffect;
import mindustry.type.Weapon;
import mindustry.type.ammo.ItemAmmoType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import mindustryX.features.RenderExt;
import mindustryX.features.StatExt;
import mindustryX.features.ui.Format;
import mindustryX.features.ui.FormatDefault;

public class UnitType
extends UnlockableContent
implements Senseable {
    public static final float shadowTX = -12.0f;
    public static final float shadowTY = -13.0f;
    private static final Vec2 legOffset = new Vec2();
    private static final Seq<UnitStance> tmpStances = new Seq();
    public int envRequired = 0;
    public int envEnabled = 1;
    public int envDisabled = 16;
    public float speed = 1.1f;
    public float boostMultiplier = 1.0f;
    public float floorMultiplier = 1.0f;
    public float rotateSpeed = 5.0f;
    public float baseRotateSpeed = 5.0f;
    public float drag = 0.3f;
    public float accel = 0.5f;
    public float hitSize = 6.0f;
    public float deathShake = -1.0f;
    public float stepShake = -1.0f;
    public float rippleScale = 1.0f;
    public float riseSpeed = 0.08f;
    public float fallSpeed = 0.018f;
    public float missileAccelTime = 0.0f;
    public float health = 200.0f;
    public float armor = 0.0f;
    public float range = -1.0f;
    public float maxRange = -1.0f;
    public float mineRange = 70.0f;
    public float buildRange = 220.0f;
    public float circleTargetRadius = 80.0f;
    public float crashDamageMultiplier = 1.0f;
    public float wreckHealthMultiplier = 0.25f;
    public float dpsEstimate = -1.0f;
    public float clipSize = -1.0f;
    public float drownTimeMultiplier = 1.0f;
    public float strafePenalty = 0.5f;
    public float researchCostMultiplier = 50.0f;
    public float groundLayer = 60.0f;
    public float flyingLayer = -1.0f;
    public float payloadCapacity = 8.0f;
    public float buildSpeed = -1.0f;
    public float aimDst = -1.0f;
    public float buildBeamOffset = 3.8f;
    public float mineBeamOffset = Float.NEGATIVE_INFINITY;
    public float targetPriority = 0.0f;
    public float shadowElevation = -1.0f;
    public float shadowElevationScl = 1.0f;
    public float engineOffset = 5.0f;
    public float engineSize = 2.5f;
    public float engineLayer = -1.0f;
    public float itemOffsetY = 3.0f;
    public float lightRadius = -1.0f;
    public float lightOpacity = 0.6f;
    public float softShadowScl = 1.0f;
    public float fogRadius = -1.0f;
    public float waveTrailX = 4.0f;
    public float waveTrailY = -3.0f;
    public float trailScl = 1.0f;
    public boolean isEnemy = true;
    public boolean flying = false;
    public boolean wobble = true;
    public boolean targetAir = true;
    public boolean targetGround = true;
    public boolean faceTarget = true;
    public boolean circleTarget = false;
    public boolean autoDropBombs = false;
    public boolean targetBuildingsMobile = true;
    public boolean canBoost = false;
    public boolean boostWhenBuilding = true;
    public boolean boostWhenMining = true;
    public boolean logicControllable = true;
    public boolean playerControllable = true;
    public boolean controlSelectGlobal = true;
    public boolean allowedInPayloads = true;
    public boolean hittable = true;
    public boolean killable = true;
    public boolean targetable = true;
    public boolean vulnerableWithPayloads = false;
    public boolean pickupUnits = true;
    public boolean physics = true;
    public boolean canDrown = true;
    public boolean useUnitCap = true;
    public boolean coreUnitDock = false;
    public boolean createWreck = true;
    public boolean createScorch = true;
    public boolean lowAltitude = false;
    public boolean rotateToBuilding = true;
    public boolean allowLegStep = false;
    public boolean legPhysicsLayer = true;
    public boolean hovering = false;
    public boolean omniMovement = true;
    public boolean rotateMoveFirst = false;
    public boolean healFlash = true;
    public boolean canHeal = false;
    public boolean singleTarget = false;
    public boolean forceMultiTarget = false;
    public boolean canAttack = true;
    public boolean hidden = false;
    public boolean internal = false;
    public boolean internalGenerateSprites = false;
    public boolean bounded = true;
    public boolean naval = false;
    public boolean autoFindTarget = true;
    public boolean targetUnderBlocks = true;
    public boolean alwaysShootWhenMoving = false;
    public boolean hoverable = true;
    public boolean alwaysCreateOutline = false;
    public boolean generateFullIcon = true;
    public boolean squareShape = false;
    public boolean drawBuildBeam = true;
    public boolean drawMineBeam = true;
    public boolean drawCell = true;
    public boolean drawItems = true;
    public boolean drawShields = true;
    public boolean drawBody = true;
    public boolean drawSoftShadow = true;
    public boolean drawMinimap = true;
    public Prov<? extends UnitController> aiController = () -> !this.flying ? new GroundAI() : new FlyingAI();
    public Func<Unit, ? extends UnitController> controller = u -> !this.playerControllable || u.team.isAI() && !u.team.rules().rtsAi ? (UnitController)this.aiController.get() : new CommandAI();
    public Prov<? extends Unit> constructor;
    public Seq<Ability> abilities = new Seq();
    public Seq<Weapon> weapons = new Seq();
    public ObjectSet<StatusEffect> immunities = new ObjectSet();
    public Color healColor = Pal.heal;
    public Color lightColor = Pal.powerLight;
    @Nullable
    public Color shieldColor;
    public Sound deathSound = Sounds.unset;
    public float deathSoundVolume = 1.0f;
    public Sound wreckSound = Sounds.unset;
    public float wreckSoundVolume = 1.0f;
    public Sound loopSound = Sounds.none;
    public float loopSoundVolume = 0.5f;
    public Sound stepSound = Sounds.mechStepSmall;
    public float stepSoundVolume = 0.5f;
    public float stepSoundPitch = 1.0f;
    public float stepSoundPitchRange = 0.1f;
    public Sound tankMoveSound = Sounds.tankMove;
    public Sound moveSound = Sounds.none;
    public float moveSoundVolume = 1.0f;
    public float moveSoundPitchMin = 1.0f;
    public float moveSoundPitchMax = 1.0f;
    public float tankMoveVolume = 0.5f;
    public Effect fallEffect = Fx.fallSmoke;
    public Effect fallEngineEffect = Fx.fallSmoke;
    public Effect deathExplosionEffect = Fx.dynamicExplosion;
    @Nullable
    public Effect treadEffect;
    public Seq<DrawPart> parts = new Seq(DrawPart.class);
    public Seq<UnitEngine> engines = new Seq();
    public boolean useEngineElevation = true;
    @Nullable
    public Color engineColor = null;
    public Color engineColorInner = Color.white;
    public int trailLength = 0;
    @Nullable
    public Color trailColor;
    public int flowfieldPathType = -1;
    @Nullable
    public Pathfinder.PathCost pathCost;
    public int pathCostId;
    @Nullable
    public Unit sample;
    public BlockFlag[] targetFlags = new BlockFlag[]{null};
    public boolean allowChangeCommands = true;
    public Seq<UnitCommand> commands = new Seq();
    @Nullable
    public UnitCommand defaultCommand;
    public Seq<UnitStance> stances = new Seq();
    public Color outlineColor = Pal.darkerMetal;
    public int outlineRadius = 3;
    public boolean outlines = true;
    public int itemCapacity = -1;
    public int ammoCapacity = -1;
    public AmmoType ammoType = new ItemAmmoType(Items.copper);
    public int mineTier = -1;
    public float mineSpeed = 1.0f;
    public boolean mineWalls = false;
    public boolean mineFloor = true;
    public boolean mineHardnessScaling = true;
    public Sound mineSound = Sounds.loopMineBeam;
    public float mineSoundVolume = 0.6f;
    public Seq<Item> mineItems = Seq.with((Object[])new Item[]{Items.copper, Items.lead, Items.titanium, Items.thorium});
    public int legCount = 4;
    public int legGroupSize = 2;
    public float legLength = 10.0f;
    public float legSpeed = 0.1f;
    public float legForwardScl = 1.0f;
    public float legBaseOffset = 0.0f;
    public float legMoveSpace = 1.0f;
    public float legExtension = 0.0f;
    public float legPairOffset = 0.0f;
    public float legLengthScl = 1.0f;
    public float legStraightLength = 1.0f;
    public float legMaxLength = 1.75f;
    public float legMinLength = 0.0f;
    public float legSplashDamage = 0.0f;
    public float legSplashRange = 5.0f;
    public float baseLegStraightness = 0.0f;
    public float legStraightness = 0.0f;
    public boolean legBaseUnder = false;
    public boolean lockLegBase = false;
    public boolean legContinuousMove;
    public boolean flipBackLegs = true;
    public boolean flipLegSide = false;
    public boolean emitWalkSound = true;
    public boolean emitWalkEffect = true;
    public float mechLandShake = 0.0f;
    public float mechSideSway = 0.54f;
    public float mechFrontSway = 0.1f;
    public float mechStride = -1.0f;
    public boolean mechStepParticles = false;
    public Color mechLegColor = Pal.darkMetal;
    public Rect[] treadRects = new Rect[0];
    public int treadFrames = 18;
    public int treadPullOffset = 0;
    public int segments = 0;
    public int segmentUnits = 1;
    @Nullable
    public UnitType segmentUnit;
    @Nullable
    public UnitType segmentEndUnit;
    public boolean segmentLayerOrder = true;
    public float segmentMag = 2.0f;
    public float segmentScl = 4.0f;
    public float segmentPhase = 5.0f;
    public float segmentRotSpeed = 1.0f;
    public float segmentMaxRot = 30.0f;
    public float segmentSpacing = -1.0f;
    public float segmentRotationRange = 80.0f;
    public float crawlSlowdown = 0.5f;
    public float crushDamage = 0.0f;
    public float crawlSlowdownFrac = 0.55f;
    public float lifetime = 300.0f;
    public float homingDelay = 10.0f;
    public TextureRegion baseRegion;
    public TextureRegion legRegion;
    public TextureRegion region;
    public TextureRegion previewRegion;
    public TextureRegion shadowRegion;
    public TextureRegion cellRegion;
    public TextureRegion itemCircleRegion;
    public TextureRegion softShadowRegion;
    public TextureRegion jointRegion;
    public TextureRegion footRegion;
    public TextureRegion legBaseRegion;
    public TextureRegion baseJointRegion;
    public TextureRegion outlineRegion;
    public TextureRegion treadRegion;
    public TextureRegion mineLaserRegion;
    public TextureRegion mineLaserEndRegion;
    public TextureRegion[] wreckRegions;
    public TextureRegion[] segmentRegions;
    public TextureRegion[] segmentCellRegions;
    public TextureRegion[] segmentOutlineRegions;
    public TextureRegion[][] treadRegions;
    protected float buildTime = -1.0f;
    @Nullable
    protected ItemStack[] totalRequirements;
    @Nullable
    protected ItemStack[] cachedRequirements;
    @Nullable
    protected ItemStack[] firstRequirements;

    public UnitType(String name) {
        super(name);
        this.constructor = EntityMapping.map((String)this.name);
        this.selectionSize = 30.0f;
    }

    public UnitController createController(Unit unit) {
        return (UnitController)this.controller.get((Object)unit);
    }

    public Unit create(Team team) {
        Unit unit = (Unit)this.constructor.get();
        unit.team = team;
        unit.setType(this);
        UnitController unitController = unit.controller();
        if (unitController instanceof CommandAI) {
            Ability[] command = (Ability[])unitController;
            if (this.defaultCommand != null) {
                command.command = this.defaultCommand;
            }
        }
        for (Ability ability : unit.abilities) {
            ability.created(unit);
        }
        unit.ammo = this.ammoCapacity;
        unit.elevation = this.flying ? 1.0f : 0.0f;
        unit.heal();
        if (unit instanceof TimedKillc) {
            TimedKillc u = (TimedKillc)unit;
            u.lifetime(this.lifetime);
        }
        return unit;
    }

    public Unit spawn(Team team, float x, float y, float rotation, @Nullable Cons<Unit> cons) {
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (this.segmentUnits > 1 && this.sample instanceof Segmentc) {
            Tmp.v1.trns(rotation, this.segmentSpacing * (float)this.segmentUnits / 2.0f);
            offsetX = Tmp.v1.x;
            offsetY = Tmp.v1.y;
        }
        Unit out = this.create(team);
        out.rotation = rotation;
        out.set(x + offsetX, y + offsetY);
        out.add();
        if (cons != null) {
            cons.get((Object)out);
        }
        if (this.segmentUnits > 1 && out instanceof Segmentc) {
            Unit last = out;
            UnitType segType = this.segmentUnit == null ? this : this.segmentUnit;
            for (int i = 0; i < this.segmentUnits; ++i) {
                UnitType type = i == this.segmentUnits - 1 && this.segmentEndUnit != null ? this.segmentEndUnit : segType;
                Unit next = type.create(team);
                Tmp.v1.trns(rotation, this.segmentSpacing * (float)(i + 1));
                next.set(x - Tmp.v1.x + offsetX, y - Tmp.v1.y + offsetY);
                next.rotation = rotation;
                next.add();
                ((Segmentc)last).addChild(next);
                if (cons != null) {
                    cons.get((Object)next);
                }
                last = next;
            }
        }
        return out;
    }

    public Unit spawn(Team team, float x, float y, float rotation) {
        return this.spawn(team, x, y, rotation, null);
    }

    public Unit spawn(Team team, float x, float y) {
        return this.spawn(team, x, y, 0.0f);
    }

    public Unit spawn(float x, float y) {
        return this.spawn(Vars.state.rules.defaultTeam, x, y);
    }

    public Unit spawn(Team team, Position pos) {
        return this.spawn(team, pos.getX(), pos.getY());
    }

    public Unit spawn(Position pos) {
        return this.spawn(Vars.state.rules.defaultTeam, pos);
    }

    public Unit spawn(Position pos, Team team) {
        return this.spawn(team, pos);
    }

    public boolean hasWeapons() {
        return this.weapons.size > 0;
    }

    public boolean targetable(Unit unit, Team targeter) {
        Payloadc p;
        return this.targetable || this.vulnerableWithPayloads && unit instanceof Payloadc && (p = (Payloadc)unit).hasPayload();
    }

    public boolean killable(Unit unit) {
        return this.killable;
    }

    public boolean hittable(Unit unit) {
        Payloadc p;
        return this.hittable || this.vulnerableWithPayloads && unit instanceof Payloadc && (p = (Payloadc)unit).hasPayload();
    }

    public void getUnitStances(Unit unit, Seq<UnitStance> out) {
        CommandAI ai;
        UnitController unitController = unit.controller();
        if (unitController instanceof CommandAI && (ai = (CommandAI)unitController).currentCommand() == UnitCommand.mineCommand) {
            out.add((Object)UnitStance.mineAuto);
            for (Item item : Vars.indexer.getAllPresentOres()) {
                ItemUnitStance itemStance;
                if (!unit.canMine(item) || (!this.mineFloor || !Vars.indexer.hasOre(item)) && (!this.mineWalls || !Vars.indexer.hasWallOre(item)) || (itemStance = ItemUnitStance.getByItem((Item)item)) == null) continue;
                out.add((Object)itemStance);
            }
        } else {
            out.addAll(this.stances);
        }
    }

    public boolean allowStance(Unit unit, UnitStance stance) {
        if (stance == UnitStance.stop) {
            return true;
        }
        tmpStances.clear();
        this.getUnitStances(unit, tmpStances);
        return tmpStances.contains((Object)stance);
    }

    public boolean allowCommand(Unit unit, UnitCommand command) {
        return this.commands.contains((Object)command);
    }

    public void update(Unit unit) {
    }

    public void updatePayload(Unit unit, @Nullable Unit unitHolder, @Nullable Building buildingHolder) {
    }

    public void killed(Unit unit) {
    }

    public void landed(Unit unit) {
    }

    public void display(Unit unit, Table table2) {
        UnitController unitController;
        table2.table(t -> {
            t.left();
            t.add((Element)new Image(this.uiIcon)).size(32.0f).scaling(Scaling.fit);
            if (unit.team.id < 6) {
                if (unit.isPlayer()) {
                    t.labelWrap(unit.getPlayer().coloredName() + "\n[#" + unit.team.color + "]" + this.localizedName).left().width(190.0f).padLeft(5.0f);
                } else {
                    t.labelWrap("[#" + unit.team.color + "]" + this.localizedName).left().width(190.0f).padLeft(5.0f);
                }
            } else if (unit.isPlayer()) {
                t.labelWrap(unit.getPlayer().coloredName() + "\n[#" + unit.team.color + "]" + this.localizedName + "[" + unit.team.id + "]").left().width(190.0f).padLeft(5.0f);
            } else {
                t.labelWrap("[#" + unit.team.color + "]" + this.localizedName + "[" + unit.team.id + "]").left().width(190.0f).padLeft(5.0f);
            }
        }).growX().left();
        table2.row();
        table2.table(bars -> {
            bars.defaults().growX().height(20.0f).pad(4.0f);
            bars.add((Element)new Bar(() -> {
                StringBuilder str = new StringBuilder();
                if (unit.shield() > 0.0f) {
                    str.append(FormatDefault.format(unit.health)).append("[gray]+[white]").append(FormatDefault.format(unit.shield));
                } else {
                    str.append("\ue813 ").append(new Format(4).percent(unit.health, unit.maxHealth));
                }
                float healthBalance = unit.healthBalance();
                if (!Mathf.equal((float)healthBalance, (float)0.0f, (float)0.1f)) {
                    str.append(healthBalance < 0.0f ? "[scarlet]" : "[acid]+");
                    float number = healthBalance * 60.0f;
                    str.append(FormatDefault.format(number));
                    str.append("/s[]");
                }
                return str.toString();
            }, () -> Pal.health, unit::healthf).blink(Color.white));
            bars.row();
            if (Vars.state.rules.unitAmmo) {
                bars.add((Element)new Bar(() -> this.ammoType.icon() + " " + Core.bundle.format("bar.ammoDetail", new Object[]{Float.valueOf(unit.ammo), this.ammoCapacity}), () -> this.ammoType.barColor(), () -> unit.ammo / (float)this.ammoCapacity));
                bars.row();
            }
            for (Ability ability : unit.abilities) {
                ability.displayBars(unit, bars);
            }
            if (this.payloadCapacity > 0.0f && unit instanceof Payloadc) {
                Payloadc payload = (Payloadc)unit;
                bars.add((Element)new Bar(() -> Strings.format((String)"\u88c5\u8f7d\uff1a@/@ @", (Object[])new Object[]{Strings.autoFixed((float)(payload.payloadUsed() / 8.0f / 8.0f), (int)4), Strings.autoFixed((float)(this.payloadCapacity / 8.0f / 8.0f), (int)4), StatUnit.blocksSquared.localized()}), () -> Pal.items, () -> payload.payloadUsed() / this.payloadCapacity));
                bars.row();
                float[] count = new float[]{-1.0f};
                bars.table().update(t -> {
                    if (count[0] != payload.payloadUsed()) {
                        payload.contentInfo(t, 16.0f, 270.0f);
                        count[0] = payload.payloadUsed();
                    }
                }).growX().left().height(0.0f).pad(0.0f);
            }
        }).growX();
        if (!unit.statuses().isEmpty()) {
            table2.row().table(t -> {
                for (StatusEntry entry : unit.statuses()) {
                    if (t.getChildren().size % 5 == 0) {
                        t.row();
                    }
                    t.stack(new Element[]{new Table(o -> {
                        o.left();
                        o.image(entry.effect.uiIcon).size(32.0f).scaling(Scaling.fit);
                    }), new Table(tt -> {
                        tt.left().bottom();
                        tt.label(() -> entry.effect.permanent || entry.time > 2160000.0f ? "Inf" : UI.formatTime(entry.time)).style((Style)Styles.outlineLabel);
                        tt.pack();
                    })}).padLeft(8.0f);
                }
            });
            table2.row().table(tt -> {
                tt.defaults().pad(0.0f, 8.0f, 0.0f, 8.0f);
                tt.add((CharSequence)"\u8840\u91cf");
                tt.add((CharSequence)"\u4f24\u5bb3");
                tt.add((CharSequence)"\u653b\u901f");
                tt.add((CharSequence)"\u79fb\u901f");
                tt.row();
                tt.add((CharSequence)FormatDefault.format(unit.healthMultiplier));
                tt.add((CharSequence)FormatDefault.format(unit.damageMultiplier));
                tt.add((CharSequence)FormatDefault.format(unit.reloadMultiplier));
                tt.add((CharSequence)FormatDefault.format(unit.speedMultiplier));
            }).growX().row();
            table2.row().table(tt -> {
                tt.defaults().pad(0.0f, 8.0f, 0.0f, 8.0f);
                tt.add((CharSequence)"\u5efa\u901f");
                tt.add((CharSequence)"\u963b\u529b");
                tt.add((CharSequence)"\u88c5\u7532");
                tt.row();
                tt.add((CharSequence)FormatDefault.format(unit.buildSpeedMultiplier));
                tt.add((CharSequence)FormatDefault.format(unit.dragMultiplier));
                tt.add((CharSequence)FormatDefault.format(unit.armorOverride >= 0.0f ? unit.armorOverride : unit.armor));
            }).growX().row();
        }
        if ((unitController = unit.controller()) instanceof LogicAI) {
            LogicAI ai = (LogicAI)unitController;
            table2.row();
            table2.table(tt -> {
                tt.add((CharSequence)(Blocks.microProcessor.emoji() + " " + Core.bundle.get("units.processorcontrol"))).growX().left();
                if (ai.controller != null && (Core.settings.getBool("mouseposition") || Core.settings.getBool("position"))) {
                    tt.add((CharSequence)("[lightgray](" + ai.controller.tileX() + ", " + ai.controller.tileY() + ")")).growX().right();
                }
            }).growX().wrap().left();
            table2.row();
            if (Vars.net.active() && ai.controller != null && ai.controller.lastAccessed != null) {
                table2.row();
                table2.add((CharSequence)Core.bundle.format("lastaccessed", new Object[]{ai.controller.lastAccessed})).growX().wrap().left();
            }
        } else if (Vars.net.active() && unit.lastCommanded != null) {
            table2.row();
            table2.add((CharSequence)Core.bundle.format("lastcommanded", new Object[]{unit.lastCommanded})).growX().wrap().left();
        }
        table2.row();
        table2.table(t -> {
            t.add((CharSequence)("\ue87c " + (long)unit.flag + "")).color(Color.lightGray).growX();
            t.add((CharSequence)(Fonts.getUnicodeStr(unit.type().name) + unit.team.data().countType(unit.type()) + "/" + Units.getStringCap(unit.team))).color(Color.lightGray).growX();
        }).growX();
        table2.row();
    }

    public boolean supportsEnv(int env) {
        return (this.envEnabled & env) != 0 && (this.envDisabled & env) == 0 && (this.envRequired == 0 || (this.envRequired & env) == this.envRequired);
    }

    @Override
    public boolean isBanned() {
        return Vars.state.rules.isBanned(this);
    }

    @Override
    public void getDependencies(Cons<UnlockableContent> cons) {
        for (Block block : Vars.content.blocks()) {
            if (!(block instanceof Reconstructor)) continue;
            Reconstructor r = (Reconstructor)((Object)block);
            for (UnitType[] recipe : r.upgrades) {
                if (recipe[1] != this) continue;
                cons.get((Object)block);
            }
        }
        for (ItemStack stack : this.researchRequirements()) {
            cons.get((Object)stack.item);
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setStats() {
        ItemStack[] reqs;
        this.stats.add(Stat.health, this.health);
        this.stats.add(Stat.armor, this.armor);
        this.stats.add(Stat.speed, this.speed * 60.0f / 8.0f, StatUnit.tilesSecond);
        this.stats.add(StatExt.rotateSpeed, this.rotateSpeed);
        this.stats.add(Stat.size, StatValues.squared(this.hitSize / 8.0f, StatUnit.blocks));
        this.stats.add(Stat.itemCapacity, (float)this.itemCapacity);
        this.stats.add(Stat.range, Strings.autoFixed((float)(this.maxRange / 8.0f), (int)1), new Object[]{StatUnit.blocks});
        if (this.crushDamage > 0.0f) {
            this.stats.add(Stat.crushDamage, this.crushDamage * 60.0f * 5.0f, StatUnit.perSecond);
        }
        if (this.legSplashDamage > 0.0f && this.legSplashRange > 0.0f) {
            this.stats.add(Stat.legSplashDamage, this.legSplashDamage, StatUnit.perLeg);
            this.stats.add(Stat.legSplashRange, Strings.autoFixed((float)(this.legSplashRange / 8.0f), (int)1), new Object[]{StatUnit.blocks});
        }
        this.stats.add(Stat.targetsAir, this.targetAir);
        this.stats.add(Stat.targetsGround, this.targetGround);
        this.stats.add(StatExt.aiController, ((UnitController)this.aiController.get()).getClass().getSimpleName(), new Object[0]);
        if (this.abilities.any()) {
            this.stats.add(Stat.abilities, StatValues.abilities(this, this.abilities));
        }
        this.stats.add(StatExt.estimateDPS, this.estimateDps());
        this.stats.add(StatExt.ammoType, this.ammoType.icon(), new Object[0]);
        this.stats.add(StatExt.ammoCapacity, (float)this.ammoCapacity);
        if (this.crushDamage > 0.0f) {
            this.stats.add(StatExt.crushDamage, this.crushDamage * 60.0f, StatUnit.perSecond);
        }
        this.stats.add(Stat.flying, this.flying);
        if (!this.flying) {
            this.stats.add(Stat.canBoost, this.canBoost);
            if (this.canBoost && this.boostMultiplier != 1.0f) {
                this.stats.add(StatExt.boostMultiplier, this.boostMultiplier);
            }
        }
        if (this.drownTimeMultiplier != 1.0f) {
            this.stats.add(StatExt.drownTimeMultiplier, this.drownTimeMultiplier);
        }
        if (this.mineTier >= 1) {
            this.stats.add(StatExt.mineLevel, "@\u7ea7", new Object[]{this.mineTier});
            this.stats.addPercent(Stat.mineSpeed, this.mineSpeed);
            this.stats.add(Stat.mineTier, StatValues.drillables(this.mineHardnessScaling ? 50.0f : 65.0f, this.mineHardnessScaling ? 1.0f : 0.0f, this.mineSpeed, null, (Boolf<Block>)((Boolf)b -> {
                block3: {
                    block2: {
                        if (b.itemDrop == null) return false;
                        if (!(b instanceof Floor)) break block2;
                        Floor f = (Floor)((Object)b);
                        if (f.wallOre && this.mineWalls || !f.wallOre && this.mineFloor) break block3;
                    }
                    if (b instanceof Floor) return false;
                    if (!this.mineWalls) return false;
                }
                if (b.itemDrop.hardness > this.mineTier) return false;
                if (!b.playerUnmineable) return true;
                if (!Core.settings.getBool("doubletapmine")) return false;
                return true;
            })));
        }
        if (this.buildSpeed > 0.0f) {
            this.stats.addPercent(Stat.buildSpeed, this.buildSpeed);
        }
        if (this.sample instanceof Payloadc) {
            this.stats.add(Stat.payloadCapacity, StatValues.squared(Mathf.sqrt((float)(this.payloadCapacity / 64.0f)), StatUnit.blocks));
        }
        if ((reqs = this.getFirstRequirements()) != null) {
            this.stats.add(Stat.buildCost, StatValues.items(reqs));
        }
        if (this.weapons.any()) {
            this.stats.add(Stat.weapons, StatValues.weapons(this, this.weapons));
        }
        if (this.targetFlags.length > 0 && this.targetFlags[0] != null) {
            this.stats.add(StatExt.targets, StatExt.targets(this.targetFlags));
        }
        if (this.immunities.size > 0) {
            this.stats.add(Stat.immunities, StatValues.statusEffects((Seq<StatusEffect>)this.immunities.toSeq().sort()));
        }
    }

    protected void checkEntityMapping(Unit example) {
        int classId;
        if (this.constructor == null) {
            throw new IllegalArgumentException(Strings.format((String)"No constructor set up for unit '@': Assign `constructor = [your unit constructor]`. Vanilla defaults are:\n  \"flying\": UnitEntity::create\n  \"mech\": MechUnit::create\n  \"legs\": LegsUnit::create\n  \"naval\": UnitWaterMove::create\n  \"payload\": PayloadUnit::create\n  \"missile\": TimedKillUnit::create\n  \"tank\": TankUnit::create\n  \"hover\": ElevationMoveUnit::create\n  \"tether\": BuildingTetherPayloadUnit::create\n  \"crawl\": CrawlUnit::create\n", (Object[])new Object[]{this.name}));
        }
        if (EntityMapping.map((String)this.name) == null) {
            EntityMapping.nameMap.put((Object)this.name, this.constructor);
        }
        if (EntityMapping.map((int)(classId = example.classId())) == null || classId != ((Entityc)EntityMapping.map((int)classId).get()).classId()) {
            String type = example.getClass().getSimpleName();
            throw new IllegalArgumentException(Strings.format((String)"Invalid class ID for `@` detected (found: @). Potential fixes:\n- Register with `EntityMapping.register(\"some-unique-name\", @::new)` to get an ID, and store it somewhere.\n- Override `@#classId()` to return that ID.\n", (Object[])new Object[]{type, classId, type, type}));
        }
    }

    void initPathType() {
        if (this.flowfieldPathType == -1) {
            int n = this.naval ? 2 : (this.allowLegStep ? 1 : (this.flying ? 4 : (this.flowfieldPathType = this.hovering ? 5 : 0)));
        }
        if (this.pathCost == null) {
            this.pathCost = this.naval ? ControlPathfinder.costNaval : (this.allowLegStep ? ControlPathfinder.costLegs : (this.hovering ? ControlPathfinder.costHover : ControlPathfinder.costGround));
        }
        this.pathCostId = ControlPathfinder.costTypes.indexOf((Object)this.pathCost);
        if (this.pathCostId == -1) {
            this.pathCostId = 0;
        }
    }

    public void init() {
        super.init();
        Unit example = (Unit)this.constructor.get();
        this.checkEntityMapping(example);
        this.allowLegStep = example instanceof Legsc || example instanceof Crawlc;
        this.stats.useCategories = true;
        if (example instanceof WaterMovec || example instanceof WaterCrawlc) {
            this.naval = true;
            this.canDrown = false;
            this.emitWalkSound = false;
            this.omniMovement = false;
            this.immunities.add((Object)StatusEffects.wet);
            if (this.shadowElevation < 0.0f) {
                this.shadowElevation = 0.11f;
            }
        }
        this.initPathType();
        if (this.flying) {
            this.envEnabled |= 2;
        }
        if (this.deathSound == Sounds.unset) {
            Sound sound = this.hitSize < 12.0f ? Sounds.unitExplode1 : (this.deathSound = this.hitSize < 22.0f ? Sounds.unitExplode2 : Sounds.unitExplode3);
        }
        if (this.wreckSound == Sounds.unset) {
            Sound sound = this.wreckSound = this.hitSize >= 22.0f ? Sounds.wreckFallBig : Sounds.wreckFall;
        }
        if (this.lightRadius == -1.0f) {
            this.lightRadius = Math.max(60.0f, this.hitSize * 2.3f);
        }
        if (this.autoFindTarget) {
            boolean bl = this.autoFindTarget = !this.weapons.contains(w -> w.shootStatus.speedMultiplier < 0.99f) || this.alwaysShootWhenMoving;
        }
        if (this.flyingLayer < 0.0f) {
            this.flyingLayer = this.lowAltitude ? 90.0f : 115.0f;
        }
        this.clipSize = Math.max(this.clipSize, this.lightRadius * 1.1f);
        this.singleTarget |= this.weapons.size <= 1 && !this.forceMultiTarget;
        if (this.itemCapacity < 0) {
            this.itemCapacity = Math.max(Mathf.round((int)((int)(this.hitSize * 4.0f)), (int)10), 10);
        }
        float margin = 4.0f;
        if (this.range < 0.0f) {
            this.range = Float.MAX_VALUE;
            for (Weapon weapon : this.weapons) {
                if (!weapon.useAttackRange) continue;
                this.range = Math.min(this.range, weapon.range() - margin);
                this.maxRange = Math.max(this.maxRange, weapon.range() - margin);
            }
        }
        if (this.maxRange < 0.0f) {
            this.maxRange = Math.max(0.0f, this.range);
            for (Weapon weapon : this.weapons) {
                if (!weapon.useAttackRange) continue;
                this.maxRange = Math.max(this.maxRange, weapon.range() - margin);
            }
        }
        if (this.fogRadius < 0.0f) {
            this.fogRadius = Math.max(174.0f, this.hitSize * 2.0f) / 8.0f;
        }
        if (!this.weapons.contains(w -> w.useAttackRange)) {
            if (this.range < 0.0f || this.range == Float.MAX_VALUE) {
                this.range = this.mineRange;
            }
            if (this.maxRange < 0.0f || this.maxRange == Float.MAX_VALUE) {
                this.maxRange = this.mineRange;
            }
        }
        if (this.mechStride < 0.0f) {
            this.mechStride = 4.0f + (this.hitSize - 8.0f) / 2.1f;
        }
        if (this.segmentSpacing < 0.0f) {
            this.segmentSpacing = this.hitSize;
        }
        if (this.aimDst < 0.0f) {
            float f = this.aimDst = this.weapons.contains(w -> !w.rotate) ? this.hitSize * 2.0f : this.hitSize / 2.0f;
        }
        if (this.stepShake < 0.0f) {
            this.stepShake = Mathf.round((float)((this.hitSize - 11.0f) / 9.0f));
            boolean bl = this.mechStepParticles = this.hitSize > 15.0f;
        }
        if (this.engineSize > 0.0f) {
            this.engines.add((Object)new UnitEngine(0.0f, -this.engineOffset, this.engineSize, -90.0f));
        }
        if (this.treadEffect == null) {
            this.treadEffect = new Effect(50.0f, e -> {
                Draw.color((Color)Tmp.c1.set(e.color).mul(1.5f));
                Fx.rand.setSeed((long)e.id);
                for (int i = 0; i < 3; ++i) {
                    Fx.v.trns(e.rotation + Fx.rand.range(40.0f), Fx.rand.random(6.0f * e.finpow()));
                    Fill.circle((float)(e.x + Fx.v.x + Fx.rand.range(4.0f)), (float)(e.y + Fx.v.y + Fx.rand.range(4.0f)), (float)(Math.min(e.fout(), e.fin() * e.lifetime / 8.0f) * this.hitSize / 28.0f * 3.0f * Fx.rand.random(0.8f, 1.1f) + 0.3f));
                }
            }).layer(20.0f);
        }
        if (this.mineBeamOffset == Float.NEGATIVE_INFINITY) {
            this.mineBeamOffset = this.hitSize / 2.0f;
        }
        for (Object ab : this.abilities) {
            ab.init(this);
        }
        Seq mapped = new Seq();
        for (Weapon w2 : this.weapons) {
            if (w2.recoilTime < 0.0f) {
                w2.recoilTime = w2.reload;
            }
            mapped.add((Object)w2);
            if (!w2.mirror) continue;
            Weapon copy = w2.copy();
            copy.flip();
            mapped.add((Object)copy);
            w2.recoilTime *= 2.0f;
            copy.recoilTime *= 2.0f;
            w2.reload *= 2.0f;
            copy.reload *= 2.0f;
            w2.otherSide = mapped.size - 1;
            copy.otherSide = mapped.size - 2;
        }
        this.weapons = mapped;
        this.weapons.each(Weapon::init);
        this.canHeal = this.weapons.contains(w -> w.bullet.heals());
        this.canAttack = this.weapons.contains(w -> !w.noAttack);
        if (this.commands.size == 0) {
            this.commands.add((Object)UnitCommand.moveCommand, (Object)UnitCommand.enterPayloadCommand);
            if (this.canBoost) {
                this.commands.add((Object)UnitCommand.boostCommand);
                if (this.buildSpeed > 0.0f) {
                    this.commands.add((Object)UnitCommand.rebuildCommand, (Object)UnitCommand.assistCommand);
                }
                if (this.mineTier > 0) {
                    this.commands.add((Object)UnitCommand.mineCommand);
                }
            }
            if (this.flying) {
                if (this.canHeal) {
                    this.commands.add((Object)UnitCommand.repairCommand);
                }
                if (this.buildSpeed > 0.0f) {
                    this.commands.add((Object)UnitCommand.rebuildCommand, (Object)UnitCommand.assistCommand);
                }
                if (this.mineTier > 0) {
                    this.commands.add((Object)UnitCommand.mineCommand);
                }
                if (example instanceof Payloadc) {
                    this.commands.addAll((Object[])new UnitCommand[]{UnitCommand.loadUnitsCommand, UnitCommand.loadBlocksCommand, UnitCommand.unloadPayloadCommand, UnitCommand.loopPayloadCommand});
                }
            }
        }
        if (this.defaultCommand == null && this.commands.size > 0) {
            this.defaultCommand = (UnitCommand)this.commands.first();
        }
        if (this.stances.size == 0) {
            if (this.canAttack) {
                this.stances.addAll((Object[])new UnitStance[]{UnitStance.stop, UnitStance.holdFire, UnitStance.pursueTarget, UnitStance.patrol});
                if (!this.flying) {
                    this.stances.add((Object)UnitStance.ram);
                }
            } else {
                this.stances.addAll((Object[])new UnitStance[]{UnitStance.stop, UnitStance.patrol});
            }
        }
        if (this.ammoCapacity < 0) {
            float shotsPerSecond = this.weapons.sumf(w -> w.useAmmo ? 60.0f / w.reload : 0.0f);
            float targetSeconds = 35.0f;
            this.ammoCapacity = Math.max(1, (int)(shotsPerSecond * targetSeconds));
        }
        this.estimateDps();
        this.sample = (Unit)this.constructor.get();
    }

    public float estimateDps() {
        if (this.dpsEstimate < 0.0f) {
            this.dpsEstimate = this.weapons.sumf(Weapon::dps);
            if (this.weapons.contains(w -> w.bullet.killShooter)) {
                this.dpsEstimate /= 15.0f;
            }
        }
        return this.dpsEstimate;
    }

    public void load() {
        int i;
        super.load();
        for (DrawPart part : this.parts) {
            part.load(this.name);
        }
        this.weapons.each(Weapon::load);
        this.region = Core.atlas.find(this.name);
        this.previewRegion = Core.atlas.find(this.name + "-preview", this.name);
        this.legRegion = Core.atlas.find(this.name + "-leg");
        this.jointRegion = Core.atlas.find(this.name + "-joint");
        this.baseJointRegion = Core.atlas.find(this.name + "-joint-base");
        this.footRegion = Core.atlas.find(this.name + "-foot");
        this.treadRegion = Core.atlas.find(this.name + "-treads");
        this.itemCircleRegion = Core.atlas.find("ring-item");
        if (this.treadRegion.found()) {
            this.treadRegions = new TextureRegion[this.treadRects.length][this.treadFrames];
            for (int r = 0; r < this.treadRects.length; ++r) {
                for (int i2 = 0; i2 < this.treadFrames; ++i2) {
                    this.treadRegions[r][i2] = Core.atlas.find(this.name + "-treads" + r + "-" + i2);
                }
            }
        }
        this.legBaseRegion = Core.atlas.find(this.name + "-leg-base", this.name + "-leg");
        this.baseRegion = Core.atlas.find(this.name + "-base");
        this.cellRegion = Core.atlas.find(this.name + "-cell", (TextureRegion)Core.atlas.find("power-cell"));
        this.mineLaserRegion = Core.atlas.find("minelaser");
        this.mineLaserEndRegion = Core.atlas.find("minelaser-end");
        this.softShadowRegion = this.squareShape ? Core.atlas.find("square-shadow") : (this.hitSize <= 10.0f || Core.settings != null && Core.settings.getBool("linear", true) ? Core.atlas.find("particle") : Core.atlas.find("circle-shadow"));
        this.outlineRegion = Core.atlas.find(this.name + "-outline");
        this.shadowRegion = this.fullIcon;
        this.wreckRegions = new TextureRegion[3];
        for (i = 0; i < this.wreckRegions.length; ++i) {
            this.wreckRegions[i] = Core.atlas.find(this.name + "-wreck" + i);
        }
        this.segmentRegions = new TextureRegion[this.segments];
        this.segmentOutlineRegions = new TextureRegion[this.segments];
        this.segmentCellRegions = new TextureRegion[this.segments];
        for (i = 0; i < this.segments; ++i) {
            this.segmentRegions[i] = Core.atlas.find(this.name + "-segment" + i);
            this.segmentOutlineRegions[i] = Core.atlas.find(this.name + "-segment-outline" + i);
            this.segmentCellRegions[i] = Core.atlas.find(this.name + "-segment-cell" + i);
        }
        this.clipSize = Math.max((float)this.region.width * 2.0f, this.clipSize);
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        for (Weapon weapon : this.weapons) {
            for (DrawPart part : weapon.parts) {
                part.getOutlines(out);
            }
        }
        for (DrawPart part : this.parts) {
            part.getOutlines(out);
        }
    }

    public boolean needsBodyOutline() {
        return this.alwaysCreateOutline;
    }

    @Override
    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        if (this.constructor == null) {
            throw new IllegalArgumentException("No constructor set up for unit '" + this.name + "', add this argument to your units field: `constructor = UnitEntity::create`");
        }
        this.sample = (Unit)this.constructor.get();
        Seq toOutline = new Seq();
        this.getRegionsToOutline((Seq<TextureRegion>)toOutline);
        for (Object region : toOutline) {
            if (!(region instanceof TextureAtlas.AtlasRegion)) continue;
            TextureAtlas.AtlasRegion atlas = (TextureAtlas.AtlasRegion)region;
            if (Core.atlas.has(atlas.name + "-outline")) continue;
            String regionName = atlas.name;
            Pixmap outlined = Pixmaps.outline((PixmapRegion)Core.atlas.getPixmap((TextureRegion)region), (Color)this.outlineColor, (int)this.outlineRadius);
            Drawf.checkBleed((Pixmap)outlined);
            packer.add(MultiPacker.PageType.main, regionName + "-outline", outlined);
            outlined.dispose();
        }
        if (this.outlines) {
            Seq outlineSeq = Seq.with((Object[])new TextureRegion[]{this.region, this.jointRegion, this.footRegion, this.baseJointRegion, this.legRegion, this.treadRegion});
            if (Core.atlas.has(this.name + "-leg-base")) {
                outlineSeq.add((Object)this.legBaseRegion);
            }
            for (TextureRegion outlineTarget : outlineSeq) {
                if (!outlineTarget.found()) continue;
                this.makeOutline(MultiPacker.PageType.main, packer, outlineTarget, this.alwaysCreateOutline && this.region == outlineTarget, this.outlineColor, this.outlineRadius);
            }
            if (this.sample instanceof Crawlc) {
                for (int i = 0; i < this.segments; ++i) {
                    this.makeOutline(packer, this.segmentRegions[i], this.name + "-segment-outline" + i, this.outlineColor, this.outlineRadius);
                }
            }
            for (Weapon weapon : this.weapons) {
                if (weapon.name.isEmpty() || this.minfo.mod != null && !weapon.name.startsWith(this.minfo.mod.name) || !weapon.top && packer.isOutlined(weapon.name) && !weapon.parts.contains(p -> p.under)) continue;
                this.makeOutline(MultiPacker.PageType.main, packer, weapon.region, !weapon.top || weapon.parts.contains(p -> p.under), this.outlineColor, this.outlineRadius);
            }
        }
        if (this.sample instanceof Tankc) {
            PixmapRegion pix = Core.atlas.getPixmap(this.treadRegion);
            for (int r = 0; r < this.treadRects.length; ++r) {
                Rect treadRect = this.treadRects[r];
                Pixmap slice = pix.crop((int)(treadRect.x + (float)pix.width / 2.0f), (int)(treadRect.y + (float)pix.height / 2.0f), 1, (int)treadRect.height);
                int frames = this.treadFrames;
                for (int i = 0; i < frames; ++i) {
                    int pullOffset = this.treadPullOffset;
                    Pixmap frame = new Pixmap(slice.width, slice.height);
                    for (int y = 0; y < slice.height; ++y) {
                        int idx = y + i;
                        if (idx >= slice.height) {
                            idx -= slice.height;
                            idx += pullOffset;
                            idx = Mathf.mod((int)idx, (int)slice.height);
                        }
                        frame.setRaw(0, y, slice.getRaw(0, idx));
                    }
                    packer.add(MultiPacker.PageType.main, this.name + "-treads" + r + "-" + i, frame);
                    frame.dispose();
                }
                slice.dispose();
            }
        }
    }

    @Override
    public void afterPatch() {
        super.afterPatch();
        this.firstRequirements = null;
        this.cachedRequirements = null;
        this.totalRequirements = null;
        this.flowfieldPathType = -1;
        this.pathCost = null;
        this.pathCostId = -1;
        this.initPathType();
    }

    public float getBuildTime() {
        this.getTotalRequirements();
        return this.buildTime;
    }

    public ItemStack[] getTotalRequirements() {
        if (this.totalRequirements == null) {
            UnitType[] ret = new UnitType[]{null};
            float[] timeret = new float[]{0.0f};
            ItemStack[] result = this.getRequirements(ret, timeret);
            this.totalRequirements = ItemStack.empty;
            if (result != null) {
                ItemSeq total = new ItemSeq();
                total.add(result);
                if (ret[0] != null) {
                    total.add(ret[0].getTotalRequirements());
                }
                this.totalRequirements = total.toArray();
            }
            for (ItemStack stack : this.totalRequirements) {
                this.buildTime += stack.item.cost * (float)stack.amount;
            }
        }
        return this.totalRequirements;
    }

    @Nullable
    public ItemStack[] getRequirements(@Nullable UnitType[] prevReturn, @Nullable float[] timeReturn) {
        Consume consume;
        Reconstructor rec = (Reconstructor)((Object)Vars.content.blocks().find(b -> {
            if (!(b instanceof Reconstructor)) return false;
            Reconstructor re = (Reconstructor)((Object)((Object)b));
            if (!re.upgrades.contains(u -> u[1] == this)) return false;
            return true;
        }));
        if (rec != null && (consume = rec.findConsumer(i -> i instanceof ConsumeItems)) instanceof ConsumeItems) {
            ConsumeItems ci = (ConsumeItems)consume;
            if (prevReturn != null) {
                prevReturn[0] = ((UnitType[])rec.upgrades.find(u -> u[1] == this))[0];
            }
            if (timeReturn != null) {
                timeReturn[0] = rec.constructTime;
            }
            return ci.items;
        }
        UnitFactory factory = (UnitFactory)((Object)Vars.content.blocks().find(u -> {
            if (!(u instanceof UnitFactory)) return false;
            UnitFactory uf = (UnitFactory)((Object)((Object)u));
            if (!uf.plans.contains(p -> p.unit == this)) return false;
            return true;
        }));
        if (factory != null) {
            UnitFactory.UnitPlan plan = (UnitFactory.UnitPlan)factory.plans.find(p -> p.unit == this);
            if (timeReturn != null) {
                timeReturn[0] = plan.time;
            }
            return plan.requirements;
        }
        UnitAssembler assembler = (UnitAssembler)((Object)Vars.content.blocks().find(u -> {
            if (!(u instanceof UnitAssembler)) return false;
            UnitAssembler a = (UnitAssembler)((Object)((Object)u));
            if (!a.plans.contains(p -> p.unit == this)) return false;
            return true;
        }));
        if (assembler != null) {
            UnitAssembler.AssemblerUnitPlan plan = (UnitAssembler.AssemblerUnitPlan)assembler.plans.find(p -> p.unit == this);
            if (timeReturn != null) {
                timeReturn[0] = plan.time;
            }
            ItemSeq reqs = new ItemSeq();
            for (PayloadStack bstack : plan.requirements) {
                Object object = bstack.item;
                if (object instanceof Block) {
                    Block block = (Block)((Object)object);
                    for (ItemStack stack : block.requirements) {
                        reqs.add(stack.item, stack.amount * bstack.amount);
                    }
                    continue;
                }
                object = bstack.item;
                if (!(object instanceof UnitType)) continue;
                UnitType unit = (UnitType)((Object)object);
                for (ItemStack stack : unit.getTotalRequirements()) {
                    reqs.add(stack.item, stack.amount * bstack.amount);
                }
            }
            return reqs.toArray();
        }
        return null;
    }

    @Nullable
    public ItemStack[] getFirstRequirements() {
        if (this.firstRequirements == null) {
            this.firstRequirements = this.getRequirements(null, null);
        }
        return this.firstRequirements;
    }

    @Override
    public ItemStack[] researchRequirements() {
        if (this.cachedRequirements != null) {
            return this.cachedRequirements;
        }
        ItemStack[] stacks = this.getRequirements(null, null);
        if (stacks != null) {
            Object[] out = new ItemStack[stacks.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = new ItemStack(stacks[i].item, UI.roundAmount((int)((float)stacks[i].amount * this.researchCostMultiplier)));
            }
            out = (ItemStack[])Structs.filter(ItemStack.class, (Object[])out, stack -> stack.amount > 0);
            this.cachedRequirements = out;
            return out;
        }
        return super.researchRequirements();
    }

    public double sense(LAccess sensor) {
        double d;
        switch (sensor) {
            case health: 
            case maxHealth: {
                d = this.health;
                break;
            }
            case size: {
                d = this.hitSize / 8.0f;
                break;
            }
            case itemCapacity: {
                d = this.itemCapacity;
                break;
            }
            case speed: {
                d = this.speed * 60.0f / 8.0f;
                break;
            }
            case payloadCapacity: {
                if (this.sample instanceof Payloadc) {
                    d = this.payloadCapacity / 64.0f;
                    break;
                }
                d = 0.0;
                break;
            }
            case id: {
                d = this.getLogicId();
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    public Object senseObject(LAccess sensor) {
        if (sensor == LAccess.name) {
            return this.name;
        }
        return noSensed;
    }

    public ContentType getContentType() {
        return ContentType.unit;
    }

    public void setEnginesMirror(UnitEngine ... array) {
        for (UnitEngine base : array) {
            this.engines.add((Object)base);
            UnitEngine engine = base.copy();
            engine.x *= -1.0f;
            engine.rotation = 180.0f - engine.rotation;
            if (engine.rotation < 0.0f) {
                engine.rotation += 360.0f;
            }
            this.engines.add((Object)engine);
        }
    }

    public void draw(Unit unit) {
        float z;
        Segmentc c;
        Segmentc seg;
        Mechc m;
        float scl = Draw.xscl;
        if (unit.inFogTo(Vars.player.team())) {
            return;
        }
        if (this.buildSpeed > 0.0f) {
            unit.drawBuilding();
        }
        if (unit.mining()) {
            this.drawMining(unit);
        }
        boolean isPayload = !unit.isAdded();
        Mechc mech = unit instanceof Mechc ? (m = (Mechc)unit) : null;
        Segmentc segmentc = seg = unit instanceof Segmentc ? (c = (Segmentc)unit) : null;
        float f = isPayload ? Draw.z() : (unit.elevation > 0.5f || this.flying && unit.dead ? this.flyingLayer : (seg != null ? this.groundLayer + (float)seg.segmentIndex() / 4000.0f * (float)Mathf.sign((boolean)this.segmentLayerOrder) + (!this.segmentLayerOrder ? 0.01f : 0.0f) : (z = this.groundLayer + Mathf.clamp((float)(this.hitSize / 4000.0f), (float)0.0f, (float)0.01f))));
        if (!isPayload && (unit.isFlying() || this.shadowElevation > 0.0f)) {
            Draw.z((float)Math.min(80.0f, z - 1.0f));
            this.drawShadow(unit);
        }
        Draw.z((float)(z - 0.02f));
        if (mech != null) {
            this.drawMech(mech);
            legOffset.trns(mech.baseRotation(), 0.0f, Mathf.lerp((float)(Mathf.sin((float)mech.walkExtend(true), (float)0.63661975f, (float)1.0f) * this.mechSideSway), (float)0.0f, (float)unit.elevation));
            legOffset.add(Tmp.v1.trns(mech.baseRotation() + 90.0f, 0.0f, Mathf.lerp((float)(Mathf.sin((float)mech.walkExtend(true), (float)0.31830987f, (float)1.0f) * this.mechFrontSway), (float)0.0f, (float)unit.elevation)));
            unit.trns(UnitType.legOffset.x, UnitType.legOffset.y);
        }
        if (unit instanceof Tankc) {
            this.drawTank((Unit)((Tankc)unit));
        }
        if (unit instanceof Legsc && !isPayload) {
            this.drawLegs((Unit)((Legsc)unit));
        }
        Draw.z((float)Math.min(z - 0.01f, 99.0f));
        if (unit instanceof Payloadc) {
            this.drawPayload((Unit)((Payloadc)unit));
        }
        if (this.drawSoftShadow) {
            this.drawSoftShadow(unit);
        }
        Draw.z((float)z);
        if (unit instanceof Crawlc) {
            Crawlc c2 = (Crawlc)unit;
            this.drawCrawl(c2);
        }
        if (this.drawBody) {
            this.drawOutline(unit);
        }
        this.drawWeaponOutlines(unit);
        if (this.engineLayer > 0.0f) {
            Draw.z((float)this.engineLayer);
        }
        if (!(this.trailLength <= 0 || this.naval || !unit.isFlying() && this.useEngineElevation)) {
            this.drawTrail(unit);
        }
        if (this.engines.size > 0) {
            this.drawEngines(unit);
        }
        Draw.z((float)z);
        if (this.drawBody) {
            this.drawBody(unit);
        }
        if (this.drawCell && !(unit instanceof Crawlc)) {
            this.drawCell(unit);
        }
        Draw.scl((float)scl);
        this.drawWeapons(unit);
        if (this.drawItems) {
            this.drawItems(unit);
        }
        if (!isPayload) {
            this.drawLight(unit);
        }
        if (unit.shieldAlpha > 0.0f && this.drawShields) {
            this.drawShield(unit);
        }
        if (this.parts.size > 0) {
            for (int i = 0; i < this.parts.size; ++i) {
                WeaponMount mount;
                DrawPart part = (DrawPart)this.parts.get(i);
                WeaponMount weaponMount = mount = unit.mounts.length > part.weaponIndex ? unit.mounts[part.weaponIndex] : null;
                if (mount != null) {
                    DrawPart.params.set(mount.warmup, mount.reload / mount.weapon.reload, mount.smoothReload, mount.heat, mount.recoil, mount.charge, unit.x, unit.y, unit.rotation);
                } else {
                    DrawPart.params.set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, unit.x, unit.y, unit.rotation);
                }
                if (unit instanceof Scaled) {
                    Scaled s = (Scaled)unit;
                    DrawPart.params.life = s.fin();
                }
                this.applyColor(unit);
                part.draw(DrawPart.params);
            }
        }
        if (!isPayload) {
            for (Ability a : unit.abilities) {
                Draw.reset();
                a.draw(unit);
            }
        }
        if (mech != null) {
            unit.trns(-UnitType.legOffset.x, -UnitType.legOffset.y);
        }
        Draw.reset();
    }

    public Color shieldColor(Unit unit) {
        return this.shieldColor == null ? unit.team.color : this.shieldColor;
    }

    public void drawMining(Unit unit) {
        if (this.drawMineBeam) {
            float focusLen = this.mineBeamOffset + Mathf.absin((float)Time.time, (float)1.1f, (float)0.5f);
            float px = unit.x + Angles.trnsx((float)unit.rotation, (float)focusLen);
            float py = unit.y + Angles.trnsy((float)unit.rotation, (float)focusLen);
            this.drawMiningBeam(unit, px, py);
        }
    }

    public void drawMiningBeam(Unit unit, float px, float py) {
        if (!unit.mining()) {
            return;
        }
        float swingScl = 12.0f;
        float swingMag = 1.0f;
        float flashScl = 0.3f;
        float ex = unit.mineTile.worldx() + Mathf.sin((float)(Time.time + 48.0f), (float)swingScl, (float)swingMag);
        float ey = unit.mineTile.worldy() + Mathf.sin((float)(Time.time + 48.0f), (float)(swingScl + 2.0f), (float)swingMag);
        Draw.z((float)115.1f);
        Draw.color((Color)Color.lightGray, (Color)Color.white, (float)(1.0f - flashScl + Mathf.absin((float)Time.time, (float)0.5f, (float)flashScl)));
        Draw.alpha((float)Renderer.unitLaserOpacity);
        Drawf.laser((TextureRegion)this.mineLaserRegion, (TextureRegion)this.mineLaserEndRegion, (float)px, (float)py, (float)ex, (float)ey, (float)0.75f);
        if (unit.isLocal()) {
            Lines.stroke(1.0f, Pal.accent);
            Lines.poly(unit.mineTile.worldx(), unit.mineTile.worldy(), 4, 4.0f * Mathf.sqrt2, Time.time);
        }
        Draw.color();
    }

    public <T extends Unit> void drawPayload(T unit) {
        if (((Payloadc)unit).hasPayload()) {
            float prev = Draw.z();
            Draw.z((float)(prev - 0.02f));
            Payload pay = (Payload)((Payloadc)unit).payloads().first();
            pay.set(unit.x, unit.y, unit.rotation);
            pay.draw();
            Draw.z((float)prev);
        }
    }

    public void drawShield(Unit unit) {
        float alpha = unit.shieldAlpha();
        float radius = unit.hitSize() * 1.3f;
        Fill.light((float)unit.x, (float)unit.y, (int)Lines.circleVertices(radius), (float)radius, (Color)Color.clear, (Color)Tmp.c2.set(unit.type.shieldColor(unit)).lerp(Color.white, Mathf.clamp((float)(unit.hitTime() / 2.0f))).a(0.7f * alpha));
    }

    public void drawShadow(Unit unit) {
        float e = Mathf.clamp((float)unit.elevation, (float)this.shadowElevation, (float)1.0f) * this.shadowElevationScl * (1.0f - unit.drownTime);
        float x = unit.x + -12.0f * e;
        float y = unit.y + -13.0f * e;
        Floor floor = Vars.world.floorWorld(x, y);
        float dest = floor.canShadow ? 1.0f : 0.0f;
        unit.shadowAlpha = unit.shadowAlpha < 0.0f ? dest : Mathf.approachDelta((float)unit.shadowAlpha, (float)dest, (float)0.11f);
        Draw.color((Color)Pal.shadow, (float)(Pal.shadow.a * unit.shadowAlpha));
        Draw.rect((TextureRegion)this.shadowRegion, (float)(unit.x + -12.0f * e), (float)(unit.y + -13.0f * e), (float)(unit.rotation - 90.0f));
        Draw.color();
    }

    public void drawSoftShadow(Unit unit) {
        this.drawSoftShadow(unit, 1.0f);
    }

    public void drawSoftShadow(Unit unit, float alpha) {
        this.drawSoftShadow(unit.x, unit.y, unit.rotation, alpha);
    }

    public void drawSoftShadow(float x, float y, float rotation, float alpha) {
        Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.4f * alpha));
        float rad = 1.6f;
        float size = (float)Math.max(this.region.width, this.region.height) * this.region.scl() * this.softShadowScl;
        Draw.rect((TextureRegion)this.softShadowRegion, (float)x, (float)y, (float)(size * rad * Draw.xscl), (float)(size * rad * Draw.yscl), (float)(rotation - 90.0f));
        Draw.color();
    }

    public void drawItems(Unit unit) {
        this.applyColor(unit);
        if (unit.item() != null && unit.itemTime > 0.01f) {
            float sin = Mathf.absin((float)Time.time, (float)5.0f, (float)1.0f);
            float size = (5.0f + sin) * unit.itemTime;
            Draw.mixcol((Color)Pal.accent, (float)(sin * 0.1f));
            Draw.rect((TextureRegion)unit.item().fullIcon, (float)(unit.x + Angles.trnsx((float)(unit.rotation + 180.0f), (float)this.itemOffsetY)), (float)(unit.y + Angles.trnsy((float)(unit.rotation + 180.0f), (float)this.itemOffsetY)), (float)size, (float)size, (float)unit.rotation);
            Draw.mixcol();
            size = ((3.0f + sin) * unit.itemTime + 0.5f) * 2.0f;
            Draw.color((Color)Pal.accent);
            Draw.rect((TextureRegion)this.itemCircleRegion, (float)(unit.x + Angles.trnsx((float)(unit.rotation + 180.0f), (float)this.itemOffsetY)), (float)(unit.y + Angles.trnsy((float)(unit.rotation + 180.0f), (float)this.itemOffsetY)), (float)size, (float)size);
            if (RenderExt.unitItemCarried || unit.isLocal() && !Vars.renderer.pixelate) {
                float z = Draw.z();
                Draw.z((float)(z + 0.01f));
                Fonts.outline.draw((CharSequence)(unit.stack.amount + ""), unit.x + Angles.trnsx((float)(unit.rotation + 180.0f), (float)this.itemOffsetY), unit.y + Angles.trnsy((float)(unit.rotation + 180.0f), (float)this.itemOffsetY) - 3.0f, Pal.accent, 0.25f * unit.itemTime / Scl.scl((float)1.0f), false, 1);
                Draw.z((float)z);
            }
            Draw.reset();
        }
    }

    public void drawTrail(Unit unit) {
        if (unit.trail == null) {
            unit.trail = new Trail(this.trailLength);
        }
        Trail trail = unit.trail;
        trail.draw(this.trailColor == null ? unit.team.color : this.trailColor, (this.engineSize + Mathf.absin((float)Time.time, (float)2.0f, (float)(this.engineSize / 4.0f)) * (this.useEngineElevation ? unit.elevation : 1.0f)) * this.trailScl);
    }

    public void drawEngines(Unit unit) {
        float f = this.useEngineElevation ? unit.elevation : 1.0f;
        if (f <= 1.0E-4f) {
            return;
        }
        for (UnitEngine engine : this.engines) {
            engine.draw(unit);
        }
        Draw.color();
    }

    public void drawWeapons(Unit unit) {
        this.applyColor(unit);
        for (WeaponMount mount : unit.mounts) {
            mount.weapon.draw(unit, mount);
        }
        Draw.reset();
    }

    public void drawWeaponOutlines(Unit unit) {
        this.applyColor(unit);
        this.applyOutlineColor(unit);
        for (WeaponMount mount : unit.mounts) {
            if (mount.weapon.top) continue;
            float z = Draw.z();
            Draw.z((float)(z + mount.weapon.layerOffset));
            mount.weapon.drawOutline(unit, mount);
            Draw.z((float)z);
        }
        Draw.reset();
    }

    public void drawOutline(Unit unit) {
        Draw.reset();
        if (Core.atlas.isFound(this.outlineRegion)) {
            this.applyColor(unit);
            this.applyOutlineColor(unit);
            Draw.rect((TextureRegion)this.outlineRegion, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
            Draw.reset();
        }
    }

    public void drawBody(Unit unit) {
        this.applyColor(unit);
        if (unit instanceof UnderwaterMovec) {
            Draw.alpha((float)1.0f);
            Draw.mixcol((Color)unit.floorOn().mapColor.write(Tmp.c1).mul(0.9f), (float)1.0f);
        }
        Draw.rect((TextureRegion)this.region, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
        Draw.reset();
    }

    public void drawCell(Unit unit) {
        this.applyColor(unit);
        Draw.color((Color)this.cellColor(unit));
        Draw.rect((TextureRegion)this.cellRegion, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
        Draw.reset();
    }

    public Color cellColor(Unit unit) {
        float f = Mathf.clamp((float)unit.healthf());
        return Tmp.c1.set(Color.black).lerp(unit.team.color, f + Mathf.absin((float)Time.time, (float)Math.max(f * 5.0f, 1.0f), (float)(1.0f - f)));
    }

    public void drawLight(Unit unit) {
        if (this.lightRadius > 0.0f) {
            Drawf.light((float)unit.x, (float)unit.y, (float)this.lightRadius, (Color)this.lightColor, (float)this.lightOpacity);
        }
    }

    public <T extends Unit> void drawTank(T unit) {
        this.applyColor(unit);
        Draw.rect((TextureRegion)this.treadRegion, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
        if (this.treadRegion.found()) {
            int frame = (int)((Tankc)unit).treadTime() % this.treadFrames;
            for (int i = 0; i < this.treadRects.length; ++i) {
                TextureRegion region = this.treadRegions[i][frame];
                Rect treadRect = this.treadRects[i];
                float xOffset = -(treadRect.x + treadRect.width / 2.0f);
                float yOffset = -(treadRect.y + treadRect.height / 2.0f);
                for (int side : Mathf.signs) {
                    Tmp.v1.set(xOffset * (float)side, yOffset).rotate(unit.rotation - 90.0f);
                    Draw.rect((TextureRegion)region, (float)(unit.x + Tmp.v1.x / 4.0f), (float)(unit.y + Tmp.v1.y / 4.0f), (float)(treadRect.width / 4.0f), (float)((float)region.height * region.scale / 4.0f), (float)(unit.rotation - 90.0f));
                }
            }
        }
    }

    public <T extends Unit> void drawLegs(T unit) {
        int j;
        this.applyColor(unit);
        Tmp.c3.set(Draw.getMixColor());
        Leg[] legs = ((Legsc)unit).legs();
        float ssize = (float)this.footRegion.width * this.footRegion.scl() * 1.5f;
        float rotation = ((Legsc)unit).baseRotation();
        float invDrown = 1.0f - unit.drownTime;
        if (this.footRegion.found()) {
            for (Leg leg : legs) {
                Drawf.shadow((float)leg.base.x, (float)leg.base.y, (float)ssize, (float)invDrown);
            }
        }
        for (j = legs.length - 1; j >= 0; --j) {
            int i = j % 2 == 0 ? j / 2 : legs.length - 1 - j / 2;
            Leg leg = legs[i];
            boolean flip = (float)i >= (float)legs.length / 2.0f;
            int flips = Mathf.sign((boolean)flip);
            Vec2 position = ((Legsc)unit).legOffset(legOffset, i).add(unit);
            Tmp.v1.set(leg.base).sub(leg.joint).inv().setLength(this.legExtension);
            if (this.footRegion.found() && leg.moving && this.shadowElevation > 0.0f) {
                float scl = this.shadowElevation * invDrown;
                float elev = Mathf.slope((float)(1.0f - leg.stage)) * scl;
                Draw.color((Color)Pal.shadow);
                Draw.rect((TextureRegion)this.footRegion, (float)(leg.base.x + -12.0f * elev), (float)(leg.base.y + -13.0f * elev), (float)position.angleTo((Position)leg.base));
                Draw.color();
            }
            Draw.mixcol((Color)Tmp.c3, (float)Tmp.c3.a);
            if (this.footRegion.found()) {
                Draw.rect((TextureRegion)this.footRegion, (float)leg.base.x, (float)leg.base.y, (float)position.angleTo((Position)leg.base));
            }
            if (this.legBaseUnder) {
                Lines.stroke((float)this.legBaseRegion.height * this.legRegion.scl() * (float)flips);
                Lines.line(this.legBaseRegion, leg.joint.x + Tmp.v1.x, leg.joint.y + Tmp.v1.y, leg.base.x, leg.base.y, false);
                Lines.stroke((float)this.legRegion.height * this.legRegion.scl() * (float)flips);
                Lines.line(this.legRegion, position.x, position.y, leg.joint.x, leg.joint.y, false);
            } else {
                Lines.stroke((float)this.legRegion.height * this.legRegion.scl() * (float)flips);
                Lines.line(this.legRegion, position.x, position.y, leg.joint.x, leg.joint.y, false);
                Lines.stroke((float)this.legBaseRegion.height * this.legRegion.scl() * (float)flips);
                Lines.line(this.legBaseRegion, leg.joint.x + Tmp.v1.x, leg.joint.y + Tmp.v1.y, leg.base.x, leg.base.y, false);
            }
            if (!this.jointRegion.found()) continue;
            Draw.rect((TextureRegion)this.jointRegion, (float)leg.joint.x, (float)leg.joint.y);
        }
        if (this.baseJointRegion.found()) {
            for (j = legs.length - 1; j >= 0; --j) {
                Vec2 position = ((Legsc)unit).legOffset(legOffset, j % 2 == 0 ? j / 2 : legs.length - 1 - j / 2).add(unit);
                Draw.rect((TextureRegion)this.baseJointRegion, (float)position.x, (float)position.y, (float)rotation);
            }
        }
        if (this.baseRegion.found()) {
            Draw.rect((TextureRegion)this.baseRegion, (float)unit.x, (float)unit.y, (float)(rotation - 90.0f));
        }
        Draw.reset();
    }

    public void drawCrawl(Crawlc crawl) {
        float f;
        Segmentc seg;
        Segmentc segmentc;
        Unit unit = (Unit)crawl;
        this.applyColor(unit);
        if (crawl instanceof Segmentc && (segmentc = (seg = (Segmentc)crawl).headSegment()) instanceof Crawlc) {
            Crawlc head = (Crawlc)segmentc;
            f = head.crawlTime() + (float)seg.segmentIndex() * this.segmentPhase * (float)this.segments;
        } else {
            f = crawl.crawlTime();
        }
        float crawlTime = f;
        for (int p = 0; p < 2; ++p) {
            TextureRegion[] regions = p == 0 ? this.segmentOutlineRegions : this.segmentRegions;
            for (int i = 0; i < this.segments; ++i) {
                float trns = Mathf.sin((float)(crawlTime + (float)i * this.segmentPhase), (float)this.segmentScl, (float)this.segmentMag);
                float rot = Mathf.slerp((float)crawl.segmentRot(), (float)unit.rotation, (float)((float)i / (float)(this.segments - 1)));
                float tx = Angles.trnsx((float)rot, (float)trns);
                float ty = Angles.trnsy((float)rot, (float)trns);
                Draw.rect((TextureRegion)regions[i], (float)(unit.x + tx), (float)(unit.y + ty), (float)(rot - 90.0f));
                if (!this.drawCell || p == 0 || !this.segmentCellRegions[i].found()) continue;
                Draw.color((Color)this.cellColor(unit));
                Draw.rect((TextureRegion)this.segmentCellRegions[i], (float)(unit.x + tx), (float)(unit.y + ty), (float)(rot - 90.0f));
                Draw.reset();
            }
        }
    }

    public void drawMech(Mechc mech) {
        Floor floor;
        Unit unit = (Unit)mech;
        Draw.reset();
        float e = unit.elevation;
        float sin = Mathf.lerp((float)Mathf.sin((float)mech.walkExtend(true), (float)0.63661975f, (float)1.0f), (float)0.0f, (float)e);
        float extension = Mathf.lerp((float)mech.walkExtend(false), (float)0.0f, (float)e);
        float boostTrns = e * 2.0f;
        Floor floor2 = floor = unit.isFlying() ? Blocks.air.asFloor() : unit.floorOn();
        if (floor.isLiquid) {
            Draw.color((Color)Color.white, (Color)floor.mapColor, (float)0.5f);
        }
        for (int i : Mathf.signs) {
            Draw.mixcol((Color)Tmp.c1.set(this.mechLegColor).lerp(Color.white, Mathf.clamp((float)unit.hitTime)), (float)Math.max(Math.max(0.0f, (float)i * extension / this.mechStride), unit.hitTime));
            Draw.rect((TextureRegion)this.legRegion, (float)(unit.x + Angles.trnsx((float)mech.baseRotation(), (float)(extension * (float)i - boostTrns), (float)(-boostTrns * (float)i))), (float)(unit.y + Angles.trnsy((float)mech.baseRotation(), (float)(extension * (float)i - boostTrns), (float)(-boostTrns * (float)i))), (float)((float)this.legRegion.width * this.legRegion.scl() * (float)i), (float)((float)this.legRegion.height * this.legRegion.scl() * (1.0f - Math.max(-sin * (float)i, 0.0f) * 0.5f)), (float)(mech.baseRotation() - 90.0f + 35.0f * (float)i * e));
        }
        Draw.mixcol((Color)Color.white, (float)unit.hitTime);
        if (unit.lastDrownFloor != null) {
            Draw.color((Color)Color.white, (Color)Tmp.c1.set(unit.lastDrownFloor.mapColor).mul(0.83f), (float)(unit.drownTime * 0.9f));
        } else {
            Draw.color((Color)Color.white);
        }
        Draw.rect((TextureRegion)this.baseRegion, (Position)unit, (float)(mech.baseRotation() - 90.0f));
        Draw.mixcol();
    }

    public void applyOutlineColor(Unit unit) {
        if (unit.drownTime > 0.0f && unit.lastDrownFloor != null) {
            Draw.color((Color)Color.white, (Color)Tmp.c1.set(unit.lastDrownFloor.mapColor).mul(0.8f), (float)(unit.drownTime * 0.9f));
        }
    }

    public void applyColor(Unit unit) {
        Draw.color();
        if (this.healFlash) {
            Tmp.c1.set(Color.white).lerp(this.healColor, Mathf.clamp((float)(unit.healTime - unit.hitTime)));
        }
        Draw.mixcol((Color)Tmp.c1, (float)Math.max(unit.hitTime, !this.healFlash ? 0.0f : Mathf.clamp((float)unit.healTime)));
        if (unit.drownTime > 0.0f && unit.lastDrownFloor != null) {
            Draw.mixcol((Color)Tmp.c1.set(unit.lastDrownFloor.mapColor).mul(0.83f), (float)(unit.drownTime * 0.9f));
        }
        if (Vars.renderer != null && Vars.renderer.overlays != null) {
            Vars.renderer.overlays.checkApplySelection(unit);
        }
    }

    public static class UnitEngine
    implements Cloneable {
        public float x;
        public float y;
        public float radius;
        public float rotation;

        public UnitEngine(float x, float y, float radius, float rotation) {
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.rotation = rotation;
        }

        public UnitEngine() {
        }

        public void draw(Unit unit) {
            float scale;
            UnitType type = unit.type;
            float f = scale = type.useEngineElevation ? unit.elevation : 1.0f;
            if (scale <= 1.0E-4f) {
                return;
            }
            float rot = unit.rotation - 90.0f;
            Color color = type.engineColor == null ? unit.team.color : type.engineColor;
            Tmp.v1.set(this.x, this.y).rotate(rot);
            float ex = Tmp.v1.x;
            float ey = Tmp.v1.y;
            float rad = (this.radius + Mathf.absin((float)Time.time, (float)2.0f, (float)(this.radius / 4.0f))) * scale;
            Draw.color((Color)color);
            Fill.circle((float)(unit.x + ex), (float)(unit.y + ey), (float)rad);
            Draw.color((Color)type.engineColorInner);
            Fill.circle((float)(unit.x + ex - Angles.trnsx((float)(rot + this.rotation), (float)(rad / 4.0f))), (float)(unit.y + ey - Angles.trnsy((float)(rot + this.rotation), (float)(rad / 4.0f))), (float)(rad / 2.0f));
        }

        public UnitEngine copy() {
            try {
                return (UnitEngine)this.clone();
            }
            catch (CloneNotSupportedException awful) {
                throw new RuntimeException("fantastic", awful);
            }
        }
    }
}

