/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.audio.Sound;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.noise.Noise;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.content.Weathers;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Drawc;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Syncc;
import mindustry.gen.WeatherState;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.world.Tile;
import mindustry.world.blocks.Attributes;

public class Weather
extends UnlockableContent {
    public static final Rand rand = new Rand();
    private static final float boundMax = 80000.0f;
    public float duration = 36000.0f;
    public float opacityMultiplier = 1.0f;
    public Attributes attrs = new Attributes();
    public Sound sound = Sounds.none;
    public float soundVol = 0.1f;
    public float soundVolMin = 0.0f;
    public float soundVolOscMag = 0.0f;
    public float soundVolOscScl = 20.0f;
    public boolean hidden = false;
    public Prov<WeatherState> type = WeatherState::create;
    public StatusEffect status = StatusEffects.none;
    public float statusDuration = 120.0f;
    public boolean statusAir = true;
    public boolean statusGround = true;

    public Weather(String name, Prov<WeatherState> type) {
        super(name);
        this.type = type;
    }

    public Weather(String name) {
        super(name);
    }

    public WeatherState create() {
        return this.create(1.0f);
    }

    public WeatherState create(float intensity) {
        return this.create(intensity, this.duration);
    }

    public WeatherState create(float intensity, float duration) {
        WeatherState entity = (WeatherState)this.type.get();
        entity.intensity(Mathf.clamp((float)intensity));
        entity.init(this);
        entity.life(duration);
        entity.add();
        return entity;
    }

    @Nullable
    public WeatherState instance() {
        return (WeatherState)Groups.weather.find(w -> w.weather() == this);
    }

    public boolean isActive() {
        return this.instance() != null;
    }

    public void remove() {
        WeatherState e = this.instance();
        if (e != null) {
            e.remove();
        }
    }

    public void update(WeatherState state) {
    }

    public void updateEffect(WeatherState state) {
        if (this.status != StatusEffects.none) {
            if (state.effectTimer <= 0.0f) {
                state.effectTimer = this.statusDuration - 5.0f;
                Groups.unit.each(u -> {
                    if (u.checkTarget(this.statusAir, this.statusGround)) {
                        u.apply(this.status, this.statusDuration);
                    }
                });
            } else {
                state.effectTimer -= Time.delta;
            }
        }
        if (!Vars.headless && this.sound != Sounds.none) {
            float noise = this.soundVolOscMag > 0.0f ? (float)Math.abs(Noise.rawNoise((double)(Time.time / this.soundVolOscScl))) * this.soundVolOscMag : 0.0f;
            Vars.control.sound.loop(this.sound, Math.max((this.soundVol + noise) * state.opacity, this.soundVolMin));
        }
    }

    public void drawOver(WeatherState state) {
    }

    public void drawUnder(WeatherState state) {
    }

    public static void drawParticles(TextureRegion region, Color color, float sizeMin, float sizeMax, float density, float intensity, float opacity, float windx, float windy, float minAlpha, float maxAlpha, float sinSclMin, float sinSclMax, float sinMagMin, float sinMagMax, boolean randomParticleRotation) {
        rand.setSeed(0L);
        Vars.world.getQuadBounds(Tmp.r1).grow(sizeMax * 1.5f);
        Core.camera.bounds(Tmp.r2);
        int total = (int)(Tmp.r1.area() / density * intensity);
        for (int i = 0; i < total; ++i) {
            float scl = rand.random(0.5f, 1.0f);
            float scl2 = rand.random(0.5f, 1.0f);
            float size = rand.random(sizeMin, sizeMax);
            float x = rand.random(0.0f, 80000.0f) + Time.time * windx * scl2;
            float y = rand.random(0.0f, 80000.0f) + Time.time * windy * scl;
            float alpha = rand.random(minAlpha, maxAlpha);
            float rotation = randomParticleRotation ? rand.random(0.0f, 360.0f) : 0.0f;
            x += Mathf.sin((float)y, (float)rand.random(sinSclMin, sinSclMax), (float)rand.random(sinMagMin, sinMagMax));
            x -= Tmp.r1.x;
            y -= Tmp.r1.y;
            x = Mathf.mod((float)x, (float)Tmp.r1.width);
            y = Mathf.mod((float)y, (float)Tmp.r1.height);
            if (!Tmp.r3.setCentered(x += Tmp.r1.x, y += Tmp.r1.y, size).overlaps(Tmp.r2)) continue;
            Draw.color((Color)color, (float)(alpha * opacity));
            Draw.rect((TextureRegion)region, (float)x, (float)y, (float)size, (float)size, (float)rotation);
        }
        Draw.reset();
    }

    public static void drawRain(float sizeMin, float sizeMax, float xspeed, float yspeed, float density, float intensity, float stroke, Color color) {
        rand.setSeed(0L);
        float padding = sizeMax * 0.9f;
        Vars.world.getQuadBounds(Tmp.r1).grow(padding);
        Core.camera.bounds(Tmp.r2);
        int total = (int)(Tmp.r1.area() / density * intensity);
        Lines.stroke(stroke);
        float alpha = Draw.getColorAlpha();
        for (int i = 0; i < total; ++i) {
            float scl = rand.random(0.5f, 1.0f);
            float scl2 = rand.random(0.5f, 1.0f);
            float size = rand.random(sizeMin, sizeMax);
            float x = rand.random(0.0f, 80000.0f) + Time.time * xspeed * scl2;
            float y = rand.random(0.0f, 80000.0f) - Time.time * yspeed * scl;
            float tint = rand.random(1.0f) * alpha;
            x -= Tmp.r1.x;
            y -= Tmp.r1.y;
            x = Mathf.mod((float)x, (float)Tmp.r1.width);
            y = Mathf.mod((float)y, (float)Tmp.r1.height);
            if (!Tmp.r3.setCentered(x += Tmp.r1.x, y += Tmp.r1.y, size).overlaps(Tmp.r2)) continue;
            Draw.color((Color)color, (float)tint);
            Lines.lineAngle(x, y, Angles.angle((float)(xspeed * scl2), (float)(-yspeed * scl)), size / 2.0f);
        }
    }

    public static void drawSplashes(TextureRegion[] splashes, float padding, float density, float intensity, float opacity, float timeScale, float stroke, Color color, Liquid splasher) {
        Vars.world.getQuadBounds(Tmp.r1).grow(padding);
        Core.camera.bounds(Tmp.r2);
        int total = (int)(Tmp.r1.area() / density * intensity) / 2;
        Lines.stroke(stroke);
        rand.setSeed(0L);
        float t = Time.time / timeScale;
        for (int i = 0; i < total; ++i) {
            float offset = rand.random(0.0f, 1.0f);
            float time = t + offset;
            int pos = (int)time;
            float life = time % 1.0f;
            float x = rand.random(0.0f, 80000.0f) + (float)(pos * 953);
            float y = rand.random(0.0f, 80000.0f) - (float)(pos * 453);
            x -= Tmp.r1.x;
            y -= Tmp.r1.y;
            x = Mathf.mod((float)x, (float)Tmp.r1.width);
            y = Mathf.mod((float)y, (float)Tmp.r1.height);
            if (!Tmp.r3.setCentered(x += Tmp.r1.x, y += Tmp.r1.y, life * 4.0f).overlaps(Tmp.r2)) continue;
            Tile tile = Vars.world.tileWorld(x, y);
            if (tile != null && tile.floor().liquidDrop == splasher) {
                Draw.color((Color)Tmp.c1.set(tile.floor().mapColor).mul(1.5f).a(opacity));
                Draw.rect((TextureRegion)splashes[(int)(life * (float)(splashes.length - 1))], (float)x, (float)y);
                continue;
            }
            if (tile == null || tile.floor().liquidDrop != null || tile.floor().solid) continue;
            Draw.color((Color)color, (float)(Mathf.slope((float)life) * opacity));
            float space = 45.0f;
            for (int j : new int[]{-1, 1}) {
                Tmp.v1.trns(90.0f + (float)j * space, 1.0f + 5.0f * life);
                Lines.lineAngle(x + Tmp.v1.x, y + Tmp.v1.y, 90.0f + (float)j * space, 3.0f * (1.0f - life));
            }
        }
    }

    public static void drawNoiseLayers(Texture noise, Color color, float noisescl, float opacity, float baseSpeed, float intensity, float vwindx, float vwindy, int layers, float layerSpeedM, float layerAlphaM, float layerSclM, float layerColorM) {
        float sspeed = 1.0f;
        float sscl = 1.0f;
        float salpha = 1.0f;
        float offset = 0.0f;
        Color col = Tmp.c1.set(color);
        for (int i = 0; i < layers; ++i) {
            Weather.drawNoise(noise, col, noisescl * sscl, salpha * opacity, sspeed * baseSpeed, intensity, vwindx, vwindy, offset);
            sspeed *= layerSpeedM;
            salpha *= layerAlphaM;
            sscl *= layerSclM;
            offset += 0.29f;
            col.mul(layerColorM);
        }
    }

    public static void drawNoise(Texture noise, Color color, float noisescl, float opacity, float baseSpeed, float intensity, float vwindx, float vwindy, float offset) {
        Draw.color((Color)color, (float)opacity);
        float speed = baseSpeed * intensity;
        float windx = vwindx * speed;
        float windy = vwindy * speed;
        float scale = 1.0f / noisescl;
        float scroll = Time.time * scale + offset;
        Tmp.tr1.texture = noise;
        Core.camera.bounds(Tmp.r1);
        Tmp.tr1.set(Tmp.r1.x * scale, Tmp.r1.y * scale, (Tmp.r1.x + Tmp.r1.width) * scale, (Tmp.r1.y + Tmp.r1.height) * scale);
        Tmp.tr1.scroll(-windx * scroll, -windy * scroll);
        Draw.rect((TextureRegion)Tmp.tr1, (float)Core.camera.position.x, (float)Core.camera.position.y, (float)Core.camera.width, (float)(-Core.camera.height));
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    public ContentType getContentType() {
        return ContentType.weather;
    }

    public static void createWeather(Weather weather, float intensity, float duration, float windX, float windY) {
        weather.create((float)intensity, (float)duration).windVector.set(windX, windY);
    }

    static abstract class WeatherStateComp
    implements Drawc,
    Syncc {
        public static final float fadeTime = 240.0f;
        Weather weather;
        float intensity = 1.0f;
        float opacity = 0.0f;
        float life;
        float effectTimer;
        Vec2 windVector = new Vec2().setToRandomDirection();

        WeatherStateComp() {
        }

        void init(Weather weather) {
            this.weather = weather;
        }

        public void update() {
            this.opacity = this.life < 240.0f ? Math.min(this.life / 240.0f, this.opacity) : Mathf.lerpDelta((float)this.opacity, (float)1.0f, (float)0.004f);
            this.life -= Time.delta;
            this.weather.update((WeatherState)this.self());
            this.weather.updateEffect((WeatherState)this.self());
            if (this.life < 0.0f) {
                this.remove();
            }
        }

        public void draw() {
            if (Vars.renderer.weatherAlpha > 1.0E-4f && Vars.renderer.drawWeather && Core.settings.getBool("showweather")) {
                Draw.draw((float)130.0f, () -> {
                    Draw.alpha((float)(Vars.renderer.weatherAlpha * this.opacity * this.weather.opacityMultiplier));
                    this.weather.drawOver((WeatherState)this.self());
                    Draw.reset();
                });
                Draw.draw((float)20.0f, () -> {
                    Draw.alpha((float)(Vars.renderer.weatherAlpha * this.opacity * this.weather.opacityMultiplier));
                    this.weather.drawUnder((WeatherState)this.self());
                    Draw.reset();
                });
            }
        }
    }

    public static class WeatherEntry {
        public Weather weather = Weathers.rain;
        public float minFrequency;
        public float maxFrequency;
        public float minDuration;
        public float maxDuration;
        public float cooldown;
        public float intensity = 1.0f;
        public boolean always = false;

        public WeatherEntry(Weather weather) {
            this(weather, weather.duration * 2.0f, weather.duration * 6.0f, weather.duration / 2.0f, weather.duration * 1.5f);
        }

        public WeatherEntry(Weather weather, float minFrequency, float maxFrequency, float minDuration, float maxDuration) {
            this.weather = weather;
            this.minFrequency = minFrequency;
            this.maxFrequency = maxFrequency;
            this.minDuration = minDuration;
            this.maxDuration = maxDuration;
            this.cooldown = Mathf.random((float)minFrequency, (float)maxFrequency);
        }

        public WeatherEntry() {
        }
    }
}

