/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.ClickListener;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Tex;
import mindustryX.VarsX;
import mindustryX.features.LogicExt;

public class Minimap
extends Table {
    private final Cell<?> mapCell;
    private ClickListener listener;
    private ClickListener listener2;

    public Minimap() {
        this.background(Tex.pane);
        final float margin = 5.0f;
        this.touchable = Touchable.enabled;
        this.mapCell = this.add(new Element(){
            {
                this.addListener((EventListener)(Minimap.this.listener = new ClickListener(KeyCode.mouseRight){

                    public void clicked(InputEvent event, float cx, float cy) {
                        TextureRegion region = Vars.renderer.minimap.getRegion();
                        if (region == null) {
                            return;
                        }
                        float sx = (cx - x) / width;
                        float sy = (cy - y) / height;
                        float scaledX = Mathf.lerp((float)region.u, (float)region.u2, (float)sx) * (float)Vars.world.width() * 8.0f;
                        float scaledY = Mathf.lerp((float)(1.0f - region.v2), (float)(1.0f - region.v), (float)sy) * (float)Vars.world.height() * 8.0f;
                        Vars.control.input.panCamera(Tmp.v1.set(scaledX, scaledY));
                    }

                    public void touchDragged(InputEvent event, float x, float y, int pointer) {
                        super.touchDragged(event, x, y, pointer);
                        if (pointer == this.pressedPointer && this.pressed) {
                            this.clicked(event, x, y);
                        }
                    }
                }));
            }

            public void act(float delta) {
                int size = (Integer)VarsX.minimapSize.get();
                Minimap.this.mapCell.size((float)size);
                this.setSize(Scl.scl((float)size));
                this.setPosition(Scl.scl((float)margin), Scl.scl((float)margin));
                Minimap.this.listener.setButton(LogicExt.invertMapClick ? KeyCode.mouseLeft : KeyCode.mouseRight);
                Minimap.this.listener2.setButton(LogicExt.invertMapClick ? KeyCode.mouseRight : KeyCode.mouseLeft);
                super.act(delta);
            }

            protected void sizeChanged() {
                super.sizeChanged();
                Minimap.this.mapCell.getTable().invalidate();
            }

            public void draw() {
                if (Vars.renderer.minimap.getRegion() == null) {
                    return;
                }
                if (!this.clipBegin()) {
                    return;
                }
                Draw.rect((TextureRegion)Vars.renderer.minimap.getRegion(), (float)(this.x + this.width / 2.0f), (float)(this.y + this.height / 2.0f), (float)this.width, (float)this.height);
                if (Vars.renderer.minimap.getTexture() != null) {
                    Draw.alpha((float)this.parentAlpha);
                    Vars.renderer.minimap.drawEntities(this.x, this.y, this.width, this.height, false);
                }
                this.clipEnd();
            }
        }).size(140.0f);
        this.margin(margin);
        this.addListener((EventListener)new InputListener(){

            public boolean scrolled(InputEvent event, float x, float y, float amountx, float amounty) {
                Vars.renderer.minimap.zoomBy(amounty);
                return true;
            }
        });
        this.listener2 = new ClickListener(){
            {
                this.tapSquareSize = Scl.scl((float)11.0f);
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                if (this.inTapSquare()) {
                    super.touchUp(event, x, y, pointer, button2);
                } else {
                    this.pressed = false;
                    this.pressedPointer = -1;
                    this.pressedButton = null;
                    this.cancelled = false;
                }
            }

            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (!this.inTapSquare(x, y)) {
                    this.invalidateTapSquare();
                }
                super.touchDragged(event, x, y, pointer);
                if (Vars.mobile) {
                    float max = (float)Math.min(Vars.world.width(), Vars.world.height()) / 16.0f / 2.0f;
                    Vars.renderer.minimap.setZoom(1.0f + y / Minimap.this.height * (max - 1.0f));
                }
            }

            public void clicked(InputEvent event, float x, float y) {
                Vars.ui.minimapfrag.toggle();
            }
        };
        this.addListener((EventListener)this.listener2);
        this.update(() -> {
            Element e = Core.scene.getHoverElement();
            if (e != null && e.isDescendantOf((Element)this)) {
                this.requestScroll();
            } else if (this.hasScroll()) {
                Core.scene.setScrollFocus(null);
            }
        });
    }
}

