/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Scaling;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.Stats;
import mindustryX.features.ui.ArcMessageDialog;

public class ContentInfoDialog
extends BaseDialog {
    public ContentInfoDialog() {
        super("@info.title");
        this.addCloseButton();
        this.keyDown(key -> {
            if (key == Binding.blockInfo.value.key) {
                Core.app.post(() -> ((ContentInfoDialog)this).hide());
            }
        });
    }

    public void show(UnlockableContent content) {
        this.cont.clear();
        Table table2 = new Table();
        table2.margin(10.0f);
        content.checkStats();
        table2.table(title1 -> {
            ((Image)title1.image(content.uiIcon).size(48.0f).scaling(Scaling.fit).get()).clicked(() -> Core.app.setClipboardText(content.emoji()));
            int logicId = content.getLogicId();
            title1.add((CharSequence)("[accent]" + content.localizedName + "\n[gray]" + content.name + (logicId != -1 ? " <#" + logicId + ">" : ""))).padLeft(5.0f);
        });
        table2.row();
        if (content.description != null) {
            boolean any;
            boolean bl = any = content.stats.toMap().size > 0;
            if (any) {
                table2.add((CharSequence)"@category.purpose").color(Pal.accent).fillX().padTop(10.0f);
                table2.row();
            }
            table2.add((CharSequence)("[lightgray]" + content.displayDescription())).wrap().fillX().padLeft(any ? 10.0f : 0.0f).width(500.0f).padTop(any ? 0.0f : 10.0f).left();
            table2.row();
            if (!content.stats.useCategories && any) {
                table2.add((CharSequence)"@category.general").fillX().color(Pal.accent);
                table2.row();
            }
        }
        Stats stats = content.stats;
        for (StatCat cat : stats.toMap().keys()) {
            OrderedMap map = (OrderedMap)stats.toMap().get((Object)cat);
            if (map.size == 0) continue;
            if (stats.useCategories) {
                table2.add((CharSequence)("@category." + cat.name)).color(Pal.accent).fillX();
                table2.row();
            }
            for (Stat stat : map.keys()) {
                table2.table(inset -> {
                    inset.left();
                    inset.add((CharSequence)("[lightgray]" + stat.localized() + ":[] ")).left().top();
                    Seq arr = (Seq)map.get((Object)stat);
                    for (StatValue value : arr) {
                        value.display(inset);
                        inset.add().size(10.0f);
                    }
                }).fillX().padLeft(10.0f);
                table2.row();
            }
        }
        if (content.details != null) {
            table2.add((CharSequence)("[gray]" + content.details)).pad(6.0f).padTop(20.0f).width(400.0f).wrap().fillX();
            table2.row();
        }
        if (Core.settings.getBool("console")) {
            table2.button("@viewfields", (Drawable)Icon.link, Styles.grayt, () -> {
                Class<?> contentClass = ((Object)((Object)content)).getClass();
                if (contentClass.isAnonymousClass()) {
                    contentClass = contentClass.getSuperclass();
                }
                Core.app.openURI("https://mindustrygame.github.io/wiki/Modding%20Classes/" + contentClass.getSimpleName());
            }).margin(8.0f).pad(4.0f).size(300.0f, 50.0f).row();
        }
        content.displayExtra(table2);
        table2.table(t -> {
            t.defaults().size(40.0f);
            t.button(content.emoji(), Styles.cleart, () -> Core.app.setClipboardText(content.emoji())).tooltip(content.emoji());
            t.button((Drawable)Icon.info, Styles.clearNonei, () -> Core.app.setClipboardText(content.name)).tooltip(content.name);
            if (content.description != null) {
                t.button((Drawable)Icon.book, Styles.clearNonei, () -> Core.app.setClipboardText(content.description)).tooltip(content.description);
            }
            if (Vars.net.active()) {
                t.button("\u2650\u7b80", Styles.cleart, () -> ArcMessageDialog.shareContent(content, false)).width(60.0f);
                t.button("\u2650\u8be6", Styles.cleart, () -> ArcMessageDialog.shareContent(content, true)).width(60.0f);
            }
        }).fillX().padLeft(10.0f);
        ScrollPane pane = new ScrollPane((Element)table2);
        table2.marginRight(30.0f);
        this.cont.add((Element)pane);
        if (this.isShown()) {
            this.show(Core.scene, (Action)Actions.fadeIn((float)0.0f));
        } else {
            this.show();
        }
    }
}

