/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.Files;
import arc.files.Fi;
import arc.func.Cons;
import arc.func.ConsT;
import arc.func.Floatc;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.ClickListener;
import arc.scene.event.EventListener;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Http;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Streams;
import arc.util.serialization.Jval;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.mod.ModListing;
import mindustry.mod.Mods;
import mindustry.type.Publishable;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustryX.features.UIExt;
import mindustryX.features.ui.CommitsTable;
import mindustryX.features.ui.ModsRecommendDialog;
import mindustryX.features.ui.comp.Card;

public class ModsDialog
extends BaseDialog {
    private ObjectMap<String, TextureRegion> textureCache = new ObjectMap();
    private float modImportProgress;
    private String searchtxt = "";
    @Nullable
    private Seq<ModListing> modList;
    private boolean orderDate = true;
    private BaseDialog currentContent;
    private BaseDialog browser;
    private Table browserTable;
    private final Seq<Mods.LoadedMod> internalMods = new Seq();
    private final Seq<Mods.LoadedMod> otherMods = new Seq();
    private String modQuery;
    private final Table modPane;
    private float modCardWidth;
    private float modCardHeight = 110.0f;
    private float scroll = 0.0f;

    public ModsDialog() {
        super("@mods");
        this.addCloseButton();
        this.browser = new BaseDialog("@mods.browser");
        this.modPane = new Table().margin(10.0f).top();
        this.browser.cont.table(table2 -> {
            table2.left();
            table2.image((Drawable)Icon.zoom);
            table2.field(this.searchtxt, res -> {
                this.searchtxt = res;
                this.rebuildBrowser();
            }).growX().get();
            ((ImageButton)table2.button((Drawable)Icon.list, Styles.emptyi, 32.0f, () -> {
                this.orderDate = !this.orderDate;
                this.rebuildBrowser();
            }).update(b -> {
                b.getStyle().imageUp = this.orderDate ? Icon.list : Icon.star;
            }).size(40.0f).get()).addListener((EventListener)new Tooltip(tip -> tip.label(() -> this.orderDate ? "@mods.browser.sortdate" : "@mods.browser.sortstars").left()));
        }).fillX().padBottom(4.0f);
        this.browser.cont.row();
        this.browser.cont.pane(tablebrow -> {
            tablebrow.margin(10.0f).top();
            this.browserTable = tablebrow;
        }).scrollX(false);
        this.browser.addCloseButton();
        this.browser.makeButtonOverlay();
        this.browser.onResize(this::rebuildBrowser);
        this.buttons.button("@mods.guide", (Drawable)Icon.link, () -> Core.app.openURI("https://mindustrygame.github.io/wiki/modding/1-modding/")).size(210.0f, 64.0f);
        if (!Vars.mobile) {
            this.buttons.button("@mods.openfolder", (Drawable)Icon.link, () -> Core.app.openFolder(Vars.modDirectory.absolutePath()));
        }
        this.shown(this::setup);
        this.onResize(this::setup);
        Events.on(EventType.ResizeEvent.class, event -> {
            if (this.currentContent != null) {
                this.currentContent.hide();
                this.currentContent = null;
            }
        });
        this.hidden(() -> {
            if (Vars.mods.requiresReload()) {
                Vars.mods.reload();
            }
        });
    }

    void modError(Throwable error) {
        Vars.ui.loadfrag.hide();
        if (error instanceof NoSuchMethodError || Strings.getCauses((Throwable)error).contains(t -> t.getMessage() != null && (t.getMessage().contains("trust anchor") || t.getMessage().contains("SSL") || t.getMessage().contains("protocol")))) {
            Vars.ui.showErrorMessage("@feature.unsupported");
        } else if (error instanceof Http.HttpStatusException) {
            Http.HttpStatusException st = (Http.HttpStatusException)error;
            Vars.ui.showErrorMessage(Core.bundle.format("connectfail", new Object[]{Strings.capitalize((String)st.status.toString().toLowerCase())}));
        } else if (error.getMessage() != null && error.getMessage().toLowerCase(Locale.ROOT).contains("writable dex")) {
            Vars.ui.showException("@error.moddex", error);
        } else {
            Vars.ui.showException(error);
        }
    }

    void getModList(Cons<Seq<ModListing>> listener) {
        this.getModList(0, listener);
    }

    public void getModList(int index, Cons<Seq<ModListing>> listener) {
        if (index >= Vars.modJsonURLs.length) {
            return;
        }
        if (this.modList != null) {
            listener.get(this.modList);
            return;
        }
        Http.get(Vars.modJsonURLs[index], (ConsT<Http.HttpResponse, Exception>)((ConsT)response -> {
            String strResult = response.getResultAsString();
            Core.app.post(() -> {
                try {
                    this.modList = (Seq)JsonIO.json.fromJson(Seq.class, ModListing.class, strResult);
                    SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    Func parser = text -> {
                        try {
                            return d.parse((String)text);
                        }
                        catch (Exception e) {
                            return new Date();
                        }
                    };
                    this.modList.sortComparing(m -> (Date)parser.get((Object)m.lastUpdated)).reverse();
                    listener.get(this.modList);
                }
                catch (Exception e) {
                    Log.err((Throwable)e);
                    Vars.ui.showException(e);
                }
            });
        }), (Cons<Throwable>)((Cons)error -> {
            if (index < Vars.modJsonURLs.length - 1) {
                this.getModList(index + 1, listener);
            } else {
                Core.app.post(() -> {
                    this.modError((Throwable)error);
                    if (this.browser != null) {
                        this.browser.hide();
                    }
                });
            }
        }));
    }

    void setup() {
        this.modCardWidth = Math.min((float)Core.graphics.getWidth() / Scl.scl((float)1.05f) - Scl.scl((float)28.0f), 520.0f);
        Seq<Mods.LoadedMod> modList = Vars.mods.list();
        this.internalMods.clear();
        this.otherMods.clear();
        for (Mods.LoadedMod mod : modList) {
            if (mod.root.type() == Files.FileType.internal) {
                this.internalMods.add((Object)mod);
                continue;
            }
            this.otherMods.add((Object)mod);
        }
        this.cont.clear();
        this.cont.defaults().width(Math.min((float)Core.graphics.getWidth() / Scl.scl((float)1.05f), 556.0f)).pad(4.0f);
        ((Label)this.cont.add((CharSequence)"@mod.reloadrequired").visible(Vars.mods::requiresReload).center().get()).setAlignment(1);
        this.cont.row();
        this.cont.table(buttons -> {
            buttons.left().defaults().growX().height(60.0f).uniformX();
            buttons.defaults().pad(4.0f).margin(12.0f);
            TextButton.TextButtonStyle style = Styles.flatBordert;
            buttons.button("@mod.import", (Drawable)Icon.add, style, () -> {
                BaseDialog dialog = new BaseDialog("@mod.import");
                TextButton.TextButtonStyle bstyle = Styles.flatt;
                dialog.cont.table(Tex.button, t -> {
                    t.defaults().size(300.0f, 70.0f);
                    t.margin(12.0f);
                    t.button("@mod.import.file", (Drawable)Icon.file, bstyle, () -> {
                        dialog.hide();
                        Vars.platform.showMultiFileChooser(file -> {
                            try {
                                Vars.mods.importMod((Fi)file);
                                this.setup();
                            }
                            catch (Exception e) {
                                Vars.ui.showException(e.getMessage() != null && e.getMessage().toLowerCase(Locale.ROOT).contains("writable dex") ? "@error.moddex" : "", e);
                                Log.err((Throwable)e);
                            }
                        }, new String[]{"zip", "jar"});
                    }).margin(12.0f);
                    t.row();
                    t.button("@mod.import.github", (Drawable)Icon.github, bstyle, () -> {
                        dialog.hide();
                        Vars.ui.showTextInput("@mod.import.github", "", 64, Core.settings.getString("lastmod", ""), (Cons<String>)((Cons)text -> {
                            if ((text = text.trim().replace(" ", "")).startsWith("https://github.com/")) {
                                text = text.substring("https://github.com/".length());
                            }
                            Core.settings.put("lastmod", text);
                            this.githubImportMod((String)text, false, null);
                        }));
                    }).margin(12.0f);
                });
                dialog.addCloseButton();
                dialog.show();
            });
            buttons.button("@mods.browser", (Drawable)Icon.menu, style, this::showModBrowser);
            buttons.row();
            buttons.button("@mods.recommend", (Drawable)Icon.list, style, () -> ((ModsRecommendDialog)UIExt.modsRecommend).show()).colspan(2);
        }).width(this.modCardWidth);
        this.cont.row();
        if (!Vars.mods.list().isEmpty()) {
            if (!Vars.mobile || Core.graphics.isPortrait()) {
                this.cont.table(search -> {
                    search.image((Drawable)Icon.zoom).padRight(8.0f);
                    search.field("", text -> {
                        this.modQuery = text;
                        this.rebuildModPane();
                    }).growX();
                }).fillX().padBottom(4.0f);
            }
            this.cont.row();
            ((ScrollPane)this.cont.pane(Styles.noBarPane, (Element)this.modPane).scrollX(false).update(s -> {
                this.scroll = s.getScrollY();
            }).get()).setScrollYForce(this.scroll);
            this.modQuery = "";
            this.rebuildModPane();
        } else {
            this.cont.table(Styles.black6, t -> t.add((CharSequence)"@mods.none")).height(80.0f);
        }
        this.cont.row();
    }

    private void rebuildModPane() {
        this.modPane.clearChildren();
        this.addModGroup(this.modPane, "internal", this.internalMods);
        this.addModGroup(this.modPane, "mod", this.otherMods);
    }

    private void addModGroup(Table table2, String groupName, Seq<Mods.LoadedMod> mods) {
        table2.table(Tex.whiteui, modGroup -> {
            modGroup.add((CharSequence)(Core.bundle.get("mods.group." + groupName) + "(" + mods.size + ")")).color(Pal.accent).pad(4.0f).padLeft(12.0f).expandX().left();
            modGroup.row();
            modGroup.table(modCont -> {
                boolean any = false;
                boolean anyDisabled = false;
                for (Mods.LoadedMod mod : mods) {
                    if (!Strings.matches((String)this.modQuery, (String)mod.meta.displayName)) continue;
                    any = true;
                    if (!mod.enabled() && !anyDisabled && mods.any()) {
                        anyDisabled = true;
                        modCont.row();
                        modCont.table(disableLine -> {
                            disableLine.add((CharSequence)"@mods.disabled").color(Color.red).pad(4.0f);
                            disableLine.image().height(4.0f).pad(4.0f).color(Pal.darkestGray).growX();
                        }).growX().pad(6.0f);
                        modCont.row();
                    }
                    this.addModCard((Table)modCont, mod);
                    Card.cardShadow(modCont);
                    modCont.row();
                }
                if (!any) {
                    modCont.add((CharSequence)"@none.found").color(Color.lightGray).pad(4.0f);
                }
            }).pad(8.0f).fillX();
        }).color(Pal.gray).padTop(16.0f).growX();
        table2.row();
    }

    private void addModCard(Table table2, final Mods.LoadedMod mod) {
        table2.button(t -> {
            t.top().left();
            t.margin(12.0f);
            String stateDetails = this.getStateDetails(mod);
            if (stateDetails != null) {
                t.addListener((EventListener)new Tooltip(f -> f.background(Styles.black8).margin(4.0f).add((CharSequence)stateDetails).growX().width(400.0f).wrap()));
            }
            t.defaults().left().top();
            t.table(title1 -> {
                title1.left();
                title1.add((Element)new BorderImage(){
                    {
                        if (mod.iconTexture != null) {
                            this.setDrawable(new TextureRegion(mod.iconTexture));
                        } else {
                            this.setDrawable(Tex.nomap);
                        }
                        this.border(Pal.accent);
                    }
                }).size(this.modCardHeight - 8.0f).padTop(-8.0f).padLeft(-8.0f).padRight(8.0f);
                title1.table(text -> {
                    boolean hideDisabled = !mod.isSupported() || mod.hasUnmetDependencies() || mod.hasContentErrors();
                    String shortDesc = mod.meta.shortDescription();
                    text.add((CharSequence)("[accent]" + Strings.stripColors((CharSequence)mod.meta.displayName) + "\n" + (shortDesc.length() > 0 ? "[lightgray]" + shortDesc + "\n" : "") + (mod.enabled() || hideDisabled ? "" : Core.bundle.get("mod.disabled") + ""))).wrap().top().width(300.0f).growX().left();
                    text.row();
                    String state = this.getStateText(mod);
                    if (state != null) {
                        text.labelWrap(state).growX().row();
                    }
                }).top().growX();
                title1.add().growX();
            }).grow().left();
            t.table(right -> {
                right.right();
                right.button((Drawable)(mod.enabled() ? Icon.downOpen : Icon.upOpen), Styles.clearNonei, () -> {
                    Vars.mods.setEnabled(mod, !mod.enabled());
                    this.setup();
                }).size(50.0f).disabled(!mod.isSupported());
                right.button((Drawable)(mod.hasSteamID() ? Icon.link : Icon.trash), Styles.clearNonei, () -> {
                    if (!mod.hasSteamID()) {
                        Vars.ui.showConfirm("@confirm", "@mod.remove.confirm", () -> {
                            Vars.mods.removeMod(mod);
                            this.setup();
                        });
                    } else {
                        Vars.platform.viewListing((Publishable)mod);
                    }
                }).size(50.0f).disabled(mod.root.type() == Files.FileType.internal);
                right.row();
                if (Vars.steam && !mod.hasSteamID()) {
                    right.button((Drawable)Icon.export, Styles.clearNonei, () -> Vars.platform.publish((Publishable)mod)).size(50.0f);
                }
                if (mod.getRepo() != null) {
                    right.button((Drawable)Icon.githubSmall, Styles.clearNonei, () -> {
                        BaseDialog dialog = new BaseDialog("@commit.title");
                        dialog.cont.add((Element)new CommitsTable(mod.getRepo())).color(Pal.lightishGray);
                        dialog.addCloseButton();
                        dialog.show();
                    }).size(50.0f);
                }
            }).growX().right().padRight(-8.0f).padTop(-8.0f);
        }, (Button.ButtonStyle)Styles.flatBordert, () -> this.showMod(mod)).maxWidth(this.modCardWidth).height(this.modCardHeight).growX().pad(4.0f);
    }

    @Nullable
    private String getStateText(Mods.LoadedMod item) {
        if (item.isOutdated()) {
            return "@mod.incompatiblemod";
        }
        if (item.isBlacklisted()) {
            return "@mod.blacklisted";
        }
        if (!item.isSupported()) {
            return "@mod.incompatiblegame";
        }
        if (item.state == Mods.ModState.circularDependencies) {
            return "@mod.circulardependencies";
        }
        if (item.state == Mods.ModState.incompleteDependencies) {
            return "@mod.incompletedependencies";
        }
        if (item.hasUnmetDependencies()) {
            return "@mod.unmetdependencies";
        }
        if (item.hasContentErrors()) {
            return "@mod.erroredcontent";
        }
        if (item.meta.hidden) {
            return "@mod.multiplayer.compatible";
        }
        return null;
    }

    @Nullable
    private String getStateDetails(Mods.LoadedMod item) {
        if (item.isOutdated()) {
            return "@mod.incompatiblemod.details";
        }
        if (item.isBlacklisted()) {
            return "@mod.blacklisted.details";
        }
        if (!item.isSupported()) {
            return Core.bundle.format("mod.requiresversion.details", new Object[]{item.meta.minGameVersion});
        }
        if (item.state == Mods.ModState.circularDependencies) {
            return "@mod.circulardependencies.details";
        }
        if (item.state == Mods.ModState.incompleteDependencies) {
            return Core.bundle.format("mod.incompletedependencies.details", new Object[]{item.missingDependencies.toString(", ")});
        }
        if (item.hasUnmetDependencies()) {
            return Core.bundle.format("mod.missingdependencies.details", new Object[]{item.missingDependencies.toString(", ")});
        }
        if (item.hasContentErrors()) {
            return "@mod.erroredcontent.details";
        }
        return null;
    }

    private void showMod(Mods.LoadedMod mod) {
        BaseDialog dialog = new BaseDialog(mod.meta.displayName);
        dialog.addCloseButton();
        if (!Vars.mobile) {
            dialog.buttons.button("@mods.openfolder", (Drawable)Icon.link, () -> Core.app.openFolder(mod.file.absolutePath()));
        }
        if (mod.getRepo() != null) {
            boolean showImport = !mod.hasSteamID();
            dialog.buttons.button("@mods.github.open", (Drawable)Icon.link, () -> Core.app.openURI("https://github.com/" + mod.getRepo()));
            if (Vars.mobile && showImport) {
                dialog.buttons.row();
            }
            if (showImport) {
                dialog.buttons.button("@mods.browser.reinstall", (Drawable)Icon.download, () -> this.githubImportMod(mod.getRepo(), mod.isJava(), null));
            }
        }
        dialog.cont.pane(desc -> {
            String state;
            desc.center();
            desc.defaults().padTop(10.0f).left();
            desc.add((CharSequence)"@editor.name").padRight(10.0f).color(Color.gray).padTop(0.0f);
            desc.row();
            desc.add((CharSequence)mod.meta.displayName).growX().wrap().padTop(2.0f);
            desc.row();
            if (mod.meta.author != null) {
                desc.add((CharSequence)"@editor.author").padRight(10.0f).color(Color.gray);
                desc.row();
                desc.add((CharSequence)mod.meta.author).growX().wrap().padTop(2.0f);
                desc.row();
            }
            if (mod.meta.version != null) {
                desc.add((CharSequence)"@mod.version").padRight(10.0f).color(Color.gray).top();
                desc.row();
                desc.add((CharSequence)mod.meta.version).growX().wrap().padTop(2.0f);
                desc.row();
            }
            if (mod.meta.description != null) {
                desc.add((CharSequence)"@editor.description").padRight(10.0f).color(Color.gray).top();
                desc.row();
                desc.add((CharSequence)mod.meta.description).growX().wrap().padTop(2.0f);
                desc.row();
            }
            if ((state = this.getStateDetails(mod)) != null) {
                desc.add((CharSequence)"@mod.disabled").padTop(13.0f).padBottom(-6.0f).row();
                desc.add((CharSequence)state).growX().wrap().row();
            }
        }).width(400.0f);
        Seq all = Seq.with((Object[])Vars.content.getContentMap()).flatten().select(c -> {
            UnlockableContent u;
            return c.minfo.mod == mod && c instanceof UnlockableContent && !(u = (UnlockableContent)((Object)c)).isHidden();
        }).as();
        if (all.any()) {
            dialog.cont.row();
            dialog.cont.button("@mods.viewcontent", (Drawable)Icon.book, () -> {
                BaseDialog d = new BaseDialog(mod.meta.displayName);
                d.cont.pane(cs -> {
                    int i = 0;
                    for (UnlockableContent c : all) {
                        cs.button((Drawable)new TextureRegionDrawable(c.uiIcon), Styles.flati, 32.0f, () -> Vars.ui.content.show(c)).size(50.0f).with(im -> {
                            ClickListener click = im.getClickListener();
                            im.update(() -> im.getImage().color.lerp(!click.isOver() ? Color.lightGray : Color.white, 0.4f * Time.delta));
                        }).tooltip(c.localizedName);
                        if (++i % (int)Math.min((float)Core.graphics.getWidth() / Scl.scl((float)110.0f), 14.0f) != 0) continue;
                        cs.row();
                    }
                }).grow();
                d.addCloseButton();
                d.show();
                this.currentContent = d;
            }).size(300.0f, 50.0f).pad(4.0f);
        }
        dialog.show();
    }

    private void showModBrowser() {
        this.rebuildBrowser();
        this.browser.show();
    }

    private void rebuildBrowser() {
        final ObjectSet installed = Vars.mods.list().map(m -> m.getRepo()).asSet();
        this.browserTable.clear();
        this.browserTable.add((CharSequence)"@loading");
        int cols = (int)Math.max((float)Core.graphics.getWidth() / Scl.scl((float)480.0f), 1.0f);
        this.getModList(0, (Cons<Seq<ModListing>>)((Cons)rlistings -> {
            this.browserTable.clear();
            int i = 0;
            Seq listings = rlistings;
            if (!this.orderDate) {
                listings = rlistings.copy();
                listings.sortComparing(m1 -> -m1.stars);
            }
            for (ModListing mod : listings) {
                if ((mod.hasJava || mod.hasScripts) && Vars.ios || !Strings.matches((String)this.searchtxt, (String)mod.name) && !Strings.matches((String)this.searchtxt, (String)mod.repo)) continue;
                float s = 64.0f;
                this.browserTable.button(con -> {
                    con.margin(0.0f);
                    con.left();
                    final String repo = mod.repo;
                    con.add((Element)new BorderImage(){
                        TextureRegion last;
                        {
                            this.border(installed.contains((Object)repo) ? Pal.accent : Color.lightGray);
                            this.setDrawable(Tex.nomap);
                            this.pad = Scl.scl((float)4.0f);
                        }

                        public void draw() {
                            TextureRegion next;
                            super.draw();
                            if (!ModsDialog.this.textureCache.containsKey((Object)repo)) {
                                this.last = Core.atlas.find("nomap");
                                ModsDialog.this.textureCache.put((Object)repo, (Object)this.last);
                                Http.get("https://raw.githubusercontent.com/Anuken/MindustryMods/master/icons/" + repo.replace("/", "_"), (ConsT<Http.HttpResponse, Exception>)((ConsT)res -> {
                                    Pixmap pix = new Pixmap(res.getResult());
                                    Core.app.post(() -> {
                                        try {
                                            Texture tex = new Texture(pix);
                                            tex.setFilter(Texture.TextureFilter.linear);
                                            ModsDialog.this.textureCache.put((Object)repo, (Object)new TextureRegion(tex));
                                            pix.dispose();
                                        }
                                        catch (Exception e) {
                                            Log.err((Throwable)e);
                                        }
                                    });
                                }), (Cons<Throwable>)((Cons)err -> {}));
                            }
                            if (this.last != (next = (TextureRegion)ModsDialog.this.textureCache.get((Object)repo))) {
                                this.last = next;
                                this.setDrawable(next);
                            }
                        }
                    }).size(s).pad(8.0f);
                    String infoText = "[accent]" + mod.name.replace("\n", "") + (installed.contains((Object)mod.repo) ? "\n[lightgray]" + Core.bundle.get("mod.installed") : "") + "\n[lightgray]\ue809 " + mod.stars + (!Version.isAtLeast(mod.minGameVersion) ? "\n" + Core.bundle.format("mod.requiresversion", new Object[]{mod.minGameVersion}) : (mod.hasJava && Strings.parseDouble((String)mod.minGameVersion, (double)0.0) < 154.0 ? "\n" + Core.bundle.get("mod.incompatiblemod") : ""));
                    con.add((CharSequence)infoText).width(358.0f).wrap().grow().pad(4.0f, 2.0f, 4.0f, 6.0f).top().left().labelAlign(10);
                }, (Button.ButtonStyle)Styles.flatBordert, () -> {
                    BaseDialog sel = new BaseDialog(mod.name);
                    sel.cont.pane(p -> p.add((CharSequence)(mod.description + "\n\n[accent]" + Core.bundle.get("editor.author") + "[lightgray] " + mod.author)).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).labelAlign(1, 8)).grow();
                    sel.buttons.defaults().size(150.0f, 54.0f).pad(2.0f);
                    sel.buttons.button("@back", (Drawable)Icon.left, () -> {
                        sel.clear();
                        sel.hide();
                    });
                    Mods.LoadedMod found = (Mods.LoadedMod)Vars.mods.list().find(l -> mod.repo != null && mod.repo.equals(l.getRepo()));
                    sel.buttons.button(found == null ? "@mods.browser.add" : "@mods.browser.reinstall", (Drawable)Icon.download, () -> {
                        sel.hide();
                        this.githubImportMod(mod.repo, mod.hasJava, null);
                    });
                    if (Core.graphics.isPortrait()) {
                        sel.buttons.row();
                    }
                    sel.buttons.button("@mods.github.open", (Drawable)Icon.link, () -> Core.app.openURI("https://github.com/" + mod.repo));
                    sel.buttons.button("@mods.browser.view-releases", (Drawable)Icon.zoom, () -> {
                        BaseDialog load = new BaseDialog("");
                        load.cont.add((CharSequence)"[accent]Fetching Releases...");
                        load.show();
                        Http.get("https://api.github.com/repos/" + mod.repo + "/releases", (ConsT<Http.HttpResponse, Exception>)((ConsT)res -> {
                            Jval json = Jval.read((String)res.getResultAsString());
                            Jval.JsonArray releases = json.asArray();
                            Core.app.post(() -> {
                                load.hide();
                                if (releases.size == 0) {
                                    Vars.ui.showInfo("@mods.browser.noreleases");
                                } else {
                                    sel.hide();
                                    BaseDialog downloads = new BaseDialog("@mods.browser.releases");
                                    downloads.cont.pane(p -> {
                                        for (int j = 0; j < releases.size; ++j) {
                                            Jval release = (Jval)releases.get(j);
                                            int index = j;
                                            p.table(((TextureRegionDrawable)Tex.whiteui).tint(Pal.darkestGray), t -> {
                                                t.add((CharSequence)("[accent]" + release.getString("name") + (index == 0 ? " " + Core.bundle.get("mods.browser.latest") : ""))).top().left().growX().wrap().pad(5.0f);
                                                t.row();
                                                t.add((CharSequence)release.getString("published_at").substring(0, 10).replaceAll("-", "/")).top().left().growX().wrap().pad(5.0f).color(Color.gray);
                                                t.row();
                                                t.table(b -> {
                                                    b.defaults().size(150.0f, 54.0f).pad(2.0f);
                                                    b.button("@mods.github.open-release", (Drawable)Icon.link, () -> Core.app.openURI(release.getString("html_url")));
                                                    b.button("@mods.browser.add", (Drawable)Icon.download, () -> {
                                                        String releaseUrl = release.getString("url");
                                                        this.githubImportMod(mod.repo, mod.hasJava, releaseUrl.substring(releaseUrl.lastIndexOf("/") + 1));
                                                    });
                                                }).right();
                                            }).margin(5.0f).growX().pad(5.0f);
                                            if (j >= releases.size - 1) continue;
                                            p.row();
                                        }
                                    }).width(500.0f).scrollX(false).fillY();
                                    downloads.buttons.button("@back", (Drawable)Icon.left, () -> {
                                        downloads.clear();
                                        downloads.hide();
                                        sel.show();
                                    }).size(150.0f, 54.0f).pad(2.0f);
                                    downloads.keyDown(KeyCode.escape, () -> ((BaseDialog)downloads).hide());
                                    downloads.keyDown(KeyCode.back, () -> ((BaseDialog)downloads).hide());
                                    downloads.hidden(() -> ((BaseDialog)sel).show());
                                    downloads.show();
                                }
                            });
                        }), (Cons<Throwable>)((Cons)t -> Core.app.post(() -> {
                            this.modError((Throwable)t);
                            load.hide();
                        })));
                    });
                    sel.keyDown(KeyCode.escape, () -> ((BaseDialog)sel).hide());
                    sel.keyDown(KeyCode.back, () -> ((BaseDialog)sel).hide());
                    sel.show();
                }).width(438.0f).pad(4.0f).growX().left().height(s + 16.0f).fillY();
                if (++i % cols != 0) continue;
                this.browserTable.row();
            }
        }));
    }

    private void handleMod(String repo, Http.HttpResponse result) {
        try {
            Fi file = Vars.tmpDirectory.child(repo.replace("/", "") + ".zip");
            long len = result.getContentLength();
            Floatc cons = len <= 0L ? f -> {} : p -> {
                this.modImportProgress = p;
            };
            try (OutputStream stream = file.write(false);){
                Streams.copyProgress((InputStream)result.getResultAsStream(), (OutputStream)stream, (long)len, (int)4096, (Floatc)cons);
            }
            Mods.LoadedMod mod = Vars.mods.importMod(file);
            mod.setRepo(repo);
            file.delete();
            Core.app.post(() -> {
                try {
                    this.setup();
                    Vars.ui.loadfrag.hide();
                }
                catch (Throwable e) {
                    Vars.ui.showException(e);
                }
            });
        }
        catch (Throwable e) {
            this.modError(e);
        }
    }

    private void importFail(Throwable t) {
        Core.app.post(() -> this.modError(t));
    }

    public void githubImportMod(String repo, boolean isJava) {
        this.githubImportMod(repo, isJava, null);
    }

    public void githubImportMod(String repo, boolean isJava, @Nullable String release) {
        this.modImportProgress = 0.0f;
        Vars.ui.loadfrag.show("@downloading");
        Vars.ui.loadfrag.setProgress(() -> this.modImportProgress);
        if (isJava) {
            this.githubImportJavaMod(repo, release);
        } else {
            Http.get("https://api.github.com/repos/" + repo, (ConsT<Http.HttpResponse, Exception>)((ConsT)res -> {
                Jval json = Jval.read((String)res.getResultAsString());
                String mainBranch = json.getString("default_branch");
                String language = json.getString("language", "<none>");
                if (language.equals("Java") || language.equals("Kotlin") || language.equals("Groovy") || language.equals("Scala")) {
                    this.githubImportJavaMod(repo, release);
                } else {
                    this.githubImportBranch(mainBranch, repo, release);
                }
            }), (Cons<Throwable>)((Cons)this::importFail));
        }
    }

    public void importDependencies(Seq<String> dependencies, Runnable done) {
        this.getModList((Cons<Seq<ModListing>>)((Cons)listings -> {
            listings.each(l -> dependencies.contains((Object)l.internalName), l -> {
                dependencies.remove((Object)l.internalName);
                this.githubImportMod(l.repo, l.hasJava);
            });
            done.run();
        }));
    }

    private void githubImportJavaMod(String repo, @Nullable String release) {
        Http.get("https://api.github.com/repos/" + repo + "/releases/" + (release == null ? "latest" : release), (ConsT<Http.HttpResponse, Exception>)((ConsT)res -> {
            Jval asset;
            Jval json = Jval.read((String)res.getResultAsString());
            Jval.JsonArray assets = json.get("assets").asArray();
            Jval dexedAsset = (Jval)assets.find(j -> j.getString("name").startsWith("dexed") && j.getString("name").endsWith(".jar"));
            Jval jval = asset = dexedAsset == null ? (Jval)assets.find(j -> j.getString("name").endsWith(".jar")) : dexedAsset;
            if (asset == null) {
                throw new ArcRuntimeException("No JAR file found in releases. Make sure you have a valid jar file in the mod's latest Github Release.");
            }
            String url = asset.getString("browser_download_url");
            Http.get(url, (ConsT<Http.HttpResponse, Exception>)((ConsT)result -> this.handleMod(repo, (Http.HttpResponse)result)), (Cons<Throwable>)((Cons)this::importFail));
        }), (Cons<Throwable>)((Cons)this::importFail));
    }

    private void githubImportBranch(String branch, String repo, @Nullable String release) {
        if (release != null) {
            Http.get("https://api.github.com/repos/" + repo + "/releases/" + release, (ConsT<Http.HttpResponse, Exception>)((ConsT)res -> {
                String zipUrl = Jval.read((String)res.getResultAsString()).getString("zipball_url");
                Http.get(zipUrl, (ConsT<Http.HttpResponse, Exception>)((ConsT)loc -> {
                    if (loc.getHeader("Location") != null) {
                        Http.get(loc.getHeader("Location"), (ConsT<Http.HttpResponse, Exception>)((ConsT)result -> this.handleMod(repo, (Http.HttpResponse)result)), (Cons<Throwable>)((Cons)this::importFail));
                    } else {
                        this.handleMod(repo, (Http.HttpResponse)loc);
                    }
                }), (Cons<Throwable>)((Cons)this::importFail));
            }));
        } else {
            Http.get("https://api.github.com/repos/" + repo + "/zipball/" + branch, (ConsT<Http.HttpResponse, Exception>)((ConsT)loc -> {
                if (loc.getHeader("Location") != null) {
                    Http.get(loc.getHeader("Location"), (ConsT<Http.HttpResponse, Exception>)((ConsT)result -> this.handleMod(repo, (Http.HttpResponse)result)), (Cons<Throwable>)((Cons)this::importFail));
                } else {
                    this.handleMod(repo, (Http.HttpResponse)loc);
                }
            }), (Cons<Throwable>)((Cons)this::importFail));
        }
    }
}

