/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.utils.Elem;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import java.util.regex.Pattern;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.Planet;
import mindustry.type.Publishable;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.StatUnit;
import mindustryX.VarsX;
import mindustryX.features.PicToMindustry;
import mindustryX.features.UIExt;
import mindustryX.features.ui.ArcMessageDialog;

public class SchematicsDialog
extends BaseDialog {
    private static final float tagh = 42.0f;
    private SchematicInfoDialog info = new SchematicInfoDialog();
    private Schematic firstSchematic;
    private String search = "";
    private TextField searchField;
    private Runnable rebuildPane = () -> {};
    private Runnable rebuildTags = () -> {};
    private Pattern ignoreSymbols = Pattern.compile("[`~!@#$%^&*()\\-_=+{}|;:'\",<.>/?]");
    private Seq<String> tags;
    private Seq<String> selectedTags = new Seq();
    private boolean checkedTags;
    private Planet selectedPlanet;
    private boolean fromShare = false;

    public SchematicsDialog() {
        super("@schematics");
        Core.assets.load((String)"sprites/schematic-background.png", Texture.class).loaded = t -> t.setWrap(Texture.TextureWrap.repeat);
        this.tags = (Seq)Core.settings.getJson("schematic-tags", Seq.class, String.class, Seq::new);
        this.shouldPause = true;
        this.addCloseButton();
        this.buttons.button("@schematic.import", (Drawable)Icon.download, this::showImport);
        if (Vars.mobile) {
            this.buttons.row();
        }
        this.buttons.button("\u84dd\u56fe\u6863\u6848\u9986", (Drawable)Icon.link, () -> UIExt.openURI("https://docs.qq.com/sheet/DVHNoS3lIcm1NbFFS"));
        this.buttons.button("\u56fe\u7247\u8f6c\u6362\u5668" + Blocks.canvas.emoji() + Blocks.logicDisplay.emoji() + Blocks.sorter.emoji(), (Drawable)Icon.image, PicToMindustry::show);
        this.makeButtonOverlay();
        this.shown(this::setup);
        this.onResize(this::setup);
    }

    void setup() {
        if (!this.checkedTags) {
            this.checkTags();
            this.checkedTags = true;
        }
        this.search = "";
        this.cont.top();
        this.cont.clear();
        this.cont.table(s -> {
            s.left();
            s.image((Drawable)Icon.zoom);
            this.searchField = (TextField)s.field(this.search, res -> {
                this.search = res;
                this.rebuildPane.run();
            }).growX().get();
            this.searchField.setMessageText("@schematic.search");
            this.searchField.clicked(KeyCode.mouseRight, () -> {
                if (!this.search.isEmpty()) {
                    this.search = "";
                    this.searchField.clearText();
                    this.rebuildPane.run();
                }
            });
        }).fillX().padBottom(4.0f);
        this.cont.row();
        this.cont.table(in -> {
            in.left();
            in.add((CharSequence)"@schematic.tags").padRight(4.0f);
            in.pane(Styles.noBarPane, t -> {
                this.rebuildTags = () -> {
                    t.clearChildren();
                    t.left();
                    t.defaults().pad(2.0f).height(42.0f);
                    for (String tag : this.tags) {
                        t.button(tag, Styles.togglet, () -> {
                            if (this.selectedTags.contains((Object)tag)) {
                                this.selectedTags.remove((Object)tag);
                            } else {
                                this.selectedTags.add((Object)tag);
                            }
                            this.rebuildPane.run();
                        }).checked(this.selectedTags.contains((Object)tag)).with(c -> c.getLabel().setWrap(false));
                    }
                };
                this.rebuildTags.run();
            }).fillX().height(42.0f).scrollY(false);
            in.button((Drawable)Icon.pencilSmall, this::showAllTags).size(42.0f).pad(2.0f).tooltip("@schematic.edittags");
        }).height(42.0f).fillX();
        this.cont.row().table(in -> {
            in.left();
            in.add((CharSequence)"\u79d1\u6280\u6811\uff1a").padRight(4.0f);
            for (Planet tag : Vars.content.planets().select(it -> it.alwaysUnlocked)) {
                ((TextButton)in.button(tag.localizedName, Styles.togglet, () -> {
                    this.selectedPlanet = this.selectedPlanet == tag ? null : tag;
                    this.rebuildPane.run();
                }).checked(t -> this.selectedPlanet == tag).get()).getLabel().setWrap(false);
            }
            in.add((CharSequence)"\u8f85\u52a9\u7b5b\u9009\uff1a").padLeft(20.0f).padRight(4.0f);
            in.button(Items.copper.emoji(), Styles.togglet, () -> {
                Core.settings.put("arcSchematicCanBuild", (Object)(!Core.settings.getBool("arcSchematicCanBuild") ? 1 : 0));
                this.rebuildPane.run();
            }).size(42.0f).pad(2.0f).tooltip("\u53ef\u5efa\u9020(\u6838\u5fc3\u6709\u6b64\u7c7b\u8d44\u6e90+\u5730\u56fe\u672a\u7981\u7528)").checked(t -> Core.settings.getBool("arcSchematicCanBuild"));
            in.add((CharSequence)"\u84dd\u56fe\u5305\u542b\uff1a").padLeft(20.0f).padRight(4.0f);
            in.button(Vars.control.input.block == null ? "[red]\ue815" : Vars.control.input.block.emoji(), Styles.togglet, () -> {
                if (Vars.control.input.block == null) {
                    return;
                }
                VarsX.autoSelectSchematic.toggle();
                this.rebuildPane.run();
            }).size(42.0f).pad(2.0f).tooltip("\u84dd\u56fe\u9700\u5305\u542b\u6b64\u5efa\u7b51").checked(t -> Vars.control.input.block != null && (Boolean)VarsX.autoSelectSchematic.get() != false);
        }).height(42.0f).fillX();
        this.cont.row();
        this.cont.pane(t -> {
            t.top();
            t.update(() -> {
                if (Core.input.keyTap(Binding.chat) && Core.scene.getKeyboardFocus() == this.searchField && this.firstSchematic != null) {
                    if (!Vars.state.rules.schematicsAllowed) {
                        Vars.ui.showInfo("@schematic.disabled");
                    } else {
                        Vars.control.input.useSchematic(this.firstSchematic);
                        this.hide();
                    }
                }
            });
            this.rebuildPane = () -> {
                int cols = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl((float)230.0f)), 1);
                t.clear();
                int i = 0;
                String searchString = this.ignoreSymbols.matcher(this.search.toLowerCase()).replaceAll("");
                this.firstSchematic = null;
                for (Schematic s : Vars.schematics.all()) {
                    if (this.selectedTags.any() && !s.labels.containsAll(this.selectedTags) || !this.search.isEmpty() && !this.ignoreSymbols.matcher(s.name().toLowerCase()).replaceAll("").contains(searchString) || this.selectedPlanet != null && !s.tiles.allMatch(it -> it.block.isOnPlanet(this.selectedPlanet)) || ((Boolean)VarsX.autoSelectSchematic.get()).booleanValue() && Vars.control.input.block != null && !s.containsBlock(Vars.control.input.block) || Core.settings.getBool("arcSchematicCanBuild") && !this.arcSchematicCanBuild(s)) continue;
                    if (this.firstSchematic == null) {
                        this.firstSchematic = s;
                    }
                    Button[] sel = new Button[]{null};
                    sel[0] = (Button)t.button(b -> {
                        b.top();
                        b.margin(0.0f);
                        b.table(buttons -> {
                            buttons.left();
                            buttons.defaults().size(50.0f);
                            ImageButton.ImageButtonStyle style = Styles.emptyi;
                            buttons.button((Drawable)Icon.info, style, () -> this.showInfo(s)).tooltip("@info.title");
                            buttons.button((Drawable)Icon.upload, style, () -> this.showExport(s)).tooltip("@editor.export");
                            buttons.button((Drawable)Icon.pencil, style, () -> this.showEdit(s)).tooltip("@schematic.edit");
                            if (s.hasSteamID()) {
                                buttons.button((Drawable)Icon.link, style, () -> Vars.platform.viewListing((Publishable)s)).tooltip("@view.workshop");
                            } else {
                                buttons.button((Drawable)Icon.trash, style, () -> {
                                    if (s.mod != null) {
                                        Vars.ui.showInfo(Core.bundle.format("mod.item.remove", new Object[]{s.mod.meta.displayName}));
                                    } else {
                                        Vars.ui.showConfirm("@confirm", "@schematic.delete.confirm", () -> {
                                            Vars.schematics.remove(s);
                                            this.rebuildPane.run();
                                        });
                                    }
                                }).tooltip("@save.delete");
                            }
                        }).growX().height(50.0f);
                        b.row();
                        b.stack(new Element[]{new SchematicImage(s).setScaling(Scaling.fit), new Table(n -> {
                            n.top();
                            n.table(Styles.black3, c -> {
                                Label label = (Label)c.add((CharSequence)s.name()).style((Style)Styles.outlineLabel).color(Color.white).top().growX().maxWidth(192.0f).get();
                                label.setEllipsis(true);
                                label.setAlignment(1);
                            }).growX().margin(1.0f).pad(4.0f).maxWidth(Scl.scl((float)192.0f)).padBottom(0.0f);
                        })}).size(200.0f);
                    }, () -> {
                        if (sel[0].childrenPressed()) {
                            return;
                        }
                        if (Vars.state.isMenu()) {
                            this.showInfo(s);
                        } else if (!Vars.state.rules.schematicsAllowed) {
                            Vars.ui.showInfo("@schematic.disabled");
                        } else {
                            Vars.control.input.useSchematic(s);
                            this.hide();
                        }
                    }).pad(4.0f).style((Style)Styles.flati).get();
                    sel[0].getStyle().up = Tex.pane;
                    if (++i % cols != 0) continue;
                    t.row();
                }
                if (this.firstSchematic == null) {
                    if (!searchString.isEmpty() || this.selectedTags.any()) {
                        t.add((CharSequence)"@none.found");
                    } else {
                        t.add((CharSequence)"@none").color(Color.lightGray);
                    }
                }
            };
            this.rebuildPane.run();
        }).grow().scrollX(false);
        if (((Boolean)VarsX.autoSelectSchematic.get()).booleanValue() && Vars.control.input.block != null) {
            String text = "[orange]\u84dd\u56fe\u7b5b\u9009\u6a21\u5f0f[white]:\u84dd\u56fe\u5fc5\u987b\u5305\u542b " + Vars.control.input.block.emoji();
            UIExt.announce(text, 5.0f);
        }
    }

    public void showInfo(Schematic schematic) {
        this.info.show(schematic);
    }

    public void showImport() {
        BaseDialog dialog = new BaseDialog("@editor.import");
        dialog.cont.pane(p -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.flatt;
                t.defaults().size(280.0f, 60.0f).left();
                t.row();
                t.button("@schematic.copy.import", (Drawable)Icon.copy, style, () -> {
                    dialog.hide();
                    try {
                        Schematic s = Schematics.readBase64(Core.app.getClipboardText());
                        s.removeSteamID();
                        Vars.schematics.add(s);
                        this.setup();
                        Vars.ui.showInfoFade("@schematic.saved");
                        this.checkTags(s);
                        this.showInfo(s);
                    }
                    catch (Throwable e) {
                        Vars.ui.showException(e);
                    }
                }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null || !Core.app.getClipboardText().startsWith("bXNjaA"));
                t.row();
                t.button("@schematic.importfile", (Drawable)Icon.download, style, () -> Vars.platform.showFileChooser(true, "msch", file -> {
                    dialog.hide();
                    try {
                        Schematic s = Schematics.read(file);
                        s.removeSteamID();
                        Vars.schematics.add(s);
                        this.setup();
                        this.showInfo(s);
                        this.checkTags(s);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                })).marginLeft(12.0f);
                t.row();
                if (Vars.steam) {
                    t.button("@schematic.browseworkshop", (Drawable)Icon.book, style, () -> {
                        dialog.hide();
                        Vars.platform.openWorkshop();
                    }).marginLeft(12.0f);
                }
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    public void showExport(Schematic s) {
        BaseDialog dialog = new BaseDialog("@editor.export");
        dialog.cont.pane(p -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.flatt;
                t.defaults().size(280.0f, 60.0f).left();
                if (Vars.steam && !s.hasSteamID()) {
                    t.button("@schematic.shareworkshop", (Drawable)Icon.book, style, () -> Vars.platform.publish((Publishable)s)).marginLeft(12.0f);
                    t.row();
                    dialog.hide();
                }
                t.button("@schematic.copy", (Drawable)Icon.copy, style, () -> {
                    dialog.hide();
                    Vars.ui.showInfoFade("@copied");
                    Core.app.setClipboardText(Vars.schematics.writeBase64(s));
                }).marginLeft(12.0f);
                t.row();
                t.button("@schematic.exportfile", (Drawable)Icon.export, style, () -> {
                    dialog.hide();
                    Vars.platform.export(s.name(), "msch", file -> Schematics.write(s, file));
                }).marginLeft(12.0f).row();
                t.button("\u5206\u4eab\u84dd\u56fe", (Drawable)Icon.chat, style, () -> {
                    dialog.hide();
                    ArcMessageDialog.uploadPasteBin(Vars.schematics.writeBase64(s), (Cons<String>)((Cons)code -> {
                        if (code == null) {
                            return;
                        }
                        ArcMessageDialog.share("[blue]<Schem>[]", " " + code.substring(code.lastIndexOf(47) + 1));
                    }));
                }).marginLeft(12.0f).row();
                t.button("\u590d\u5236\u5230\u526a\u5207\u677f(\u9ad8\u7ea7\u7248\uff0c\u542b\u4ecb\u7ecd)", (Drawable)Icon.star, style, () -> {
                    dialog.hide();
                    ArcMessageDialog.uploadPasteBin(Vars.schematics.writeBase64(s), (Cons<String>)((Cons)code -> {
                        if (code == null) {
                            code = "x";
                        }
                        this.arcSendClipBroadMsg(s, (String)code);
                    }));
                }).marginLeft(12.0f);
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    private void arcSendClipBroadMsg(Schematic schem, String link) {
        StringBuilder s = new StringBuilder();
        s.append("\u8fd9\u662f\u4e00\u6761\u6765\u81ea MDTX-").append(VarsX.version).append("\u7684\u5206\u4eab\u8bb0\u5f55\n");
        s.append("\u84dd\u56fe\u540d\uff1a").append(schem.name()).append("\n");
        s.append("\u5206\u4eab\u8005\uff1a").append(Vars.player.name).append("\n");
        s.append("\u84dd\u56fe\u9020\u4ef7\uff1a");
        ItemSeq arr = schem.requirements();
        for (ItemStack stack : arr) {
            s.append(stack.item.emoji()).append(stack.item.localizedName).append(stack.amount).append("|");
        }
        s.append("\n");
        s.append("\u7535\u529b\uff1a");
        float cons = schem.powerConsumption() * 60.0f;
        float prod = schem.powerProduction() * 60.0f;
        if (!Mathf.zero((float)prod)) {
            s.append("+").append(Strings.autoFixed((float)prod, (int)2));
            if (!Mathf.zero((float)cons)) {
                s.append("|");
            }
        }
        if (!Mathf.zero((float)cons)) {
            s.append("-").append(Strings.autoFixed((float)cons, (int)2));
        }
        s.append("\n");
        s.append("\u84dd\u56fe\u4ee3\u7801\u94fe\u63a5\uff1a").append(link).append("\n");
        if (Vars.schematics.writeBase64(schem).length() > 3500) {
            s.append("\u84dd\u56fe\u4ee3\u7801\u8fc7\u957f\uff0c\u8bf7\u70b9\u51fb\u94fe\u63a5\u67e5\u770b");
        } else {
            s.append("\u84dd\u56fe\u4ee3\u7801\uff1a\n").append(Vars.schematics.writeBase64(schem));
        }
        Core.app.setClipboardText(Strings.stripColors((CharSequence)s.toString()));
        UIExt.announce("\u5df2\u4fdd\u5b58\u81f3\u526a\u8d34\u677f");
    }

    public void readShare(String base64, @Nullable Player sender) {
        try {
            Schematic s = Schematics.readBase64(base64);
            s.removeSteamID();
            s.tags.put((Object)"name", (Object)(sender == null ? "\u6765\u81ea\u670d\u52a1\u5668\u7684\u84dd\u56fe" : "\u6765\u81ea" + sender.plainName() + "\u7684\u84dd\u56fe"));
            this.fromShare = true;
            this.showInfo(s);
        }
        catch (Throwable e) {
            Vars.ui.showException(e);
        }
    }

    public void showEdit(final Schematic s) {
        new BaseDialog("@schematic.edit"){
            {
                super(title);
                this.setFillParent(true);
                this.addCloseListener();
                this.cont.margin(30.0f);
                this.cont.add((CharSequence)"@schematic.tags").padRight(6.0f);
                this.cont.table(tags -> SchematicsDialog.this.buildTags(s, (Table)tags, false)).maxWidth(400.0f).fillX().left().row();
                this.cont.margin(30.0f).add((CharSequence)"@name").padRight(6.0f);
                TextField nameField = (TextField)this.cont.field(s.name(), null).size(400.0f, 55.0f).left().get();
                this.cont.row();
                this.cont.margin(30.0f).add((CharSequence)"@editor.description").padRight(6.0f);
                TextField descField = (TextField)this.cont.area(s.description(), Styles.areaField, t -> {}).size(400.0f, 140.0f).left().get();
                Runnable accept = () -> {
                    s2.tags.put((Object)"name", (Object)nameField.getText());
                    s2.tags.put((Object)"description", (Object)descField.getText());
                    s.save();
                    this.hide();
                    SchematicsDialog.this.rebuildPane.run();
                };
                this.buttons.defaults().size(210.0f, 64.0f).pad(4.0f);
                this.buttons.button("@ok", (Drawable)Icon.ok, accept).disabled(b -> nameField.getText().isEmpty());
                this.buttons.button("@cancel", (Drawable)Icon.cancel, () -> (this).hide());
                this.keyDown(KeyCode.enter, () -> {
                    if (!nameField.getText().isEmpty() && Core.scene.getKeyboardFocus() != descField) {
                        accept.run();
                    }
                });
            }
        }.show();
    }

    void checkTags() {
        ObjectSet encountered = new ObjectSet();
        encountered.addAll(this.tags);
        for (Schematic s : Vars.schematics.all()) {
            for (String tag : s.labels) {
                if (!encountered.add((Object)tag)) continue;
                this.tags.add((Object)tag);
            }
        }
    }

    void checkTags(Schematic s) {
        boolean any = false;
        for (String tag : s.labels) {
            if (this.tags.contains((Object)tag)) continue;
            this.tags.add((Object)tag);
            any = true;
        }
        if (any) {
            this.rebuildTags.run();
        }
    }

    void tagsChanged() {
        this.rebuildTags.run();
        if (this.selectedTags.any()) {
            this.rebuildPane.run();
        }
        Core.settings.putJson("schematic-tags", String.class, this.tags);
    }

    void addTag(Schematic s, String tag) {
        s.labels.remove(it -> it.equals(tag));
        s.labels.add((Object)tag);
        s.save();
        this.tagsChanged();
    }

    void removeTag(Schematic s, String tag) {
        s.labels.remove((Object)tag);
        s.save();
        this.tagsChanged();
    }

    void showNewTag(Cons<String> result) {
        Vars.ui.showTextInput("@schematic.addtag", "", "", (Cons<String>)((Cons)out -> {
            if (this.tags.contains(out)) {
                Vars.ui.showInfo("@schematic.tagexists");
            } else {
                this.tags.add(out);
                this.tagsChanged();
                result.get(out);
            }
        }));
    }

    void showNewIconTag(final Cons<String> cons) {
        new Dialog(){
            {
                this.closeOnBack();
                this.setFillParent(true);
                this.cont.pane(t -> this.resized(true, () -> {
                    t.clearChildren();
                    t.marginRight(19.0f).marginLeft(12.0f);
                    t.defaults().size(48.0f);
                    int cols = (int)Math.min(20.0f, (float)Core.graphics.getWidth() / Scl.scl((float)52.0f));
                    int i = 0;
                    for (String string : Vars.accessibleIcons) {
                        String out = (char)Iconc.codes.get((Object)string) + "";
                        if (SchematicsDialog.this.tags.contains((Object)out)) continue;
                        t.button((Drawable)Icon.icons.get((Object)string), Styles.flati, 32.0f, () -> {
                            SchematicsDialog.this.tags.add((Object)out);
                            SchematicsDialog.this.tagsChanged();
                            cons.get((Object)out);
                            this.hide();
                        });
                        if (++i % cols != 0) continue;
                        t.row();
                    }
                    for (String string : Vars.defaultContentIcons) {
                        Seq all = Vars.content.getBy((ContentType)string).as().select(u -> !u.isHidden() && u.unlockedNow() && u.hasEmoji());
                        t.row();
                        if (all.count(u -> !SchematicsDialog.this.tags.contains((Object)u.emoji())) > 0) {
                            t.image().colspan(cols).growX().width(Float.NEGATIVE_INFINITY).height(3.0f).color(Pal.accent);
                        }
                        t.row();
                        i = 0;
                        for (UnlockableContent u2 : all) {
                            if (SchematicsDialog.this.tags.contains((Object)u2.emoji())) continue;
                            t.button((Drawable)new TextureRegionDrawable(u2.uiIcon), Styles.flati, 32.0f, () -> {
                                String out = u2.emoji() + "";
                                SchematicsDialog.this.tags.add((Object)out);
                                SchematicsDialog.this.tagsChanged();
                                cons.get((Object)out);
                                this.hide();
                            }).tooltip(u2.localizedName);
                            if (++i % cols != 0) continue;
                            t.row();
                        }
                    }
                })).scrollX(false);
                this.buttons.button("@back", (Drawable)Icon.left, () -> (this).hide()).size(210.0f, 64.0f);
            }
        }.show();
    }

    void showAllTags() {
        BaseDialog dialog = new BaseDialog("@schematic.edittags");
        dialog.addCloseButton();
        Runnable[] rebuild2 = new Runnable[]{null};
        dialog.cont.pane(p -> {
            rebuild2[0] = () -> {
                p.clearChildren();
                p.margin(12.0f).defaults().fillX().left();
                float sum = 0.0f;
                Table current = new Table().left();
                for (String tag : this.tags) {
                    float si = 40.0f;
                    Table next = new Table(Tex.whiteui, n -> {
                        n.setColor(Pal.gray);
                        n.margin(5.0f);
                        n.table(move -> {
                            move.button((Drawable)Icon.upOpen, Styles.emptyi, () -> {
                                int idx = this.tags.indexOf((Object)tag);
                                if (idx > 0) {
                                    this.tags.swap(idx, idx - 1);
                                    this.tagsChanged();
                                    rebuild2[0].run();
                                }
                            }).size(si).tooltip("@editor.moveup").row();
                            move.button((Drawable)Icon.downOpen, Styles.emptyi, () -> {
                                int idx = this.tags.indexOf((Object)tag);
                                if (idx < this.tags.size - 1) {
                                    this.tags.swap(idx, idx + 1);
                                    this.tagsChanged();
                                    rebuild2[0].run();
                                }
                            }).size(si).tooltip("@editor.movedown");
                        }).fillY();
                        n.table(t -> {
                            t.add((CharSequence)tag).left().row();
                            ((Label)t.add((CharSequence)Core.bundle.format("schematic.tagged", new Object[]{Vars.schematics.all().count(s -> s.labels.contains((Object)tag))})).left().update(b -> b.setColor(b.hasMouse() ? Pal.accent : Color.lightGray)).get()).clicked(() -> {
                                dialog.hide();
                                this.selectedTags.clear().add((Object)tag);
                                this.rebuildTags.run();
                                this.rebuildPane.run();
                            });
                        }).growX().fillY();
                        n.table(b -> {
                            b.margin(2.0f);
                            b.button((Drawable)Icon.pencil, Styles.emptyi, () -> Vars.ui.showTextInput("@schematic.renametag", "@name", tag, (Cons<String>)((Cons)result -> {
                                if (result.equals(tag)) {
                                    return;
                                }
                                if (this.tags.contains(result)) {
                                    Vars.ui.showInfo("@schematic.tagexists");
                                } else {
                                    for (Schematic s : Vars.schematics.all()) {
                                        if (!s.labels.any()) continue;
                                        s.labels.replace((Object)tag, result);
                                        s.save();
                                    }
                                    this.selectedTags.replace((Object)tag, result);
                                    this.tags.replace((Object)tag, result);
                                    this.tagsChanged();
                                    rebuild2[0].run();
                                }
                            }))).size(si).tooltip("@schematic.renametag").row();
                            b.button((Drawable)Icon.trash, Styles.emptyi, () -> Vars.ui.showConfirm("@schematic.tagdelconfirm", () -> {
                                for (Schematic s : Vars.schematics.all()) {
                                    if (!s.labels.any()) continue;
                                    s.labels.remove((Object)tag);
                                    s.save();
                                }
                                this.selectedTags.remove((Object)tag);
                                this.tags.remove((Object)tag);
                                this.tagsChanged();
                                this.rebuildPane.run();
                                rebuild2[0].run();
                            })).size(si).tooltip("@save.delete");
                        }).fillY();
                    });
                    next.pack();
                    float w = next.getWidth() + Scl.scl((float)9.0f);
                    if (w * 2.0f + sum >= (float)Core.graphics.getWidth() * 0.9f) {
                        p.add((Element)current).row();
                        current = new Table();
                        current.left();
                        sum = 0.0f;
                    }
                    current.add((Element)next).minWidth(210.0f).pad(4.0f);
                    sum += w;
                }
                if (sum > 0.0f) {
                    p.add((Element)current).row();
                }
                p.table(t -> {
                    t.left().defaults().fillX().height(42.0f).pad(2.0f);
                    ((TextButton)t.button("@schematic.texttag", (Drawable)Icon.add, () -> this.showNewTag((Cons<String>)((Cons)res -> rebuild2[0].run()))).wrapLabel(false).get()).getLabelCell().padLeft(5.0f);
                    ((TextButton)t.button("@schematic.icontag", (Drawable)Icon.add, () -> this.showNewIconTag((Cons<String>)((Cons)res -> rebuild2[0].run()))).wrapLabel(false).get()).getLabelCell().padLeft(5.0f);
                });
                p.row();
                p.table(t -> {
                    t.left().defaults().fillX().height(42.0f).pad(2.0f);
                    ((TextButton)t.button("\u81ea\u52a8\u6807\u7b7e", (Drawable)Icon.add, () -> this.arcAutoTags(rebuild2[0])).wrapLabel(false).get()).getLabelCell().padLeft(5.0f);
                });
            };
            this.resized(true, rebuild2[0]);
        }).scrollX(false);
        dialog.show();
    }

    void arcAutoTags(final Runnable done) {
        new Dialog(){
            {
                this.closeOnBack();
                this.setFillParent(true);
                Table t = new Table();
                this.cont.pane((Element)t);
                this.resized(true, () -> {
                    t.clearChildren();
                    t.marginRight(19.0f);
                    t.defaults().size(48.0f);
                    int cols = (int)Math.min(20.0f, (float)Core.graphics.getWidth() / Scl.scl((float)52.0f));
                    for (ContentType ctype : Vars.defaultContentIcons) {
                        t.row();
                        t.image().colspan(cols).growX().width(Float.NEGATIVE_INFINITY).height(3.0f).color(Pal.accent);
                        t.row();
                        int i = 0;
                        for (UnlockableContent u : Vars.content.getBy(ctype).as()) {
                            if (u.isHidden() || !u.unlockedNow() || !u.hasEmoji() || SchematicsDialog.this.tags.contains((Object)u.emoji())) continue;
                            t.button((Drawable)new TextureRegionDrawable(u.uiIcon), Styles.flati, 32.0f, () -> {
                                String out = u.emoji();
                                SchematicsDialog.this.tags.add((Object)out);
                                SchematicsDialog.this.arcAutoTag(u, out);
                                done.run();
                                this.hide();
                            });
                            if (++i % cols != 0) continue;
                            t.row();
                        }
                    }
                });
                this.buttons.button("@back", (Drawable)Icon.left, () -> (this).hide()).size(210.0f, 64.0f);
            }
        }.show();
    }

    void arcAutoTag(UnlockableContent u, String tag) {
        block8: {
            block9: {
                block7: {
                    if (!(u instanceof Block)) break block7;
                    Block block = (Block)u;
                    for (Schematic s : Vars.schematics.all()) {
                        s.tiles.each(sBlock -> {
                            if (sBlock.block == block) {
                                this.addTag(s, tag);
                            }
                        });
                    }
                    break block8;
                }
                if (!(u instanceof Item)) break block9;
                Item item = (Item)u;
                Seq blocklist = new Seq();
                for (Block factory : Vars.content.blocks()) {
                    if (!(factory instanceof GenericCrafter)) continue;
                    GenericCrafter crafter = (GenericCrafter)factory;
                    if (crafter.outputItems == null) continue;
                    for (ItemStack stack : crafter.outputItems) {
                        if (stack.item != item) continue;
                        blocklist.add((Object)factory);
                    }
                }
                for (Schematic s : Vars.schematics.all()) {
                    s.tiles.each(sBlock -> {
                        if (blocklist.contains((Object)sBlock.block)) {
                            this.addTag(s, tag);
                        }
                    });
                }
                break block8;
            }
            if (!(u instanceof Liquid)) break block8;
            Liquid liquid = (Liquid)u;
            Seq blocklist = new Seq();
            for (Block factory : Vars.content.blocks()) {
                if (!(factory instanceof GenericCrafter)) continue;
                GenericCrafter crafter = (GenericCrafter)factory;
                if (crafter.outputLiquids == null) continue;
                for (LiquidStack stack : crafter.outputLiquids) {
                    if (stack.liquid != liquid) continue;
                    blocklist.add((Object)factory);
                }
            }
            for (Schematic s : Vars.schematics.all()) {
                s.tiles.each(sBlock -> {
                    if (blocklist.contains((Object)sBlock.block)) {
                        this.addTag(s, tag);
                    }
                });
            }
        }
    }

    boolean arcSchematicCanBuild(Schematic s) {
        for (ItemStack item : s.requirements()) {
            if (UIExt.coreItems.hadItem(item.item)) continue;
            return false;
        }
        for (Schematic.Stile tile : s.tiles) {
            Block block = tile.block;
            if (!block.isPlaceable()) {
                return false;
            }
            if (!Vars.state.rules.bannedBlocks.contains((Object)block)) continue;
            return false;
        }
        return true;
    }

    void buildTags(Schematic schem, Table t) {
        this.buildTags(schem, t, true);
    }

    void buildTags(Schematic schem, Table t, boolean name) {
        t.clearChildren();
        t.left();
        schem.labels.sort(s -> this.tags.indexOf(s));
        if (name) {
            t.add((CharSequence)"@schematic.tags").padRight(4.0f);
        }
        t.pane(s -> {
            s.left();
            s.defaults().pad(3.0f).height(42.0f);
            for (String tag : schem.labels) {
                s.table(Tex.button, i -> {
                    i.add((CharSequence)tag).padRight(4.0f).height(42.0f).labelAlign(1);
                    i.button((Drawable)Icon.cancelSmall, Styles.emptyi, () -> {
                        this.removeTag(schem, tag);
                        this.buildTags(schem, t, name);
                    }).size(42.0f).padRight(-9.0f).padLeft(-9.0f);
                });
            }
        }).fillX().left().height(42.0f).scrollY(false);
        t.button((Drawable)Icon.addSmall, () -> {
            BaseDialog dialog = new BaseDialog("@schematic.addtag");
            dialog.addCloseButton();
            dialog.cont.pane(p -> this.resized(true, () -> {
                p.clearChildren();
                p.defaults().fillX().left();
                float sum = 0.0f;
                Table current = new Table().left();
                for (String tag : this.tags) {
                    if (schem.labels.contains((Object)tag)) continue;
                    TextButton next = Elem.newButton((String)tag, () -> {
                        this.addTag(schem, tag);
                        this.buildTags(schem, t, name);
                        dialog.hide();
                    });
                    next.getLabel().setWrap(false);
                    next.pack();
                    float w = next.getPrefWidth() + Scl.scl((float)6.0f);
                    float f = Core.graphics.getWidth();
                    float f2 = Core.graphics.isPortrait() ? 1.0f : 0.8f;
                    if (w + sum >= f * f2) {
                        p.add((Element)current).row();
                        current = new Table();
                        current.left();
                        current.add((Element)next).height(42.0f).pad(2.0f);
                        sum = 0.0f;
                    } else {
                        current.add((Element)next).height(42.0f).pad(2.0f);
                    }
                    sum += w;
                }
                if (sum > 0.0f) {
                    p.add((Element)current).row();
                }
                Cons handleTag = res -> {
                    dialog.hide();
                    this.addTag(schem, (String)res);
                    this.buildTags(schem, t, name);
                };
                p.row();
                p.table(v -> {
                    v.left().defaults().fillX().height(42.0f).pad(2.0f);
                    ((TextButton)v.button("@schematic.texttag", (Drawable)Icon.add, () -> this.showNewTag((Cons<String>)handleTag)).wrapLabel(false).get()).getLabelCell().padLeft(4.0f);
                    ((TextButton)v.button("@schematic.icontag", (Drawable)Icon.add, () -> this.showNewIconTag((Cons<String>)handleTag)).wrapLabel(false).get()).getLabelCell().padLeft(4.0f);
                });
            }));
            dialog.show();
        }).size(42.0f).tooltip("@schematic.addtag");
    }

    public Dialog show() {
        super.show();
        if (Core.app.isDesktop() && this.searchField != null) {
            Core.scene.setKeyboardFocus((Element)this.searchField);
        }
        return this;
    }

    public class SchematicInfoDialog
    extends BaseDialog {
        SchematicInfoDialog() {
            super("");
            this.setFillParent(true);
            this.addCloseListener();
        }

        public void show(Schematic schem) {
            this.cont.clear();
            this.title.setText((CharSequence)("[[" + Core.bundle.get("schematic") + "] " + schem.name()));
            this.cont.add((CharSequence)Core.bundle.format("schematic.info", new Object[]{schem.width, schem.height, schem.tiles.size})).color(Color.lightGray).row();
            this.cont.table(tags -> SchematicsDialog.this.buildTags(schem, (Table)tags)).fillX().left().row();
            this.cont.add((Element)new SchematicImage(schem)).maxSize(800.0f).row();
            ItemSeq arr = schem.requirements();
            this.cont.table(r -> {
                int i = 0;
                for (ItemStack s : arr) {
                    r.image(s.item.uiIcon).left().size(32.0f);
                    r.label(() -> {
                        CoreBlock.CoreBuild core = Vars.player.core();
                        if (core == null || Vars.state.isMenu() || Vars.state.rules.infiniteResources || core.items.has(s.item, s.amount)) {
                            return "[lightgray]" + s.amount + "";
                        }
                        return (core.items.has(s.item, s.amount) ? "[lightgray]" : "[scarlet]") + Math.min(core.items.get(s.item), s.amount) + "[lightgray]/" + s.amount;
                    }).padLeft(2.0f).left().padRight(4.0f);
                    if (++i % 4 != 0) continue;
                    r.row();
                }
            });
            this.cont.row();
            if (schem.tiles.contains(stile -> stile.block instanceof LogicBlock)) {
                LogicBlock.LogicBuild tmpBuild = new LogicBlock.LogicBuild((LogicBlock)Blocks.logicProcessor);
                this.cont.table(t -> schem.tiles.each(stile -> {
                    Block patt39164$temp = stile.block;
                    if (patt39164$temp instanceof LogicBlock) {
                        LogicBlock logicBlock = (LogicBlock)patt39164$temp;
                        tmpBuild.readCompressed((byte[])stile.config, false);
                        String codeString = tmpBuild.code;
                        if (codeString.isEmpty()) {
                            return;
                        }
                        t.button(logicBlock.emoji(), Styles.cleart, () -> {
                            Core.app.setClipboardText(codeString);
                            UIExt.announce("\u5df2\u590d\u5236\u903b\u8f91\u4ee3\u7801");
                        }).tooltip(Strings.truncate((String)codeString, (int)500, (String)"\n...")).size(40.0f);
                        if (t.getChildren().size % 15 == 0) {
                            t.row();
                        }
                    }
                }));
                this.cont.row();
            }
            float cons = schem.powerConsumption() * 60.0f;
            float prod = schem.powerProduction() * 60.0f;
            if (!Mathf.zero((float)cons) || !Mathf.zero((float)prod)) {
                this.cont.table(t -> {
                    if (!Mathf.zero((float)prod)) {
                        t.image((Drawable)Icon.powerSmall).color(Pal.powerLight).padRight(3.0f);
                        t.add((CharSequence)("+" + Strings.autoFixed((float)prod, (int)2))).color(Pal.powerLight).left();
                        if (!Mathf.zero((float)cons)) {
                            t.add().width(15.0f);
                        }
                    }
                    if (!Mathf.zero((float)cons)) {
                        t.image((Drawable)Icon.powerSmall).color(Pal.remove).padRight(3.0f);
                        t.add((CharSequence)("-" + Strings.autoFixed((float)cons, (int)2))).color(Pal.remove).left();
                    }
                });
            }
            this.cont.row();
            schem.calProduction();
            this.cont.table(r -> {
                int i = 0;
                for (Item item : schem.items.keys()) {
                    r.image(item.uiIcon).left().size(32.0f);
                    r.label(() -> (schem.items.get((Object)item, 0.0f) > 0.0f ? "+" : "") + Strings.autoFixed((float)schem.items.get((Object)item, 0.0f), (int)2) + StatUnit.perSecond.localized()).padLeft(2.0f).left().padRight(5.0f).color(Color.lightGray);
                    if (++i % 4 != 0) continue;
                    r.row();
                }
                for (Liquid liquid : schem.liquids.keys()) {
                    r.image(liquid.uiIcon).left().size(32.0f);
                    r.label(() -> (schem.liquids.get((Object)liquid, 0.0f) > 0.0f ? "+" : "") + Strings.autoFixed((float)schem.liquids.get((Object)liquid, 0.0f), (int)2) + StatUnit.perSecond.localized()).padLeft(2.0f).left().padRight(5.0f).color(Color.lightGray);
                    if (++i % 4 != 0) continue;
                    r.row();
                }
            });
            this.buttons.clearChildren();
            this.buttons.defaults().size(Core.graphics.isPortrait() ? 150.0f : 210.0f, 64.0f);
            this.buttons.button("@back", (Drawable)Icon.left, () -> ((SchematicInfoDialog)this).hide());
            this.buttons.button("@editor.export", (Drawable)Icon.upload, () -> SchematicsDialog.this.showExport(schem));
            this.buttons.button("@edit", (Drawable)Icon.edit, () -> SchematicsDialog.this.showEdit(schem));
            if (SchematicsDialog.this.fromShare) {
                this.buttons.button("@save", (Drawable)Icon.save, () -> {
                    SchematicsDialog.this.fromShare = false;
                    Vars.schematics.add(schem);
                    SchematicsDialog.this.setup();
                    Vars.ui.showInfoFade("@schematic.saved");
                    SchematicsDialog.this.checkTags(schem);
                });
            }
            this.show();
        }
    }

    public static class SchematicImage
    extends Image {
        private static boolean setLock = false;
        public float scaling = 16.0f;
        public float thickness = 4.0f;
        public Color borderColor = Pal.gray;
        private Schematic schematic;
        private Texture lastTexture;
        boolean set;

        public SchematicImage(Schematic s) {
            super(Tex.clear);
            this.setScaling(Scaling.fit);
            this.schematic = s;
            if (Vars.schematics.hasPreview(s)) {
                this.setPreview();
                this.set = true;
            }
        }

        public void draw() {
            boolean checked = this.parent.parent instanceof Button && ((Button)this.parent.parent).isOver();
            boolean wasSet = this.set;
            if (!this.set && !setLock) {
                setLock = true;
                Core.app.post(this::setPreview);
                this.set = true;
            } else if (this.lastTexture != null && this.lastTexture.isDisposed()) {
                wasSet = false;
                this.set = false;
            }
            Texture background = (Texture)Core.assets.get("sprites/schematic-background.png", Texture.class);
            TextureRegion region = Draw.wrap((Texture)background);
            float xr = this.width / this.scaling;
            float yr = this.height / this.scaling;
            region.setU2(xr);
            region.setV2(yr);
            Draw.color();
            Draw.alpha((float)this.parentAlpha);
            Draw.rect((TextureRegion)region, (float)(this.x + this.width / 2.0f), (float)(this.y + this.height / 2.0f), (float)this.width, (float)this.height);
            if (wasSet) {
                super.draw();
            } else {
                Draw.rect((TextureRegion)Icon.refresh.getRegion(), (float)(this.x + this.width / 2.0f), (float)(this.y + this.height / 2.0f), (float)(this.width / 4.0f), (float)(this.height / 4.0f));
            }
            Draw.color((Color)(checked ? Pal.accent : this.borderColor));
            Draw.alpha((float)this.parentAlpha);
            Lines.stroke(Scl.scl((float)this.thickness));
            Lines.rect(this.x, this.y, this.width, this.height);
            Draw.reset();
        }

        private void setPreview() {
            setLock = false;
            this.lastTexture = Vars.schematics.getPreview(this.schematic);
            TextureRegionDrawable draw = new TextureRegionDrawable(new TextureRegion(this.lastTexture));
            this.setDrawable((Drawable)draw);
            this.setScaling(Scaling.fit);
        }
    }
}

