/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.Input;
import arc.func.Boolp;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.ui.Label;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.game.EventType;
import mindustry.gen.Call;
import mindustry.gen.Iconc;
import mindustry.input.Binding;
import mindustry.ui.Fonts;

public class ChatFragment
extends Table {
    private static final int messagesShown = 10;
    private Seq<String> messages = new Seq();
    private float fadetime;
    private boolean shown = false;
    private TextField chatfield;
    private Label fieldlabel = new Label((CharSequence)">");
    public ChatMode mode = ChatMode.normal;
    private Font font;
    private GlyphLayout layout = new GlyphLayout();
    private float offsetx = Scl.scl((float)4.0f);
    private float offsety = Scl.scl((float)4.0f);
    private float fontoffsetx = Scl.scl((float)2.0f);
    private float chatspace = Scl.scl((float)50.0f);
    private Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private float textspacing = Scl.scl((float)10.0f);
    private Seq<String> history = new Seq();
    private int historyPos = 0;
    private int scrollPos = 0;

    public ChatFragment() {
        this.setFillParent(true);
        this.font = Fonts.def;
        this.visible(() -> {
            if (!Vars.net.active() && this.messages.size > 0) {
                this.clearMessages();
                if (this.shown) {
                    this.hide();
                }
            }
            return Vars.net.active() && Vars.ui.hudfrag.shown;
        });
        this.update(() -> {
            if (Vars.net.active() && Core.input.keyTap(Binding.chat) && (Core.scene.getKeyboardFocus() == this.chatfield || Core.scene.getKeyboardFocus() == null || Vars.ui.minimapfrag.shown()) && !Vars.ui.consolefrag.shown()) {
                this.toggle();
            }
            if (this.shown) {
                if (Core.input.keyTap(Binding.chatHistoryPrev) && this.historyPos < this.history.size - 1) {
                    if (this.historyPos == 0) {
                        this.history.set(0, (Object)this.chatfield.getText());
                    }
                    ++this.historyPos;
                    this.updateChat();
                }
                if (Core.input.keyTap(Binding.chatHistoryNext) && this.historyPos > 0) {
                    --this.historyPos;
                    this.updateChat();
                }
                this.chatfield.setFocusTraversal(Binding.chatMode.value.key != KeyCode.tab);
                if (Core.input.keyTap(Binding.chatMode)) {
                    this.nextMode();
                }
                this.scrollPos = (int)Mathf.clamp((float)((float)this.scrollPos + Core.input.axis(Binding.chatScroll)), (float)0.0f, (float)Math.max(0, this.messages.size - 10));
            }
        });
        this.history.insert(0, (Object)"");
        this.setup();
    }

    public void build(Group parent) {
        Core.scene.add((Element)this);
    }

    public void clearMessages() {
        this.messages.clear();
        this.history.clear();
        this.history.insert(0, (Object)"");
    }

    private void setup() {
        this.fieldlabel.setStyle(new Label.LabelStyle(this.fieldlabel.getStyle()));
        this.fieldlabel.getStyle().font = this.font;
        this.fieldlabel.setStyle(this.fieldlabel.getStyle());
        this.chatfield = new TextField("", new TextField.TextFieldStyle((TextField.TextFieldStyle)Core.scene.getStyle(TextField.TextFieldStyle.class)));
        this.chatfield.setMaxLength(150);
        this.chatfield.getStyle().background = null;
        this.chatfield.getStyle().fontColor = Color.white;
        this.chatfield.setStyle(this.chatfield.getStyle());
        this.chatfield.typed(this::handleType);
        this.bottom().left().marginBottom(this.offsety).marginLeft(this.offsetx * 2.0f).add((Element)this.fieldlabel).padBottom(6.0f);
        this.add((Element)this.chatfield).padBottom(this.offsety).padLeft(this.offsetx).growX().padRight(this.offsetx).height(28.0f);
        if (Vars.mobile) {
            this.marginBottom(105.0f);
            this.marginRight(240.0f);
        }
    }

    private void handleType(char c) {
        int index;
        int cursor = this.chatfield.getCursorPosition();
        if (c == ':' && (index = this.chatfield.getText().lastIndexOf(58, cursor - 2)) >= 0 && index < cursor) {
            String text = this.chatfield.getText().substring(index + 1, cursor - 1);
            String uni = Fonts.getUnicodeStr(text);
            if ((uni == null || uni.isEmpty()) && Iconc.codes.containsKey((Object)text)) {
                uni = Character.toString((char)Iconc.codes.get((Object)text));
            }
            if (uni != null && !uni.isEmpty()) {
                this.chatfield.setText(this.chatfield.getText().substring(0, index) + uni + this.chatfield.getText().substring(cursor));
                this.chatfield.setCursorPosition(index + uni.length());
            }
        }
    }

    protected void rect(float x, float y, float w, float h) {
        Draw.rect((String)"whiteui", (float)(x + w / 2.0f), (float)(y + h / 2.0f), (float)w, (float)h);
    }

    public void draw() {
        float opacity = (float)Core.settings.getInt("chatopacity") / 100.0f;
        float textWidth = Math.min((float)Core.graphics.getWidth() / 1.5f, Scl.scl((float)700.0f));
        Draw.color((Color)this.shadowColor);
        if (this.shown) {
            this.rect(this.offsetx, this.chatfield.y + Core.scene.marginBottom, this.chatfield.getWidth() + 15.0f, this.chatfield.getHeight() - 1.0f);
        }
        super.draw();
        float spacing = this.chatspace;
        this.chatfield.visible = this.shown;
        this.fieldlabel.visible = this.shown;
        Draw.color((Color)this.shadowColor);
        Draw.alpha((float)(this.shadowColor.a * opacity));
        float theight = this.offsety + spacing + this.getMarginBottom() + Core.scene.marginBottom;
        for (int i = this.scrollPos; i < this.messages.size && i < 10 + this.scrollPos && ((float)i < this.fadetime || this.shown); ++i) {
            String message = (String)this.messages.get(i);
            this.layout.setText(this.font, (CharSequence)message, Color.white, textWidth, 12, true);
            theight += this.layout.height + this.textspacing;
            if (i - this.scrollPos == 0) {
                theight -= this.textspacing + 1.0f;
            }
            this.font.getCache().clear();
            this.font.getCache().setColor(Color.white);
            this.font.getCache().addText((CharSequence)message, this.fontoffsetx + this.offsetx, this.offsety + theight, textWidth, 12, true);
            if (!this.shown && this.fadetime - (float)i < 1.0f && this.fadetime - (float)i >= 0.0f) {
                this.font.getCache().setAlphas((this.fadetime - (float)i) * opacity);
                Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(this.shadowColor.a * (this.fadetime - (float)i) * opacity));
            } else {
                this.font.getCache().setAlphas(opacity);
            }
            this.rect(this.offsetx, theight - this.layout.height - 2.0f, textWidth + Scl.scl((float)4.0f), this.layout.height + this.textspacing);
            Draw.color((Color)this.shadowColor);
            Draw.alpha((float)(opacity * this.shadowColor.a));
            this.font.getCache().draw();
        }
        Draw.color();
        if (this.fadetime > 0.0f && !this.shown) {
            this.fadetime -= Time.delta / 180.0f;
        }
    }

    private void sendMessage() {
        String message = this.chatfield.getText().trim();
        this.clearChatInput();
        if (message.isEmpty() || message.startsWith(this.mode.prefix) && message.substring(this.mode.prefix.length()).isEmpty()) {
            return;
        }
        if (this.history.size < 2 || !((String)this.history.get(1)).equals(message)) {
            this.history.insert(1, (Object)message);
        }
        message = UI.formatIcons(message);
        Events.fire((Object)new EventType.ClientChatEvent(message));
        Call.sendChatMessage((String)message);
    }

    public void toggle() {
        if (!this.shown) {
            Core.scene.setKeyboardFocus((Element)this.chatfield);
            this.shown = true;
            if (Vars.mobile) {
                Input.TextInput input = new Input.TextInput();
                input.maxLength = 150;
                input.text = this.chatfield.getText() + " ";
                input.accepted = text -> {
                    this.chatfield.setText(text);
                    this.sendMessage();
                    this.hide();
                    Core.input.setOnscreenKeyboardVisible(false);
                };
                input.canceled = this::hide;
                Core.input.getTextInput(input);
            } else {
                this.chatfield.fireClick();
            }
        } else {
            Time.runTask((float)2.0f, () -> {
                Core.scene.setKeyboardFocus(null);
                this.shown = false;
                this.scrollPos = 0;
                this.sendMessage();
            });
        }
    }

    public void hide() {
        Core.scene.setKeyboardFocus(null);
        this.shown = false;
        this.clearChatInput();
    }

    public void updateChat() {
        if (((String)this.history.get(this.historyPos)).contains(this.mode.normalizedPrefix())) {
            this.chatfield.setText((String)this.history.get(this.historyPos));
        } else {
            this.chatfield.setText(this.mode.normalizedPrefix() + (String)this.history.get(this.historyPos));
        }
        this.updateCursor();
    }

    public void nextMode() {
        ChatMode prev = this.mode;
        do {
            this.mode = this.mode.next();
        } while (!this.mode.isValid());
        if (this.chatfield.getText().startsWith(prev.normalizedPrefix())) {
            this.chatfield.setText(this.mode.normalizedPrefix() + this.chatfield.getText().substring(prev.normalizedPrefix().length()));
        } else {
            this.chatfield.setText(this.mode.normalizedPrefix());
        }
        this.updateCursor();
    }

    public void clearChatInput() {
        this.historyPos = 0;
        this.history.set(0, (Object)"");
        this.chatfield.setText(this.mode.normalizedPrefix());
        this.updateCursor();
    }

    public void updateCursor() {
        this.chatfield.setCursorPosition(this.chatfield.getText().length());
    }

    public boolean shown() {
        return this.shown;
    }

    public void addMessage(String message) {
        if (message == null) {
            return;
        }
        this.messages.insert(0, (Object)message);
        this.fadetime += 1.0f;
        this.fadetime = Math.min(this.fadetime, 10.0f) + 1.0f;
        if (this.scrollPos > 0) {
            ++this.scrollPos;
        }
    }

    public static enum ChatMode {
        normal(""),
        team("/t"),
        admin("/a", Vars.player::admin);

        public String prefix;
        public Boolp valid;
        public static final ChatMode[] all;

        private ChatMode(String prefix) {
            this.prefix = prefix;
            this.valid = () -> true;
        }

        private ChatMode(String prefix, Boolp valid) {
            this.prefix = prefix;
            this.valid = valid;
        }

        public ChatMode next() {
            return all[(this.ordinal() + 1) % all.length];
        }

        public String normalizedPrefix() {
            return this.prefix.isEmpty() ? "" : this.prefix + " ";
        }

        public boolean isValid() {
            return this.valid.get();
        }

        static {
            all = ChatMode.values();
        }
    }
}

