/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Application;
import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.Image;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Seq;
import arc.util.Nullable;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.core.Platform;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.MenuRenderer;
import mindustry.ui.Fonts;
import mindustry.ui.MobileButton;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.AboutDialog;
import mindustry.ui.dialogs.CustomGameDialog;
import mindustry.ui.dialogs.DatabaseDialog;
import mindustry.ui.dialogs.EditorMapsDialog;
import mindustry.ui.dialogs.JoinDialog;
import mindustry.ui.dialogs.LoadDialog;
import mindustry.ui.dialogs.ModsDialog;
import mindustry.ui.dialogs.SettingsMenuDialog;
import mindustryX.features.ArcOld;
import mindustryX.features.ui.MenuFloatLabel;

public class MenuFragment {
    private Table container;
    private Table submenu;
    private Button currentMenu;
    private MenuRenderer renderer;
    private Seq<MenuButton> customButtons = new Seq();
    public Seq<MenuButton> desktopButtons = null;
    MenuFloatLabel floatLabel;

    public void build(Group parent) {
        this.renderer = new MenuRenderer();
        WidgetGroup group = new WidgetGroup();
        group.setFillParent(true);
        group.visible(() -> !Vars.ui.editor.isShown());
        parent.addChild((Element)group);
        this.floatLabel = new MenuFloatLabel();
        parent.addChild((Element)this.floatLabel);
        parent = group;
        Image img = new Image();
        group.addChild((Element)img);
        img.setFillParent(true);
        ArcOld.nextBackground(img);
        parent.fill((x, y, w, h) -> {
            if (img.getDrawable() == null) {
                this.renderer.render();
            }
        });
        parent.fill(c -> c.pane(Styles.noBarPane, cont -> {
            this.container = cont;
            cont.name = "menu container";
            if (!Vars.mobile) {
                c.left();
                this.buildDesktop();
                Events.on(EventType.ResizeEvent.class, event -> this.buildDesktop());
            } else {
                this.buildMobile();
                Events.on(EventType.ResizeEvent.class, event -> this.buildMobile());
            }
        }).with(pane -> pane.setOverscroll(false, false)).grow());
        if (Vars.mobile) {
            parent.fill((x, y, w, h) -> {
                x = 0.0f;
                y = 0.0f;
                w = Core.graphics.getWidth();
                h = Core.graphics.getHeight();
                if (Core.scene.marginLeft > 0.0f) {
                    Tex.paneRight.draw(x, y, Core.scene.marginLeft, h);
                }
                if (Core.scene.marginRight > 0.0f) {
                    Tex.paneLeft.draw(x + w - Core.scene.marginRight, y, Core.scene.marginRight, h);
                }
                if (Core.scene.marginBottom > 0.0f) {
                    Tex.paneTop.draw(Core.scene.marginLeft, 0.0f, (float)Core.graphics.getWidth() - Core.scene.marginRight - Core.scene.marginLeft, Core.scene.marginBottom);
                }
            });
            parent.fill(c -> c.bottom().left().button("", new TextButton.TextButtonStyle(){
                {
                    this.font = Fonts.def;
                    this.fontColor = Color.white;
                    this.up = Tex.infoBanner;
                }
            }, () -> ((AboutDialog)Vars.ui.about).show()).size(84.0f, 45.0f).name("info"));
        }
        parent.fill(c -> c.bottom().left().table(t -> {
            t.background(Tex.buttonEdge3);
            t.button("\ue83d", Styles.cleart, () -> ArcOld.nextBackground(img)).width(50.0f);
        }).visible(() -> !((String)ArcOld.backgroundPath.get()).isEmpty()).left().width(100.0f));
        String versionText = (Version.build == -1 ? "[#fc8140aa]" : "[#ffffffba]") + Version.combined();
        parent.fill((Table.DrawRect)(Table.DrawRect)LambdaMetafactory.metafactory(null, null, null, (FFFF)V, lambda$build$13(java.lang.String float float float float ), (FFFF)V)((MenuFragment)this, (String)versionText)).touchable = Touchable.disabled;
    }

    private void buildMobile() {
        this.container.clear();
        this.container.name = "buttons";
        this.container.setSize((float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
        float size = 120.0f;
        this.container.defaults().size(size).pad(5.0f).padTop(4.0f);
        MobileButton play = new MobileButton((Drawable)Icon.play, "@campaign", () -> this.checkPlay(Vars.ui.planet::show));
        MobileButton custom = new MobileButton((Drawable)Icon.rightOpenOut, "@customgame", () -> this.checkPlay(() -> ((CustomGameDialog)Vars.ui.custom).show()));
        MobileButton maps = new MobileButton((Drawable)Icon.download, "@loadgame", () -> this.checkPlay(() -> ((LoadDialog)Vars.ui.load).show()));
        MobileButton join = new MobileButton((Drawable)Icon.add, "@joingame", () -> this.checkPlay(() -> ((JoinDialog)Vars.ui.join).show()));
        MobileButton editor = new MobileButton((Drawable)Icon.terrain, "@editor", () -> this.checkPlay(() -> ((EditorMapsDialog)Vars.ui.maps).show()));
        MobileButton tools = new MobileButton((Drawable)Icon.settings, "@settings", () -> ((SettingsMenuDialog)Vars.ui.settings).show());
        MobileButton mods = new MobileButton((Drawable)Icon.book, "@mods", () -> ((ModsDialog)Vars.ui.mods).show());
        MobileButton exit = new MobileButton((Drawable)Icon.exit, "@quit", () -> Core.app.exit());
        MobileButton database = new MobileButton((Drawable)Icon.book, "@database", () -> ((DatabaseDialog)Vars.ui.database).show());
        Seq customs = this.customButtons.map(b -> new MobileButton(b.icon, b.text, b.runnable == null ? () -> {} : b.runnable));
        if (!Core.graphics.isPortrait()) {
            int i;
            this.container.marginTop(60.0f);
            this.container.add((Element)play);
            this.container.add((Element)join);
            this.container.add((Element)custom);
            this.container.add((Element)maps);
            for (i = 1; i < customs.size; i += 2) {
                this.container.add((Element)((MobileButton)customs.get(i)));
            }
            this.container.row();
            this.container.add((Element)editor);
            this.container.add((Element)tools);
            this.container.add((Element)mods);
            this.container.add((Element)database);
            for (i = 0; i < customs.size; i += 2) {
                this.container.add((Element)((MobileButton)customs.get(i)));
            }
            if (!Vars.ios) {
                this.container.add((Element)exit);
            }
        } else {
            this.container.marginTop(0.0f);
            this.container.add((Element)play);
            this.container.add((Element)maps);
            this.container.row();
            this.container.add((Element)custom);
            this.container.add((Element)join);
            this.container.row();
            this.container.add((Element)editor);
            this.container.add((Element)tools);
            this.container.row();
            this.container.add((Element)mods);
            this.container.add((Element)database);
            this.container.row();
            for (int i = 0; i < customs.size; ++i) {
                this.container.add((Element)((MobileButton)customs.get(i)));
                if (i % 2 != 0) continue;
                this.container.row();
            }
            if (!Vars.ios) {
                this.container.add((Element)exit);
            }
        }
    }

    private void buildDesktop() {
        this.container.clear();
        this.container.setSize((float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
        float width = 230.0f;
        Drawable background = Styles.black6;
        this.container.left();
        this.container.add().width((float)Core.graphics.getWidth() / 10.0f);
        this.container.table(background, t -> {
            t.defaults().width(width).height(70.0f);
            t.name = "buttons";
            if (this.desktopButtons == null) {
                Object[] objectArray = new MenuButton[6];
                objectArray[0] = new MenuButton("@play", (Drawable)Icon.play, new MenuButton("@campaign", (Drawable)Icon.play, () -> this.checkPlay(Vars.ui.planet::show)), new MenuButton("@joingame", (Drawable)Icon.add, () -> this.checkPlay(() -> ((JoinDialog)Vars.ui.join).show())), new MenuButton("@customgame", (Drawable)Icon.terrain, () -> this.checkPlay(() -> ((CustomGameDialog)Vars.ui.custom).show())), new MenuButton("@loadgame", (Drawable)Icon.download, () -> this.checkPlay(() -> ((LoadDialog)Vars.ui.load).show())));
                MenuButton[] menuButtonArray = new MenuButton[3];
                menuButtonArray[0] = new MenuButton("@schematics", (Drawable)Icon.paste, Vars.ui.schematics::show);
                menuButtonArray[1] = new MenuButton("@database", (Drawable)Icon.book, () -> ((DatabaseDialog)Vars.ui.database).show());
                menuButtonArray[2] = new MenuButton("@about.button", (Drawable)Icon.info, () -> ((AboutDialog)Vars.ui.about).show());
                objectArray[1] = new MenuButton("@database.button", (Drawable)Icon.menu, menuButtonArray);
                objectArray[2] = new MenuButton("@editor", (Drawable)Icon.terrain, () -> this.checkPlay(() -> ((EditorMapsDialog)Vars.ui.maps).show()));
                objectArray[3] = Vars.steam ? new MenuButton("@workshop", (Drawable)Icon.steam, () -> ((Platform)Vars.platform).openWorkshop()) : null;
                objectArray[4] = new MenuButton("@mods", (Drawable)Icon.book, () -> ((ModsDialog)Vars.ui.mods).show());
                objectArray[5] = new MenuButton("@settings", (Drawable)Icon.settings, () -> ((SettingsMenuDialog)Vars.ui.settings).show());
                this.desktopButtons = Seq.with((Object[])objectArray);
            }
            this.buttons((Table)t, (MenuButton[])this.desktopButtons.toArray(MenuButton.class));
            this.buttons((Table)t, (MenuButton[])this.customButtons.toArray(MenuButton.class));
            MenuButton[] menuButtonArray = new MenuButton[1];
            menuButtonArray[0] = new MenuButton("@quit", (Drawable)Icon.exit, () -> ((Application)Core.app).exit());
            this.buttons((Table)t, menuButtonArray);
        }).width(width).growY();
        this.container.table(background, t -> {
            this.submenu = t;
            t.name = "submenu";
            t.color.a = 0.0f;
            t.top();
            t.defaults().width(width).height(70.0f);
            t.visible(() -> !t.getChildren().isEmpty());
        }).width(width).growY();
    }

    private void checkPlay(Runnable run) {
        if (!Vars.mods.hasContentErrors()) {
            run.run();
        } else {
            Vars.ui.showInfo("@mod.noerrorplay");
        }
    }

    private void fadeInMenu() {
        this.submenu.clearActions();
        this.submenu.actions(new Action[]{Actions.alpha((float)1.0f, (float)0.15f, (Interp)Interp.fade)});
    }

    private void fadeOutMenu() {
        if (this.submenu.getChildren().isEmpty()) {
            return;
        }
        this.submenu.clearActions();
        this.submenu.actions(new Action[]{Actions.alpha((float)1.0f), Actions.alpha((float)0.0f, (float)0.2f, (Interp)Interp.fade), Actions.run(() -> this.submenu.clearChildren())});
    }

    private void buttons(Table t, MenuButton ... buttons) {
        for (MenuButton b : buttons) {
            if (b == null) continue;
            Button[] out = new Button[]{null};
            out[0] = (Button)t.button(b.text, b.icon, Styles.flatToggleMenut, () -> {
                if (this.currentMenu == out[0]) {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                } else if (b.submenu != null && b.submenu.any()) {
                    this.currentMenu = out[0];
                    this.submenu.clearChildren();
                    this.fadeInMenu();
                    this.submenu.add().height(((float)Core.graphics.getHeight() - Core.scene.marginTop - Core.scene.marginBottom - out[0].getY(10)) / Scl.scl((float)1.0f));
                    this.submenu.row();
                    this.buttons(this.submenu, (MenuButton[])b.submenu.toArray());
                } else {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                    b.runnable.run();
                }
            }).marginLeft(11.0f).get();
            out[0].update(() -> out[0].setChecked(this.currentMenu == out[0]));
            t.row();
        }
    }

    public void addButton(String text, Drawable icon, Runnable callback) {
        this.addButton(new MenuButton(text, icon, callback));
    }

    public void addButton(String text, Runnable callback) {
        this.addButton(text, Styles.none, callback);
    }

    public void addButton(MenuButton button2) {
        this.customButtons.add((Object)button2);
    }

    private /* synthetic */ void lambda$build$13(String versionText, float x, float y, float w, float h) {
        TextureAtlas.AtlasRegion logo = Core.atlas.find("logo");
        float width = Core.graphics.getWidth();
        float height = (float)Core.graphics.getHeight() - Core.scene.marginTop;
        float logoscl = Scl.scl((float)1.0f) * logo.scale;
        float logow = Math.min((float)logo.width * logoscl, (float)Core.graphics.getWidth() - Scl.scl((float)20.0f));
        float logoh = logow * (float)logo.height / (float)logo.width;
        float fx = (int)(width / 2.0f);
        float fy = (float)((int)(height - 6.0f - logoh)) + logoh / 2.0f - (Core.graphics.isPortrait() ? Scl.scl((float)30.0f) : 0.0f);
        if (Core.settings.getBool("macnotch")) {
            fy -= Scl.scl((float)Vars.macNotchHeight);
        }
        this.floatLabel.setPosition(width / 2.0f + logow * 0.35f, fy - logoh / 2.0f - Scl.scl((float)2.0f) + logoh * 0.15f);
        this.floatLabel.baseScale = logoh * 0.03f;
        Draw.color();
        Draw.rect((TextureRegion)logo, (float)fx, (float)fy, (float)logow, (float)logoh);
        Fonts.outline.setColor(Color.white);
        Fonts.outline.draw((CharSequence)versionText, fx, fy - logoh / 2.0f - Scl.scl((float)2.0f), 1);
    }

    public static class MenuButton {
        public final Drawable icon;
        public final String text;
        public final Runnable runnable;
        @Nullable
        public final Seq<MenuButton> submenu;

        public MenuButton(String text, Drawable icon, Runnable runnable) {
            this.icon = icon;
            this.text = text;
            this.runnable = runnable;
            this.submenu = null;
        }

        public MenuButton(String text, Drawable icon, Runnable runnable, MenuButton ... submenu) {
            this.icon = icon;
            this.text = text;
            this.runnable = runnable;
            this.submenu = submenu != null ? Seq.with((Object[])submenu) : null;
        }

        MenuButton(String text, Drawable icon, MenuButton ... submenu) {
            this.icon = icon;
            this.text = text;
            this.runnable = () -> {};
            this.submenu = submenu != null ? Seq.with((Object[])submenu) : null;
        }
    }
}

