/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.layout.Scl;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustryX.features.LogicExt;

public class MinimapFragment {
    private boolean shown;
    float panx;
    float pany;
    float zoom = 1.0f;
    float lastZoom = -1.0f;
    private float baseSize = Scl.scl((float)5.0f);
    public Element elem;

    protected Rect getRectBounds() {
        float w = Core.graphics.getWidth();
        float h = Core.graphics.getHeight();
        float ratio = Vars.renderer.minimap.getTexture() == null ? 1.0f : (float)Vars.renderer.minimap.getTexture().height / (float)Vars.renderer.minimap.getTexture().width;
        float size = this.baseSize * this.zoom * (float)Vars.world.width();
        return Tmp.r1.set(w / 2.0f + this.panx * this.zoom - size / 2.0f, h / 2.0f + this.pany * this.zoom - size / 2.0f * ratio, size, size * ratio);
    }

    public void build(Group parent) {
        this.elem = parent.fill((x, y, w, h) -> {
            w = Core.graphics.getWidth();
            h = Core.graphics.getHeight();
            float size = this.baseSize * this.zoom * (float)Vars.world.width();
            Draw.color((Color)Color.black);
            Fill.crect((float)0.0f, (float)0.0f, (float)w, (float)h);
            if (Vars.renderer.minimap.getTexture() != null) {
                Draw.color();
                float ratio = (float)Vars.renderer.minimap.getTexture().height / (float)Vars.renderer.minimap.getTexture().width;
                TextureRegion reg = Draw.wrap((Texture)Vars.renderer.minimap.getTexture());
                Draw.rect((TextureRegion)reg, (float)(w / 2.0f + this.panx * this.zoom), (float)(h / 2.0f + this.pany * this.zoom), (float)size, (float)(size * ratio));
                Rect bounds = this.getRectBounds();
                Vars.renderer.minimap.drawEntities(bounds.x, bounds.y, bounds.width, bounds.height, true);
            }
            Draw.reset();
        });
        this.elem.visible(() -> this.shown);
        this.elem.update(() -> {
            if (!Vars.ui.chatfrag.shown()) {
                this.elem.requestKeyboard();
                this.elem.requestScroll();
            }
            this.elem.setFillParent(true);
            this.elem.setBounds(0.0f, 0.0f, (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
            if (Core.input.keyTap(Binding.menu)) {
                this.shown = false;
            }
        });
        this.elem.touchable = Touchable.enabled;
        this.elem.addListener((EventListener)new ElementGestureListener(){

            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (MinimapFragment.this.lastZoom < 0.0f) {
                    MinimapFragment.this.lastZoom = MinimapFragment.this.zoom;
                }
                MinimapFragment.this.zoom = Mathf.clamp((float)(distance / initialDistance * MinimapFragment.this.lastZoom), (float)0.25f, (float)10.0f);
            }

            public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                if (event.keyCode != (LogicExt.invertMapClick ? KeyCode.mouseLeft : KeyCode.mouseRight)) {
                    MinimapFragment.this.panx += deltaX / MinimapFragment.this.zoom;
                    MinimapFragment.this.pany += deltaY / MinimapFragment.this.zoom;
                } else {
                    MinimapFragment.this.panTo(x, y);
                }
            }

            public void touchDown(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                super.touchDown(event, x, y, pointer, button2);
                if (button2 == (LogicExt.invertMapClick ? KeyCode.mouseLeft : KeyCode.mouseRight)) {
                    MinimapFragment.this.panTo(x, y);
                }
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                MinimapFragment.this.lastZoom = MinimapFragment.this.zoom;
            }
        });
        this.elem.addListener((EventListener)new InputListener(){

            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                MinimapFragment.this.zoom = Mathf.clamp((float)(MinimapFragment.this.zoom - amountY / 10.0f * MinimapFragment.this.zoom), (float)0.25f, (float)10.0f);
                return true;
            }
        });
        parent.fill(t -> {
            t.setFillParent(true);
            t.visible(() -> this.shown);
            t.update(() -> t.setBounds(0.0f, 0.0f, (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight()));
            t.add((CharSequence)"@minimap").style((Style)Styles.outlineLabel).pad(10.0f);
            t.row();
            t.add().growY();
            t.row();
            t.button("@back", (Drawable)Icon.leftOpen, () -> {
                this.shown = false;
            }).size(220.0f, 60.0f).pad(10.0f);
        });
    }

    public void panTo(float relativeX, float relativeY) {
        Rect r = this.getRectBounds();
        Tmp.v1.set(relativeX, relativeY).sub(r.x, r.y).scl(1.0f / r.width, 1.0f / r.height).scl((float)Vars.world.unitWidth(), (float)Vars.world.unitHeight());
        Vars.control.input.panCamera(Tmp.v1.clamp(-4.0f, -4.0f, (float)Vars.world.unitWidth() + 4.0f, (float)Vars.world.unitHeight() + 4.0f));
    }

    public boolean shown() {
        return this.shown;
    }

    public void hide() {
        this.shown = false;
    }

    public void toggle() {
        if (Vars.renderer.minimap.getTexture() != null) {
            float size = this.baseSize * this.zoom * (float)Vars.world.width();
            float ratio = (float)Vars.renderer.minimap.getTexture().height / (float)Vars.renderer.minimap.getTexture().width;
            float px = Vars.player.dead() ? Core.camera.position.x : Vars.player.x;
            float py = Vars.player.dead() ? Core.camera.position.y : Vars.player.y;
            this.panx = (size / 2.0f - px / (float)(Vars.world.width() * 8) * size) / this.zoom;
            this.pany = (size * ratio / 2.0f - py / (float)(Vars.world.height() * 8) * size * ratio) / this.zoom;
        }
        this.shown = !this.shown;
    }
}

