/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.audio.Sound;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.EnumSet;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.Ranged;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import mindustryX.features.RenderExt;
import mindustryX.features.StatExt;

public class MendProjector
extends Block {
    public final int timerUse;
    public Color baseColor;
    public Color phaseColor;
    public TextureRegion topRegion;
    public float reload;
    public float range;
    public float healPercent;
    public float phaseBoost;
    public float phaseRangeBoost;
    public float useTime;
    public Sound mendSound;
    public float mendSoundVolume;
    private boolean any;

    public MendProjector(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.baseColor = Color.valueOf((String)"84f491");
        this.phaseColor = Color.valueOf((String)"ffd59e");
        this.reload = 250.0f;
        this.range = 60.0f;
        this.healPercent = 12.0f;
        this.phaseBoost = 12.0f;
        this.phaseRangeBoost = 50.0f;
        this.useTime = 400.0f;
        this.mendSound = Sounds.healWave;
        this.mendSoundVolume = 0.5f;
        this.any = false;
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasItems = true;
        this.emitLight = true;
        this.lightRadius = 50.0f;
        this.suppressable = true;
        this.envEnabled |= 2;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.blockRepair});
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        this.stats.timePeriod = this.useTime;
        super.setStats();
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(StatExt.mend, this.healPercent, StatUnit.percent);
        this.stats.add(StatExt.mendReload, this.reload / 60.0f, StatUnit.seconds);
        this.stats.add(StatExt.mendSpeed, "@%/s", new Object[]{Strings.autoFixed((float)(this.healPercent / (this.reload / 60.0f)), (int)1)});
        Object t = this.findConsumer((Boolf<Consume>)((Boolf)c -> c instanceof ConsumeItems));
        if (t instanceof ConsumeItems) {
            ConsumeItems cons = (ConsumeItems)((Object)t);
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.itemBoosters("{0}x\u4fee\u590d\u91cf", this.stats.timePeriod, (this.phaseBoost + this.healPercent) / this.healPercent, this.phaseRangeBoost, cons.items));
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("charge", entity -> new Bar(() -> "\u5145\u80fd: " + (int)entity.charge + " / " + this.reload, () -> Pal.items, () -> entity.charge / this.reload));
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)this.baseColor);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)(this.range + this.phaseRangeBoost), (Color)this.phaseColor);
        Vars.indexer.eachBlock(Vars.player.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range + this.phaseRangeBoost, (Boolf<Building>)((Boolf)other -> true), (Cons<Building>)((Cons)other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(this.phaseColor).a(Mathf.absin((float)4.0f, (float)1.0f)))));
        Vars.indexer.eachBlock(Vars.player.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, (Boolf<Building>)((Boolf)other -> true), (Cons<Building>)((Cons)other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f)))));
    }

    public class MendBuild
    extends Building
    implements Ranged {
        public float heat;
        public float charge;
        public float phaseHeat;
        public float smoothEfficiency;

        public MendBuild() {
            this.charge = Mathf.random((float)MendProjector.this.reload);
        }

        public float range() {
            return MendProjector.this.range;
        }

        @Override
        public void updateTile() {
            boolean canHeal = !this.checkSuppression();
            this.smoothEfficiency = Mathf.lerpDelta((float)this.smoothEfficiency, (float)this.efficiency, (float)0.08f);
            this.heat = Mathf.lerpDelta((float)this.heat, (float)(this.efficiency > 0.0f && canHeal ? 1.0f : 0.0f), (float)0.08f);
            this.charge += this.heat * this.delta();
            this.phaseHeat = Mathf.lerpDelta((float)this.phaseHeat, (float)this.optionalEfficiency, (float)0.1f);
            if (this.optionalEfficiency > 0.0f && this.timer(MendProjector.this.timerUse, MendProjector.this.useTime) && canHeal) {
                this.consume();
            }
            if (this.charge >= MendProjector.this.reload && canHeal) {
                float realRange = MendProjector.this.range + this.phaseHeat * MendProjector.this.phaseRangeBoost;
                this.charge = 0.0f;
                MendProjector.this.any = false;
                Vars.indexer.eachBlock(this, realRange, (Boolf<Building>)((Boolf)b -> b.damaged() && !b.isHealSuppressed()), (Cons<Building>)((Cons)other -> {
                    other.heal(other.maxHealth() * (MendProjector.this.healPercent + this.phaseHeat * MendProjector.this.phaseBoost) / 100.0f * this.efficiency);
                    other.recentlyHealed();
                    Fx.healBlockFull.at(other.x, other.y, (float)other.block.size, MendProjector.this.baseColor, (Object)other.block);
                    MendProjector.this.any = true;
                }));
                if (MendProjector.this.any) {
                    MendProjector.this.mendSound.at((Position)this, 1.0f + Mathf.range((float)0.1f), MendProjector.this.mendSoundVolume);
                }
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp((float)(this.charge / MendProjector.this.reload));
            }
            return super.sense(sensor);
        }

        @Override
        public void drawSelect() {
            float realRange = MendProjector.this.range + this.phaseHeat * MendProjector.this.phaseRangeBoost;
            Vars.indexer.eachBlock(this, realRange, (Boolf<Building>)((Boolf)other -> true), (Cons<Building>)((Cons)other -> Drawf.selected((Building)other, (Color)Tmp.c1.set(MendProjector.this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f)))));
            Drawf.dashCircle((float)this.x, (float)this.y, (float)realRange, (Color)MendProjector.this.baseColor);
        }

        @Override
        public void draw() {
            super.draw();
            float realRange = MendProjector.this.range + this.phaseHeat * MendProjector.this.phaseRangeBoost;
            if (this.status() == BlockStatus.active && RenderExt.mendZoneTransparency > 0.02f) {
                Color c = Tmp.c1.set(MendProjector.this.baseColor);
                if (this.phaseHeat > 0.0f) {
                    c.lerp(MendProjector.this.phaseColor, 0.5f);
                }
                Draw.color((Color)c, (float)RenderExt.mendZoneTransparency);
                Lines.dashCircle(this.x, this.y, realRange);
            }
            float f = 1.0f - Time.time / 100.0f % 1.0f;
            Draw.color((Color)MendProjector.this.baseColor, (Color)MendProjector.this.phaseColor, (float)this.phaseHeat);
            Draw.alpha((float)(this.heat * Mathf.absin((float)Time.time, (float)7.957747f, (float)1.0f) * 0.5f));
            Draw.rect((TextureRegion)MendProjector.this.topRegion, (float)this.x, (float)this.y);
            Draw.alpha((float)1.0f);
            Lines.stroke((2.0f * f + 0.2f) * this.heat);
            Lines.square(this.x, this.y, Math.min(1.0f + (1.0f - f) * (float)MendProjector.this.size * 8.0f / 2.0f, (float)(MendProjector.this.size * 8) / 2.0f));
            Draw.reset();
        }

        @Override
        public void drawLight() {
            Drawf.light((float)this.x, (float)this.y, (float)(MendProjector.this.lightRadius * this.smoothEfficiency), (Color)MendProjector.this.baseColor, (float)(0.7f * this.smoothEfficiency));
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
            write.f(this.phaseHeat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
            this.phaseHeat = read.f();
        }
    }
}

